/*
 * TWCLOSE.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <twindow.h>

#include <rect.h>
#include <alloc.h>

#define _D_MEMTYPE	0x0030

int twclose(DOBJ *p)
{
	int result;

	twhide(p);
	result = rcclose(p->rc, p->flag, p->wp);
	if ((p->flag & _D_MEMTYPE) == _D_ALLOC)
		p->wp = NULL;
	if (p->flag & _D_RCNEW)
		free(p);
	else
		p->flag &= ~_D_DOPEN;
	return result;
}
