/*
 * RSREOPEN.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <wchar.h>
#include <tdialog.h>

int rsreload(ROBJ *rp, DOBJ *dialog)
{
	int h,x,z;
	char *b;

	if ((dialog->flag & _D_DOPEN) == 0)
		return 0;
	h = tdhide(dialog);
	x = ((dialog->count * 8) + 8) + 2;
	b = ((char *)rp) + x;
	z = dialog->rc.row * dialog->rc.col;
	if (dialog->flag & _D_RESAT)
		z |= 0x8000;
	wcunzip(dialog->wp, b, z);
	tdinit(dialog);
	if (h != 0)
		tdshow(dialog);
	return h;
}