/*
 * MEMMOVE.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <defs.h>

void * _CType memmove(unsigned char *dst, unsigned char *src, unsigned count)
{
	void *p = dst;

	if (dst <= src || dst >= (src + count)) {
		while (count--)
			*dst++ = *src++;
	} else {
		dst += count - 1;
		src += count - 1;
		while (count--)
			*dst-- = *src--;
	}
	return p;
}