/*
 * FTELL.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <errno.h>
#include <stdio.h>

long ftell(FILE *o)
{
	int fd;
	long filepos;
	unsigned rdcnt;
	unsigned offset;
	char *p;
	char *max;

	fd = _fileno(o);
	if (o->cnt < 0)
		o->cnt = 0;
	if ((filepos = lseek(fd, 0L, SEEK_CUR)) < 0L)
		return -1L;
	if (!bigbuf(o))
		return (filepos - o->cnt);
	offset = o->bp - o->base;
	if (o->flag & (_IOWRT|_IOREAD)) {
	} else if (!(o->flag & _IORW)) {
		errno = EINVAL;
		return (-1L);
	}
	if (filepos == 0L)
		return (long)offset;
	if (o->flag & _IOREAD) {
		if (o->cnt == 0) {
			offset = 0;
		} else {
			rdcnt = o->cnt + (o->bp - o->base);
			filepos -= (long)rdcnt;
		}
	}
	return (filepos + (long)offset);
}
