/*
 * FOPEN.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <stdio.h>
#include <share.h>
#include <errno.h>
#include <sys\stat.h>
#include <fcntl.h>	// O_... constants

#define CMASK   0644    /* [0000 0110 0100 0100] rw-r--r-- */

FILE *fopen(const char *file, const char *mode)
{
	FILE *o;
	WORD flag;
	WORD fmode;
	WORD create;
	WORD isdev;
	char ch;
	char attrib;
	long filepos;

	int oflag = 0;
	int sflag = 0;
	int wflag = 0;
	int osfh  = 0;

	_ASSERTE(file == NULL);
	if ((o = _getst()) == NULL)
		return NULL;

	switch (*mode) {
	case 'r':
		oflag = O_RDONLY;
		sflag |= _IOREAD;
		break;
	case 'w':
		oflag = O_WRONLY | O_CREAT | O_TRUNC;
		sflag |= _IOWRT;
		break;
	case 'a':
		oflag = O_WRONLY | O_CREAT | O_APPEND;
		sflag |= _IOWRT;
		break;
	default:
		return NULL;
	}

	wflag = 1;
	while (*++mode && wflag) {
		switch(*mode) {
		case '+':
			if (oflag & O_RDWR) {
				wflag = 0;
			} else {
				oflag |= O_RDWR;
				oflag &= ~(O_RDONLY | O_WRONLY);
				sflag |= _IORW;
				sflag &= ~(_IOREAD | _IOWRT);
			}
			break;
		case 'b':
			if (oflag & (O_TEXT | O_BINARY))
				wflag = 0;
			else
				oflag |= O_BINARY;
			break;
		case 't':
			if (oflag & (O_TEXT | O_BINARY))
				wflag = 0;
			else
				oflag |= O_TEXT;
			break;
		default:
			wflag = 0;
			break;
		}
	}

	if (oflag & O_BINARY)
		flag = 0;
	else if (oflag & O_TEXT)
		flag = FH_TEXT;
	else if (_fmode == O_BINARY)
		flag = 0;
	else
		flag = FH_TEXT;

	switch (oflag & (O_RDONLY | O_WRONLY | O_RDWR)) {
	case O_RDONLY:
		fmode = O_RDONLY;
		break;
	case O_WRONLY:
		fmode = O_WRONLY;
		break;
	case O_RDWR:
		fmode = O_RDWR;
		break;
	default:
		errno = EINVAL;
		doserrno = 0;
		return NULL;
	}

	switch (oflag & (O_CREAT | O_EXCL | O_TRUNC)) {
	case 0:
	case O_EXCL:
		create = A_OPEN;
		break;
	case O_CREAT:
		create = A_OPEN | A_CREATE;
		break;
	case O_CREAT | O_EXCL:
	case O_CREAT | O_TRUNC | O_EXCL:
		create = A_CREATE | A_TRUNC;
		break;
	case O_TRUNC:
	case O_TRUNC | O_EXCL:
		create = A_TRUNC;
		break;
	case O_CREAT | O_TRUNC:
		create = A_CREATE | A_TRUNC;
		break;
	default:
		errno = EINVAL;
		doserrno = 0;
		return NULL;
	}
	attrib = _A_NORMAL;
	if (oflag & O_CREAT) {
		if (!((CMASK & ~_umaskval) & S_IWRITE))
			attrib = _A_RDONLY;
	}
	if ((osfh = osopen(file, attrib, fmode, create)) == -1)
		return NULL;
	if ((isdev = osfiletype(osfh)) == DEV_UNKNOWN) {
		close(osfh);
		dosmaperr(doserrno);
		return NULL;
	}
	if (isdev == DEV_CHAR)
		flag |= FH_DEVICE;
	flag |= FH_OPEN;
		_osfile[osfh] = flag;
	if ((flag & (FH_DEVICE | FH_PIPE)) == 0 &&
		(flag & FH_TEXT) && (oflag & O_RDWR)) {
		if ((filepos = lseek(osfh, -1L, SEEK_END)) == -1) {
			if (errno != EINVAL) {
				close(osfh);
				return NULL;
			}
		} else {
			ch = 0;
			if (osread(osfh, &ch, 1) == 0 && ch == 26) {
				if (chsize(osfh, filepos) == -1) {
					close(osfh);
					return NULL;
				}
			}
			if ((filepos = lseek(osfh, 0, SEEK_SET)) == -1) {
				close(osfh);
				return NULL;
			}
		}
	}
	if (!(flag & (FH_DEVICE | FH_PIPE)) && (oflag & O_APPEND))
		_osfile[osfh] |= FH_APPEND;

	o->flag = sflag;
	o->cnt  = 0;
	o->base = o->bp = NULL;
	o->file = osfh;
	return o;
}