; _OUTPUT.ASM--
; Copyright (c) 1996 Hjort Nidudsson
;
; Change history:
; 08 Des 1997	'%b'   (BYTE)	means 00000000B
; 08 Des 1997	'%lb'  (WORD)	means 0000000000000000B
; 08 Jan 2000	'%02X' (HEXA)	means byte
;

INCLUDE		clib.inc
INCLUDE		stdio.inc

		.386p
		locals

FLAG_SIGN	= 0001h
FLAG_SIGNSP	= 0002h
FLAG_LEFT	= 0004h
FLAG_LEADZERO	= 0008h
FLAG_LONG       = 0010h
FLAG_SHORT      = 0020h
FLAG_SIGNED	= 0040h
FLAG_ALTERNATE	= 0080h
FLAG_NEGATIVE	= 0100h
FLAG_FORCEOCTAL = 0200h

BUFFERSIZE 	= 512

_DATA		SEGMENT

cl_table	DB	 06h, 00h, 00h, 06h, 00h, 01h, 00h, 00h ; !"#$%&'
		DB	 10h, 00h, 03h, 06h, 00h, 06h, 02h, 10h ;()*+,-./
		DB	 04h, 45h, 45h, 45h, 05h, 05h, 05h, 05h ;01234567
		DB	 05h, 35h, 30h, 00h, 50h, 00h, 00h, 00h ;89:;<=>?
		DB	 00h, 20h, 28h, 38h, 50h, 58h, 07h, 08h ;@ABCDEFG
		DB	 00h, 37h, 30h, 30h, 57h, 50h, 07h, 00h ;HIJKLMNO
		DB	 00h, 20h, 20h, 08h, 00h, 00h, 00h, 00h ;PQRSTUVW
		DB	 08h, 60h, 60h, 60h, 60h, 60h, 60h, 00h ;XYZ[\]^_
		DB	 00h, 70h, 78h, 78h, 78h, 78h, 78h, 08h ;`abcdefg
		DB	 07h, 08h, 00h, 00h, 07h, 00h, 08h, 08h ;hijklmno
		DB	 08h, 00h, 00h, 08h, 00h, 08h, 00h, 00h ;pqrstuvw
		DB	 08h                                    ;x
formchar	DB	'bcdefginopsuxEGX'
nullstring	DB	'(null)',0

_DATA		ENDS

;;;%%%%%%%%%;;;;;;;;;%%%

_TEXT		SEGMENT

	; --- floating point - defined in fltcvt.asm

		PUBLIC	output_proctab

output_proctab	DW	tp_case_b
		DW      tp_case_c
		DW      tp_case_d
		DW      tp_case_dummy	; e signed_float
		DW      tp_case_dummy   ; f
		DW      tp_case_dummy   ; g
		DW      tp_case_d
		DW      tp_case_n
		DW      tp_case_o
		DW	tp_case_p
		DW      tp_case_s
		DW      tp_case_u
		DW      tp_case_x
		DW	tp_case_dummy	; E unsigned_float
		DW      tp_case_dummy   ; G
		DW      tp_case_xu

st_table 	DW	st_normal	; 0
		DW	st_percent	; 1
		DW	st_flag		; 2
		DW	st_width	; 3
		DW	st_dot		; 4
		DW	st_precision	; 5
		DW	st_size		; 6
		DW	st_type		; 7

;;;%%%%%%%%%;;;;;;;;;%%%

st_normal:	mov	al,dl
		call	output_AL
		ret

st_percent:	xor	ax,ax
		mov	no_output,ax
		mov	fldwidth,ax
		mov	prefixlen,ax
		mov	capitalize,ax
		xor	si,si		; bufferiswide (default)
		mov	di,-1           ; precision
		ret

st_flag:	mov	al,dl
		cbw
		cmp	ax,'+'
		jz	SHORT @@forcesign
		jg	SHORT @@leftorpad
		cmp	ax,' '
		jz	SHORT @@forcespace
		cmp	ax,'#'
		jz	SHORT @@alternateform
		ret
@@leftorpad:	cmp	ax,'-'
		jz	SHORT @@leftjustify
		cmp	ax,'0'
		jz	SHORT @@padwithzero
		ret
@@leftjustify:	or	si,FLAG_LEFT		; '-' left justify
		ret
@@forcesign:	or	si,FLAG_SIGN		; '+' force sign indicator
		ret
@@forcespace:	or	si,FLAG_SIGNSP		; ' ' force sign or space
		ret
@@alternateform:or	si,FLAG_ALTERNATE	; '#' alternate form
		ret
@@padwithzero:	or	si,FLAG_LEADZERO	; '0' pad with leading zeros
		ret

st_width:	cmp	dl,'*'
		jnz	SHORT @@addigit
		call	output_get16
		mov	fldwidth,ax
		cmp	ax,0
		jnl	SHORT @@toend
		or	si,4
		neg	ax
		mov	fldwidth,ax
@@toend:	ret
@@addigit:	mov	al,dl
		cbw
		push	ax
		mov	ax,fldwidth
		mov	dx,10
		imul	dx
		pop	dx
		add	dx,ax
		add	dx,-48
		mov	fldwidth,dx
		ret

st_dot:		xor	di,di
		ret

st_precision:	cmp	dl,'*'
		jnz	SHORT @@adddigit
		call	output_get16
		mov	di,ax
		or	di,di
		jnl	SHORT @@toend
		mov	di,-1
@@toend:	ret
@@adddigit:	mov	al,dl
		cbw
		push	ax
		mov	ax,di
		mov	dx,10
		imul	dx
		pop	dx
		add	dx,ax
		add	dx,-48
		mov	di,dx
		ret

st_size:	cmp	dl,'l'
		jnz	SHORT @@toend
		or	si,FLAG_LONG
@@toend:	ret

st_type:	xor	bx,bx
		mov	cx,16
@@next:		cmp	dl,formchar[bx]
		je	SHORT @@switch_tp
		inc	bx
		dec	cx
		jnz	SHORT @@next
		jmp	short @@output
@@switch_tp:	add	bx,bx
		call	WORD PTR CS:[bx.output_proctab]
@@output:	call	output
		ret

;;;%%%%%%%%%;;;;;;;;;%%%

tp_case_b:	push	si
		call	output_get16
		test	si,FLAG_LONG
		jz	SHORT @@bshort
		mov	si,16
		mov	count,16
		jmp	SHORT @@binary
@@bshort:	mov	si,8
		mov	count,8
@@binary:	mov	dx,ax
		xor	cx,cx
@@shiftword:	mov	ax,dx
		shr	ax,cl
		and	ax,1
		add	ax,48
		mov	buffer[si-1],al
		inc	cx
		dec	si
		jnz	@@shiftword
		pop	si
		lea	ax,buffer
		mov	segtext,SS
		mov	offtext,ax
		ret

tp_case_c:     	call	output_get16
		mov	dx,ax
		mov	buffer[0],dl
		mov	count,1
		lea	ax,buffer
		mov	segtext,SS
		mov	offtext,ax
		ret

tp_case_s:	cmp	di,-1
		jnz	SHORT @@precision
		mov	cx,7FFFh
		jmp	SHORT @@getstringp
@@precision:	mov	cx,di
@@getstringp:
IFDEF 		LDATA
		call	output_get32
		mov	segtext,dx
ELSE
		xor	ax,ax
		mov	segtext,ax
		call	output_get16
		or	ax,ax
		jz	SHORT @@setoffset
		mov	segtext,DS
ENDIF
@@setoffset:	mov	offtext,ax
		cmp	DWORD PTR offtext,0
		jnz	SHORT @@getstringlen
		mov	segtext,DS
		mov	offtext,OFFSET DGROUP:nullstring
@@getstringlen: les	bx,DWORD PTR offtext
@@nextchar:	cmp	BYTE PTR ES:[bx],0
		jz	SHORT @@setslen
		inc	bx
		dec	cx
		jnz	SHORT @@nextchar
@@setslen:      sub	bx,offtext
		mov	count,bx
		ret

tp_case_n:
IFDEF 		LDATA
		call	output_get32
		mov	ES,dx
		mov	bx,ax
		test	si,FLAG_LONG
		jnz	SHORT @@islong
		mov	ax,charsout
		mov	ES:[bx],ax
		ret
@@islong:	movsx	eax,charsout
		mov	ES:[bx],eax
ELSE
		call	output_get16
		mov	bx,ax
		test	si,FLAG_LONG
		jnz	SHORT @@islong
		mov	ax,charsout
		mov	[bx],ax
		jmp	output
@@islong:	movsx	eax,charsout
		mov	[bx],eax
ENDIF
		mov	no_output,1
		ret

tp_case_p:
	IFND	mov	di,4
	IFFD	mov	di,8
	IFFD	or	si,FLAG_LONG
tp_case_xu:	mov	hexoff,('A'-'9'-1)
		jmp	SHORT commonhex
tp_case_x:	mov	hexoff,('a'-'9'-1)
commonhex:	mov	curadix,16
		test	si,FLAG_ALTERNATE
		jz	SHORT @@
		mov	prefix[0],'0'
		mov	prefix[1],'x'
		mov	prefixlen,2
@@:		test	si,FLAG_LONG
		jnz	SHORT long_int
		cmp	fldwidth,2
		jnz	SHORT short_int
		call	output_get16
		mov	ah,0
		jmp	SHORT unsigned_int
tp_case_o:	mov	curadix,8
		test	si,FLAG_ALTERNATE
		jz	SHORT general_int
		or	si,FLAG_FORCEOCTAL
		jmp	SHORT general_int

tp_case_d:	or	si,FLAG_SIGNED
tp_case_u:	mov	curadix,10

general_int:	test	si,FLAG_LONG
		jz	SHORT short_int

long_int:	call	output_get32
		jmp	SHORT checknegative

short_int: 	call	output_get16
		test	si,FLAG_SIGNED
		jz	SHORT unsigned_int
		movsx	eax,ax
		jmp	SHORT checknegative

unsigned_int:	movzx	eax,ax

checknegative:  mov	ddtemp,eax
		test	si,FLAG_SIGNED
		jz	SHORT @@precision
		cmp	eax,0
		jnl	SHORT @@precision
		neg	eax
		or	si,FLAG_NEGATIVE

@@precision:	mov	number,eax
		or	di,di
		jnl	SHORT @@
		mov	di,1
		jmp	SHORT testprefixlen
@@:		and	si,-9

testprefixlen:	cmp	eax,0
		jnz	SHORT @@asciiconvert
		mov	prefixlen,0

@@asciiconvert:	lea	ax,buffer[BUFFERSIZE-1]
		mov	segtext,ss
		mov	offtext,ax
		jmp	SHORT @@textloop

@@nextdigit:	movsx	ebx,curadix
		;mov	ddtemp,ebx

		mov	eax,number
		xor	edx,edx
		div	ebx
		add	dx,'0'
		mov	cx,dx

		;mov	eax,numeax
		;xor	edx,edx
		;div	ddtemp
		mov	number,eax

		cmp	cx,'9'
		jng	SHORT @@nothex
		add	cx,hexoff

@@nothex:	les	bx,DWORD PTR offtext
		mov	ES:[bx],cl
		dec	offtext

@@textloop:	mov	ax,di
		dec	di
		or	ax,ax
		jg	SHORT @@nextdigit

		cmp	number,0
		jnz	SHORT @@nextdigit

		lea	ax,buffer[BUFFERSIZE-1]
		xor	dx,dx
		sub	ax,offtext
		sbb	dx,0
		shl	eax,16
		shrd	eax,edx,16
		mov	count,ax
		inc	offtext
		test	si,FLAG_FORCEOCTAL
		jz	SHORT tp_case_dummy
		les	bx,DWORD PTR offtext
		cmp	BYTE PTR ES:[bx],48
		jnz	SHORT @@_0_
		cmp	count,0
		jnz	SHORT tp_case_dummy
@@_0_:		dec	offtext
		les	bx,DWORD PTR offtext
		mov	BYTE PTR ES:[bx],'0'
		inc	count
tp_case_dummy:	ret

;;;%%%%%%%%%;;;;;;;;;%%%

		public	output_get16
		public	output_get32

output_get16:   lea	bx,WORD PTR [argp]	; get WORD from stack
IFDEF	LDATA
		mov	ax,SS:[bx+2]
		add	WORD PTR SS:[bx],2
		mov	bx,SS:[bx]
		mov	ES,ax
		mov	ax,ES:[bx-2]
ELSE
		add	WORD PTR [bx],2
		mov	bx,[bx]
		mov	ax,[bx-2]
ENDIF
		ret

output_get32:	lea	bx,WORD PTR [argp]	; get DWORD from stack
IFDEF	LDATA
		mov	ax,SS:[bx+2]
		add	WORD PTR SS:[bx],4
		mov	bx,SS:[bx]
		mov	ES,ax
		mov	eax,ES:[bx-4]
		shld	edx,eax,16
ELSE
		add	WORD PTR [bx],4
		mov	bx,[bx]
		mov	eax,[bx-4]
		shld	edx,eax,16
ENDIF
		ret

;;;%%%%%%%%%;;;;;;;;;%%%

output_AL:	push	si
IFDEF	LDATA
		les	bx,filep
		dec	ES:[bx.iob_cnt]
		jl	SHORT @@flush
		inc	WORD PTR ES:[bx.iob_bp]
		les	si,ES:[bx.iob_bp]
		mov	ES:[si-1],al
ELSE
		mov	bx,filep
		dec	[bx.iob_cnt]
		jl	SHORT @@flush
		mov	si,[bx.iob_bp]
		mov	[si],al
		inc     [bx.iob_bp]
ENDIF
@@inc:		inc	charsout
		jmp	SHORT @@toend
@@flush:	push	ax
		push	filep
		call	_flsbuf
		cmp	ax,-1
		jnz	SHORT @@inc
		mov	charsout,-1
@@toend:	pop	si
		ret

output_DXAL:	push	si	; AL = char,DX = count
		push	di
		xor	ah,ah
		mov	si,ax
		mov	di,dx
		jmp	SHORT @@loop
@@outch:     	mov	ax,si
		call	output_AL
		cmp	charsout,-1
		jnz	SHORT @@loop
		jmp	SHORT @@toend
@@loop:		mov	ax,di
		dec	di
		or	ax,ax
		jg	SHORT @@outch
@@toend:	pop	di
		pop	si
		ret

output_AXDXCX:	push	di	; AX:DX = string, CX = len
		push	si
		mov	si,cx
		mov	di,ax
		mov	bx,dx
		jmp	SHORT @@loop
@@outch:     	mov	ES,di
		mov	al,ES:[bx]
		inc	bx
		push	bx
		cbw
		call	output_AL
		pop	bx
		cmp	charsout,-1
		jnz	SHORT @@loop
		jmp	SHORT @@toend
@@loop:		mov	ax,si
		dec	si
		or	ax,ax
		jg	SHORT @@outch
@@toend:	pop	si
		pop	di
		ret

output:		cmp	no_output,0
		jz	SHORT @@setprefix
		ret
@@setprefix:	test	si,FLAG_SIGNED
		jz	SHORT @@setpadding
		test	si,FLAG_NEGATIVE
		jz	SHORT @@testsign
		mov	prefix[0],'-'
		mov	prefixlen,1
		jmp	SHORT @@setpadding
@@testsign:	test	si,FLAG_SIGN
		jz	SHORT @@testspace
		mov	prefix[0],43
		mov	prefixlen,1
		jmp	SHORT @@setpadding
@@testspace:	test	si,FLAG_SIGNSP
		jz	SHORT @@setpadding
		mov	prefix[0],' '
		mov	prefixlen,1
@@setpadding:	mov	ax,fldwidth
		sub	ax,count
		sub	ax,prefixlen
		mov	padding,ax
		test	si,12
		jnz	SHORT @@writeprefix
		mov	dx,ax
		mov	ax,' '
		call	output_DXAL
@@writeprefix:	mov	ax,SS
		lea	dx,prefix
		mov	cx,prefixlen
		call	output_AXDXCX
		test	si,8
		jz	SHORT @@writetext
		test	si,4
		jnz	SHORT @@writetext
		mov	ax,'0'
		mov	dx,padding
		call	output_DXAL
@@writetext:	cmp	count,0
		jng	SHORT @@putstr
		mov	eax,DWORD PTR offtext
		mov	ddtemp,eax
		mov	ax,count
		mov	dwtemp,ax
		jmp	SHORT @@putslen
@@putch:	les	bx,ddtemp
		inc	WORD PTR ddtemp
		mov	al,ES:[bx]
		cbw
		call	output_AL
@@putslen:	mov	ax,dwtemp
		dec	dwtemp
		or	ax,ax
		jg	SHORT @@putch
		jmp	SHORT @@padright
@@putstr:	mov	dx,offtext
		mov	ax,count
		mov	cx,ax
		call	output_AXDXCX
@@padright:	test	si,FLAG_LEFT
		jz	SHORT @@toend
		mov	ax,' '
		mov	dx,padding
		call	output_DXAL
@@toend:	ret

_TEXT		ENDS

;;;%%%%%%%%%;;;;;;;;;%%%%%%%%%;;;

PPROC		_output
ARG		filep:DPTR, format:DPTR, argp:DPTR
LOCAL		buffer:		BYTE:[BUFFERSIZE],\
		charsout: 	WORD,\
		hexoff:		WORD,\
		state:		WORD,\
		curadix:	WORD,\
		prefix:		BYTE:[2],\
		count:		WORD,\
		prefixlen:	WORD,\
		no_output:	WORD,\
		fldwidth:	WORD,\
		padding:	WORD,\
		offtext:	WORD,\
		segtext:	WORD,\
		capitalize:	WORD,\
		number:		DWORD,\
		ddtemp:		DWORD,\
		dwtemp:		WORD

		USES	si,di

		xor	ax,ax
		mov	count,ax
		mov	charsout,ax
		mov	state,ax
@@mainloop:
	IFND	mov	bx,format
	IFFD	les	bx,format
		inc	WORD PTR [format]
	IFND	mov	dl,[bx]
	IFFD	mov	dl,ES:[bx]
		mov	al,dl
		or	al,al
		jz	short @@toend
		cmp	charsout,0
		jl	short @@toend
		cmp	dl,' '
		jl	SHORT @@other
		cmp	dl,'x'
		jng	SHORT @@setclass
@@other:	xor	ax,ax
		jmp	SHORT @@setstate
@@setclass:	mov	al,dl
		cbw
		mov	bx,ax
		mov	al,cl_table[bx-32]
		cbw
		and	ax,15
@@setstate:	mov	cx,ax
		mov	bx,ax
		shl	bx,3
		add	bx,state
		mov	al,cl_table[bx]
		cbw
		sar	ax,4
		mov	state,ax
		mov	bx,ax
		cmp	bx,7
		jbe	SHORT @@switch_st
		jmp	SHORT @@mainloop
@@switch_st:	add	bx,bx
		call	WORD PTR CS:[bx.st_table]
		jmp	SHORT @@mainloop
@@toend:	mov	ax,charsout
		ret
PEND		_output

		END