/*
 * FFLUSH.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <stdio.h>

int _flush(FILE *o)
{
	int n, result = 0;

	if ((o->flag & (_IOREAD | _IOWRT)) == _IOWRT && bigbuf(o)
		&& (n = o->bp - o->base) > 0) {
		if (write(o->file, o->base, n) == n) {
			if (_IORW & o->flag)
				o->flag &= ~_IOWRT;
		} else {
			o->flag |= _IOERR;
			result = EOF;
		}
	}
	o->bp = o->base;
	o->cnt = 0;
	return result;
}

