/*
 * DRVRETRY.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <errno.h>
#include <stdsc.h>
#include <tdialog.h>
#include <string.h>

extern ROBJ *IDD_DriveNotReady;

int _disk_retry(int drive)
{
	DOBJ *p;

	if ((p = rsopen(IDD_DriveNotReady)) == NULL)
		return 0;
	twshow(p);
	scputc(p->rc.x + 25, p->rc.y + 2, 0, 1, 'A'+ drive);
	scputf(p->rc.x + 3, p->rc.y + 4, 0, 29, "'%s'", dos_errlist[errno]);
	return tdmodal(p);
}

/******** Resource begin DriveNotReady *
	{ 0x081C,   2,   1, { 6, 4,35, 8} },
	{ 0x0000,   0, 'T', { 4, 6,13, 1} },
	{ 0x0000,   0, 'C', {20, 6,10, 1} },
********* Resource data  *******************/
static int DriveNotReady_RC[] = {
	0x0291,0x081C,0x0102,0x0406,0x0823,0x0000,0x5400,0x0604,
	0x010D,0x0000,0x4300,0x0614,0x010A,0x23F0,0xF070,0x47B3,
	0x7070,0xF074,0x700A,0x4740,0x7047,0x7470,0x07F0,0x4070,
	0x09F0,0xF047,0x400D,0x03F0,0xF047,0x400A,0x04F0,0xF047,
	0x200A,0x7244,0x7669,0x2065,0x6F6E,0x2074,0x6572,0x6461,
	0xF079,0x2030,0x6E55,0x6261,0x656C,0x7420,0x206F,0x6572,
	0x6461,0x6420,0x6972,0x6576,0x03F0,0x3A20,0x77F0,0x5420,
	0x7972,0x6120,0x6167,0x6E69,0x2020,0xF0DC,0x2004,0x6143,
	0x636E,0x6C65,0x2020,0xF0DC,0x2009,0x0DF0,0xF0DF,0x2003,
	0x0AF0,0xF0DF,0x2004,0x4747,
}; //	152 byte
ROBJ *IDD_DriveNotReady = (ROBJ *)&DriveNotReady_RC;
/******** Resource end   DriveNotReady */
