/*
 * CONFIRMD.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <arch.h>
#include <dialog.h>

extern ROBJ *IDD_ConfirmDelete;
extern const char
	cp_delselected	[], /*    You have selected %d file(s)\n */
			    /* Do you want to delete all the files */
	cp_delrdonly	[], /* The following file is marked Read only. */
	cp_delsystem	[], /* The following file is marked System. */
	cp_delflag	[], /* Do you still wish to delete it? */
	cp_dodelete	[]; /* Do you wish to delete */

#define ID_DELETE	1
#define ID_DELETEALL	2
#define ID_SKIPFILE	3
#define ID_CANCEL	4

int confirmflag;

int confirm_delete(const char *info, int selected)
{
	int x,y;
	int result;
	DOBJ *d;

	if ((d = rsopen(IDD_ConfirmDelete)) == NULL)
		return 0;
	twshow(d);
	x = d->rc.x;
	y = d->rc.y;
	if (selected > 1) {
		scputf(x + 12, y + 2, 0, 0, cp_delselected, selected);
	} else if (selected == MSG_DELSYSTEM) {
		scputs(x + 12, y + 2, 0, 0, cp_delsystem);
		scenter(x + 3, y + 3, 53, info);
		scputs(x + 14, y + 4, 0, 0, cp_delflag);
	} else if (selected == MSG_DELRDONLY) {
		scputs(x + 10, y + 2, 0, 0, cp_delrdonly);
		scenter(x + 3, y + 3, 53, info);
		scputs(x + 14, y + 4, 0, 0, cp_delflag);
	} else {
		scputs(x + 18, y + 2, 0, 0, cp_dodelete);
		scenter(x + 3, y + 3, 53, info);
	}
	beep(50, 6);
	result = rsevent(IDD_ConfirmDelete, d);
	tdclose(d);
	return result;
}

/******** Resource begin ConfirmDelete *
	{ 0x081C,   4,   0, {11, 6,59, 7} },
	{ 0x0000,   0, 'D', { 4, 5,10, 1} },
	{ 0x0000,   0, 'A', {17, 5,14, 1} },
	{ 0x0000,   0, 'J', {34, 5, 8, 1} },
	{ 0x0200,   0, 'C', {45, 5,10, 1} },
********* Resource data  *******************/
static int ConfirmDelete_RC[] = {
	0x03D1,0x081C,0x0004,0x060B,0x073B,0x0000,0x4400,0x0504,
	0x010A,0x0000,0x4100,0x0511,0x010E,0x0000,0x4A00,0x0522,
	0x0108,0x0200,0x4300,0x052D,0x010A,0x3BF0,0xF070,0x47F0,
	0x7070,0xF074,0x7007,0x4740,0xF047,0x7009,0xF074,0x7004,
	0x4740,0x7047,0x7470,0x05F0,0x4070,0x4747,0x7070,0xF074,
	0x7007,0xF040,0x4708,0x0AF0,0xF040,0x4703,0x0EF0,0xF040,
	0x4703,0x08F0,0xF040,0x4703,0x0AF0,0xF040,0x4703,0x1AF0,
	0x4420,0x6C65,0x7465,0xF165,0x200D,0x6544,0x656C,0x6574,
	0x2020,0xF0DC,0x2004,0x6544,0x656C,0x6574,0x6120,0x6C6C,
	0x2020,0xF0DC,0x2004,0x754A,0x706D,0x2020,0xF0DC,0x2004,
	0x6143,0x636E,0x6C65,0x2020,0xF0DC,0x2008,0x0AF0,0xF0DF,
	0x2003,0x0EF0,0xF0DF,0x2003,0x08F0,0xF0DF,0x2003,0x0AF0,
	0xF0DF,0x2003,0x4747,
}; //	198 byte
ROBJ *IDD_ConfirmDelete = (ROBJ *)&ConfirmDelete_RC;
/******** Resource end   ConfirmDelete */
