/* DZFBLK.H--
 * Copyright (c) 2007 Hjort Nidudsson
 *
 * Change history:
 * 07 Mar 2007	- Created
 */
#ifndef __INC_FBLK
#define __INC_FBLK

#include <wsub.h>
#include <fblock.h>

#define FWID_ARJ	0xEA60
#define FWID_ZIP	0x4B50	/* two-byte .ZIP lead-in -- 'PK' */
#define FWID_7Z		0x7A37	/* two-byte .7Z  lead-in -- '7z' */
#define FWID_GZ		0x8B1F	/* two-byte .GZ  lead-in */
#define FWID_BZ2	0x5442	/* two-byte .BZ2 lead-in */
#define FWID_CAB	0x534D	/* two-byte .CAB lead-in -- 'MSCF' */
#define FWID_RAR	0x6152	/* two-byte .RAR lead-in -- 'Rar' */

#define FTYPE_NOEXT	0
#define FTYPE_FILE	1
#define FTYPE_SUBDIR	2
#define FTYPE_UPDIR	3
#define FTYPE_USER	4	/* File is defined in DZ.INI->[Filetype] */
#define FTYPE_ARCHIVE	5	/* File is inside archive */

#define FTYPE_BAT	6	/* Executable files */
#define FTYPE_COM	7
#define FTYPE_EXE	8

#define FTYPE_ZIP	_W_ZIP	/* Archive Files */
#define FTYPE_ARJ	_W_ARJ
#define FTYPE_7Z	_W_7Z
#define FTYPE_CAB	_W_CAB
#define FTYPE_GZ	_W_GZ
#define FTYPE_BZ2	_W_BZ2

int isexec(const char *);
int fbinitype(const FBLK *, char *);
int select_fb(FBLK *);
int invert_fb(FBLK *);

void fbputsl(const FBLK *, int, int);
void fbputsd(const FBLK *, int, int);
void fbputll(const FBLK *, int, int);
void fbputld(const FBLK *, int, int);
void fbput83(int, int, BYTE, const char *);
void fbputfile(FBLK *, int, int);

extern const char cp_updir[];
extern const char cp_subdir[];

#endif