{**********************************************************************
Copyright (C) 2009 by Salvatore Licciardi

Web http://www.webalice.it/turylicciardi    eMail turylicciardi@tiscali.it

 This program is free software: you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation, version 3 of the License.
 This program is distributed in the hope  that it will be useful , but WITHOUT
 ANY WARRANTY without even the implied warranty  of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details. You should have received
 a copy of the GNU General Public License along with this program. If not, see
 http://www.gnu.org/licenses/

 **********************************************************************}

unit T_ini;      // per editor a partire dalla versione 2.59
{$MODE ObjFpc}
{$H+}  // longstring

interface

uses Sysutils,Dos,
     Altro32,Lista_S,LDU_Pch;

type Ini_File=object

     public
      constructor Init;
      destructor  Destroy;
      function    Separatore_Opzioni():char;
      function    Separatore_Valori():char;  // Visualizza e Recenti
      function    Separatore_File():char;    // ver  2.91
      function    Salva_Ora(destinazione:string; estensioni:ListaDinamicaUnidirezionale):boolean;   // ver 2.68  false == errore in scrittura
      function    Salva_Ora(estensioni:ListaDinamicaUnidirezionale):boolean;
      function    Salva_in_Uscita():boolean;
      function    Salva_in_Uscita(destinazione:string):boolean;
      function    Get_Modifica():boolean;
      procedure   Aggiorna(nome_gruppo,nome_tipo,valore:string);
      procedure   Set_Modifica(b:boolean);
      procedure   Input(s:string);
      procedure   Stampa;
      procedure   Input_File_Recenti(s:string); //  gruppo [RECENTI]  : files chiusi
      function    Estrai_File_Recenti():string; //  gruppo [RECENTI]
      procedure   Input_File_Aperti(s:string);  //  gruppo [VISUALIZZA]  : files aperti
      function    Estrai_File_Aperti():string;  //  gruppo [VISUALIZZA]
      function    numElementi():longint;
      function    Get_stringa(n:longint):string;   // non estrae
      function    Estrai_Iniziale():string;
      function    Rimuovi_Separatore_Opzioni(s:string):string;
      function    Get_File_Recenti(n:longint):string;   //  gruppo [RECENTI]  : files chiusi
      function    Get_File_Recenti(n:longint; top:boolean):string;   //  gruppo [RECENTI]  : files chiusi
      function    numElementi_File_Recenti():longint;   //  gruppo [RECENTI]  : files chiusi
      function    Estrai_File_Recenti(n:longint):string;
      procedure   Svuota_File_Recenti;
      function    Get_Salva_Configurazione():boolean;
      function    Get_Salva_Visualizza():boolean;
      function    Get_Salva_Recenti():boolean;
      procedure   Set_Salva_Configurazione(b:boolean);
      procedure   Set_Salva_Visualizza(b:boolean);
      procedure   Set_Salva_Recenti(b:boolean);
      procedure   Inserisci_Associazione_Estensioni(estensioni:ListaDinamicaUnidirezionale);  // ver 2.75
      procedure   Reverse_File_Recenti;
      function    Configuazione_Predefinita():boolean;

     private
      Editor_Ini,Editor_File_Recenti,Editor_File_Aperti:Lista_Esadecimale;
      modifica,salva_configurazione,salva_visualizza,salva_recenti:boolean;
      procedure   Cerca_Gruppo(nome_gruppo:string; var inizio,fine:longint);
      procedure   Cerca_Tipo(nome_gruppo,nome_tipo:string; var posizione:longint; var valore,commento:string);
      procedure   Rimuovi_Associazione_Estensioni;  // ver 2.75
      function    Rimuovi_Commento(s:string):string;

     protected

     end;

implementation

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

constructor Ini_File.init;
begin
modifica:=false;
salva_configurazione:=true;
salva_visualizza:=true;
salva_recenti:=true;
Editor_Ini.init;
Editor_File_Recenti.init;
Editor_File_Aperti.init;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function    Ini_File.Get_Salva_Configurazione():boolean;
begin
exit(salva_configurazione);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function    Ini_File.Get_Salva_Visualizza():boolean;
begin
exit(salva_visualizza);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function    Ini_File.Get_Salva_Recenti():boolean;
begin
exit(salva_recenti);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure   Ini_File.Set_Salva_Configurazione(b:boolean);
begin
salva_configurazione:=b;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure   Ini_File.Set_Salva_Visualizza(b:boolean);
begin
salva_visualizza:=b;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure   Ini_File.Set_Salva_Recenti(b:boolean);
begin
salva_recenti:=b;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

destructor Ini_File.Destroy;
begin
Editor_Ini.Destroy;
Editor_File_Recenti.Destroy;
Editor_File_Aperti.Destroy;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Ini_File.Set_Modifica(b:boolean);
begin
modifica:=b;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Ini_File.Get_Modifica():boolean;
begin
exit(modifica);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Ini_File.Separatore_Opzioni():char;
begin
exit('|');  // Pipe sepataoe del tipo  variabile|valore|commento
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Ini_File.Separatore_File():char;  // ver  2.91
begin
exit('*');  // asterisco, sepaa il nome del file dalle opzioni
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Ini_File.Separatore_Valori():char;  // Visualizza e Recenti
begin
exit(',');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Ini_File.Stampa;
begin
Editor_Ini.Stampa;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Ini_File.input(s:string);
begin
Editor_Ini.input(s);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Ini_File.Rimuovi_Separatore_Opzioni(s:string):string;
var new_s:string;
    s_separatore:char;
    i:longint;
begin
s_separatore:=separatore_opzioni();
new_s:='';
for i:=1 to length(s) do
    begin
    if s[i]=';' then
                begin   // copia tutta la riga restante, perche' e' commento
                new_s:=new_s+copy_end(s,i);
                break;
                end else
    if s[i]<>s_separatore then new_s:=new_s+s[i];
    end;
rimuovi_separatore_opzioni:=new_s;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function    Ini_File.Configuazione_Predefinita():boolean;
var f_ini:Text;
begin
result:=true;
assign(f_ini,pathOf(ParamStr(0))+'editor.ini');
SetFAttr(f_ini,0);
{$i-}
rewrite(f_ini);
writeln(f_ini,'[OPZIONI]');
writeln(f_ini,'ASK=DOC,,');
writeln(f_ini,'TXT=BAS,HTM,C,TXT');
writeln(f_ini,'ESA=AVI');
writeln(f_ini,'TXT=LOG,REG,BAT,CMD,CPP,INI,JAVA,ME,1ST,M3U,PP,F90,F95,XML,DTD,TDF,XSL,INI,PAS');
writeln(f_ini,'ESA=MPG,MP3,WK3,CPL,SYS,CLASS,BIN,DLL,EXE,COM,ZIP,Z,ARJ,LNK,PS,PDF,BMP,GIF,ICO');
writeln(f_ini,'; Esa,Txt,Ask indicano in che modo aprire il file, basandosi sull''estensione');
writeln(f_ini,'; associata.');
writeln(f_ini,'; Rispettivamente in esadecimale, testo, o chiedendolo.');
writeln(f_ini,'; Le estensioni ripetute vengono ignorate, solo l'' ultima viene associata.');
writeln(f_ini,'');
writeln(f_ini,'Language=          ; il file.lng della lingua');
writeln(f_ini,'');
writeln(f_ini,'Frequenza=0');
writeln(f_ini,'Ritardo=0');
writeln(f_ini,'; impostazioni per la tastiera.  Valori validi: frequenza=0..31  ritardo=0..3');
writeln(f_ini,'');
writeln(f_ini,'MouseOrizzontale=8');
writeln(f_ini,'MouseVerticale=16');
writeln(f_ini,'; impostazione della velocita'' per il mouse.  Valori validi: maggiori di zero');
writeln(f_ini,'');
writeln(f_ini,'; Frequenza, Ritardo, MouseOrizzontale e MouseVerticale sono validi solo nella');
writeln(f_ini,'; versione per DOS');
writeln(f_ini,'');
writeln(f_ini,'; RunEdit=mode con lines=50 cols=80');
writeln(f_ini,'; programma da eseguire all''avvio di Editor. Specificare percorso,');
writeln(f_ini,'; nome programma, (estensione) e opzioni');
writeln(f_ini,'; esempio: RunEdit=mode con lines=50 cols=80');
writeln(f_ini,'');
writeln(f_ini,'RunShell=');
writeln(f_ini,'; script da eseguire quando si va in Shell');
writeln(f_ini,'');
writeln(f_ini,'SaveShell=C');
writeln(f_ini,'; ST  = salva solo i files di testo, e avvisa se ci sono stati errori di');
writeln(f_ini,';       scrittura (valore predefinito)');
writeln(f_ini,'; SE  = salva solo i files in esadecimale, e avvisa se ci sono stati errori in');
writeln(f_ini,';       scrittura');
writeln(f_ini,'; STI = salva solo i files di testo, e ignora (non avvisa) se ci sono stati');
writeln(f_ini,';       errori in scrittura');
writeln(f_ini,'; SEI = salva solo i files in esadecimale, e ignora (non avvisa) se ci sono');
writeln(f_ini,';       stati errori in scrittura');
writeln(f_ini,'; N   = va in Shell direttamente: nessuno file verra'' salvato');
writeln(f_ini,'; C   = chiede per tutti i file di salvarli o meno, e avvisa in caso di errore');
writeln(f_ini,';       in scrittura');
writeln(f_ini,'; A   = salva tutti i files e avvisa in caso di errore in scrittura');
writeln(f_ini,'; AI  = salva tutti i files e ignora (non avvisa) se ci sono stati errori in');
writeln(f_ini,';       scrittura');
writeln(f_ini,'');
writeln(f_ini,'AutoDetect=true');
writeln(f_ini,'; AutoDetect puo'' assumere i valori True o False.');
writeln(f_ini,'; Se True, ed un file viene aperto col formato errato, viene richiesto di');
writeln(f_ini,'; riaprilo in quello corretto. Se False nessuna operazione viene intrapresa.');
writeln(f_ini,'');
writeln(f_ini,'WIN_FILES=*.*');
writeln(f_ini,'DOS_FILES=*.*');
writeln(f_ini,'OS2_FILES=*.*');
writeln(f_ini,'LNX_FILES=*');
writeln(f_ini,'; Indica quali files mostrare nei menu ''Apri/Salva con nome'' . E'' possibile');
writeln(f_ini,'; specificarlo su piu'' righe o coi parametri separati da una virgola, es:');
writeln(f_ini,'; Files=*.exe,*.com');
writeln(f_ini,'; Files=*.txt,*.bak');
writeln(f_ini,'; e'' equivalente a Files=*.exe,*.com,*.txt,*.bak');
writeln(f_ini,'');
writeln(f_ini,'; Opzioni equivalenti lanciabili anche dal prompt. Dal prompt hanno priorita''');
writeln(f_ini,'; maggiore rispetto al loro settaggio in questo file');
writeln(f_ini,'/DM=False');
writeln(f_ini,'/BK=True');
writeln(f_ini,'/SF=True');
writeln(f_ini,'/CL=True');
writeln(f_ini,'/US=True');
writeln(f_ini,'/SL=False');
writeln(f_ini,'');
writeln(f_ini,'Lunghezza_Riga_TXT=254 ; valore consigliato e predefinito 254');
writeln(f_ini,'Lunghezza_Riga_ESA=79 ; valore consigliato e predefinito 79');
writeln(f_ini,'; Lunghezza_Riga_TXT e Lunghezza_Riga_ESA validi con Apri/Nuovo file');
writeln(f_ini,'');
writeln(f_ini,'ClickDelay=0 ; Ritardo in centesimi di secondo tra un click ed il successivo,');
writeln(f_ini,'; sulle barre verticali.');
writeln(f_ini,'; Valori validi da 0 a 100. Predefinito o in sostituzione di uno errato e'' 0.');
writeln(f_ini,'');
writeln(f_ini,'/D2=False');
writeln(f_ini,'/D1=False');
writeln(f_ini,'/D0=True');
writeln(f_ini,'; Delimitatori di fine riga sono: /D0=true e'' quello dell'' OS (predefinito),');
writeln(f_ini,'; /D1=true e'' il carettere #10, /D2=true sono i caratteri #13#10');
writeln(f_ini,'');
writeln(f_ini,'Printer=Lpt1 ; Stampante LPT1..9 e COM1..4, LPT1 e'' predefinita');
writeln(f_ini,'; Parametro ignorato in Linux');
writeln(f_ini,'');
writeln(f_ini,'BarraPag=True');
writeln(f_ini,'; Per la barra verticale, BarraPag= false (default) punta direttamente alla');
writeln(f_ini,'; riga in percentuale, o se true fa scorrere il testo come pag SU/Giu');
writeln(f_ini,'');
writeln(f_ini,'Mancino=False ; Mancino= true | false (default). Gestione mouse per mancini.');
writeln(f_ini,'');
writeln(f_ini,'Tab=8 ; spaziatura fatta dal tasto TAB: minimo=1, massimo=lunghezza riga');
writeln(f_ini,'; Valore consigliato e di default=8');
writeln(f_ini,'');
writeln(f_ini,'Salva_Tab=False ; true|false (predefinito), per salvare la sequenza di spazi');
writeln(f_ini,'; indicati in "Tab" con il carattere TAB  (#9)');
writeln(f_ini,'');
writeln(f_ini,'Home=False ; true|false (predefinito), per andare ad inizio parola/riga');
writeln(f_ini,'; premendo il tasto Inizio una o due volte');
writeln(f_ini,'');
writeln(f_ini,'End=False ; true|false (predefinito), per andare a fine parola/riga');
writeln(f_ini,'; premendo il tasto Fine una o due volte');
writeln(f_ini,'');
writeln(f_ini,'Default_Path=. ; Il percorso predefinito');
writeln(f_ini,'');
writeln(f_ini,'Num_Notes=0 ; Il numero di appunti da poter tenere in memoria: da 1 a 2147483647');
writeln(f_ini,'; Il valore predefinito e'' 0, equivalente ad illimitato');
writeln(f_ini,'');
writeln(f_ini,'Selezione_Quadrata=False ; consente la selezione a forma di quadrato del testo');
writeln(f_ini,'; se posto a True, altrimenti quella classica (false) che e'' predefinita');
writeln(f_ini,'');
writeln(f_ini,'Salva_Configurazione=True ; valori: True (predefinito) | False');
writeln(f_ini,'; Salva la  configurazione');
writeln(f_ini,'; Se False, ignora Salva_Visualizza e Salva_Recenti pure se posti a True');
writeln(f_ini,'');
writeln(f_ini,'Salva_Visualizza=True ; valori: True (predefinito) | False');
writeln(f_ini,'; Mantiene la lista dei files da riaprire al prossimo avvio');
writeln(f_ini,'');
writeln(f_ini,'Salva_Recenti=True ; valori: True (predefinito) | False');
writeln(f_ini,'; Mantiene la lista dei primi 9 files chiusi da recente');
writeln(f_ini,'');
writeln(f_ini,'Max_Righe_Txt=6000 ; Numero di righe nel formato TXT (consigliato 6.000)');
writeln(f_ini,'Max_Righe_Esa=810 ; Numero di righe nel formato ESA (consigliato 810)');
writeln(f_ini,'');
writeln(f_ini,'Font=');
writeln(f_ini,'Htm=1,1,,,0,0,0,0,0,0,0');
writeln(f_ini,'; Impostazioni per conversione nel formato Htm e Rtf');
close(f_ini);
{$i+}
if ioresult<>0 then result:=false;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Ini_File.Salva_in_Uscita():boolean;   // false == errore in scrittura
begin
result:=Salva_in_Uscita(pathOf(ParamStr(0))+'editor.ini');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Ini_File.Salva_in_Uscita(destinazione:string):boolean;   // false == errore in scrittura
var f_ini:Text;
    visualizza_inizio,visualizza_fine,recenti_inizio,recenti_fine,estratti:longint;
    old_riga,riga:string;
begin
result:=true;
if not salva_configurazione then Exit; // ver 2.68
if not Get_Modifica() then Exit;
Cerca_Gruppo('VISUALIZZA',visualizza_inizio,visualizza_fine);
Cerca_Gruppo('RECENTI',recenti_inizio,recenti_fine);
if recenti_inizio>recenti_fine then Exchange(recenti_inizio,recenti_fine);
if visualizza_inizio>visualizza_fine then Exchange(visualizza_inizio,visualizza_fine);

Editor_Ini.Reverse;
assign(f_ini,destinazione);
SetFAttr(f_ini,0);
{$i-}
rewrite(f_ini);
{$i+}
if ioresult<>0 then result:=false;
estratti:=0;
riga:='';
while Editor_Ini.numElementi>0 do
      begin
      old_riga:=riga;
      riga:=rimuovi_separatore_opzioni(Editor_Ini.Estrai_iniziale);
      inc(estratti);
      if (recenti_inizio>0) and (not salva_recenti) then
         if (estratti>=recenti_inizio)and(estratti<=recenti_fine) then continue;
      if (visualizza_inizio>0) and (not salva_visualizza) then
         if (estratti>=visualizza_inizio)and(estratti<=visualizza_fine) then continue;
      if (riga='')and(old_riga='') then Continue; // evita 2 o piu' righe vuote consecutive
      {$i-}
      write(f_ini,riga+#13+#10);
      {$i+}
      if ioresult<>0 then
              begin
              result:=false;
              break;
              end;
      end;
Editor_Ini.Destroy; // nel caso si esca dal ciclo prima della rimozione totale delle righe
{$i-}
close(f_ini);
{$i+}
if ioresult<>0 then;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Ini_File.Salva_Ora(estensioni:ListaDinamicaUnidirezionale):boolean;   // false == errore in scrittura
begin
result:=Salva_Ora(pathOf(ParamStr(0))+'editor.ini',estensioni);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Ini_File.Rimuovi_Associazione_Estensioni;  // ver 2.75
var i:longint;
    riga:shortstring;
begin
//  il ciclo si dovrebbe fare solo dentro il gruppo opzioni
i:=Editor_Ini.numElementi();
while i>0 do
    begin
    riga:=upcase(copy(trim(Editor_Ini.Get_stringa(i)),1,4));
    if (riga='ESA=')or(riga='TXT=')or(riga='ASK=') then riga:=editor_ini.Estrai_stringa(i);
    i:=i-1;
    end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Ini_File.Inserisci_Associazione_Estensioni(estensioni:ListaDinamicaUnidirezionale);  // ver 2.75
var i:longint;
    ext,e_ext,t_ext,a_ext:shortstring;
    valido:boolean;
    ext_tipo:char;
begin
Rimuovi_Associazione_Estensioni;
e_ext:='ESA=';
t_ext:='TXT=';
a_ext:='ASK=';
for i:=estensioni.numElementi() downto 1 do
    begin
    ext:=get_iesimo(estensioni.l,i,valido);
    if (not valido) or (length(ext)<1) then Continue;
    ext_tipo:=ext[1];
    ext:=copy_end(ext,2);
    case ext_tipo of
         'E': if length(e_ext+ext)<79 then e_ext:=e_ext+ext+','
                                      else
                                       begin
                                       editor_ini.Inserisci(2,copy(e_ext,1,length(e_ext)-1));
                                       e_ext:='ESA='+ext+',';
                                       end;
         'T': if length(t_ext+ext)<79 then t_ext:=t_ext+ext+','
                                      else
                                       begin
                                       editor_ini.Inserisci(2,copy(t_ext,1,length(t_ext)-1));
                                       t_ext:='TXT='+ext+',';
                                       end;
         'A': if length(a_ext+ext)<79 then a_ext:=a_ext+ext+','
                                      else
                                       begin
                                       editor_ini.Inserisci(2,copy(a_ext,1,length(a_ext)-1));
                                       a_ext:='ASK='+ext+',';
                                       end;
         else ; // non dovrebbe accadere MAI
         end;   // case
    end;
if editor_ini.numElementi=0 then editor_ini.Inserisci(1,'[OPZIONI]');
if length(e_ext)>4 then editor_ini.Inserisci(2,copy(e_ext,1,length(e_ext)-1));
if length(t_ext)>4 then editor_ini.Inserisci(2,copy(t_ext,1,length(t_ext)-1));
if length(a_ext)>4 then editor_ini.Inserisci(2,copy(a_ext,1,length(a_ext)-1));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Ini_File.Salva_Ora(destinazione:string; estensioni:ListaDinamicaUnidirezionale):boolean;   // false == errore in scrittura
var f_ini:Text;  // ver 2.68
    visualizza_inizio,visualizza_fine,recenti_inizio,recenti_fine,estratti:longint;
    old_riga,riga:string;
begin
inserisci_associazione_estensioni(estensioni);
result:=true;
Cerca_Gruppo('VISUALIZZA',visualizza_inizio,visualizza_fine);
Cerca_Gruppo('RECENTI',recenti_inizio,recenti_fine);
if recenti_inizio>recenti_fine then Exchange(recenti_inizio,recenti_fine);
if visualizza_inizio>visualizza_fine then Exchange(visualizza_inizio,visualizza_fine);

Editor_Ini.Reverse;
assign(f_ini,destinazione);
SetFAttr(f_ini,0);
{$i-}
rewrite(f_ini);
{$i+}
if ioresult<>0 then result:=false;
estratti:=0;
riga:='';
while Editor_Ini.numElementi>estratti do
      begin
      inc(estratti);
      old_riga:=riga;
      riga:=rimuovi_separatore_opzioni(Editor_Ini.Get_stringa(estratti));
      if (recenti_inizio>0) and (not salva_recenti) then
         if (estratti>=recenti_inizio)and(estratti<=recenti_fine) then continue;
      if (visualizza_inizio>0) and (not salva_visualizza) then
         if (estratti>=visualizza_inizio)and(estratti<=visualizza_fine) then continue;
      if (riga='')and(old_riga='') then Continue; // evita 2 o piu' righe vuote consecutive
      {$i-}
      write(f_ini,riga+#13+#10);
      {$i+}
      if ioresult<>0 then
              begin
              result:=false;
              break;
              end;
      end;
{$i-}
close(f_ini);
{$i+}
if ioresult<>0 then;
Editor_Ini.Reverse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure  Ini_File.Aggiorna(nome_gruppo,nome_tipo,valore:string); // per [OPZIONI]
var inizio,fine,posizione:longint;
    commento,valore_nel_file:string;
begin
nome_gruppo:=trim(nome_gruppo);
nome_tipo:=trim(nome_tipo);
valore:=trim(valore);
Cerca_Gruppo(nome_gruppo,inizio,fine);
if inizio=0 then
   begin
   Editor_Ini.Input('['+nome_gruppo+']');   // inserire nuovo gruppo in coda
   Editor_Ini.Input(nome_tipo+'='+valore);  // inserire nuovo tipo+valore in coda
   Exit;
   end;
Cerca_Tipo(nome_gruppo,nome_tipo,posizione,valore_nel_file,commento);
if posizione=-1 then Editor_Ini.Inserisci(inizio+1,nome_tipo+'='+valore)
                else
                 begin
                 if commento<>'' then commento:=' '+commento;
                 Editor_Ini.set_stringa(Editor_Ini.numElementi-posizione-1,nome_tipo+'='+valore+commento);
                 end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Ini_File.Cerca_Tipo(nome_gruppo,nome_tipo:string; var posizione:longint; var valore,commento:string);
var i,inizio,fine:longint; // per [OPZIONI]
    separatore_:char;
    s_tipo,str,s_valore:string;
begin
Cerca_Gruppo(nome_gruppo,inizio,fine);
valore:='';
posizione:=-1;
if inizio=0 then Exit;
nome_tipo:=upcase(trim(nome_tipo));
separatore_:=separatore_opzioni;
for i:=inizio-1 to fine do
    begin
    if i<0 then Continue;
    str:=Editor_Ini.Get_stringa(Editor_Ini.numElementi-i-1);
    Testa_Coda(str,separatore_,s_tipo{testa},str{coda});
    s_tipo:=upcase(trim(Rimuovi_Separatore_Opzioni(s_tipo)));
    if (s_tipo=nome_tipo)or(os_prog+s_tipo=nome_tipo) then
          begin
          posizione:=i;
          Testa_Coda(str,separatore_,s_valore{testa},str{coda});
          valore:=trim(Rimuovi_Separatore_Opzioni(s_valore));
          commento:=trim(copy_end(str,2)); // *** dalla ver 2.66 in poi sostituisce le 2 righe seguenti
//          Testa_Coda(str,separatore_,commento{testa},str{coda});
//          commento:=trim(Rimuovi_Separatore_Opzioni(commento));
          break;
          end;
    end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function    Ini_File.Rimuovi_Commento(s:string):string;   // ver 2.68
var p:longint;
begin
p:=pos(';',s);
if p=0 then Exit(s)
       else Exit(copy(s,1,p-1));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Ini_File.Cerca_Gruppo(nome_gruppo:string; var inizio,fine:longint);
var s_tipo,str:string;
    separatore_:char;
    i:longint;
begin
inizio:=0;
fine:=0;
nome_gruppo:=trim(nome_gruppo);
if nome_gruppo='' then exit;
nome_gruppo:='['+upcase(nome_gruppo)+']';
separatore_:=separatore_opzioni();
for i:=1 to Editor_Ini.numElementi do
    begin
    str:=Editor_Ini.Get_stringa(Editor_Ini.numElementi-i+1);
    Testa_Coda(str,separatore_,s_tipo{testa},str{coda});
    s_tipo:=upcase(trim(Rimuovi_Commento(s_tipo)));
    if s_tipo=nome_gruppo then
       begin
       inizio:=i;  // numero della riga a partire da 1
       break;
       end;
    end;
for i:=inizio+1 to Editor_Ini.numElementi do
    begin
    str:=Editor_Ini.Get_stringa(Editor_Ini.numElementi-i-1);
    Testa_Coda(str,separatore_,s_tipo{testa},str{coda});
    s_tipo:=upcase(trim(Rimuovi_Commento(s_tipo)));
    fine:=i;       // numero della riga a partire da 1
    if (s_tipo<>'') and (s_tipo[1]='[') and (s_tipo[length(s_tipo)]=']') then break;
    end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Ini_File.Input_File_Recenti(s:string); //  gruppo [RECENTI]  : files chiusi
var recente,filename:string;
    i:longint;
begin
filename:=copy(s,1,pos(Separatore_File(),s)-1);
for i:=1 to numElementi_File_Recenti() do
    begin
    recente:=Get_File_Recenti(i);
    if copy(recente,1,pos(Separatore_File(),recente)-1)=filename then
       begin
       Estrai_File_Recenti(Editor_File_Recenti.NumElementi()-i+1);
       break;
       end;
    end;
Editor_File_Recenti.Input(s,true);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Ini_File.Reverse_File_Recenti; //  gruppo [RECENTI]  : files chiusi
begin
Editor_File_Recenti.Reverse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}


function  Ini_File.Estrai_File_Recenti():string;   //  gruppo [RECENTI]  : files chiusi
begin
result:=Editor_File_Recenti.Estrai_iniziale;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  Ini_File.Get_File_Recenti(n:longint):string;   //  gruppo [RECENTI]  : files chiusi
begin
result:=Editor_File_Recenti.Get_stringa(n);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  Ini_File.Get_File_Recenti(n:longint; top:boolean):string;   //  gruppo [RECENTI]  : files chiusi
begin
result:=Editor_File_Recenti.Get_stringa(n,top);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  Ini_File.numElementi_File_Recenti():longint;   //  gruppo [RECENTI]  : files chiusi
begin
result:=Editor_File_Recenti.numElementi();
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Ini_File.Input_File_Aperti(s:string); //  gruppo [VISUALIZZA]  : files aperti
begin
Editor_File_Aperti.Input(s);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  Ini_File.Estrai_File_Aperti():string;   //  gruppo [VISUALIZZA]  : files aperti
begin
result:=Editor_File_Aperti.Estrai_iniziale;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  Ini_File.numElementi():longint;
begin
result:=Editor_Ini.numElementi();
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  Ini_File.Estrai_Iniziale():string;
begin
result:=Editor_Ini.Estrai_Iniziale();
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  Ini_File.Get_stringa(n:longint):string;   // non estrae
begin
result:=Editor_Ini.Get_stringa(Editor_Ini.NumElementi()-n+1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function    Ini_File.Estrai_File_Recenti(n:longint):string;
begin
result:=Editor_File_Recenti.Estrai_stringa(Editor_File_Recenti.NumElementi()-n+1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Ini_File.Svuota_File_Recenti;
begin
if numElementi_File_Recenti=0 then Exit;
Set_modifica(true);
Editor_File_Recenti.Destroy;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

begin
end.

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

Versione:    Data:     Righe:  Modifica:

2.5.9       26/04/05      ?     inizio.
