;------------------------------------------------------------------------------
; Tries to find memory by INT15 EAX=0xe820.
; In:	DS - initialized with code segment
;	SI - pointing at start of handle table
; Out:	EAX - total amount of memory found in kiB.
;	SI - pointing at next entry to be filled in in handle table
;	EBX - destroyed.
;	ECX - destroyed.
;	EDX - destroyed.
;	DI - destroyed.
	
xms_size		dd	0	; Size of XMS in KiB.
	
smap_buf		db	size smap_strc dup (?)
smap_high_address	db	'Base address higher than 0xffffffff detected. This release of FDXMS does not', 13, 10
			db	'support this. Ignoring this address range.', 13, 10, '$'
smap_high_length	db	'Length longer than 0xffef0000 detected. This release of FDXMS does not', 13, 10
			db	'support this. Clamping length.', 13, 10, '$'
smap_too_long		db	'Range length crossing 0xffffffff detected. Clamping length.', 13, 10, '$'

too_few_handles_pre	db	'Due to memory configuration the number of handles has been increased to $'
too_few_handles_post	db	13, 10, '$'

proc	int15ax0xe820
	push	es
	mov	ax, cs
	mov	es, ax
	mov	di, offset smap_buf
	xor	ebx, ebx
	mov	edx, 'SMAP'

	mov	ecx, size smap_strc
	mov	eax, 0e820h
	push    esi			; At least one BIOS clobbers ESI.
	int	15h
	pop	esi
	jc	@@smap_end
	cmp	eax, 'SMAP'
	jne	@@smap_end
	cmp	ecx, size smap_strc
	jne	@@smap_end

@@smap_found:	
	cmp	[ di+smap_strc.type ], SMAP_MEMORY
	jne	@@next_smap

	;; Upp the address to even KiB.
	mov	eax, [ di+smap_strc.address ]
	and	eax, 3ffh
	jz	@@check_high_address
	mov	ecx, 400h
	sub	ecx, eax
	sub	[ di+smap_strc.length ], ecx
	sbb	[ di+smap_strc.length_high ], 0
	jc	@@next_smap	; If we have no length left, ignore this block.
	add	[ di+smap_strc.address ], 03ffh
	adc	[ di+smap_strc.address_high ], 0
	and	[ di+smap_strc.address ], 0fffffc00h

@@check_high_address:	
	cmp	[ di+smap_strc.address_high ], 0	; Any high bits set?
	je	@@no_high_address

	mov	cx, dx		; Save dx.
	mov	dx, offset smap_high_address
	mov	ah, 9
	int	21h		; Output appropiate complaintive message.
	mov	dx, cx		; Restore dx.
	jmp	@@next_smap	; Ignore this block.
	
@@no_high_address:	
	mov	eax, [ di+smap_strc.address ]
	cmp	eax, 100000h		; Not XMS memory?
	jb	@@next_smap
	
	sub	eax, 110000h
	jae	@@not_hma
	
	neg	eax		; Reserve HMA.
	add	[ di+smap_strc.address ], eax
	sub	[ di+smap_strc.length ], eax
	jnc	@@not_hma	; If the length was smaller than 64KiB,
	jmp	@@next_smap	; we ignore this memory block.

@@not_hma:
	cmp	[ di+smap_strc.length_high ], 0		; Any high bits set?
	je	@@no_high_length

	mov	cx, dx		; Save dx.
	mov	dx, offset smap_high_length
	mov	ah, 9
	int	21h		; Output appropiate complaintive message.
	mov	dx, cx		; Restore dx.
	mov	[ di+smap_strc.length_high ], 0		; Zero it out
	mov	[ di+smap_strc.length ], 0ffef0000h	; and set max size.

@@no_high_length:	
	mov	eax, [ di+smap_strc.address ]
	mov	ecx, eax			; Store start address in ECX.
	
	dec	eax				; Verify that end address
	add	eax, [ di+smap_strc.length ]	; is not bigger than 
	jnc	@@end_address_ok		; 0xffffffff.

	mov	dx, offset smap_too_long
	mov	ah, 9
	int	21h

	xor	eax, eax	; Update length so end address is 0xffffffff.
	sub	eax, ecx
	mov	[ di+smap_strc.length ], eax
	
	mov	eax, 0ffffffffh

@@end_address_ok:
	cmp	eax, [ xms_highest_address ]	; Is this bigger than what 
	jb	@@setup_one_block		; we've got so far?

	mov	[ xms_highest_address ], eax	; Yes, update.

@@setup_one_block:
	mov	eax, [ di+smap_strc.length ]
	add	[ xms_size ], eax		; Update found XMS memory.
	shr	eax, 10				; Convert to KiB.
	mov	[ si+xms_handle.xsize ], eax
	shr	ecx, 10				; Convert to KiB.
	mov	[ si+xms_handle.xbase ], ecx
	mov	[ si+xms_handle.used ], 0	; Not in use.
	add	si, size xms_handle		; Advance handle pointer.
		
@@next_smap:
	test	ebx, ebx
	jz	@@smap_end
	mov	ecx, size smap_strc
	mov	eax, 0e820h
	push    esi			; At least one BIOS clobbers ESI.
	int	15h
	pop	esi
	jc	@@smap_end
	jmp	@@smap_found

@@smap_end:
	;; Verify that there's at least one free handle.
	xor	eax, eax
	mov	ax, si
	sub	ax, offset driver_end
	xor	dx, dx
	mov	cx, size xms_handle
	div	cx
	cmp	ax, [ xms_num_handles ]
	jb	@@done

	;; We need to increase the number of handles.
	inc	ax
	mov	[ xms_num_handles ], ax
	mov	bx, ax
	;; Tell the user that we did.
	mov	ah, 9
	mov	dx, offset too_few_handles_pre
	int	21h
	mov	ax, bx
	call	print_dec_number
	mov	ah, 9
	mov	dx, offset too_few_handles_post
	int	21h

@@done:
	pop	es
	mov	eax, [ xms_size ]	; Return amount of memory found in kiB in EAX.

	ret
endp	int15ax0xe820

