; include file for the Free-DOS XMS driver
; Copyright 2001, Martin Strmberg.
; Copyright (c) 1995, Till Gerken

IFNDEF XXMS
INFO_STR		equ	'80386 64MB version, no XXMS support'
ELSE
INFO_STR		equ	'80386 4GB version'
ENDIF ; XXMS

DRIVER_VERSION		equ	'0.91.Apples'
DRIVER_VER		=	0091

IFNDEF XXMS
INTERFACE_VERSION	equ	'2.0'
INTERFACE_VER		=	200h
ELSE
INTERFACE_VERSION	equ	'3.0'
INTERFACE_VER		=	300h
ENDIF

XMS_START		=	1088	; XMS starts at 1088k. After HMA.
XMS_MAX 		= 	0fbc0h	; The maximum amount of XMS memory.
INT15_MAX		= 	XMS_MAX-1	; The maximum amount of INT15 reserved memory.
INT15_MAX_STR		equ	"0xfbbf"

CMD_INIT		=	0	; init command (used when installed)

STATUS_OK		=	0100h	; driver is initialized and ok
STATUS_BAD		=	8000h	; driver couldn't be installed

VDISK_IDSTR		equ	"VDISK"
VDISK_IDLEN		=	5
VDISK_IDOFS		=	12h

XMS_NOT_IMPLEMENTED	=	80h
XMS_VDISK_DETECTED	=	81h
XMS_A20_FAILURE		=	82h
XMS_DRIVER_FAILURE	=	8eh
XMS_DRIVER_FATAL	=	8fh
XMS_HMA_NOT_THERE	=	90h
XMS_HMA_IN_USE		=	91h
XMS_HMAREQ_TOO_SMALL	=	92h
XMS_HMA_NOT_USED	=	93h
XMS_A20_STILL_ENABLED	=	94h
XMS_ALREADY_ALLOCATED	=	0a0h
XMS_NO_HANDLE_LEFT	=	0a1h
XMS_INVALID_HANDLE	=	0a2h
XMS_INVALID_SOURCE_HANDLE =	0a3h
XMS_INVALID_SOURCE_OFFSET =	0a4h
XMS_INVALID_DESTINATION_HANDLE=	0a5h
XMS_INVALID_DESTINATION_OFFSET=	0a6h
XMS_INVALID_LENGTH	=	0a7h
XMS_OVERLAP		=	0a8h
XMS_PARITY_ERROR	=	0a9h
XMS_BLOCK_NOT_LOCKED	=	0aah
XMS_BLOCK_LOCKED	=	0abh
XMS_LOCK_COUNT_OVERFLOW	=	0ach
XMS_LOCK_FAILED		=	0adh
XMS_ONLY_SMALLER_UMB	=	0b0h
XMS_NO_UMB_AVAILABLE	=	0b1h
XMS_UMB_SEGMENT_NR_INVALID =	0b2h

XMS_COMMAND_LINE_LENGTH_MAX = 	100h

FLAG_INITIALISED 	= 	1


struc	request_hdr
  req_size	db	?		; number of bytes stored
  unit_id	db	?		; unit ID code
  cmd		db	?		; command code
  status	dw	?		; status word
  rsvd		db	8 dup (?)	; reserved
ends	request_hdr

struc	init_strc
  init_hdr	db	size request_hdr dup (?)
  units		db	?		; number of supported units
  end_addr	dd	?		; end address of resident part
  cmd_line	dd	?		; address of command line
ends	init_strc

struc	desc
  limit		dw	0ffffh		; segment limit
  base0_15	dw	?		; low word of base address
  base16_23	db	?		; high byte of base address
  flags		db	93h		; std read/write segment
  reserved	db	0
ends	desc

struc	xms_move_strc
  len		dd	?		; block length in bytes
  src_handle	dw	?		; source handle
  src_offset	dd	?		; offset into source
  dest_handle	dw	?		; destination handle
  dest_offset	dd	?		; offset into destination
ends	xms_move_strc

IFNDEF XXMS

struc	xms_handle
  xbase		dw	?		; base address in kbytes
  xsize		dw	?		; size in kbytes
  used		db	?		; 1 if used, > 1 if locked.
ends	xms_handle

ELSE

struc	xms_handle
  xbase		dd	?		; Base address in kiB.
  xsize		dd	?		; Size in kiB.
  used		db	?		; 1 if used, > 1 if locked.
ends	xms_handle

struc	smap_strc
  address	dd	?		; Bits 0-31 of base address.
  address_high	dd	?		; Bits 32-63 of base address.
  length	dd	?		; Bits 0-31 of length.
  length_high	dd	?		; Bits 32-63 of length.
  type		dd	?		; Type of address range.
ends	smap_strc

SMAP_MEMORY		=	1

ENDIF

