program _VERSION;
{$R+}{$S+}{$D+}
uses DOS,OpenDOS;

const version  = '7.02d' {$IFOPT D+} + #225{beta} {$ENDIF};
	  author   = 'M.Aitchison@phys.canterbury.ac.nz';
      thanks_to= 'Dantowitz%eagle1.dec@decwrl,kermit,Kirchbaum,ToadHall';
	  ValidOptions = Attr_+'/Bios date and version'+Checksum_+'/Dos version/Emulator version'
                      +Order_+'/Machine ID'+Pause_+Subdirs_+Wide_;
	  Syntax       = fileList_;
	  WhatItDoes   = 'Display program version numbers (etc)';

const
        CRC_12    = $0F01;
        CRC_16    = $A001;   {used by zoo}
        CRC_CCITT = $8404;   {default}

{  --from CRC2.PAS by David Dantowitz--

   CRC polynomials in this program are represented by replacing
   each term that is non-zero with a 1 and each zero term with a 0.
   Note that the highest order bits represent the low order terms
   of the polynomial.

   Thus X^3+X^1+1 becomes 1101 and X^4+X^1+1 becomes 11001.

   Since all polynomials have a highest term (X^a) we drop the
   highest term during computation (shift right one bit).


   Here are some examples :


           Polynomial                Representation     Hex

          X^5 + X^2 + 1                  10100          $14

            X^7 + 1                     1000000         $40

          X^3+X^2+X^1+1                   111           $7

          X^6+X^5+X^3+1                 100101          $25


   For a good discussion of polynomial selection see "Cyclic
   Codes for Error Detection", by W. W. Peterson and
   D. T. Brown, Proceedings of the IEEE, volume 49, pp 228-235,
   January 1961.

   A reference on table driven CRC computation is "A Cyclic
   Redundancy Checking (CRC) Algorithm" by A. B. Marton and
   T. K. Frambs, The Honeywell Computer Journal, volume 5,
   number 3, 1971.

   Also used to prepare these examples was "Computer Networks",
   by Andrew S. Tanenbaum, Prentice Hall, Inc.  Englewood Cliffs,
   New Jersey, 1981.

   The following three polynomials are international standards:


        CRC-12 = X^12 + X^11 + X^3 + X^2 + X^1 + 1
        CRC-16 = X^16 + X^15 + X^2 + 1
        CRC-CCITT = X^16 + X^12 + X^5 + 1

   In Binary and hexadecimal :

                   Binary                     Hex

        CRC-12    = 1111 0000 0001           $0F01
        CRC-16    = 1010 0000 0000 0001      $A001
        CRC-CCITT = 1000 0100 0000 1000      $8404    (Used below)

   The first is used with 6-bit characters and the second two
   with 8-bit characters.  All of the above will detect any
   odd number of errors.  The second two will catch all 16-bit
   bursts, a high percentage of 17-bit bursts (~99.997%) and
   also a large percentage of 18-bit or larger bursts (~99.998%).
   The paper mentioned above (Peterson and Brown) discusses how
   to compute the statistics presented which have been quoted
   from Tanenbaum.

   (A burst of length N is defined a sequence of N bits, where
   the first and last bits are incorrect and the bits in the
   middle are any possible combination of correct and incorrect.
   See the paper by Peterson and Brown for more information)


   Note that when using a polynomial of degree N, the CRC is the
   first N bits of the value returned by the routines below.
   (e.g. with CRC-12, the CRC is bits 0 to 11 of the CRC value,
   with the other two mentioned above, the CRC is all 16 bits.)


   Here is a quick idea of what is being calculated ...

   The CRC is the residual from division of the data stream by
   the CRC polynomial.  The data stream is also thought of as a
   polynomial, with the highest order term being the lowest bit
   of the first byte of the data stream and the lowest order term
   of the polynomial being the high bit of the last byte of data.
   The actual division is performed on the data stream polynomial
   multiplied by X^y where y is the degree of the CRC polynomial.


   CRC use ...

   The CRC is then appended to the end of the data stream.  When
   the receiver gets the data stream, the CRC is again computed
   and matched against the received CRC, if the two do not match
   then an error has most likely occurred.


   This work was prompted by a submission by David Kirschbaum,
   who unknowingly submitted a program that contained an error.
   I have not determined if what it computed has any reliable
   error-detecting capabilities, only that it was an attempt to
   compute a CRC, that really did not work.  The original code
   is correctly used in the program KERMIT (Columbia University)
   to compute the CRC-CCITT polynomial CRC.


   My address is

   David Dantowitz
   Digital Equipment Corporation
   Dantowitz%eagle1.dec@decwrl


   The views and ideas expressed here are my own and do not necessarily
   reflect those of the Digital Equipment Corporation.


   David Kirschbaum
   Toad Hall
   ABN.ISCAMS@USC-ISID.ARPA
}
Const
      max = 32767;

Type
      Bytes = Array [1..max] of Byte;
var
   Buffer   : array[0..max] of char;

var
      table_256 : Array [byte] of word;
      CRC_value : word;

Procedure generate_table_256(POLY : Word);

{
    This routine computes the remainder values of 0 through 255 divided
  by the polynomial represented by POLY.  These values are placed in a
  table and used to compute the CRC of a block of data efficiently.
  More space is used, but the CRC computation will be faster.



    This implementation only permits polynomials up to degree 16.
}


Var
   val, i, result, divide : word;

Begin
For val := 0 to 255 Do
  Begin
     result := val;
     For i := 1 to 8 Do
        Begin
           If (result and 1) = 1
              then result := (result shr 1) xor POLY
              else result :=  result shr 1;
        End;

     table_256[val] := result;
  End
End;


Function crc_string_256(Var s : Bytes; length, initial_crc : word) : word;

{
     This routine computes the CRC value and returns it as the function
  value.  The routine takes an array of Bytes, a length and an initial
  value for the CRC.  The routine requires that a table of 256 values
  be set up by a previous call to Generate_table_256.

      This routine uses table_256.
}

Begin

inline(

$c4/$7e/<s/                {les di,s[bp]            (es:di points to array)  }
$8b/$46/<initial_crc/      {mov ax,initial_crc[bp]  (initial CRC value)      }
$8b/$4e/<length/           {mov cx,length[bp]       (count)                  }
$be/table_256/             {mov si,offset table_256 (table address)          }


{ next:  }

$26/$32/$05/               {xor al,es:[di]          CRC = CRC XOR next byte  }
$47/                       {inc di                  (point to next byte)     }

{ intermediate steps, see comments for overall effect }

$31/$db/                   {xor bx,bx               (bx <- 0)                }
$86/$d8/                   {xchg al,bl              (bx <- ax and 0FF)       }
$86/$e0/                   {xchg al,ah              (ax <- ax shr 8)         }
$d1/$e3/                   {shl bx,1                (bx <- bx+bx)            }

$33/$00/                   {xor ax,[bx+si]          CRC = (CRC shr 8) XOR
                                                          table[CRC and 0FF] }

$e2/$f0/                   {loop next               (count <- count -1)      }

$89/$46/<s+4);             {mov s+4[bp],ax          (crc_string_256 := CRC)  }


{  basic algorithm expressed above

crc := initial_crc

For each byte Do
Begin
crc := crc XOR next_byte;

crc := (crc shr 8) XOR table_256 [crc and $FF];
End;

crc_string_256 := crc;
}
End;


Procedure Compute_crc_256(next_byte : byte);

{
   This routine calculates the CRC and stores the result in a global
 variable CRC_value.  You must first initialize CRC_value to 0 or the
 proper initial value for the CRC and then call this routine with
 each byte.

   This routine uses table_256.
}

Begin

inline(
$8b/$16/CRC_value/         {mov dx,CRC_value      }
$be/table_256/             {mov si,offset table_256 (table address)          }


$32/$56/<next_byte/        {xor dl,next_byte[bp]    CRC = CRC XOR Next_byte  }

{ intermediate steps, see comments for overall effect }

$31/$db/                   {xor bx,bx               (bx <- 0)                }
$86/$d3/                   {xchg bl,dl              (bx <- dx and 0FF)       }
$86/$f2/                   {xchg dl,dh              (dx <- dx shr 8)         }
$d1/$e3/                   {shl bx,1                (bx <- bx+bx)            }
$33/$10/                   {xor dx,[bx+si]          CRC = (CRC shr 8) XOR
                                                           table[CRC and 0FF] }

$89/$16/CRC_value);        {mov CRC_value,dx        Update CRC in memory     }

{  basic algorithm expressed above

temp := crc XOR next_byte;

temp := (temp shr 8) XOR table_256 [temp and $FF];

CRC_value := temp;
}
End;

function DOSversionString : string;
var ID,DRDOS,Serial : longint;
    oemCode : byte;
    st,vers : string[22];
begin
ID:=DosVersion;
if lo(ID)>=10
   then begin
        st:=decimal(lo(ID) div 10);
        if lo(ID)=20
           then if hi(ID)<30
               then st:=decimal(hi(ID))
               else st:=+decimal(hi(ID) div 10)+'.'+decimal(hi(ID) mod 10);
        DOSversionString:='OS/2 v'+st;
        exit;
        end;
DRDOS:=DrdosVersionNumber;
with reg do begin
            AX:=$3000; msdos(reg);
            oemCode:=BH; Serial:=BL*65536+CX;
            st:=decimal(AL)+'.'+decimal(AH);
            if (oemCode=0) and (st='6.0') then st:='6.1';
            vers:=st;
            AX:=$3306; BX:=0; msdos(reg);
            if (AL<>$FF) and (BL>0) then
               begin
               st:=decimal(BL)+'.'+decimal(BH);
               if BX=$3205 then st:='NT DOS Box';
               if st<>vers then vers:=vers+' (really '+st+')';
               if DL<>0 then vers:=vers+'r'+decimal(DL and 7);
               end;
            end;
if not (hi(word(DRDOS)) in [0,$44])
   then begin
        vers:=copy(vers,1,byte(pred(pos(' ',vers))));
        if st<>vers then vers:=vers+'/'+st;
        case word(DRDOS) of
             $1060 : st:='DOS plus';
             $1063 : st:='DRDOS 3.31';
             $1064 : st:='DRDOS 3.41';
             $1065 : st:='DRDOS 5';
             $1067 : st:='DRDOS 6';
             $1070 : st:='PalmDOS';
             $1071 : st:='DRDOS 6-March93 b.u.';
             $1072 : st:='Novell DOS 7';
             $1073 : st:='OpenDOS 7.0'; {should cover SETVER fully some day}
             $1074..$10FF : st:='OpenDOS '+GetEnv('VER')+'?';
             $1432 : st:='Concurrent PCDOS 3.2';
             $1466 : st:='DR Multiuser DOS 5.1';
             $1467 : st:='Concurrent DOS 5.1';
             $1400..$1499 : st:='Concurrent DOS '+decimal(byte(DRDOS) shr 4)+'.'+decimal(byte(DRDOS) and 15);
             end;
        DosVersionString:=st+' (pretending to be '+vers+')';
        exit;
        end;
case oemCode of {not DRDOS/OpenDOS etc}
                           0 : if copy(st,1,3)='3.3' then st:=''
                                                     else st:='PC-';
                           1 : st:='Compaq ';
                           2,$FF : st:='MS';
                           4 : st:='AT&T ';
                           5 : st:='Zenith ZDS ';
                           6,$4D : st:='HP ';
                           7 : st:='ZDS ';
                         $0D : st:='Packard-Bell ';
                         $16 : st:='DEC ';
                         $23 : st:='Olivetti ';
                         $28 : st:='TI ';
                         $29 : st:='Toshiba ';
                         $33 : st:='Novell '; {won't happen here}
                         $5E : st:='Rx';
                         $66 : st:='PTS-';
                         $99 : st:='General Software ';
                         $EE : st:='DR'; {??}
                         $FD : st:='Free';
                         else st:='??DOS';
                         end;
DosVersionString:=st+'DOS '+vers;
end;

procedure ScanFile(var FileInfo : FileInfoPacket; var file_version,file_copyright,file_checksum : string80);
   var i,j,k : word; b : integer; CRC : longint;

    procedure fixup(var st : string80);
    var i : integer;
    begin
    for i:=1 to length(st) do if st[i] in [#0..#31,#127,#176..#223,#255]
        then begin st[0]:=chr(i-1); exit; end
    end;

    function better(v1,v2 : string) : boolean; {report if v1 more valid version string}
    const goodstuff = #0#9#13' '').';
    var i,j,k : byte;
    begin
    better:=true;
    if length(v2)<2 then exit;
    i:=1; repeat inc(i) until (i>length(v1)) or not (v1[i] in ['0'..'9','A'..'Z','a'..'z']);
    j:=1; repeat inc(j) until (j>length(v2)) or not (v2[j] in ['0'..'9','A'..'Z','a'..'z']);
    if pos(v2[j],goodstuff)>pos(v1[i],goodstuff)
       then better:=false;
    end;

   begin
   file_version:='';
   file_copyright:='';
   file_checksum:='';
   fillchar(buffer,sizeof(buffer),0);
   CRC_Value:=0;
   j:=0;
   with FileInfo do repeat
          k:=sizeof(buffer)-j;
          {$I-}
          blockread(fyle,buffer[j],k,bytesRead);
          {$I+}
          i:=IORESULT;
          if i<>0
             then ErrorMessage(DosErrorMessage(i)+' in: '+trim0(LFN)+' @'+decimal(FilePos(fyle)));
          for b:=j to (j+BytesRead-1)
              do Compute_crc_256(byte(buffer[b]));
          for i:=k-9 downto 1 do
              case buffer[i] of
                'V','v': if buffer[i+1]='e' then
                            if buffer[i+2]='R'
                               then begin
                                    file_version:=trim0(buffer[i+length('Version=')])
                                    end
                               else if (buffer[i+2]='r')
                                       then if buffer[i-2]='c'
                                               then begin
                                                    if buffer[i+8]=#0
                                                       then file_version:=trim0(buffer[i+9])
                                                       else file_version:='(same as Windows)'
                                                    end
                                               else begin
                                                    st:=trim0(buffer[i+3]);
                                                    if st[1] in ['s','.',' ',':']
                                                       then while (st<>'') and (st[1]in [#0..' ','=',':','A'..'z'])
                                                            do delete(st,1,1);
                                                    if (st[1] in ['0'..'9',''''])
                                                       then if better(st,file_version)
                                                               then file_version:=st;
                                                    end;
                'C','c' : case buffer[i+1] of
                               ')' : if (buffer[i-1]='(') and (file_copyright='')
                                        then begin
                                             file_Copyright:=trim0(buffer[i-1]);
                                             st:=trim0(buffer[i-20]);
                                             if copy(st,1,8)='Portions'
                                                then file_copyright:=copy(st,1,byte(pos('land',st)-1)+4);
                                             if verbosity=245 then writeln('now (c)=',file_copyright,^M^J' st=',st);
                                             end;
                               'o' : if (buffer[i+2]='P') and (buffer[i+4]='R')
                                        then begin
                                             file_Copyright:=trim0(buffer[i+length('copyright=')]);
                                             if verbosity=245 then writeln('now CoP=',file_copyright,' st=',st);
                                             end
                                        else if (buffer[i+2]='p') and (file_copyright='') and (buffer[i+5]='i')
                                               and not (buffer[i-1] in ['+','_',''''])
                                                then begin
                                                     File_copyright:=trim0(buffer[i]);
                                                     st:=trim0(buffer[i-20]);
                                                     if copy(st,1,8)='Portions'
                                                        then file_copyright:=copy(st,1,byte(pos('land',st)-1)+4);
                                                     if verbosity=245 then writeln('now Cop=',file_copyright,' st=',st);
                                                     end;
                               'O' : if (buffer[i+2]='P') and (file_copyright='')
                                        then File_copyright:=trim0(buffer[i]);
                               end;
                   end;
          j:=16;
          if j<k then move(buffer[j],buffer[0],j);
          until bytesRead<k;
   fixup(file_version);
   if file_copyright<>''
      then begin
           fixup(file_copyright);
           i:=pos('Copyr',file_copyright);
           if i in [1..4]
              then file_copyright:=copy(file_copyright,i,99);
           if copy(file_copyright,1,2)='''+'
              then file_copyright:='';
           end;
   if verbosity=245 then writeln('file_cop=',file_copyright);
   File_Checksum:=copy(hex4(CRC_Value),5,4);
   end;

function SearchForFile(var FileInfo : FileInfoPacket) : boolean;
const extension : array[0..3] of string[4] = ('','.com','.bat','.exe');
var st,path,fn : string;
    i          : byte;
    TryUnix : boolean;
begin
SearchForFile:=false;
path:='.;'+GetEnv('PATH');
TryUnix:=false;
with FileInfo do
  if directory<>''
   then exit
   else while path>'' do 
     begin
     st:=copy(path,1,byte(pred(pos(';',path))));
     delete(path,1,length(st)+1);
     if st[length(st)]='/'
        then TryUnix:=true
        else if not (st[length(st)] in [':','\']) then st:=st+'\';
        {test for .zip some day}
     directory:=Fexpand(st);
     if FileExists(directory+trim0(Shortname))
        then begin SearchForFile:=OpenFile(FileInfo); exit; end
        else begin
             st:=directory+trim0(LFN);
             for i:=0 to 3 do
                 if FileExists(st+extension[i])
                    then begin
                         st:=trim0(LFN)+extension[i]+#0;
                         move(st[1],LFN,length(st));
                         move(st[1],Shortname,14);
                         SearchForFile:=OpenFile(FileInfo);
                         exit;
                         end;
             end;
     end;
end;

begin   {Main Program}

if not Parse('VeRsIoN='+version+#0,'CoPyRiGhT='+copyright+#0,author,

        ValidOptions,Syntax,WhatItDoes)
	then halt;

if (pos('/D',Globals)>0)  or (CommandLIne^ = '')
   then begin
        st:=DosVersionString;
        if (CommandLine^='') and (DosEmu_Version<>'')
           then st:=st+' under DOSEMU: '+DosEmu_Version;
        writeln('DOS version: '+st);
        end;
if (pos('/E',Globals)>0)
   then begin
        st:=DosEmu_Version;
        if st<>''
           then begin
                write('DOSEMU version: '+st+', ');
                if boolean(Verbosity and 2)
                   then ExecUnix('uname -smr') { call Linux to report version}
                   else writeln;
                end
           else {check for Windoze, etc?};
        end;

if (pos('/B',Globals)>0)
   then begin
        st:=TryToString(RomCopyright);
        if (Verbosity and 64)=0 then st:='';
        writeln('BIOS date: '+TryToString(BiosDate+' '+st));
        end;

if (pos('/M',Globals)>0)
   then begin
        write('Machine ID: ',hex(MachineID));
        case lo(MachineID) of
             ID_PC : st:='PC';
             ID_XT : st:='XT';
             ID_PCjr : st:='PCjr';
             ID_AT : st:='AT';       
             ID_PS2 : st:='PS2';
             ID_Bison : st:='Bison';
             ID_OldCompaq,
             ID_OldCompaqXT : st:='old Compaq';
             else case hi(MachineID) of
	               $CA : st:='yuk!';
	               $FE : st:='M20';
	               else if IVect[$65]<>IVect[$63]
	                    then st:='DG10'
	                    else if seg(IVect[$FD]^)>=$FC00
	                         then st:='MBC550'
	                         else st:='very old clone';
	               end {of case hi}
             end {of case lo};

        if st<>'' then writeln(' ('+st+')')
                  else writeln;
        end;

st:=GetGlobalSpec('/C');
if st[1] in ['$','0']
   then Generate_table_256(StringToInteger(st))
   else case pos(capitals(copy(st,length(st)-1,2)),'1216TT') of
             1 : Generate_table_256(CRC_12);
             3 : Generate_table_256(CRC_16);
             else Generate_table_256(CRC_CCITT);
             end;
GetFileMode := [FilesNeedNotExist  ];
RecurseOption:=pos('/S',Globals)>0;

while GetFile(FileInfo) do
  if (FileInfo.Attributes and (Directory or VolumeID))=0 
   then begin
        if openFile(FileInfo) or SearchForFile(FileInfo)
           then with FileInfo do
                begin
                Scanfile(FileInfo,file_version,file_copyright,file_checksum);
                close(Fileinfo.fyle);
                if BriefOutput
                   then OutputLine(File_Version+'  '+directory+trim0(LFN))
                   else begin
                        OutputLine(trim0(LFN)+':');
                        if File_Version=''
                           then OutputLine('        Version number not found.')
                           else OutputLine('   Version '+file_Version+'.');
                        if file_copyright<>''
                           then OutputLine('   '+file_Copyright);
                        if File_Checksum<>''
                           then OutputLine('   Checksum is '+File_Checksum+'.'^M^J);
                        end;
                end
           else ;

        end;

FinishOff;

end.
