; UDMA Driver for DOS  Copyleft (G) 2003 Jack R. Ellis and Luchezar I. Georgiev
%define	 Version '6.5'
%if 0

UDMA is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License (herein called GPL), as published by the Free
Software Foundation; either version 2 of the GPL, or (at your option) any later
version. UDMA is distributed hoping that it would be useful to you, but WITHOUT
ANY GUARANTEE; without even the implied guarantee of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GPL for details. You ought to have received a
copy of it along with UDMA; if not, write to the Free Software Foundation, Inc.
59 Temple Place, Suite 330, Boston, MA 02111-1307  USA	(www.gnu.org/licenses/)

Program history:
Version	 Date (D.M.2003)
6,5	21.12	Multi-sector read test on install to detect more errors (JE&LG)
6,4	7.XII	No VDS active check, VDS unlock on installation failure (JE&LG)
6,3	30.XI	Extra resident space optimisation & must run on FW82801CAM (LG)
6,2	25.XI	Ultimate resident space optimisation & do not check RDY (JE&LG)
6,1	15.XI	Optimisation, no initial ChkRdy, don't load if HD > 128 GB (LG)
6,0	9.XI.	Check LBA heads & sectors, and test reading before loading (LG)
5,9	7.XI.	Require a 386+ so universal installers fail, Ready removed (LG)
5,8	3.XI.	All error codes replaced by FF, resident part optimised (JE&LG)
5,7	2.XI.	Resident optimisation, streamline Identify install code (JE&LG)
5,6	27.X.	No EAX, reject > 28-bit LBA, no ONCYL, unlock on errors (JE&LG)
5,5	22.X.	Optimisation, no VDSAddr test, survive VDS misdetection (JE&LG)
5,4	18.X.	Ultra heavy resident space optimisation, exclude VDS ID (JE&LG)
5,3	14.X.	Bug fix: in case of XMS error, nonzero BX currupted memory (JE)
5,2	13.X.	Data and code space optimisation, DUMB_XMS code removed (JE&LG)
5,1	12.X.	64KB buffer, one-pass transfer, allow 1 to 128 blocks only (JE)
5,0	11.X.	Use a 32KB XMS buffer lowering resident RAM usage 7+ times (JE)
4,9	10.X.	Experimental multiple PRD version: abandoned, not released (JE)
4,8	9.10.	Lower resident stack use, revert back to old VDS detection (LG)
4,7	8.10.	Optimise resident code further: allow EAX MSW save/restore (LG)
4,6	7.10.	Spare several tens of bytes by optimising resident code (JE&LG)
4,5	6.10.	Error resets Start/Stop, try default HDD only if single (JE&LG)
4,4	5.10.	Optimise resident code addressing & fix buffered output (JE&LG)
4,3	4.10.	Fix a typo bug at "Output", was destroying buffered writes (LG)
4,2	3.10.	Fix "Ready" for 686A, fix controller ports/bits for slaves (LG)
4,1	2.10.	If no EDD BIOS, use the primary master; show disk location (LG)
4,0	1.10.	Resident variables and code optimisation, clean-up and fix (JE)
3,9	30.9.	Detect address of BIOS hard disk 80h, "Ready" optimised (LG&JE)
3,8	29.9.	Read entire ID block, use Active DMA mode, options removed (LG)
3,7	28.9.	Two bugs introduced in some earlier version and v3.6 fixed (JE)
3,6	27.9.	Minor changes to "DoIO", reset Start/Stop on interrupts (JE&LG)
3,5	26.9.	Hex in place to allow redirection, model not shown if none (LG)
3,4	25.9.	Load only if an UDMA-capable HDD is found & show its model (LG)
3,3	24.9.	Mode option sets also default mode, detect/show controller (LG)
3,2	23.9.	Correctly handle the case when UDMA mode bits are all zero (LG)
3,1	22.9.	Added conditional-assembly of Quick-Write driver thru -DQW (JE)
3,0	21.9.	Error display bug fix, hard disk mode detection simplified (LG)
2,9	17.9.	Code cleanup and optimisation, the 'W' test option removed (JE)
2,8	16.9.	Ready now waits not only Active low but Interrupt high too (LG)
2,7	15.9.	Save initial VDS lock state, save EAX & do CLI on VDS call (JE)
2,6	14.9.	Check DRQ before starting DMA, detect VDS via call 8102 (JE&LG)
2,5	12.9.	Reduced Ready subroutine, Go bit now reset on next request (JE)
2,4	9.IX.	Send DMAAddr/Len after command/control regs reset, cleanup (JE)
2,3	7.IX.	Load descriptor table pointer reg on each transfer, bugfix (JE)
2,2	6.IX.	Bug fix, code cleanup and optimisation (Jack Ellis &L.Georgiev)
2,1	4.IX.	NASM port, PCI port detection, LBA, options (Luchezar Georgiev)
2,0	1.IX.	Base buffered driver (MASM 5 version) written by Jack R. Ellis.
1,0	22.2.	Base un-buffered driver (MASM 5 version) written by Jack Ellis.
%endif

; General Equates

BUFSIZ	equ	32*512		; Read buffer size
HEADS	equ	255		; LBA heads
SECSHD	equ	63		; LBA sectors per head
SECSCYL equ	HEADS*SECSHD	; LBA sectors per cylinder
RDYTO	equ	7		; 384 ms ready timeout
HD0DAT	equ	1F0h		; Primary hard disk data port
HD0CTL	equ	3F6h		; and control port
RBYTES	equ	(2*1024*65536*12/14318180+1)*512; Read bytes for rate test
	; ( = microseconds per tick, but adjusted for binary megabytes)
	; Number of reads this length per tick = transfer rate in MB/s
BIOSTMR equ	46Ch		; BIOS tick timer offset
HDISKS	equ	475h		; BIOS number of fixed disk drives
CR	equ	13		; Carriage return
LF	equ	10		; Line feed
%define CRLF	CR,LF

; IDE Status bits

BSY	equ	80h		; Device busy
FLT	equ	20h		; Disk fault
DRQ	equ	8		; Data request
ERR	equ	1		; Error flag

; IDE Commands

SETM	equ	3		; Set Mode subcommand
SETF	equ	0EFh		; Set Features
IDCMD	equ	0ECh		; Identify drive
DRCMD	equ	0C8h		; DMA read (write: CAh)

; UDMA Controller status bits

INTRPT	equ	4		; Interrupt has occured
BM_ERR	equ	2		; Bus master error flag
ACTIVE	equ	1		; Bus master IDE active

; Driver Request Header

struc	RP
	.RPlenU resb	2	; Length and sub-unit
	.RPOp	resb	1	; Opcode
	.RPStat resw	1	; Status word
	.RPResN resb	9	; Reserved fields and number of units
	.RPSize resd	1	; Resident driver size
	.RPCmdl resd	1	; Pointer to command line arguments
endstruc

RPERR	equ	8003h		; Request status error flag and unknown command
RPDONE	equ	100h		; Request status done flag

; Driver Header

@	dd	-1		; Link to the next driver
	dw	8000h		; Attributes (bit 15: character device)
XHandle dw	Strat		; Strategy ofst / XMS buffer handle, set by init
BufOffs dd	DevInt		; Interrupt ofst/ XMS buffer offset, set by init

; Resident Variables (NOTE: Order and location VERY CRITICAL!)

DDS	equ	$		; DMA Descriptor Structure (DDS), DWORD-aligned:
VDSLen	dd	0		;	Buffer length
%if $ != @+16
	%error VDSOffs is not 16
%endif	; Used as a multiplier^
VDSOffs dd	0		;	Buffer offset (32-bit), must be at @+16
VDSSeg	dd	0		;	Buffer segment (LSW) and ID (MSW)
VDSAddr dd	0		;	Buffer address (32-bit)
				; Extended Memory Move (EMM) struct./SHARES DDS:
XMSLen	equ	VDSLen		;	32-bit number of bytes to transfer
XMSSrcH equ	VDSOffs		;	Source block handle	    (0 if DS:SI)
XMSSrcA equ	VDSOffs+2	;	32-bit source address	  (may be DS:SI)
XMSDstH equ	VDSSeg+2	;	Destination block handle    (0 if ES:DI)
XMSDstA equ	VDSAddr		;	32-bit destination address(may be ES:DI)
DMAAddr equ	VDSAddr		; DMA buffer address - SHARES DDS address
DMALen	dd	80000000h+RBYTES; DMA buffer length + stop bit: SAME paragraph
PRDAddr dd	DMAAddr		; 32-bit PRD address, set by init
				; I/O Parameters:
Blocks	db	RBYTES/512	;	Number of blocks
LBA	dd	0		;	Logical Block Address and device bits
IOCmd	db	DRCMD		;	Command byte

; Perform a VDS call

Unlock	mov	ax,8104h	; Do VDS unlock on our buffer
	xor	dx,dx
VDSInt	mov	di,DDS		; Point to VDS descriptor block
	int	4Bh
	ret

; Move data to or from the driver XMS buffer. The 48-bit user buffer
; address in VDSOffs/VDSSeg was converted to XMS format by the main
; routine and is ALREADY in the XMS move block source field.
; Entry: SF = 0: input, SF = 1: output

MovData mov	di,XMSDstH	; Point to destination in XMS move block
	js	MovOut		; If output, XMS source OK, set XMS destination
	push	si		; If input, move XMS source (user buffer
	movsw			; address) up to XMS destination (SI = XMSSrcH)
	movsd
	pop	di		; Point to source in XMS move block
MovOut	mov	si,XHandle	; Set XMS buffer handle/offset in move block
	movsw			; as input source, output destination
	movsd
	mov	ah,11		; Move data to or from XMS buffer
	call	0:0		; (SI already points to the XMS move structure)
XEntry	equ	$-4		; XMS driver entry address (set by init)
	cmp	al,1		; Success (Was AX = 1? If so, BL is preserved)?
	ret			; Return with CF = 1 on error or CF = 0 if not

; Execute an I/O request

BufIO	mov	dword [DMAAddr],0; Set driver buffer address
BufBase equ	$-4		; (XMS buffer address, set by init)
DoIO	mov	bp,0		; Load UDMA command register address
PCIAddr equ	$-2		; PCI Base UDMA Address, set by init
	lea	dx,[bp+4]
	push	si		; May be used later by MovData
	mov	si,PRDAddr	; Set controller PRD address pointer
	outsd
	mov	al,[IOCmd]	; Load ATA command (11001000b or 11001010b)
	add	al,0		; Get UDMA command (00001000b or 00000000b)
	aaa
	mov	dx,bp		; Reset UDMA command register
	out	dx,al
	xchg	ax,di		; Save command register "off" state
	inc	dx		; Reset UDMA control register
	inc	dx
	in	al,dx
	or	al,6		; Clear INTRPT and BM_ERR by SETTING them
	out	dx,al
	mov	cx,6
	mov	dx,HD0DAT
IDEAddr equ	$-2		; I/O port base register, set by init
	inc	dx		; Point to sector count register
DMAPar	inc	dx		; SI already points to our I/O parameters
	outsb			; Output them
	loop	DMAPar
	mov	ds,cx		; Segment 0
	mov	cl,RDYTO	; Set timeout limit
	mov	si,BIOSTMR	; Point to BIOS timer
	add	cl,[si]		; 3MSB not needed as we check for equal
ChkDRQ	cmp	cl,[si]
	je	Error		; Time-out? Give up
	in	al,dx		; DX already points to status register
	test	al,DRQ		; Has first DRQ arrived?
	jz	ChkDRQ		; No, wait
	xchg	dx,bp		; Yes, DX = UDMA command, BP = IDE status
	in	al,dx		; Set UDMA Start/Stop bit
	inc	ax
	out	dx,al		; (Transfer begins NOW)
ChkDMA	cmp	cl,[si]
	je	Stop		; Time-out? Stop UDMA
	inc	dx		; Point to status register
	inc	dx
	hlt			; Wait for interrupt from disk or timer...
	in	al,dx		; (minimising delay)
	dec	dx		; Back to UDMA command register
	dec	dx
	and	al,INTRPT+BM_ERR; Any interrupt or error?
	jz	ChkDMA		; No, check again
	or	al,INTRPT	; Yes, make PF = ~BM_ERR
Stop	xchg	ax,di		; Reset UDMA Start/Stop (and Active status) bits
	out	dx,al
	jpe	Error		; Timeout or transfer error? Give up
	inc	dx
	inc	dx
	in	al,dx		; Re-read controller status
	test	al,BM_ERR	; Late bus master error?
	jnz	Error		; Yes, give up
	mov	dx,bp		; Read IDE status
	in	al,dx
	and	al,FLT+ERR	; Error or disk fault at I/O end?
	jz	IORet		; No, exit with CF = SF = 0
Error	stc			; Yes, denote error
IORet	pop	si		; Reload SI and DS
	push	cs
	pop	ds
	ret

; Buffered and direct I/O routines

FunTab	dw	BufIO,MovData,BufIO,DoIO,Unlock

; Main driver routine, invoked by Int 13h (Disk Services) calls.
; For a CHS request, the registers contain the following at entry:
;
;	AH	Command code: we handle only 2 (read) and 3 (write)
;	AL	Sector count
;	CH	Lower 8 bits of starting cylinder number
;	CL	Starting sector number and upper 2 bits of cylinder number
;	DH	Starting head number
;	DL	Unit number: we handle only 80h (hard disk 0)
;	ES:BX	Buffer address
;
; For an LBA request, the registers contain the following at entry:
;
;	AH	Command code - we handle only 42h (read) and 43h (write)
;	DL	Unit number  - we handle only 80h (hard disk 0)
;	DS:SI	Pointer to Device Address Packet (DAP):
;	.DASize resb	1	; Packet size in bytes (16 for IA-32)
;	.DARes1 resb	1	; Reserved (0)
;	.DABlks resb	1	; Number of blocks to transfer
;	.DARes2 resb	1	; Reserved (0)
;	.DABuf	resd	1	; Address of transfer buffer
;	.DABeg	resd	2	; Starting logical block address

NotUs	popa			; Request not for us - reload registers
Old13h	jmp	0F000h:0EC59h	; Go to previous Int 13h vector, set by Init
Entry	cmp	dl,80h		; Is this request for our disk?
	jne	Old13h		; No, exit quick
	push	ax		; Save command code
	and	ah,0BEh		; Mask out LBA and write bits (6 and 0)
	cmp	ah,2		; Is command a read or write?
	pop	ax		; (Restore command code)
	jne	Old13h		; No, exit quick
	pusha			; Yes, save registers
	cld			; Ensure forward moves
	shl	ah,1		; Make AH L00001W0b
	add	ah,DRCMD-4	; Get DMA command byte (C10010W0b). LBA or CHS?
	jnc	MkLBA		; CHS - obtain LBA from CHS
	or	ah,dl		; LBA - restore command MSb
	inc	si		; Skip packet size and reserved byte
	inc	si
	lodsb			; Get LBA block count
	xchg	ax,dx		; Save DMA command and block count
	inc	si		; Skip second reserved byte
	lodsw			; Get transfer buffer address
	xchg	ax,cx		; (offset)
	lodsw
	xchg	ax,bp		; (segment)
	lodsw			; and starting LBA
	xchg	ax,di		; LSW
	lodsw
	xchg	ax,dx		; MSW, re-load DMA command and block count
	jmp	short ChkCnt	; Go check block count
MkLBA	xchg	ax,cx		; Save DMA command and block count
	mov	di,SECSHD	; Get starting sector - 1 in DI
	and	di,ax
	dec	di
	mov	si,dx		; Get starting head in SI
	shr	al,6		; Get cylinder number in AX
	xchg	al,ah
	mov	dx,SECSCYL	; Convert cylinder to sectors
	mul	dx
	xchg	ax,si		; Swap low-order and head number
	mov	al,SECSHD	; Convert head to sectors
	mul	ah
	add	di,ax		; Add to starting sector
	add	di,si		; Add to cylinder/head sectors
	adc	dl,dh
	xchg	ax,bx		; Get buffer offset in AX
	xchg	ax,cx		; Swap offset with command/blocks
	mov	bp,es		; Save segment
ChkCnt	dec	al		; Block count within 1 and 128?
	js	NotUs		; No, let BIOS handle this
	sti			; Yes, be nice
	push	ds		; Save segments
	push	es
	push	cs		; Set our DS
	pop	ds
	push	ds		; Point ES to driver data
	pop	es
	xor	bx,bx		; Clear BX to reference our data
	mov	[bx+LBA-@],di	; Save lower LBA value in I/O parameters
	or	dh,-32		; Set DEV/LBA bits
UNibble equ	$-1		; LBA device register upper nibble
	mov	[bx+LBA+2-@],dx ; Save upper LBA value
	mov	[bx+IOCmd-@],ah ; Save DMA command
	cbw			; Clear AH (AL is positive)
	inc	ax		; Recover block count
	mov	[Blocks],al	; Save it
	shl	ax,1		; Set VDS and DMA length
	mov	[VDSLen+1],ax
	mov	[DMALen+1],al	; (Don't touch the reserved MSW, 0 means 64 KB)
	xchg	ax,cx		; CX: length/256 for 64K cross check, AX: offset
	mov	si,VDSOffs	; = 16
	mov	[si],ax		; Save 32-bit user buffer offset
	mov	[si+2],bx
	test	al,3		; Is user buffer DWORD-aligned?
	xchg	ax,bp		; (Save 32-bit user buffer segment)
	mov	[VDSSeg],ax
	jnz	UseBuf		; No, use buffered logic below
	mul	si		; Yes, set 20-bit DMA address
	add	ax,[si]		; Add offset to scaled segment
	adc	dx,bx
	mov	[VDSAddr],ax	; Save address
	mov	[bx+VDSAddr+2-@],dx
	mov	ax,8103h	; Do VDS lock on our buffer
	mov	dx,0Ch		; Neither remap nor allocate
	call	VDSInt		; VDS error (only if active)?
	jc	UseBuf		; Yes, use buffered logic below
	shl	cx,8		; No error or no VDS - CF:CX = length
	dec	cx		; Add to end address which is at length - 1
	add	cx,[bx+VDSAddr-@]; Will transfer cross a 64 KB boundary?
	jc	Locked		; Yes, unlock user buffer and transfer via XMS
	mov	bl,DRCMD+6	; No, target the last 2 entries in FunTab
	jmp	short Exec	; Go execute them
Locked	call	Unlock
UseBuf	shl	dword [si],16	; Buffered: convert VDSOffs to XMS handle/offset
	add	bl,[bx+IOCmd-@] ; Get command (DRCMD or DRCMD+2) and set SF
Exec	call	[bx+FunTab-@-DRCMD]; BufIO(read)|MovData(write)|DoIO(direct)
	jc	Done		; Error? Exit (else SF = 0)
	call	[bx+FunTab+2-@-DRCMD]; MovData(read)|BufIO(write)|Unlock(direct)
Done	pop	es		; Reload registers
	pop	ds
	popa
	sbb	ah,ah		; 0 (no error) or FF (sense operation failed)
	retf	2		; Discard entry flags

	align	16		; Pad to paragraph boundary
ResEnd	equ	$		; Resident driver part end

; Initialisation Variables

ReqHdr	dd	0		; Device driver request header address
IVDSLen dd	ResEnd		; VDS parameters
IVDSOfs dd	0
IVDSSeg dd	0
IVDSAdr dd	0
CtlAddr dw	HD0CTL		; IDE alternate status

; Messages

ModTab	dd	'16. ','25. ','33. ','44. ','66. ','100.','133.','166.'
TTLMsg	db	'UDMA HDD Driver ',Version,CRLF,'$'
IEMsg	db	'Identify$'
NSMsg	db	'UDMA not supported$'
UMMsg	db	'UDMA mode '
CurMode db	'?, ATA-'
DspMode db	'???.',CRLF,'$'
SEMsg	db	'Set mode$'
VEMsg	db	'VDS lock$'
XEMsg	db	'XMS memory$'
NXMsg	db	'No XMS driver$'
notsup	db	'PCI BIOS 2.0c+ required$'
notfnd	db	'PCI IDE controller not found$'
no_lba	db	'Logic sectors/heads not 63/255$'
toobig	db	'HDD over 128 GiB$'
busmer	db	'Bus master$'
rderor	db	'Read$'
suffix	db	' error - UDMA not loaded',CRLF,'$'
xferat	db	'Transfer rate:   '
mbpstr	db	'? MB/s',CRLF,'$'
unknwn	db	'Unknown Id = '
id_hex	db	'????????$'
fndstr	db	' IDE controller found at:',CRLF,'PCI bus '
bus_no	db	'??, device '
dev_no	db	'??, function '
fun_no	db	'?, base '
basadr	db	'????',CRLF,'$'
no_edd	db	'No EDD BIOS HDD parameters',CRLF,'$'
master	db	'Master$'
slaved	db	'Slave$'
hddstr	db	' hard disk at '
hdbase	db	'????/'
hdctrl	db	'????$'
hdmods	db	': '
modeln	times 40 db 0	; 40 swapped bytes
newlin	db	CRLF,'$'
	align	4	; Required by the PCI table below
buffer	dw	30,0	; Result buffer, its size and flags

; Interface byte table - busmaster, legacy mode (bit writable or not)

itable	db	80h,8Ah,0F0h,0FAh
it_end	equ	$

; PCI vendor and device table. Format: dd <id>, db <dword-aligned name>

devtab:
%include "udma.pci"
dt_end	equ	$

; Strategy routine. This routine saves the device driver request header
; for handling below. At entry, ES:BX points to the header.

Strat	mov	[cs:ReqHdr],bx	; Save device driver request header address
	mov	[cs:ReqHdr+2],es
	retf			; Exit - await DOS Device Interrupt

; Device-Interrupt routine. This routine initialises the driver.

DevInt	push	ds		; Entry - save registers
	push	es
	pushf
	push	ax
	push	bx
	lds	bx,[cs:ReqHdr]	; Point to device driver request header
IsInit	cmp	byte [bx+RP.RPOp],0; Is this an Init command?
	jne	I_BadP		; No, post error and exit
	push	sp		; Yes, check if the CPU is a 386 or newer
	pop	ax
	cmp	ax,sp		; 80286+ push SP, then decrement it
	jne	No_386		; CPU is below 80286
	push	word 7000h	; CPU is at least an 80286 - try to set NT|IOPL
	popf
	pushf
	pop	ax
	test	ah,70h		; NT|IOPL stuck to 0?
	jnz	I_Init		; No, CPU is at least a 386
No_386	mov	word [bx+RP.RPSize],0; Yes, it's a 80286 - post zero size
	mov	[bx+RP.RPSize+2],cs; Silently fail and not crash uni-installers
I_BadP	mov	word [bx+RP.RPStat],RPERR; Unknown command
	pop	bx
	pop	ax
	jmp	I_Ret		; Return
I_Init	pop	bx
	pop	ax
	popf			; Restore original flags
	pushf			; and save them again
	sti			; Be nice
	cld			; Ensure forward moves
	pushad			; Save all extended general-purpose registers
	push	cs		; Set our DS and ES
	pop	ds
	push	cs
	pop	es
	mov	dx,TTLMsg	; Display our title message
	call	putstr

; Find the UDMA controller. Return its base I/O address in AX

	xor	edi,edi
	mov	ax,0B101h
	int	1Ah		; PCI BIOS v2.0c+ installation check
	cmp	edx,'PCI '	; BIOS OK?
	je	biosok		; yes, continue
	mov	dx,notsup	; no, BIOS too old
	jmp	short fnderr
biosok	mov	si,itable
findev	mov	ecx,10100h	; class 1 (storage), subclass 1 (IDE)
	lodsb			; interface byte
	mov	cl,al
	mov	ax,0B103h	; find PCI class code
	push	si
	xor	si,si		; prepare device index (0)
	int	1Ah		; BH: bus, BL: bit 7-3: device, 2-0: function
	pop	si
	jnc	found		; if found, break loop
	cmp	si,it_end	; end of table?
	jne	findev		; no, continue searching
	mov	dx,notfnd	; yes - not found, show error and exit
fnderr	jmp	short finderr
found	xor	di,di		; get vendor/device id
	mov	ax,0B10Ah	; read configuration dword in ECX
	push	bx		; bus/device/function may be distroyed
	int	1Ah
	pop	bx
	xchg	ecx,eax		; look up for the id in the PCI device table
	ror	eax,16		; swap words (MSW: vendor id, LSW: device id)
	mov	cx,(dt_end-devtab)/4
	mov	di,devtab
	repne	scasd		; is it there?
	jnz	unkdev		; no, show its id
	mov	dx,di		; yes, show its name
	call	putstr
	jmp	short putloc
unkdev	mov	di,id_hex	; unknown device - must not occur often
	call	xprint		; show vendor/device id
	mov	dx,unknwn
	call	putstr
putloc	mov	ax,bx		; get bus/device/function for display
	xchg	ah,al
	mov	di,bus_no
	call	_8print		; store bus
	rol	ax,5		; move bits 15:8 to 4:0,15:13
	and	al,11111b
	mov	di,dev_no
	call	_8print		; store device
	rol	ax,3		; move bits 15:13 to 2:0
	and	al,111b
	mov	di,fun_no
	call	_4print		; store function
	mov	di,4		; get command low byte
	mov	ax,0B108h	; read configuration byte
	push	bx		; bus/device/function may be distroyed
	int	1Ah
	pop	bx
	and	cl,101b		; mask Bus Master and I/O Space bits
	cmp	cl,101b		; asked bits supported?
	je	bitsup		; yes, continue
	mov	dx,busmer	; no, display error message and exit
finderr jmp	I_Err
bitsup	mov	di,20h		; point to base address register 4
	mov	ax,0B109h	; read configuration word
	int	1Ah
	xchg	cx,ax		; base address now in AX
	and	ax,0FFFCh	; mask non-signinficant 2LSb
	mov	di,basadr
	call	hprint		; store base address
	mov	dx,fndstr
	call	putstr		; show controller location
	mov	[PCIAddr],ax	; save command register address ( = base)

; Get parameters of the first physical drive from BIOS

	mov	ah,41h		; Check Int 13h (EDD, LBA) extensions present
	mov	bx,55AAh
	call	DskInt
	jc	I_NoEB		; Invalid Command error
	cmp	bx,0AA55h
	jne	I_NoEB		; Invalid magic return value
	test	cl,4
	jz	I_NoEB		; EDD support subset absent
	mov	ah,48h		; Get drive parameters of first BIOS drive
	mov	si,buffer
	call	DskInt
	jc	I_NoEB		; Invalid Command error
	les	si,[si+26]	; Point to DPTE
	mov	ax,es
	cmp	ax,si
	jne	I_DPTE
	cmp	ax,byte -1	; Pointer invalid (FFFF:FFFF)?
	jne	I_DPTE		; No, use it
I_NoEB	mov	dx,no_edd	; Yes, show "No EDD BIOS HDD info"
	call	putstr
	push	byte 0		; But in case of a single HDD, try to find it:
	pop	es
	cmp	byte [es:HDISKS],1; Do we have only one hard disk?
	jne	near I_Quit	; No, don't know which to handle, so give up
	mov	al,[UNibble]	; Yes, try to find the primary master disk
	mov	dx,HD0DAT
	jmp	short I_IDev
I_DPTE	mov	cx,16		; Calculate DPTE checksum
	mov	al,0
	mov	bx,si
I_CkSm	add	al,[es:bx]
	inc	bx
	loop	I_CkSm
	cmp	al,0		; Is DPTE valid (checksum = 0)?
	jne	I_NoEB		; No, EDD BIOS error
	mov	al,[es:si+4]	; Yes, copy DPTE fields we need
	mov	[UNibble],al	; Device register upper nibble
	mov	[LBA+3],al	; Save it for read test
	les	dx,[es:si]	; I/O port base and control port address
	mov	[IDEAddr],dx
	mov	[CtlAddr],es

; Get IDE parameters from the drive

I_IDev	add	dx,byte 6	; Point to device register
	out	dx,al
	mov	al,IDCMD	; Issue Identify Device command
	inc	dx		; Point to command register
	call	I_Cmd		; Clear BX and do it
	mov	dx,IEMsg	; "Identify error"
	jc	I_Err1		; Error? Display message
	mov	dx,[bx+IDEAddr-@]; Point to controller PIO data register
	mov	cx,256		; Get the Identify data
	mov	di,buffer
	rep	insw
	mov	si,buffer+54	; Get model number (ID bytes 54-93)
	mov	di,modeln
	mov	cl,20
I_GetM	lodsw
	xchg	ah,al		; Swap its bytes
	stosw
	loop	I_GetM
	test	byte [UNibble],16; Master device?
	mov	dx,master
	jz	I_ShMS		; Yes, show "Master"
	mov	dx,slaved	; No, show "Slave"
I_ShMS	call	putstr
	mov	ax,[IDEAddr]	; Prepare I/O port base address
	test	al,al		; Primary IDE channel (base port 1F0h)?
	js	I_ShPt		; Yes, continue
	add	word [bx+PCIAddr-@],byte 8; Secondary (170h): update UDMA base
I_ShPt	mov	di,hdbase
	call	hprint
	mov	ax,[CtlAddr]	; and control address for display
	mov	di,hdctrl
	call	hprint
	mov	dx,hddstr	; Show the HDD port addresses
	call	putstr
	cmp	word [modeln],byte 0; Valid model number?
	mov	dx,newlin	; (just new line if not)
	jz	I_ModN		; No, don't show it
	mov	dx,hdmods	; Yes, show it
I_ModN	call	putstr

; Check the drive parameters and set UDMA mode

	test	byte [buffer+123],-16; Check number of blocks
	mov	dx,toobig	; Over 128 GiB?
	jnz	I_Err1		; Yes, show message and exit
	mov	ah,8		; Get drive parameters of BIOS hard disk 0
	call	DskInt
	jc	I_ELBA		; Drive parameter activity failed
	and	cl,SECSHD	; Clear cylinder bits
	cmp	cl,SECSHD	; Sectors per cylinder = 63?
	jnz	I_ELBA		; No, error
	cmp	dh,HEADS-1	; Heads = 255 (maximum head number = 254)?
	je	I_SetM		; Yes, continue
I_ELBA	mov	dx,no_lba	; No, show "HDD not in LBA mode" and exit
I_Err1	jmp	short I_Err2
I_SetM	test	byte [buffer+106],4; Are UDMA flag bits valid?
	jz	I_NSup		; No, UDMA not supported error
	mov	al,[buffer+177] ; Yes, get selected UDMA mode flag byte
	xor	ah,ah
	bsr	ax,ax		; Get highest mode bit number
	jnz	I_DMod		; No mode bit is set - "Not supported" error
I_NSup	mov	dx,NSMsg	; Show "Not supported" message and exit
I_Err2	jmp	short I_Err3
I_DMod	mov	dx,UMMsg	; Set up to display "UDMA mode" message
	cwde
	mov	ebx,[ModTab+eax*4]
	mov	[DspMode],ebx	; Set displayed mode
	add	al,'0'
	mov	[CurMode],al	; Update current mode value
	call	putstr
	mov	dx,[IDEAddr]
	inc	dx		; Point to subcommand register
	mov	al,SETM		; Set Mode Select subcode
	out	dx,al
	inc	dx
	mov	al,[CurMode]	; Set desired UDMA mode value
	add	al,10h
	out	dx,al
	mov	al,SETF		; Issue Set Features command to disk
	add	dx,byte 5	; Point to command register
	call	I_Cmd		; Error (clears BX)?
	jnc	short I_Lock	; No, continue
I_SErr	mov	dx,SEMsg	; Set mode error - point to message
I_Err3	jmp	short I_Err4

; Lock resident part if VDS active. Set up PRD address and XMS buffer

I_Lock	xor	eax,eax		; Get driver code segment
	mov	ax,cs
	mov	[IVDSSeg],ax	; Set code segment in VDS block
	shl	eax,4		; Save 20-bit driver physical address
	mov	[IVDSAdr],eax
	mov	ax,8103h	; Lock our driver into memory
	mov	dx,0Ch		; Neither remap nor allocate
	mov	di,IVDSLen
	int	4Bh		; Successful?
	jnc	I_SetA		; Yes, go set addresses
	mov	dx,VEMsg	; No, point to "VDS lock error" message
I_Err4	jmp	short I_Err5	; Go display error message and exit
I_SetA	mov	eax,[IVDSAdr]	; Get 32-bit starting driver address
	add	[bx+PRDAddr-@],eax; Set 32-bit PRD address
	mov	word [bx+VDSLen-@],0; Reset lower word of VDS length
	mov	ax,4300h	; Inquire about an XMS driver
	int	2Fh
	cmp	al,80h		; Is an XMS driver installed?
	je	I_SavX		; Yes, save XMS entry address
	mov	dx,NXMsg	; Point to "No XMS driver" message
I_Err5	call	putstr
	jmp	I_Quit		; Go display error message and exit
I_SavX	mov	ax,4310h	; Save XMS driver entry address
	int	2Fh
	mov	[XEntry],bx
	mov	[XEntry+2],es
	mov	ah,9		; Request 128K of XMS memory
	mov	dx,128
	call	far [XEntry]
	dec	ax		; Did we get our buffer memory?
	jnz	I_XErr		; No? Display error message and exit
	mov	[XHandle],dx	; Save our buffer handle
	mov	ah,0Ch		; Lock our XMS memory buffer
	call	far [XEntry]
	dec	ax		; Did buffer get locked?
	jz	I_SavB		; Yes, save buffer address
I_XErr	mov	dx,XEMsg	; Point to "XMS memory" error message
	jmp	I_Err		; Go display error message and exit
I_SavB	mov	[BufBase],bx	; Save 32-bit XMS buffer address
	mov	[BufBase+2],dx
	mov	eax,[BufBase]	; Find 1st 64K boundary in our 128K
	mov	[DMAAddr],eax	; Prepare for buffered transfer
	add	eax,65536
	xor	ax,ax
	xor	bx,bx		; Needed by BufIO
	xchg	eax,[bx+BufBase-@]; Set final buffer address and get old
	neg	eax		; Set buffer offset in original 128K
	add	eax,[bx+BufBase-@]
	mov	[BufOffs],eax

; Test reading speed and verify reading with BIOS

	mov	si,BIOSTMR	; Point to BIOS timer
	call	BufIO		; Do a primary read to start from same place
	jc	I_RErr		; Error? Exit
	mov	ax,bx		; Clear read counter
	mov	es,bx		; Segment 0
	mov	cl,[es:si]	; Load current timer tick count LSB
I_Wait	cmp	cl,[es:si]	; Next tick arrived?
	je	I_Wait		; No, keep waiting
	add	cl,1+4		; Yes, update and prepare for 4 passes
I_Read	inc	ax		; Yes, count reads up
	push	ax		; Save counters
	push	cx
	call	BufIO		; Read RBYTES bytes
	pop	cx		; Reload counters
	pop	ax
I_RErr	jc	I_RdEr		; Read error? Exit
	cmp	cl,[es:si]	; Next timer interrupt arrived?
	jne	I_Read		; No, read once more
	shr	ax,2		; Yes, get average rate for the 4 passes
	push	ds		; Set ES = DS
	pop	es
	mov	di,mbpstr	; Store transfer rate in MB/s
	call	itoa
	mov	dx,xferat	; Show it
	call	putstr
	mov	ax,3513h	; Get current Int 13h vector
	int	21h
	mov	[Old13h+1],bx	; Save vector for passed requests
	mov	[Old13h+3],es
	push	ds		; Buffer segment
	pop	es
	mov	bx,tstbuf
	mov	si,bx		; Source comparison address
	call	RdBuf		; Read to buffer 1 via the old Int 13h handler
	jc	I_RdEr		; Error? Exit
	mov	ax,2513h	; Hook our driver into Int 13h
	mov	dx,Entry
	int	21h
	mov	bx,tstbuf+BUFSIZ
	mov	di,bx		; Destination comparison address
	call	RdBuf		; Read to buffer 2 via the new Int 13h handler
	jc	I_Back		; Error? Revert to the old one
	mov	cx,BUFSIZ/2	; Compare both read blocks
	repe	cmpsw
	jcxz	I_OK		; If compare OK, exit successfully

; Turn back on error, else load driver

I_Back	mov	ax,2513h	; Else set back the old Int 13h vector
	lds	dx,[Old13h+1]
	int	21h
	push	cs		; Reload DS
	pop	ds
I_RdEr	mov	dx,rderor	; Show "Read error" and exit
I_Err	call	putstr		; Display error message and suffix
	mov	ax,8104h	; Unlock if locked
	push	ds
	pop	es
	mov	di,IVDSLen
	xor	dx,dx
	int	4Bh
I_Quit	mov	dx,suffix
	call	putstr
	les	bx,[ReqHdr]	; Post 0 size and error status
	mov	word [es:bx+RP.RPStat],RPERR; Unknown command
	mov	word [es:bx+RP.RPSize],0
	jmp	short I_Exit	; Go reload registers and exit
I_OK	les	bx,[ReqHdr]	; Post success code and driver size
	mov	word [es:bx+RP.RPStat],RPDONE
	mov	word [es:bx+RP.RPSize],ResEnd
I_Exit	mov	[es:bx+RP.RPSize+2],cs
	popad			; Reload registers and exit
I_Ret	popf
	pop	es
	pop	ds
	retf

; Issue initialisation commands to our disk

I_Cmd	out	dx,al		; Issue the command
	xor	bx,bx		; Needed by ChkRdy
	mov	es,bx		; Segment 0
	mov	di,BIOSTMR	; Point to BIOS timer
	mov	cl,RDYTO	; Set up command time limit
	add	cl,[es:di]	; 3MSB not needed as we check for equal
ChkRdy	cmp	cl,[es:di]
	je	I_CmdE		; Time-out? Exit
	in	al,dx
	and	al,BSY+FLT+ERR	; Busy, error or disk fault at I/O end?
	js	ChkRdy		; Busy - loop back and check again
	jz	I_CmdX		; OK - exit without carry
I_CmdE	stc
I_CmdX	push	ds		; Reload ES
	pop	es
	ret			; Exit

; Read BUFSIZ bytes to buffer at ES:BX

RdBuf	mov	ax,200h+BUFSIZ/512
	mov	cx,300h+SECSHD	; cylinder 3, sector 63
DskInt	mov	dx,0F80h	; head 15, drive 80h
	int	13h
	ret

; Right-justified unsigned decimal AX output to ES:DI (points to buffer END)

itoa	std			; store in reverse direction
	mov	cx,10		; CX = divisor
nxtd	xor	dx,dx		; DX:AX = dividend
	div	cx
	xchg	dx,ax		; DX = quotient, AX = reminder
	add	al,'0'		; convert to ASCII
	stosb
	xchg	dx,ax		; AX = quotient
	or	ax,ax		; zero?
	jnz	nxtd		; no, continue
	cld			; yet, restore forward direction
	ret

; Tightest but cryptic hex output to ES:DI

xprint	call	_32p
_32p	ror	eax,16
hprint	call	_8p
_8p	xchg	al,ah
_8print call	_4p
_4p	ror	al,4
_4print push	ax
	and	al,0Fh
	cmp	al,10
	sbb	al,69h		; 0-9 => 96h-9Fh, 0Ah-0Fh => 0A1h-0A6h
	das			; subtract 66h from digits or 60h from letters
	stosb			; store 30h-39h ('0'-'9') or 41h-46h ('A'-'F')
	pop	ax
	ret

; Display string in DX

putstr	push	ax
	mov	ah,9
	int	21h
	pop	ax
	ret

; Read test buffer

	align	4
tstbuf	times	BUFSIZ	dw 0
%if $ > @+10000h
	%error BUFSIZ too big
%endif
