;			   Ultra DMA Driver for DOS


%define Version '5.3  Copyleft (G) 2003 J.Ellis and L.Georgiev',CRLF,\
'Dedicated to the 100 year anniversary of the birth of John Atanasoff',CRLF,\
'- the inventor of the first electronic digital computer in the world!',CRLF
%if 0

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.
You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place, Suite 330, Boston, MA	02111-1307  USA	 (www.gnu.org)

Version	 Date
5.3    14/10/3	Bug fix: in case of XMS error, nonzero BX currupted memory (JE)
5.2    13/10/3	Data and code space optimisation, DUMB_XMS code removed (JE&LG)
5.1    12/10/3	64K buffer, one-pass transfer, allow 1 to 128 sectors only (JE)
5.0    11/10/3	Use a 32K XMS buffer, lowering resident RAM usage 7+ times (JE)
4.9    10/10/3	Experimental multiple PRD version: abandoned, not released (JE)
4.8	9/10/3	Lower resident stack use, revert back to old VDS detection (LG)
4.7	8/10/3	Optimise resident code further: allow EAX MSW save/restore (LG)
4.6	7/10/3	Spare several tens of bytes by optimising resident code (JE&LG)
4.5	6/10/3	Error resets Start/Stop, try default HDD only if single (JE&LG)
4.4	5/10/3	Optimise resident code addressing & fix buffered output (JE&LG)
4.3	4/10/3	Fix a typo bug at "Output", was destroying buffered writes (LG)
4.2	3/10/3	Fix "Ready" for 686A, fix controller ports/bits for slaves (LG)
4.1	2/10/3	If no EDD BIOS, use the primary master; show disk location (LG)
4.0	1/10/3	Resident variables and code optimisation, clean-up and fix (JE)
3.9	30/9/3	Detect address of BIOS hard disk 80h, "Ready" optimised (LG&JE)
3.8	29/9/3	Read entire ID block, use Active DMA mode, options removed (LG)
3.7	28/9/3	Two bugs introduced in some earlier version and v3.6 fixed (JE)
3.6	27/9/3	Minor changes to "DoIO", reset Start/Stop on interrupts (JE&LG)
3.5	26/9/3	Hex in place to allow redirection, model not shown if none (LG)
3.4	25/9/3	Load only if an UDMA-capable HDD is found & show its model (LG)
3.3	24/9/3	Mode option sets also default mode, detect/show controller (LG)
3.2	23/9/3	Correctly handle the case when UDMA mode bits are all zero (LG)
3.1	22/9/3	Added conditional-assembly of Quick-Write driver thru -DQW (JE)
3.0	21/9/3	Error display bug fix, hard disk mode detection simplified (LG)
2.9	17/9/3	Code cleanup and optimisation, the 'W' test option removed (JE)
2.8	16/9/3	Ready now waits not only Active low but Interrupt high too (LG)
2.7	15/9/3	Save initial VDS lock state, save EAX & do CLI on VDS call (JE)
2.6	14/9/3	Check DRQ before starting DMA, detect VDS via call 8102 (JE&LG)
2.5	12/9/3	Reduced Ready subroutine, Go bit now reset on next request (JE)
2.4	 9/9/3	Send DMAAddr/Len after command/control regs reset, cleanup (JE)
2.3	 7/9/3	Load descriptor table pointer reg on each transfer, bugfix (JE)
2.2	 6/9/3	Bug fix, code cleanup and optimisation (Jack Ellis &L.Georgiev)
2.1	 4/9/3	NASM port, PCI port detection, LBA, options (Luchezar Georgiev)
2.0	 1/9/3	Base buffered driver (MASM 5 version) written by Jack R. Ellis.
1.0	22/2/3	Base un-buffered driver (MASM 5 version) written by Jack Ellis.
%endif

; General Program Equations

SECSCYL equ	255*63		; LBA sectors per cylinder
SECSHD	equ	63		; LBA sectors per head
RDYTO	equ	7		; 384 msec ready timeout
DMAERR	equ	8		; UDMA status error (DMA overrun code used)
HERROR	equ	0E0h		; Hard disk status error return code
TIMOUT	equ	80h		; Timed-out return code
XMSERR	equ	0BBh		; XMS-error return code ("undefined" error)
PRIMHD	equ	3F601F0h	; Primary hard disk ports

BIOSTMR equ	46Ch		; BIOS tick timer offset
HDISKS	equ	475h		; BIOS number of fixed disk drives
VDSON	equ	47Bh		; VDS services active
CR	equ	0Dh		; ASCII carriage-return
LF	equ	0Ah		; ASCII line-feed
%define CRLF	CR,LF

; IDE Controller Status bits

BUSY	equ	80h		; Controller is busy
DSKRDY	equ	40h		; Disk is ready
FAULT	equ	20h		; Disk has a fault
ONCYL	equ	10h		; Device seek complete
DRQ	equ	8		; Data request by disk
ERROR	equ	1		; General error flag

; IDE Command Definitions

SETM	equ	3		; Set Mode subcommand
SETF	equ	0EFh		; Set Features command
IDCMD	equ	0ECh		; Identify drive command
DRCMD	equ	0C8h		; DMA read command (write is 0CAh)

; UDMA Controller status bits

INTRPT	equ	4		; Interrupt has occured
BM_ERR	equ	2		; Bus master error flag
ACTIVE	equ	1		; Bus master IDE active

; Word and Doubleword Layouts

struc dbt
	.lb	resb	1
	.hb	resb	1
endstruc
struc dwd
	.lw	resw	1
	.hw	resw	1
endstruc

; Device Address (LBA) Packet Layout

struc	DAP
	.DASize resb	1	; Packet size in bytes (16 for IA-32)
	.DARes1 resb	1	; Reserved, must be 0
	.DASC	resb	1	; Number of sectors to transfer
	.DARes2 resb	1	; Reserved, must be 0
	.DABuf	resd	1	; Address of transfer buffer
	.DABeg	resd	2	; Starting logical block address
endstruc

; DOS Request Packet Layout

struc	RP
	.RPlenU resb	2	; Length and sub-unit
	.RPOp	resb	1	; Opcode
	.RPStat resw	1	; Status word
	.RPResN resb	9	; Reserved fields and number of units
	.RPSize resd	1	; Resident driver size
	.RPCmdl resd	1	; Pointer to command line arguments
endstruc

RPERR	equ	8003h		; Strategy packet error flags
RPDON	equ	100h		; Strategy packet done flag

; DOS Driver Device Header

@	dd	-1		; Link to next device-header block
	dw	0C000h		; Driver device attributes
IDEAddr dw	Strat		; Strategy routine offset
				; (IDE I/O port base address after init)
CtlAddr dw	DevInt		; Device-Interrupt routine offset
				; (IDE control port addess after init)
	db	'UDMA$',0	; Driver name

; Resident Driver Variables

Params	equ	$		; I/O Parameters:
SectCt	db	0		;   Sector count
LBA	dd	0		;   Logical Block Address and commands
IOCmd	db	0		;   Command byte
Locked	db	0		; VDS "buffer locked" flag (1 = true)
UNibble db	0E0h		; LBA device register upper nibble
XEntry	dd	0		; XMS driver "entry" address (set by init)
XMS	equ	$		; XMS "move" structure:
XMSLen	dd	0		;   32-bit number of bytes to transfer
XMSSrcH dw	0		;   Source block handle	      (00h if DS:SI)
XMSSrcA dd	0		;   32-bit source address     (may be DS:SI)
XMSDstH dw	0		;   Destination block handle  (00h if ES:DI)
XMSDstA dd	0		;   32-bit destination address(may be ES:DI)
DMAAddr equ	XMSSrcA+2	; 32-bit DMA address - SHARES the VDS block!
DMALen	equ	XMSDstA		; 32-bit DMA length  - SHARES the VDS block!
VDS	equ	$		; VDS Parameter Block:
VDSLen	dd	ResEnd		;   Buffer length
VDSOffs dd	0		;   Buffer offset (32-bit!)
VDSSeg	dd	0		;   Buffer segment (LSW) and ID (MSW)
VDSAddr dd	-1		;   Buffer address (32-bit)
PCIAddr dw	0		; PCI Base UDMA Address (set by init)

; Main driver routine, invoked by Int 13h (Disk Services) calls.
; For a CHS request, the registers contain the following at entry:
;
;   AH	   Command code - we handle only 2 (read) and 3 (write)
;   AL	   I/O sector count
;   CH	   Lower 8 bits of starting cylinder number
;   CL	   Starting sector number and upper 2 bits of cylinder number
;   DH	   Starting head number
;   DL	   Unit number - we handle only 80h (hard disk 0)
;   ES:BX  I/O buffer address
;
; For an LBA request, the registers contain the following at entry:
;
;   AH	   Command code - we handle only 42h (read) and 43h (write)
;   DL	   Unit number	- we handle only 80h (hard disk 0)
;   DS:SI  Pointer to Device Address Packet (DAP), described above

NotUs	popa			; Request not for us - reload registers
Old13h	jmp	0F000h:0EC59h	; Go to previous INT 13h vector, set by Init
Entry	cmp	dl,80h		; Is this request for our disk?
	jne	Old13h		; No, exit quick!
	pusha			; Save all 16-bit CPU registers
	mov	dl,ah		; Get command code in DL
	and	dl,0FEh		; Mask out write (bit 0)
	cmp	dl,2		; Is command a CHS read or write?
	je	CheckSC		; Yes, check sector count
	cmp	dl,42h		; Is command an LBA read or write?
	jne	NotUs		; No, exit quick!
	mov	al,[si+DAP.DASC]; Get LBA I/O sector count
CheckSC dec	al		; Sector count within 1 and 128?
	js	NotUs		; No, let BIOS handle this!
	inc	ax		; Yes, recover sector count
	push	eax		; Save EAX MSW
	pop	ax
	push	ds		; Save segment registers
	push	es
	mov	bp,sp		; Point BP to our stack frame
	and	byte [bp+26],0FEh; Reset exiting carry bit (error flag)
	xchg	al,ah		; Swap opcode and sector count
	shl	al,1		; Make AL L00001W0b
	add	al,DRCMD-4	; Get DMA command byte (C10010W0b)
	jnc	CalcLBA		; LBA or CHS request?
	or	al,DRCMD	; LBA - restore high-order command bits
	les	cx,[si+DAP.DABuf]; Get user I/O buffer address
	mov	dx,[si+DAP.DABeg+dwd.hw]; Get LBA value in SI and DX
	mov	si,[si+DAP.DABeg+dwd.lw]
	jmp	short SaveBuf	; Go save buffer address and LBA value
CalcLBA push	ax		; CHS - save DMA command and sector count
	mov	si,SECSHD	; Save starting sector in SI
	and	si,cx
	mov	di,dx		; Save starting head in DI
	shr	cl,6		; Get cylinder number in CX
	xchg	cl,ch
	mov	ax,SECSCYL	; Convert cylinder to sectors
	mul	cx
	xchg	ax,di		; Swap low-order and head number
	mov	al,SECSHD	; Convert head to sectors
	mul	ah
	add	di,ax		; Add to cylinder sectors
	adc	dl,dh
	dec	si		; Get starting sector number - 1
	add	si,di		; Add to cylinder/head sectors
	adc	dl,dh
	mov	cx,bx		; Save user I/O buffer address
	pop	ax
SaveBuf xor	bx,bx		; Clear BX to reference our data
	push	cs		; Set our DS
	pop	ds
	mov	[IOCmd],al	; Save DMA command and sector count
	mov	[bx+SectCt-@],ah
	movzx	ax,ah		; Set VDS and XMS buffer length
	shl	ax,1
	mov	[VDSLen+1],ax
	mov	[XMSLen+1],ax
	mov	[bx+VDSOffs-@],cx; Save user I/O buffer address
	mov	[bx+VDSSeg-@],es
	mov	[bx+LBA-@],si	; Save lower LBA value in I/O parameters
	or	dh,[bx+UNibble-@]; Set DEV/LBA bits
	mov	[bx+LBA+2-@],dx ; Save upper LBA value in I/O parameters
	mov	word [bx+VDSAddr+2-@],-1; Invalidate DMA address
	test	cl,3		; Is user's buffer DWORD-aligned?
	jnz	UseBuf		; No, use driver-buffered logic below
	mov	es,bx		; Point ES to low memory
	cli			; Prevent VDS mess
	test	byte [es:VDSON],20h; VDS active?
	jnz	DoLock		; Yes, lock our buffer
	mov	eax,[VDSSeg]	; No, set 20-bit DMA address
	shl	eax,4
	add	eax,[bx+VDSOffs-@]
	mov	[VDSAddr],eax
	jmp	short DirDMA	; Go do direct DMA to/from user buffer
DoLock	mov	al,3		; Do VDS lock on our I/O buffer
	mov	dx,0Ch
	call	VDSInt
	jc	UseBuf		; If error, use buffered logic below
	cmp	word [bx+VDSAddr+2-@],byte -1; Got a valid DMA address?
	je	UseBuf		; No, use driver-buffered logic below
	inc	byte [bx+Locked-@]; Set VDS buffer locked flag
DirDMA	mov	eax,[VDSLen]	; Get I/O buffer length - 1
	dec	eax
	add	eax,[bx+VDSAddr-@]; Calculate ending DMA address
	xor	ax,ax		; Clear low-order ending address
	cmp	eax,[bx+VDSAddr-@]; Will this I/O cross a 64K boundary?
	ja	UseBuf		; Yes, use driver-buffered logic below
	call	Ready		; Await controller- and disk-ready
	mov	eax,[VDSAddr]	; Do DMA input direct to user buffer
	call	DoIO
	jmp	short GoodIO	; All done - post "success" and exit
UseBuf	call	Ready		; Await controller- and disk-ready
	cmp	byte [bx+IOCmd-@],DRCMD; Is this a read request?
	jne	Output		; No, use output logic below
	call	BufIO		; Input next block of sectors
	mov	si,XMSSrcH	; Set input parameter pointers
	mov	di,XMSDstH
	call	MovData		; Move driver data to user's buffer
	jmp	short GoodIO	; All done - post "success" and exit
Output	mov	si,XMSDstH	; Output - set parameter pointers
	mov	di,XMSSrcH
	call	MovData		; Move user data to driver's buffer
	call	BufIO		; Output next block of sectors
GoodIO	mov	[bp+21],bl	; Success! Reset exiting AH
Done	shr	byte [Locked],1 ; Was I/O buffer locked by VDS (BL may be != 0)?
	jnc	Exit		; No, reload registers and exit
	mov	al,4		; Do VDS unlock on input buffer
	xor	dx,dx
	call	VDSInt
Exit	pop	es		; Reload registers and exit
	pop	ds
	push	ax
	pop	eax		; Restore EAX MSW
	popa
	iret

; Execute an I/O request

BufIO	mov	eax,0		; Buffered - get driver buffer address
BufBase equ	$-4		; (XMS buffer address, set by init)
DoIO	mov	[DMAAddr],eax	; Set DMA buffer address and length
	mov	eax,[VDSLen]
	mov	[DMALen],eax
	mov	byte [bx+DMALen+3-@],80h
	mov	eax,DMAAddr	; Set controller PRD address pointer
PRDAddr equ	$-4		; (32-bit PRD address, set by init)
	mov	dx,[bx+PCIAddr-@]
	push	dx		; Save UDMA command register address
	add	dx,byte 4
	out	dx,eax
	mov	al,[IOCmd]	; Load ATA command (110010W0b)
	add	al,6		; Get UDMA command (0000W000b)
	and	al,8
	pop	dx		; Reset UDMA command register
	out	dx,al
	inc	ax		; Prepare to set Start/Stop
	xchg	ax,di		; Save UDMA command byte
	inc	dx		; Reset UDMA control register
	inc	dx
	in	al,dx
	or	al,6		; Clear INTRPT and BM_ERR by SETTING them
	out	dx,al
	mov	dx,[bx+IDEAddr-@]
	inc	dx
	inc	dx		; Point to sector count register
	mov	si,Params
	mov	cx,6
DMAPar	outsb			; Output our 6 I/O parameters
	inc	dx
	loop	DMAPar
	call	SeTimer		; Set timeout limit for this request
ChkDRQ	cmp	cl,[es:si]	; IDE timeout? (Unlikely, but...)
	jne	RdStat		; No, go read IDE status
TimedO	mov	ah,TIMOUT	; Timed out! Get error code
BadIO	call	StopDMA		; Reset DMA Start/Stop bit
Error	pop	dx		; Error! Discard return address
	mov	al,0		; Reset exiting sector count
	mov	[bp+20],ax	; Post error code and sector count
	inc	byte [bp+26]	; Set exiting carry bit (error!)
	jmp	Done		; Go see about VDS unlock and exit
Overrun mov	ah,DMAERR	; DMA overrun! Get error code
	jmp	BadIO		; Go stop DMA and take error exit
RdStat	mov	dx,[bx+CtlAddr-@]; Read IDE alternate status
	in	al,dx
	test	al,DRQ		; Has first DRQ arrived?
	jz	ChkDRQ		; No, wait
	xchg	ax,di		; Reload UDMA command byte
	mov	dx,[bx+PCIAddr-@]; Set UDMA Start/Stop bit
	out	dx,al		; (Transfer begins NOW!)
	inc	dx		; Point to status register
	inc	dx
	mov	ch,FAULT+ERROR	; Check disk-fault and error at end
ChkDMA	cmp	cl,[es:si]	; Has a DMA transfer timed out?
	je	TimedO		; Yes? Post timeout and stop DMA!
	hlt			; Wait for an interrupt from disk or timer...
	in	al,dx		; (This minimises delay)
	test	al,BM_ERR	; Bus master transfer error?
	jnz	Overrun		; Yes? Post overrun and stop DMA!
	test	al,INTRPT	; Has interrupt occured?
	jz	ChkDMA		; No, loop back and check again
	call	StopDMA		; Yes, reset UDMA Start/Stop bit
	inc	dx
	inc	dx
	in	al,dx		; Read controller status once again
	test	al,BM_ERR	; Late bus master transfer error?
	jnz	Overrun		; Yes? Post overrun and stop DMA!
ChkRdy	cmp	cl,[es:si]	; Too long without becoming ready?
	je	TimedO		; Yes? Post timeout and stop DMA!
	mov	dx,[bx+IDEAddr-@]; Read IDE controller primary status
	add	dx,byte 7
	in	al,dx
	xor	al,DSKRDY+ONCYL ; Get "not-ready" and "off-cylinder"
	test	al,BUSY+DSKRDY+ONCYL; Controller or disk still busy?
	jnz	ChkRdy		; Yes, loop back and check again
	and	al,ch		; Error or disk fault at I/O end?
	mov	ah,HERROR	; (Load hard-error code if so)
	jnz	Error		; Yes? Post hard-error and exit
	ret			; All is well - exit

; Move data to or from the driver's XMS memory buffer

MovData mov	[si],word 0	; Set parameters in XMS move block
XHandle equ	$-2		; (XMS buffer handle, set by init)
	mov	[si+2],dword 0
BufOffs equ	$-4		; (XMS buffer offset, set by init)
	mov	[di],bx
	mov	ax,[VDSOffs]
	mov	[di+2],eax
	mov	ax,[VDSSeg]
	mov	[di+4],ax
	mov	ah,0Bh		; Move data to or from XMS buffer
	mov	si,XMS
	call	far [bx+XEntry-@]
	dec	ax		; Any errors during XMS move?
	mov	ah,XMSERR	; (Load XMS error code if so)
	jnz	Error		; Yes? Go take error exit! (BL != 0)
	ret			; Exit

; Perform a VDS call

VDSInt	push	ds		; Point to VDS descriptor block
	pop	es
	mov	di,VDS
	mov	ah,81h
	int	4Bh
	ret

; Do the initial check for controller- and disk-ready

Ready	sti			; Enable CPU interrupts
	cld			; Ensure we do forward string commands
	call	StopDMA		; Reset DMA Start/Stop bit, to be safe!
	mov	ch,FAULT	; Consider only disk-fault as error
	call	SeTimer		; Set timeout limit for this check
	jmp	ChkRdy		; Go check IDE controller and drive

; Reset the DMA controller Start/Stop bit

StopDMA mov	dx,[bx+PCIAddr-@]; Point to DMA command register
	in	al,dx		; Reset DMA Start/Stop bit
	and	al,0FEh		; (This will reset Active status bit too)
	out	dx,al
	ret			; Exit

; Set up a timeout limit

SeTimer mov	es,bx		; Segment 0
	mov	si,BIOSTMR	; Point to BIOS timer
	mov	cl,RDYTO
	add	cl,[es:si]	; 3MSB not needed as we check for equal
	ret

	align	16		; Pad to paragraph boundary
ResEnd	equ	$		; Resident driver part end

; Initialization Variables

Packet	dd	0		; DOS init request packet address

; Messages

ModTab	dd	'16. ','25. ','33. ','44. ','66. ','100.','133.','166.'

TTLMsg	db	'UDMA HDD Driver Version ',Version,'$'
IEMsg	db	CRLF,'Identify$'
NSMsg	db	CRLF,'UDMA not supported$'
SMMsg	db	CRLF,'UDMA mode '
CurMode db	'?, ATA-'
DspMode db	'???.',CRLF,'$'
SEMsg	db	CRLF,'Set-mode$'
VEMsg	db	CRLF,'VDS lock$'
XEMsg	db	CRLF,'XMS memory$'
NXMsg	db	CRLF,'No XMS driver$'
Suffix	db	' error - driver NOT loaded',CRLF,'$'
notsup	db	CR,'PCI BIOS 2.0c+ required$'
notfnd	db	'PCI IDE controller not found$'
unknwn	db	'Unknown Id = '
id_hex	db	'????????$'
fndstr	db	' IDE controller found at:',CRLF,'PCI bus '
bus_no	db	'??, device '
dev_no	db	'??, function '
fun_no	db	'?, base '
basadr	db	'????$'
busmer	db	CRLF,'Bus master$'
no_edd	db	CRLF,'No EDD BIOS HDD information available$'
master	db	CRLF,'Master$'
slaved	db	CRLF,'Slave$'
hddstr	db	' hard disk at '
hdbase	db	'????/'
hdctrl	db	'????$'
hdmods	db	': '
modeln	times 40 db 0	; 40 swapped bytes
	db	'$'

; Interface byte table - busmaster, legacy mode (bit writable or not)

itable	db	80h,8Ah,0FAh
it_end	equ	$
	align	4	; Required by the PCI table below

; PCI vendor and device table. Format: dd <id>, db <dword-aligned name>

devtab:
%include "udma.pci"
dt_end	equ	$

; Strategy routine. This routine saves our DOS Init request packet
; for handling below. At entry, ES:BX points to the packet.

Strat	mov	[cs:Packet+dwd.lw],bx; Save DOS request-packet address
	mov	[cs:Packet+dwd.hw],es
	retf			; Exit - await DOS Device Interrupt

; Device-Interrupt routine. This routine initializes the driver.

DevInt	pushf			; Entry - save used registers
	pushad
	push	ds
	push	es
	push	cs		; Set our DS
	pop	ds
	les	bx,[Packet]	; Point to DOS request packet
	cmp	byte [es:bx+RP.RPOp],0; Is this an Init packet?
	jne	near I_BadP	; No? Post errors and exit
	mov	dx,TTLMsg	; Display our title message
	call	putstr
FindIt	push	cs
	pop	es		; Set ES
	cld			; Ensure we do forward moves!
	call	find_it		; Find the UDMA controller PCI base port
	jc	near I_Quit	; Not found? Quit!
	mov	[PCIAddr],ax	; Save command register address ( = base)
	mov	ah,41h		; Check Int 13h (EDD, LBA) extensions present
	mov	bx,55AAh
	mov	dl,80h
	int	13h
	jc	I_NoEB		; Invalid Command error
	cmp	bx,0AA55h
	jne	I_NoEB		; Invalid magic return value
	test	cx,4
	jz	I_NoEB		; EDD support subset absent
	mov	ah,48h		; Get drive parameters of first BIOS drive
	mov	dl,80h
	mov	si,Result
	int	13h
	jc	I_NoEB		; Invalid Command error
	les	si,[si+26]	; Point to DPTE
	mov	ax,es
	cmp	ax,si
	jne	I_DPTE
	cmp	ax,byte -1	; Pointer invalid (FFFF:FFFF)?
	jne	I_DPTE		; No - use it
I_NoEB	mov	dx,no_edd	; Yes, show "No EDD BIOS HDD info"
	push	byte 0		; But in case of a single HDD, try to find it:
	pop	es
	cmp	byte [es:HDISKS],1; Do we have only one hard disk?
	jne	near I_Quit	; No, don't know which to handle, so give up
	mov	al,[UNibble]
	mov	edx,PRIMHD	; Yes - try to find the primary master disk
	jmp	short I_IDev
I_NSup	mov	dx,NSMsg	; Show "Not supported" message and exit
I_Err_	jmp	I_Err
I_DPTE	mov	cx,16		; Calculate DPTE checksum
	mov	al,0
	mov	bx,si
I_CkSm	add	al,[es:bx]
	inc	bx
	loop	I_CkSm
	cmp	al,0		; Is DPTE valid (checksum = 0)?
	jne	I_NoEB		; No - EDD BIOS error
	mov	al,[es:si+4]	; Yes, copy DPTE fields we need
	mov	[UNibble],al	; Device register upper nibble
	mov	edx,[es:si]	; I/O port base and control port address
I_IDev	mov	[IDEAddr],edx
	add	dx,byte 6	; Point to device register
	out	dx,al
	mov	al,IDCMD	; Issue "Identify Device" command
	inc	dx		; Point to command register
	call	I_Cmd
	mov	dx,IEMsg	; "Identify error"
	jc	I_Err_		; Error? Display message
	mov	dx,[IDEAddr]	; Point to controller PIO data register
	mov	cx,27		; Skip ID bytes 0-53
I_Skp1	in	ax,dx
	loop	I_Skp1
	mov	di,modeln	; Get model number (ID bytes 54-93)
	mov	cl,20
I_GetM	in	ax,dx
	xchg	ah,al		; Get model number, swapping its bytes
	stosw
	loop	I_GetM
	push	dx		; Save data port
	test	byte [UNibble],10h; Master device?
	mov	dx,master
	jz	I_ShMS		; Yes, show "Master"
	mov	dx,slaved	; No, show "Slave"
I_ShMS	call	putstr
	mov	ax,[IDEAddr]	; Prepare I/O port base address
	test	al,al		; Primary IDE channel (base port 1F0h)?
	js	I_ShPt		; Yes, continue
	add	word [PCIAddr],byte 8; Secondary (170h): update controller base
I_ShPt	mov	di,hdbase
	call	hprint
	mov	ax,[CtlAddr]	; and control address for display
	mov	di,hdctrl
	call	hprint
	mov	dx,hddstr	; Show the HDD port addresses
	call	putstr
	cmp	word [modeln],byte 0; Valid model number?
	jz	I_Cont		; No - don't show it
	mov	dx,hdmods	; Yes, show it
	call	putstr
I_Cont	pop	dx		; Restore data port
	mov	cl,6		; Skip ID bytes 94-105
I_Skp2	in	ax,dx
	loop	I_Skp2
	in	ax,dx		; Read ID bytes 106 and 107
	mov	bh,al		; Save "DMA valid" flag byte
	mov	cl,34		; Skip ID bytes 108-175
I_Skp3	in	ax,dx
	loop	I_Skp3
	in	ax,dx		; Read ID bytes 176 and 177
	mov	bl,ah		; Save "Selected DMA mode" flag byte
	mov	cl,167		; Skip remaining ID data
I_Skp4	in	ax,dx
	loop	I_Skp4
	test	bh,4		; Are UltraDMA flag bits valid?
	jz	I_NSup		; No - UDMA not supported error
	xor	bh,bh		; Yes, use selected UltraDMA mode
	bsr	ax,bx		; Get highest mode bit number in AX
	jz	I_NSup		; No mode bit is set - "Not supported" error
	mov	dx,SMMsg	; Set up to display "Setting mode" message
I_DMod	cwde
	mov	ebx,[ModTab+eax*4]
	mov	[DspMode],ebx	; Set displayed mode
	add	al,'0'
	mov	[CurMode],al	; Update current mode value
	call	putstr
	mov	dx,[IDEAddr]
	inc	dx		; Point to subcommand register
	mov	al,SETM		; Set mode-select subcode
	out	dx,al
	inc	dx
	mov	al,[CurMode]	; Set desired UltraDMA mode value
	add	al,10h
	out	dx,al
	mov	al,SETF		; Issue set-features command to disk
	add	dx,byte 5	; Point to command register
	call	I_Cmd
	jc	near I_SErr	; Error - display message and exit!
	xor	eax,eax		; Get driver code segment
	mov	ax,cs
	mov	[VDSSeg+dwd.lw],ax; Set code segment in VDS block
	shl	eax,4		; Save 20-bit driver virtual address
	mov	[VDSAddr],eax
	push	byte 0
	pop	es
	pushf			; Save CPU flags
	cli			; Prevent VDS mess
	test	byte [es:VDSON],20h; Are VDS active?
	jz	I_SetA		; No - use 20-bit virtual addresses
	or	dword [VDSAddr],byte -1; Invalidate VDS address
	mov	al,3		; Try to lock this driver into memory
	mov	dx,0Ch
	call	VDSInt
	jc	I_VErr		; Failed? Display error message and exit
	cmp	dword [VDSAddr],byte -1; REALLY got a 32-bit address?
	jne	I_SetA		; Yes, set 32-bit driver addresses
I_VErr	popf			; VDS lock error! Restore CPU flags
	mov	dx,VEMsg	; Point to VDS error message
	jmp	I_Err		; Go display error message and exit
I_SetA	popf			; Restore CPU flags
	mov	eax,[VDSAddr]	; Get 32-bit starting driver address
	add	[PRDAddr],eax	; Set 32-bit PRD address
	mov	word [VDSLen+dwd.lw],0; Reset lower word of VDS length
	mov	ax,4300h	; Inquire about an XMS driver
	int	2Fh
	cmp	al,80h		; Is an XMS driver installed?
	je	I_SavX		; Yes, save XMS "entry" address
	mov	dx,NXMsg	; Point to "No XMS driver" message
	jmp	I_Err		; Go display error message and exit
I_SavX	mov	ax,4310h	; Save XMS driver "entry" address
	int	2Fh
	mov	[XEntry],bx
	mov	[XEntry+2],es
	mov	ah,9		; Request 128K of XMS memory
	mov	dx,128
	call	far [XEntry]
	dec	ax		; Did we get our buffer memory?
	jnz	I_XErr		; No? Display error message and exit
	mov	[XHandle],dx	; Save our buffer handle
	mov	ah,0Ch		; Lock our XMS memory buffer
	call	far [XEntry]
	dec	ax		; Did buffer get locked?
	jz	I_SavB		; Yes, save buffer address
I_XErr	mov	dx,XEMsg	; Point to "XMS memory" error message
	jmp	short I_Err	; Go display error message and exit
I_SavB	mov	[BufBase],bx	; Save 32-bit XMS buffer address
	mov	[BufBase+2],dx
	mov	eax,[BufBase]	; Find 1st 64K boundary in our 128K
	add	eax,65536
	xor	ax,ax
	xchg	eax,[BufBase]	; Set final buffer address & get old
	neg	eax		; Set buffer offset in original 128K
	add	eax,[BufBase]
	mov	[BufOffs],eax
	mov	ax,3513h	; Get current INT 13h vector
	int	21h
	mov	[Old13h+1+dwd.lw],bx; Save vector for passed requests
	mov	[Old13h+1+dwd.hw],es
	mov	ax,2513h	; Hook this driver into INT 13h
	mov	dx,Entry
	int	21h
	les	bx,[Packet]	; Post driver size and success code
	mov	word [es:bx+RP.RPSize+dwd.lw],ResEnd
	mov	[es:bx+RP.RPSize+dwd.hw],cs
	mov	word [es:bx+RP.RPStat],RPDON
	jmp	short I_Exit	; Go reload registers and exit
I_SErr	mov	dx,SEMsg	; Set-mode error! Point to message
I_Err	call	putstr		; Display error message and suffix
I_Quit	mov	dx,Suffix
	call	putstr
	les	bx,[Packet]	; Post 0 size and error status
	mov	word [es:bx+RP.RPSize+dwd.lw],0
	mov	[es:bx+RP.RPSize+dwd.hw],cs
I_BadP	mov	word [es:bx+RP.RPStat],RPERR; "Unknown command"
I_Exit	pop	es		; Reload registers and exit
	pop	ds
	popad
	popf
	retf

; Issue initialization commands to our disk

I_Cmd	out	dx,al		; Issue desired initialization command
	xor	bx,bx
	call	SeTimer		; Set up ID command time limit
I_CmdW	cmp	cl,[es:si]	; Has our ID command timed out?
	je	I_CmdE		; Yes, set CPU carry flag and exit
	in	al,dx		; Get controller alternate status
	test	al,BUSY		; Is our controller still busy?
	jnz	I_CmdW		; Yes, loop back and keep checking
	test	al,ERROR	; Did ID command cause any errors?
	jz	I_CmdX		; No, leave carry flag off and exit
I_CmdE	stc			; Error - set CPU carry flag on
I_CmdX	push	cs
	pop	es		; Restore ES
	ret			; Exit

; Stanislav's tightest but cryptic hex output

xprint	call	_32p
_32p	ror	eax,16
hprint	call	_8p
_8p	xchg	al,ah
_8print call	_4p
_4p	ror	al,4
_4print push	ax
	and	al,0Fh
	cmp	al,0Ah
	sbb	al,69h
	das
	stosb
	pop	ax
	ret

; Display string in DX

putstr	push	ax
	mov	ah,9
	int	21h
	pop	ax
	ret

; Find the UltraDMA controller. Return its base I/O address in AX (CF on error)

find_it xor	edi,edi
	mov	ax,0B101h
	int	1Ah		; PCI BIOS v2.0c+ installation check
	cmp	edx,'PCI '	; BIOS OK?
	je	biosok		; yes, continue
	mov	dx,notsup	; no, BIOS too old
	jmp	finderr
biosok	mov	si,itable
findev	mov	ecx,10100h	; class 1 (storage), subclass 1 (IDE)
	lodsb			; interface byte
	mov	cl,al
	mov	ax,0B103h	; find PCI class code
	push	si
	xor	si,si		; prepare device index (0)
	int	1Ah		; BH: bus, BL: bit 7-3: device, 2-0: function
	pop	si
	jnc	found		; if found, break loop
	cmp	si,it_end	; end of table?
	jne	findev		; no, continue searching
	mov	dx,notfnd	; yes - not found, show error and exit
	jmp	short finderr
found	xor	di,di		; get vendor/device id
	mov	ax,0B10Ah	; read configuration dword in ECX
	push	bx		; bus/device/function may be distroyed
	int	1Ah
	pop	bx
	xchg	ecx,eax		; look up for the id in the PCI device table
	ror	eax,16		; swap words (MSW: vendor id, LSW: device id)
	mov	cx,(dt_end-devtab)/4
	mov	di,devtab
	repne	scasd		; is it there?
	jnz	unkdev		; no - show its id
	mov	dx,di		; yes, show its name
	call	putstr
	jmp	short putloc
unkdev	mov	di,id_hex	; unknown device - shouldn't occur often
	call	xprint		; show vendor/device id
	mov	dx,unknwn
	call	putstr
putloc	mov	ax,bx		; get bus/device/function for display
	xchg	ah,al
	mov	di,bus_no
	call	_8print		; store bus
	rol	ax,5		; move bits 15:8 to 4:0,15:13
	and	al,11111b
	mov	di,dev_no
	call	_8print		; store device
	rol	ax,3		; move bits 15:13 to 2:0
	and	al,111b
	mov	di,fun_no
	call	_4print		; store function
	mov	di,4		; get command low byte
	mov	ax,0B108h	; read configuration byte
	push	bx		; bus/device/function may be distroyed
	int	1Ah
	pop	bx
	and	cl,101b		; mask Bus Master and I/O Space bits
	cmp	cl,101b		; asked bits supported?
	je	bitsup		; yes, continue
	mov	dx,busmer	; no, exit
finderr call	putstr
	stc			; error return
	ret
bitsup	mov	di,20h		; point to base address register 4
	mov	ax,0B109h	; read configuration word
	int	1Ah
	xchg	cx,ax		; base address now in AX
	and	ax,0FFFCh	; mask non-signinficant 2LSb
	mov	di,basadr
	call	hprint		; store base address
	mov	dx,fndstr
	call	putstr		; show controller location
	clc
	ret			; base in AX

Result	db	30	; Result buffer and its size
	times	30-1 db 0
