;************************** UltraDMA Driver for DOS **************************;

%define Version '4.2  Copyleft (G) MMIII J.Ellis and L.Georgiev'

;Version  Date	Description **************************************************;
; v2.0	 1/9/3: Base buffered driver (MASM 5 version) written by Jack R. Ellis.
; v2.1	 4/9/3: NASM port, PCI port detection, LBA, options (Luchezar Georgiev)
; v2.2	 6/9/3: Bug fix, code cleanup and optimisation (Jack Ellis &L.Georgiev)
; v2.3	 7/9/3: Load descriptor table pointer reg on each transfer, bugfix (JE)
; v2.4	 9/9/3: Send DMAAddr/Len after command/control regs reset, cleanup (JE)
; v2.5	12/9/3: Reduced Ready subroutine, Go bit now reset on next request (JE)
; v2.6	14/9/3: Check DRQ before starting DMA, detect VDS via call 8102 (JE&LG)
; v2.7	15/9/3: Save initial VDS lock state, save EAX & do CLI on VDS call (JE)
; v2.8	16/9/3: Ready now waits not only Active low but Interrupt high too (LG)
; v2.9	17/9/3: Code cleanup and optimisation, the 'W' test option removed (JE)
; v3.0	21/9/3: Error display bug fix, hard disk mode detection simplified (LG)
; v3.1	22/9/3: Added conditional-assembly of Quick-Write driver thru -DQW (JE)
; v3.2	23/9/3: Correctly handle the case when UDMA mode bits are all zero (LG)
; v3.3	24/9/3: Mode option sets also default mode, detect/show controller (LG)
; v3.4	25/9/3: Load only if an UDMA-capable HDD is found & show its model (LG)
; v3.5	26/9/3: Hex in place to allow redirection, model not shown if none (LG)
; v3.6	27/9/3: Minor changes to "DoIO" (JE), reset "Go" bit on interrupts (LG)
; v3.7	28/9/3: Two bugs introduced in some earlier version and v3.6 fixed (JE)
; v3.8	29/9/3: Read entire ID block, use Active DMA mode, options removed (LG)
; v3.9	30/9/3: Detect address of BIOS hard disk 0 (LG), "Ready" optimised (JE)
; v4.0	1/10/3: Resident variables and code optimisation, clean-up and fix (JE)
; v4.1	2/10/3: If no EDD BIOS, use the primary master; show disk location (LG)
; v4.2	3/10/3: Fix "Ready" for 686A, fix controller ports/bits for slaves (LG)

; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;	This program is distributed in the hope that it will be useful,
;	but WITHOUT ANY WARRANTY; without even the implied warranty of
;	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;	GNU General Public License for more details.
; You should have received a copy of the GNU General Public License along
; with this program; if not, write to the Free Software Foundation, Inc.,
; 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  (www.gnu.org)

; General Program Equations:

%ifdef	QW			; Quick-Write driver -
BUFSIZ	equ	20480		; Driver I/O buffer size
%else				; Standard driver -
BUFSIZ	equ	4096		; Driver I/O buffer size
%endif
SECSBUF equ	BUFSIZ/512	; Sectors per I/O buffer
SECSCYL equ	255*63		; LBA sectors per cylinder
SECSHD	equ	63		; LBA sectors per head
RDYTO	equ	7		; 384 msec ready timeout
DMAERR	equ	8		; UDMA status error (DMA overrun code used)
HERROR	equ	0E0h		; Hard disk status error return code
TIMOUT	equ	80h		; Timed-out return code
PRIMHD	equ	3F601F0h	; Primary hard disk ports

BIOSTMR equ	46Ch		; BIOS "tick" timer offset
CR	equ	0Dh		; ASCII carriage-return
LF	equ	0Ah		; ASCII line-feed
%define CRLF	CR,LF

; IDE Controller Status bits:

BUSY	equ	80h		; Controller is busy
DSKRDY	equ	40h		; Disk is ready
FAULT	equ	20h		; Disk has a fault
ONCYL	equ	10h		; Device seek complete
DRQ	equ	8		; Data request by disk
ERROR	equ	1		; General error flag

; IDE Command Definitions:

SETM	equ	3		; Set Mode subcommand
SETF	equ	0EFh		; Set Features command
IDCMD	equ	0ECh		; Identify drive command
DRCMD	equ	0C8h		; DMA read command (write is 0CAh)

; UDMA Controller status bits:

INTRPT	equ	4		; Interrupt has occured
BM_ERR	equ	2		; Bus master error flag
ACTIVE	equ	1		; Bus master IDE active

; Word and Doubleword Layouts:

struc dbt
	.lb	resb	1
	.hb	resb	1
endstruc
struc dwd
	.lw	resw	1
	.hw	resw	1
endstruc

; Device Address (LBA) Packet Layout:

struc	DAP
	.DASize resb	1	; Packet size in bytes (16 for IA-32)
	.DARes1 resb	1	; Reserved, must be 0
	.DANum	resb	1	; Number of blocks to transfer
	.DARes2 resb	1	; Reserved, must be 0
	.DABuf	resd	1	; Address of transfer buffer
	.DABeg	resd	2	; Starting logical block address
endstruc

; DOS "Request Packet" Layout:

struc	RP
	.RPlenU resb	2	; (Unused by us)
	.RPOp	resb	1	; Opcode
	.RPStat resw	1	; Status word
	.RPResN resb	9	; (Unused by us)
	.RPSize resd	1	; Resident driver size
	.RPCmdl resd	1	; Pointer to command line arguments
endstruc

RPERR	equ	8003h		; "Strategy" packet error flags
RPDON	equ	100h		; "Strategy" packet done flag

; DOS Driver Device Header:

	dd	-1		; Link to next device-header block
	dw	0C000h		; Driver "device attributes"
IDEAddr dw	Strat		; "Strategy" routine offset -
				;   Becomes IDE I/O port base address
CtlAddr dw	DevInt		; "Device-Interrupt" routine offset -
				;   Becomes IDE control port address
	db	'UDMA$',0	; Driver name

; Resident Driver Variables:

PCIAddr dw	0		; PCI Base UDMA Address (set by init)
UNibble db	0E0h		; LBA device register upper nibble
Params	equ	$		; I/O Parameters:
SectCt	db	0		;   Sector count
LBA	dd	0		;   Logical Block Address and commands
IOCmd	db	0		;   Command byte
Sectors db	0		; Remaining I/O sector count
Locked	db	0		; VDS lock flags:
				;   Bit 7 = VDS "locked" at init
				;   Bit 1 = VDS "locked" in resident code
ChkErrs db	2*FAULT		; "Check I/O errors" flag
	align	4		; PRD Table must be DWORD-aligned for Intel
UserBuf dd	0		; "User" buffer pointer and segment
PRDAddr dd	DMAAddr		; PRD Address (always points to DMAAddr)
BufBase dd	Buff		; 32-bit buffer base address
VDS	equ	$		; VDS Parameter Block:
VDSLen	dd	ResEnd		;   Buffer length
VDSOffs dd	0		;   Buffer offset (32-bit!)
VDSSeg	dd	0		;   Buffer segment (LSW) and ID (MSW)
VDSAddr dd	-1		;   Buffer address (32-bit)
DMAAddr dd	0		; DMA buffer address (32-bit)
DMALen	dd	80000000h	; DMA buffer length and "end" flag
	align	64		; Athlon XP cache line alignment

; Initialization Variables:
;	NOTE - All memory from Buff through BuffEnd is the driver I/O buffer
;	after init, which places all run-time data (variables and buffer) in
;	one place and takes only ONE init check for crossing a 64K boundary!

Buff	equ	$		; Start of driver I/O buffer
%ifdef ML
MaxMode db	6		; Maximum / default UDMA mode (command option)
%endif

; Messages:

ModTab	dd	'16. ','25. ','33. ','44. ','66. ','100.','133.','166.'
@:
TTLMsg	db	'UDMA'
%ifdef	QW			; Quick-Write driver
	db	'QW'
%endif
	db	' Hard Disk Driver Version ', Version, CRLF,'$'
IEMsg	db	CRLF,'Identify$'
NSMsg	db	CRLF,'UDMA not supported$'
SMMsg	db	CRLF,'UDMA mode '
CurMode db	'?, ATA-'
DspMode db	'???.',CRLF,'$'
BEMsg	db	CRLF,'64K DMA boundary cross$'
SEMsg	db	CRLF,'Set-mode$'
VEMsg	db	CRLF,'VDS lock$'
Suffix	db	' error - driver NOT loaded',CRLF,'$'
notsup	db	CR,'PCI BIOS 2.0c+ required$'
notfnd	db	'PCI IDE controller not found$'
unknwn	db	'Unknown Id = '
id_hex	db	'????????$'
fndstr	db	' IDE controller found at:',CRLF,'PCI bus '
bus_no	db	'??, device '
dev_no	db	'??, function '
fun_no	db	'?, base '
basadr	db	'????$'
busmer	db	CRLF,'Bus master$'
no_edd	db	CRLF,'No EDD BIOS HDD information available$'
master	db	CRLF,'Master$'
slaved	db	CRLF,'Slave$'
hddstr	db	' hard disk at '
hdbase	db	'????/'
hdctrl	db	'????$'
hdmods	db	': '
modeln	times 40 db 0	; 40 swapped bytes
	db	'$'

; Interface byte table - busmaster, legacy mode (bit writable or not):

itable	db	80h,8Ah,0FAh
it_end	equ	$
	align	4

; PCI vendor and device table. Format: dd <id>, db <dword-aligned name>

devtab:
%include "udma.pci"
dt_end	equ	$

; "Strategy" routine. This routine saves our DOS "Init" request packet
; for handling below. At entry, ES:BX points to the packet.

Strat	mov	[cs:UserBuf+dwd.lw],bx; Save DOS request-packet address
	mov	[cs:UserBuf+dwd.hw],es
	retf			; Exit - await DOS "Device Interrupt"

; "Device-Interrupt" routine. This routine initializes the driver.

DevInt	pushf			; Entry - save used registers
	pushad
	push	ds
	push	es
	push	cs		; Set our DS
	pop	ds
	les	bx,[UserBuf]	; Point to DOS request packet
	cmp	byte [es:bx+RP.RPOp],0; Is this an "Init" packet?
	jne	near I_BadP	; No? Post errors and exit quick!
	mov	dx,TTLMsg	; Display our "title" message
	call	putstr
%ifdef ML
	les	bx,[es:bx+RP.RPCmdl]; Point to the command line tail
GetNxt	mov	al,[es:bx]	; Get a command line character
	inc	bx
	cmp	al,0		; Terminate if end of line reached
	jz	FindIt
	cmp	al,CR
	je	FindIt
	cmp	al,LF
	je	FindIt
	sub	al,'0'
	jb	GetNxt
	cmp	al,6		; Mode 0-6 (in filename TOO)?
	ja	GetNxt		; No, continue
	mov	[MaxMode],al	; Yes, store the maximum allowable UDMA mode
%endif
FindIt	push	cs
	pop	es		; Set ES
	cld			; Ensure we do "forward" moves!
	call	find_it		; Find the UDMA controller PCI base port
	jc	near I_Quit	; Not found? Quit!
	mov	[PCIAddr],ax	; Save command register address ( = base)
	mov	ah,41h		; Check Int 13h (EDD, LBA) extensions present
	mov	bx,55AAh
	mov	dl,80h
	int	13h
	jc	I_NoEB		; Invalid Command error
	cmp	bx,0AA55h
	jne	I_NoEB		; Invalid magic return value
	test	cx,4
	jz	I_NoEB		; EDD support subset absent
	mov	ah,48h		; Get drive parameters of first BIOS drive
	mov	dl,80h
	mov	si,Result
	int	13h
	jc	I_NoEB		; Invalid Command error
	les	si,[si+26]	; Point to DPTE
	mov	ax,es
	cmp	ax,si
	jne	I_DPTE
	cmp	ax,byte -1	; Pointer invalid (FFFF:FFFF)?
	jne	I_DPTE		; No - use it
I_NoEB	mov	dx,no_edd	; Yes, show "No EDD BIOS HDD info"
	call	putstr
	mov	al,[UNibble]
	mov	edx,PRIMHD	; Try to find a primary master disk
	jmp	short I_IDev
I_NSup	mov	dx,NSMsg	; Show "Not supported" message and exit
I_Err_	jmp	I_Err
I_DPTE	mov	cx,16		; Calculate DPTE checksum
	mov	al,0
	mov	bx,si
I_CkSm	add	al,[es:bx]
	inc	bx
	loop	I_CkSm
	cmp	al,0		; Is DPTE valid (checksum = 0)?
	jne	I_NoEB		; No - EDD BIOS error
	mov	al,[es:si+4]	; Yes, copy DPTE fields we need
	mov	[UNibble],al	; Device register upper nibble
	mov	edx,[es:si]	; I/O port base and control port address
I_IDev	mov	[IDEAddr],edx
	add	dx,byte 6	; Point to device register
	out	dx,al
	mov	al,IDCMD	; Issue "Identify Device" command
	inc	dx		; Point to command register
	call	I_Cmd
	mov	dx,IEMsg	; "Identify error"
	jc	I_Err_		; Error? Display message
	mov	dx,[IDEAddr]	; Point to controller PIO data register
	mov	cx,27		; Skip ID bytes 0-53
I_Skp1	in	ax,dx
	loop	I_Skp1
	mov	di,modeln	; Get model number (ID bytes 54-93)
	mov	cl,20
I_GetM	in	ax,dx
	xchg	ah,al		; Get model number, swapping its bytes
	stosw
	loop	I_GetM
	push	dx		; Save data port
	test	byte [UNibble],10h; Master device?
	mov	dx,master
	jz	I_ShMS		; Yes, show "Master"
	mov	dx,slaved	; No, show "Slave"
I_ShMS	call	putstr
	mov	ax,[IDEAddr]	; Prepare I/O port base address
	test	al,al		; Primary IDE channel (base port 1F0h)?
	js	I_ShPt		; Yes, continue
	add	word [PCIAddr],byte 8; Secondary (170h): update controller base
I_ShPt	mov	di,hdbase
	call	hprint
	mov	ax,[CtlAddr]	; and control address for display
	mov	di,hdctrl
	call	hprint
	mov	dx,hddstr	; Show the HDD port addresses
	call	putstr
	cmp	word [modeln],byte 0; Valid model number?
	jz	I_Cont		; No - don't show it
	mov	dx,hdmods	; Yes, show it
	call	putstr
I_Cont	pop	dx		; Restore data port
	mov	cl,6		; Skip ID bytes 94-105
I_Skp2	in	ax,dx
	loop	I_Skp2
	in	ax,dx		; Read ID bytes 106 and 107
	mov	bh,al		; Save "DMA valid" flag byte
	mov	cl,34		; Skip ID bytes 108-175
I_Skp3	in	ax,dx
	loop	I_Skp3
	in	ax,dx		; Read ID bytes 176 and 177
	mov	bl,ah		; Save "Selected DMA mode" flag byte
	mov	cl,167		; Skip remaining ID data
I_Skp4	in	ax,dx
	loop	I_Skp4
	test	bh,4		; Are UltraDMA flag bits valid?
	jz	I_NSup		; No - UDMA not supported error
	xor	bh,bh		; Yes, use selected UltraDMA mode
	bsr	ax,bx		; Get highest mode bit number in AX
	jz	I_NSup		; No mode bit is set - "Not supported" error
	mov	dx,SMMsg	; Set up to display "Setting mode" message
%ifdef ML
	cmp	al,[MaxMode]	; Mode greater than maximum allowable mode?
	jbe	I_DMod		; No, go display it
	mov	al,[MaxMode]	; Yes, limit it!
%endif
I_DMod	cwde
	mov	ebx,[ModTab+eax*4]
	mov	[DspMode],ebx	; Set displayed mode
	add	al,'0'
	mov	[CurMode],al	; Update "current mode" value
	call	putstr
	mov	dx,[IDEAddr]
	inc	dx		; Point to subcommand register
	mov	al,SETM		; Set mode-select subcode
	out	dx,al
	inc	dx
	mov	al,[CurMode]	; Set desired UltraDMA mode value
	add	al,10h
	out	dx,al
	mov	al,SETF		; Issue set-features command to disk
	add	dx,byte 5	; Point to command register
	call	I_Cmd
	jc	near I_SErr	; Error - display message and exit!
	pushf			; Save CPU flags
	cli			; Disable interrupts during VDS tests
	xor	eax,eax		; Get driver code segment
	mov	ax,cs
	mov	[VDSSeg+dwd.lw],ax; Set code segment in VDS block
	shl	eax,4		; Save 20-bit driver virtual address
	push	eax
	mov	ax,8102h
	xor	dx,dx
	stc			; Prevent false VDS detection
	int	4Bh		; See if VDS services are active
	pop	eax		; (Restore 20-bit virtual address)
	jc	I_SetV		; No VDS - set 20-bit virtual addresses
	mov	di,VDS		; Point to VDS descriptor block
	mov	ax,8103h	; "Lock" this driver into memory
	mov	dx,0Ch
	int	4Bh
	jc	I_VErr		; Failed? Display error message and exit
	cmp	word [VDSAddr+dwd.hw],byte -1; REALLY got a 32-bit address?
	je	I_VErr		; No? Display error message and exit
	or	byte [Locked],80h; Set initialization VDS "lock" flag
	mov	eax,[VDSAddr]	; Get 32-bit starting driver address
I_SetV	popf			; Restore CPU flags
	add	[PRDAddr],eax	; Set 32-bit PRD address
	add	[BufBase],eax	; Set 32-bit buffer base address
	mov	word [VDSLen+dwd.lw],0; Reset lower word of VDS length
	mov	eax,BUFSIZ+7	; Calculate ending 32-bit buffer address
	add	eax,[PRDAddr]	; (+7 includes DMAAddr/DMALen too!)
	xor	ax,ax		; Clear low-order ending address
	cmp	eax,[PRDAddr]	; Does buffer cross a 64K boundary?
	jna	I_Vect		; No, do INT13 vector "hook"
	test	byte [Locked],80h; Cannot load! Was driver "locked"?
	jz	I_BErr		; No, display error message and exit
	mov	di,VDS		; Point to VDS descriptor block
	mov	ax,8104h	; "Unlock" this driver from memory
	xor	dx,dx
	int	4Bh
I_BErr	mov	dx,BEMsg	; Boundary error! Point to message
	jmp	short I_Err	; Go display error message and exit
I_VErr	popf			; VDS "lock" error! Restore CPU flags
	mov	dx,VEMsg	; Point to VDS error message
	jmp	short I_Err	; Go display error message and exit
I_Vect	mov	ax,3513h	; Get current INT13 vector
	int	21h
	mov	[Int13V+dwd.lw],bx; Save vector for "passed" requests
	mov	[Int13V+dwd.hw],es
	mov	ax,2513h	; "Hook" this driver into INT13
	mov	dx,Entry
	int	21h
	les	bx,[UserBuf]	; Post driver size and success code
	mov	word [es:bx+RP.RPSize+dwd.lw],ResEnd
	mov	[es:bx+RP.RPSize+dwd.hw],cs
	mov	word [es:bx+RP.RPStat],RPDON
	jmp	short I_Exit	; Go reload registers and exit
I_SErr	mov	dx,SEMsg	; Set-mode error! Point to message
I_Err	call	putstr		; Display error message and suffix
I_Quit	mov	dx,Suffix
	call	putstr
	les	bx,[UserBuf]	; Post 0 size and error status
	mov	word [es:bx+RP.RPSize+dwd.lw],0
	mov	[es:bx+RP.RPSize+dwd.hw],cs
I_BadP	mov	word [es:bx+RP.RPStat],RPERR; "Unknown command"
I_Exit	pop	es		; Reload registers and exit
	pop	ds
	popad
	popf
	retf

; Subroutine to issue initialization commands to our disk

I_Cmd	out	dx,al		; Issue desired initialization command
	xor	di,di		; Point to BIOS timer
	mov	es,di
	mov	di,BIOSTMR
	mov	cl,RDYTO	; Set up ID command time limit
	add	cl,[es:di]	; (3MSB not needed)
I_CmdW	cmp	cl,[es:di]	; Has our ID command timed out?
	je	I_CmdE		; Yes, set CPU carry flag and exit
	in	al,dx		; Get controller alternate status
	test	al,BUSY		; Is our controller still busy?
	jnz	I_CmdW		; Yes, loop back and keep checking
	test	al,ERROR	; Did ID command cause any errors?
	jz	I_CmdX		; No, leave carry flag off and exit
I_CmdE	stc			; Error - set CPU carry flag on
I_CmdX	push	cs
	pop	es		; Restore ES
	ret			; Exit

; Stanislav's tightest but cryptic hex output

xprint	call	_32p
_32p	ror	eax,16
hprint	call	_8p
_8p	xchg	al,ah
_8print call	_4p
_4p	ror	al,4
_4print push	ax
	and	al,0Fh
	cmp	al,0Ah
	sbb	al,69h
	das
	stosb
	pop	ax
	ret

; Display string in DL

putstr	push	ax
	mov	ah,9
	int	21h
	pop	ax
	ret

; Find the UltraDMA controller. Return its base I/O address in AX (CF on error)

find_it xor	edi,edi
	mov	ax,0B101h
	int	1Ah		; PCI BIOS v2.0c+ installation check
	cmp	edx,'PCI '	; BIOS OK?
	je	biosok		; yes, continue
	mov	dx,notsup	; no, BIOS too old
	jmp	finderr
biosok	mov	si,itable
findev	mov	ecx,10100h	; class 1 (storage), subclass 1 (IDE)
	lodsb			; interface byte
	mov	cl,al
	mov	ax,0B103h	; find PCI class code
	push	si
	xor	si,si		; prepare device index (0)
	int	1Ah		; BH: bus, BL: bit 7-3: device, 2-0: function
	pop	si
	jnc	found		; if found, break loop
	cmp	si,it_end	; end of table?
	jne	findev		; no, continue searching
	mov	dx,notfnd	; yes - not found, show error and exit
	jmp	short finderr
found	xor	di,di		; get vendor/device id
	mov	ax,0B10Ah	; read configuration dword in ECX
	push	bx		; bus/device/function may be distroyed
	int	1Ah
	pop	bx
	xchg	ecx,eax		; look up for the id in the PCI device table
	ror	eax,16		; swap words (MSW: vendor id, LSW: device id)
	mov	cx,(dt_end-devtab)/4
	mov	di,devtab
	repne	scasd		; is it there?
	jnz	unkdev		; no - show its id
	mov	dx,di		; yes, show its name
	call	putstr
	jmp	short putloc
unkdev	mov	di,id_hex	; unknown device - shouldn't occur often
	call	xprint		; show vendor/device id
	mov	dx,unknwn
	call	putstr
putloc	mov	ax,bx		; get bus/device/function for display
	xchg	ah,al
	mov	di,bus_no
	call	_8print		; store bus
	rol	ax,5		; move bits 15:8 to 4:0,15:13
	and	al,11111b
	mov	di,dev_no
	call	_8print		; store device
	rol	ax,3		; move bits 15:13 to 2:0
	and	al,111b
	mov	di,fun_no
	call	_4print		; store function
	mov	di,4		; get command low byte
	mov	ax,0B108h	; read configuration byte
	push	bx		; bus/device/function may be distroyed
	int	1Ah
	pop	bx
	and	cl,101b		; mask Bus Master and I/O Space bits
	cmp	cl,101b		; asked bits supported?
	je	bitsup		; yes, continue
	mov	dx,busmer	; no, exit
finderr call	putstr
	stc			; error return
	ret
bitsup	mov	di,20h		; point to base address register 4
	mov	ax,0B109h	; read configuration word
	int	1Ah
	xchg	cx,ax		; base address now in AX
	and	ax,0FFFCh	; mask non-signinficant 2LSb
	mov	di,basadr
	call	hprint		; store base address
	mov	dx,fndstr
	call	putstr		; show controller location
	clc
	ret			; base in AX

Result	db	30		; Result buffer and its size
	times	30-1 db -1
	times Buff+BUFSIZ-$ db 0;"Pad" remainder of I/O buffer: DON'T REMOVE!
				; (forces RAM occupation at load time)
BuffEnd equ	$		; End of init logic and driver I/O buffer

; Main driver routine, invoked by Int 13h (Disk Services) calls.
; For a CHS request, the registers contain the following at entry:
;
;   AH	   Command code - we handle only 2 (read) and 3 (write)
;   AL	   I/O sector count
;   CH	   Lower 8 bits of starting cylinder number
;   CL	   Starting sector number and upper 2 bits of cylinder number
;   DH	   Starting head number
;   DL	   Unit number - we handle only 80h (hard disk 0)
;   ES:BX  I/O buffer address
;
; For an LBA request, the registers contain the following at entry:
;
;   AH	   Command code - we handle only 42h (read) and 43h (write)
;   DL	   Unit number	- we handle only 80h (hard disk 0)
;   DS:SI  Pointer to Device Address Packet ("DAP"), described above

Entry	pushf			; Driver entry point - save CPU flags
	cmp	dl,80h		; Is this request for our disk?
	je	CheckRW		; Yes, check for read or write command
NotUs	popf			; Request NOT for us - reload CPU flags
	db	0EAh		; "Pass" request to BIOS or other drivers
Int13V	dd	-1		; Previous INT13 vector, set by Init
CheckRW push	ax		; Save command
	and	ah,0BEh		; Mask out LBA (bit 6) and write (bit 0)
	cmp	ah,2		; Is command a read or write?
	pop	ax		; Reload command
	jne	NotUs		; NOT read or write - exit quick!
	popf			; Valid request - discard entry flags
	sti			; Enable CPU interrupts
	push	eax		; Save needed CPU registers
	push	cx		; (Unusual order, for exit logic, and
	push	dx		;  so DS:SI "DAP" pointer is on stack)
	push	di
	push	es
	push	ds
	push	si
	push	bp
	push	cs		; Set our DS
	pop	ds
	mov	bp,sp		; Point BP to our "stack frame"
	and	byte [bp+22+dbt.lb],0FEh; Reset exiting carry bit (error flag)
	xchg	al,ah		; Swap opcode and CHS sector count
	shl	al,1		; Get DMA command byte
	add	al,DRCMD-4
	jnc	CalcLBA		; LBA or CHS request?
	or	al,DRCMD	; LBA - restore high-order command bits
	les	di,[bp+2]	; Get "DAP" pointer in ES:DI
	mov	ah,[es:di+DAP.DANum]; Get I/O sector count
	mov	[IOCmd],ax	; Save DMA command and sector count
	mov	si,[es:di+DAP.DABeg+dwd.lw]; Get LBA value in SI and DX
	mov	dx,[es:di+DAP.DABeg+dwd.hw]
	les	cx,[es:di+DAP.DABuf]; Get user I/O buffer address
	jmp	short SaveBuf	; Go save buffer address and LBA value
CalcLBA mov	[IOCmd],ax	; CHS - save DMA command and sector count
	mov	si,SECSHD	; Save starting sector in SI
	and	si,cx
	mov	di,dx		; Save starting head in DI
	shr	cl,6		; Get cylinder number in CX
	xchg	cl,ch
	mov	ax,SECSCYL	; Convert cylinder to sectors
	mul	cx
	xchg	ax,di		; Swap low-order and head number
	mov	al,SECSHD	; Convert head to sectors
	mul	ah
	add	di,ax		; Add to cylinder sectors
	adc	dl,dh
	dec	si		; Get starting sector number - 1
	add	si,di		; Add to cylinder/head sectors
	adc	dl,dh
	mov	cx,bx		; Set buffer offset in CX
SaveBuf mov	[UserBuf+dwd.lw],cx; Save user I/O buffer address
	mov	[UserBuf+dwd.hw],es
	mov	[LBA+dwd.lw],si ; Save lower LBA value in I/O parameters
	or	dh,[UNibble]	; "Or" in DEV/LBA bits
	mov	[LBA+dwd.hw],dx ; Save upper LBA value in I/O parameters
	mov	word [VDSAddr+dwd.hw],-1; Invalidate DMA address
%ifdef	QW			; Quick-Write driver -
	mov	ax,[IOCmd]	; Get DMA command and total sectors
	or	al,cl		; "Or" in low-order buffer offset
	and	al,3		; Misaligned buffer, or write command?
	jnz	UseBuf		; Yes, use driver-buffered logic below
	xchg	al,ah		; Set input sector count
%else				; Standard driver -
	test	cl,3		; Is user's buffer DWORD-aligned?
	jnz	UseBuf		; No, use driver-buffered logic below
	movzx	ax,[Sectors]	; Set I/O sector count
%endif
	mov	[SectCt],al
	shl	ax,1		; Set VDS buffer length
	mov	[VDSLen+1],ax
	mov	[VDSOffs+dwd.lw],cx; Save buffer address in VDS block
	mov	ax,es
	mov	[VDSSeg+dwd.lw],ax
	cli			; Disable CPU interrupts during VDS tests
	test	byte [Locked],80h; Was driver "locked" during init?
	jnz	DoLock		; Yes, VDS services must be active
	mov	ax,8102h
	xor	dx,dx
	stc			; Prevent false detection
	int	4Bh		; Are VDS services active?
	jc	NoVDS		; No, set up 20-bit DMA address
DoLock	push	ds		; Point to VDS descriptor block
	pop	es
	mov	di,VDS
	mov	ax,8103h	; Do VDS "lock" on our I/O buffer
	mov	dx,0Ch
	int	4Bh
	sti			; Re-enable CPU interrupts
	jc	UseBuf		; If error, use buffered logic below
	cmp	word [VDSAddr+dwd.hw],byte -1; Got a valid DMA address?
	je	UseBuf		; No, use driver-buffered logic below
	inc	byte [Locked]	; Set VDS "lock" flag
DirDMA	mov	eax,[VDSLen]	; Get I/O buffer length - 1
	dec	eax
	add	eax,[VDSAddr]	; Calculate ending DMA address
	xor	ax,ax		; Clear low-order ending address
	cmp	eax,[VDSAddr]	; Will this I/O cross a 64K boundary?
	ja	UseBuf		; Yes, use driver-buffered logic below
	call	Ready		; Await controller- and disk-ready
	mov	eax,[VDSAddr]	; Do DMA input direct to user buffer
	call	DoIO
%ifdef	QW			; Quick-Write driver -
	call	Ready		; Await controller- and disk-ready
%endif
	jmp	short GoodIO	; All done - post "success" and exit
NoVDS	sti			; No VDS - re-enable CPU interrupts
	mov	eax,[VDSSeg]	; Set 20-bit DMA address
	shl	eax,4
	add	eax,[VDSOffs]
	mov	[VDSAddr],eax
	jmp	DirDMA		; Go do direct DMA to/from user buffer
UseBuf	call	Ready		; Await controller- and disk-ready
Next	mov	ax,[IOCmd]	; Get DMA command & sector count
	cmp	ah,SECSBUF	; Will next I/O be a full buffer?
	jb	NextSC		; No, use remaining sector count
	mov	ah,SECSBUF	; Use full-buffer sector count
NextSC	mov	[SectCt],ah	; Set next I/O sector count
	cmp	al,DRCMD	; Is this a read request?
	jne	Output		; No, use output logic below
	call	BufIO		; Input next block of sectors
%ifdef	QW			; Quick-Write driver -
	call	Ready		; Await controller- and disk-ready
%endif
	mov	si,Buff		; Set driver and user buffer pointers
	les	di,[UserBuf]
	movzx	cx,[SectCt]
	shl	cx,7		; 128 moves per sector
	rep	movsd		; Move driver data to user's buffer
	mov	[UserBuf+dwd.lw],di; Update user buffer offset
%ifdef	QW			; Quick-Write driver -
	sub	byte [Sectors],SECSBUF; More I/O sectors left to go?
	ja	Next		; Yes, loop back
	jmp	short GoodIO	; All done - post "success" & exit
%else				; Standard driver -
	jmp	short More	; Go check for more I/O sectors
%endif
Output	push	dx		; Output - save our DS
	pop	es		; Set driver buffer pointer
	mov	di,Buff
	lds	si,[UserBuf]	; Set user buffer pointer
	movzx	cx,ah
	shl	cx,7		; 128 moves per sector
	rep	movsd		; Move user data to driver's buffer
	push	es		; Reload our DS
	pop	ds
	mov	[UserBuf+dwd.lw],si; Update user buffer offset
	call	BufIO		; Output next block of sectors
More	sub	byte [Sectors],SECSBUF; More I/O sectors left to go?
%ifdef	QW			; Quick-Write driver -
	ja	UseBuf		; Yes, loop back
%else				; Standard driver -
	ja	Next		; Yes, loop back
%endif
GoodIO	mov	byte [bp+14+dbt.hb],0; Success! Reset exiting AH
Done	pop	bp		; Reload BP and SI (not needed below)
	pop	si
	btr	word [Locked],0 ; Was I/O buffer "locked" by VDS?
	jnc	Exit		; No, reload remaining registers
	push	ds		; Point to VDS descriptor block
	pop	es
	mov	di,VDS
	mov	ax,8104h	; Do VDS "unlock" on input buffer
	xor	dx,dx
	int	4Bh
Exit	pop	ds		; Reload remaining registers and exit
	pop	es
	pop	di
	pop	dx
	pop	cx
	pop	eax
	iret

; Subroutine to start I/O. This logic exits by "falling through" to
; the "Ready" routine below, nasty but FAST assembly-language code!

BufIO	mov	eax,[BufBase]	; Buffered - get driver buffer address
	align	4
DoIO	xchg	ax,cx		; Save lower I/O buffer address
	mov	al,[IOCmd]	; If reading, get DMA "read" command
	add	al,6
	and	al,8
	mov	dx,[PCIAddr]	; Reset DMA command register
	out	dx,al
	inc	ax		; Set "go" and save DMA command byte
	xchg	ax,di
	inc	dx		; Reset DMA control register
	inc	dx
	in	al,dx
	or	al,6		; Clear INTRPT and BM_ERR by SETTING them
	out	dx,al
	xchg	ax,cx		; Reload lower I/O buffer address
	mov	[DMAAddr],eax	; Set DMA buffer address and length
	movzx	ax,[SectCt]
	shl	ax,1
	mov	[DMALen+1],ax
	inc	dx		; Set PRD pointer to our DMAAddr
	inc	dx
	mov	eax,[PRDAddr]
	out	dx,eax
	mov	dx,[IDEAddr]
	inc	dx
	inc	dx		; Point to sector count register
	mov	si,Params
DMAPar	outsb			; Output our 6 I/O parameters
	inc	dx
	cmp	si,Params+6
	jb	DMAPar
ChkDRQ	mov	dx,[CtlAddr]	; Read IDE alternate status
	in	al,dx
	test	al,DRQ		; Has 1st DRQ arrived?
	jz	ChkDRQ		; No, wait
	xchg	ax,di		; Reload DMA command byte
	mov	dx,[PCIAddr]	; Set DMA Start/Stop bit
	out	dx,al		; (Transfer begins NOW!)
	add	dword [LBA],byte SECSBUF; Update logical block address
	mov	byte [ChkErrs],2*(FAULT+ERROR)+1; Check fault/error at end
%ifdef	QW			; Quick-Write driver -
	ret			; Exit
%endif
	align	4

; Subroutine to await controller- and disk-ready

Ready	cld			; Ensure we do "forward" string commands!
	xor	di,di		; Point to BIOS timer
	mov	es,di
	mov	di,BIOSTMR
	mov	cl,RDYTO	; Set up command timeout limit
	add	cl,[es:di]
	mov	ah,2*FAULT	; Load/reset "Check I/O Errors" flag
	xchg	ah,[ChkErrs]
	shr	ah,1		; Checking one of our I/O requests?
	jnc	ChkRdy		; No, do NOT check DMA status
ChkDMA	cmp	cl,[es:di]	; Has a DMA transfer timed out?
	je	TimedO		; Yes? Post timeout error and exit!
	mov	dx,[PCIAddr]	; Read DMA controller status
	inc	dx
	inc	dx
	hlt			; Wait for an interrupt from disk or timer...
	in	al,dx		; (This minimises delay)
	test	al,BM_ERR	; Bus master transfer error?
	jnz	Overrun		; Yes? Post DMA overrun and exit!
	test	al,INTRPT	; Has interrupt occured?
	jz	ChkDMA		; No, loop back and check again
	dec	dx		; Reset DMA Start/Stop bit
	dec	dx		; (Active bit will be reset too)
	in	al,dx
	and	al,0FEh
	out	dx,al
	inc	dx		; Read controller status once again
	inc	dx
	in	al,dx
	test	al,BM_ERR	; Bus master transfer error?
	jnz	Overrun		; Yes? Post DMA overrun and exit!
ChkRdy	cmp	cl,[es:di]	; Too long without becoming ready?
	je	TimedO		; Yes? Post timeout error and exit!
	mov	dx,[IDEAddr]	; Read IDE controller primary status
	add	dx,byte 7
	in	al,dx
	xor	al,DSKRDY+ONCYL ; Get "not-ready" and "off-cylinder"
	test	al,BUSY+DSKRDY+ONCYL; Controller or disk still busy?
	jnz	ChkRdy		; Yes, loop back and check again
	and	al,ah		; Error or disk fault at I/O end?
	mov	ah,HERROR	; (Load hard-error code if so)
	jnz	BadIO		; Yes? Post hard-error and exit!
	ret			; All is well - exit
Overrun mov	ah,DMAERR	; DMA overrun! Post error and exit
	jmp	short BadIO
TimedO	mov	ah,TIMOUT	; Timed out! Get error code
BadIO	pop	dx		; Discard subroutine exit address
	mov	al,0		; Reset exiting sector count
	mov	[bp+14],ax	; Post error code and sector count
	inc	byte [bp+22+dbt.lb]; Set exiting carry bit (error!)
	jmp	Done		; Go see about VDS "unlock" and exit

	align	64		; Athlon XP Cache line alignment
ResEnd	equ	$		; Resident part end
