%define		Version 'v1.3'

; UDMA Driver for DOS. Base driver written 22-Feb-2003 by Jack R. Ellis.
; Detection, NASM Port, EDD Support and Options by Luchezar I. Georgiev.

;! This program is free software; you can redistribute it and/or modify
;! it under the terms of the GNU General Public License as published by
;! the Free Software Foundation; either version 2 of the License, or
;! (at your option) any later version.
;!
;!	This program is distributed in the hope that it will be useful,
;!	but WITHOUT ANY WARRANTY; without even the implied warranty of
;!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
;!	GNU General Public License for more details.
;!
;! You should have received a copy of the GNU General Public License along
;! with this program; if not, write to the Free Software Foundation, Inc.,
;! 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

; This is a DOS driver intended to run ONLY a single UltraDMA hard disk
; on motherboards using a VIA 8233A/8235 or similar chipset. The disk
; must be the "master" on the primary IDE channel. A primary "slave"
; is assumed NOT to be present. Other IDE units (CDROM, ZIP) must use
; the secondary IDE channel and are assumed to be run by other drivers.
;
; The disk is assumed to support standard LBA mode (1024 cylinders, 255
; heads, 63 sectors). An "identify drive" command is sent to the disk
; when the driver loads, and the disk is set to its best UltraDMA mode
; not higher than the best controller mode given by command line option
; with mode 2 (ATA-33) as a default. Disks from ATA-33 to ATA-133 may
; be used. The driver does only read or write requests to the primary
; master disk. Requests with odd buffer addresses (give DMA errors),
; requests using fragmented buffers (unlikely in DOS), and all non-data
; requests (seeks, etc.) are "passed" back to the BIOS for handling.

;	Usage in CONFIG.SYS: DEVICE[HIGH]=[path]UDMA.SYS [options]
;	(after XMS/UMB drivers but before disk cache)
; Options:
; UPPERCASE W = enable UDMA writes (default: pass them to the BIOS)
;	  2-6 = maximum UDMA mode supported by chipset (default: 2)
; Options can be combined. Unknown command line characters are ignored
; ("W 5", "W5", "5W", "/5/W", "/W5", "-5 -W", "-W-5", "-5W" are same).
;
; UDMA writes default to "off" because the VIA VT82C686B "south bridge"
; has a BUG that can CORRUPT data on UDMA writes (fixed in the VT8235).
; Enable at YOUR OWN RISK! If mode is specified, UDMA mode is set to the
; lowest common mode of your disk and controller, else it defaults to 2.
; Modes: 2 (ATA-33), 3 (ATA-44), 4 (ATA-66), 5 (ATA-100), 6 (ATA-133).

; General Program Equations:

SECSCYL equ	255*63		; LBA sectors per cylinder
SECSHD	equ	63		; LBA sectors per head
RDYTO	equ	7		; 100-ms ready timeout
HERROR	equ	0FFh		; Hard-error return code
TIMOUT	equ	0BBh		; Timed-out return code
BIOSSEG equ	40h		; BIOS segment value
BIOSTMR equ	6Ch		; BIOS "tick" timer offset
BIOSVDS equ	7Bh		; BIOS VDS flag-byte offset
CR	equ	0Dh		; ASCII carriage-return
LF	equ	0Ah		; ASCII line-feed
%define	CRLF	CR,LF

; IDE Controller Register Definitions:

CDATA	equ	1F0h		; Data port
CSUBCM	equ	CDATA+1		; Subcommand register
CSECCT	equ	CDATA+2		; I/O sector count
CCMD	equ	CDATA+7		; Command register
CSTAT	equ	CDATA+7		; Status register (resets INTR)

; Controller Status and Command Definitions:

BUSY	equ	80h		; Controller is busy
READY	equ	40h		; Disk is "ready"
FAULT	equ	20h		; Disk has a "fault"
ONCYL	equ	10h		; Disk is "on cylinder"
ERROR	equ	1		; General error flag
LBABITS equ	0E0h		; Fixed MSB LBA bits: LBA = 1, DEV = 0
SETM	equ	3		; Set Mode subcommand
SETF	equ	0EFh		; Set Features command
DRCMD	equ	0C8h		; DMA read command (write is 0CAh)

; Word and Doubleword Layouts:

struc dbt
	.lb	resb	1
	.hb	resb	1
endstruc
struc dwd
	.lw	resw	1
	.hw	resw	1
endstruc

; Device Address (LBA) Packet Layout:

struc	DAP
	.DASize resb	1	; Packet size in bytes (16 for IA-32)
	.DARes1 resb	1	; Reserved, must be 0
	.DANum	resb	1	; Number of blocks to transfer
	.DARes2 resb	1	; Reserved, must be 0
	.DABuf	resd	1	; Address of transfer buffer
	.DABeg	resd	2	; Starting logical block address
endstruc

; DOS "Request Packet" Layout:

struc	RP
	.RPlenU resb	2	; (Unused by us)
	.RPOp	resb	1	; Opcode
	.RPStat resw	1	; Status word
	.RPResN resb	9	; (Unused by us)
	.RPSize resd	1	; Resident driver size
	.RPCmdl resd	1	; Pointer to command line arguments
endstruc

RPERR	equ	8003h		; "Strategy" packet error flags
RPDON	equ	100h		; "Strategy" packet done flag

; DOS Driver Device Header:

	dd	-1		; Link to next device-header block
	dw	0C000h		; Driver "device attributes"
	dw	Strat		; "Strategy" routine offset
	dw	DevInt		; "Device-Interrupt" routine offset
	db	'UDMA$',0	; Driver name

; Resident Driver Variables:

VDS	equ	$		; VDS Parameter Block:
VDSSize dd	Strat		;   Buffer size
VDSOffs dd	0		;   Buffer offset (32-bit!)
VDSSeg	dw	0		;   Buffer segment
VDSid	dw	0		;   Buffer ID
DMAAdr	dd	-1		; DMA buffer address (part of VDS block)
DMALen	dd	080000000h	; DMA buffer length and "end" flag
Params	equ	$		; I/O Parameters:
Sectors db	0		;   Sector count
LBA	dd	0E0000000h	;   Logical Block Address
IOCmd	db	0		;   Command byte
CUCMD	dw	0		; UDMA command register
WritEn	db	2		; write enabled (3) / disabled (2) command flag

; Main driver routine, invoked by INT13 calls. At entry, the registers
; contain the parameters of the desired I/O request, as follows:
;
;	AH	Command code
;	AL	I/O sector count (CHS)
;	CH	Lower 8 bits of starting cylinder number (CHS)
;	CL	Starting sector number and 2MSb of cylinder number (CHS)
;	DH	Starting head number (CHS)
;	DL	Unit number
;	ES:BX	I/O buffer address (CHS)
;	DS:SI	Device Address Packet (LBA)

PopOpc	pop	ax		; Resore opcode
NotUs	popf			; Request not for us - reload CPU flags
	db	0EAh		; "Pass" request to BIOS or other drivers
Int13V	dd	-1		; Previous INT13 vector, set by Init
Entry	pushf			; Driver entry - save CPU flags
	sti			; Enable CPU interrupts
	cmp	dl,80h		; Is this request for our disk?
	jne	NotUs		; No, exit quick!
	push	ax		; Yes, save opcode
	and	ah,0BFh		; Mask Int 13 extension bit (6)
	cmp	ah,[cs:WritEn]	; Is opcode above "write" (if enabled)/"read"?
	ja	PopOpc		; Yes, exit quick!
	cmp	ah,2		; No, is opcode below "read"?
	jb	PopOpc		; Yes, exit quick!
	pop	ax		; No, restore opcode
	pusha			; Save all registers
	push	ds
	push	es
	test	ah,40h		; LBA request?
	jz	CHS		; No, go check BL
	mov	al,[si+DAP.DANum]; Yes, load values before chaning DS
	les	bx,[si+DAP.DABuf]
	mov	edx,[si+DAP.DABeg]
CHS	test	bl,1		; Odd buffer address (causes DMA errors)?
	jnz	near VDSErr	; Yes, exit quick! (Let BIOS handle it)
	push	cs		; Set our DS
	pop	ds
	mov	[Sectors],al	; Save number of blocks
	mov	[VDSOffs+dwd.lw],bx; Save I/O buffer address
	mov	[VDSSeg],es
	push	ax		; Save opcode for the sake of LBA bit (6)
	and	ah,0BFh		; Mask Int 13 extension bit (6)
	shl	ah,1		; Set DMA command byte
	add	ah,DRCMD-4
	mov	[IOCmd],ah
	xor	ah,ah		; Set VDS size and DMA buffer length
	shl	ax,1
	mov	[VDSSize+1],ax
	mov	[DMALen+1],ax
	pop	ax		; Restore opcode
	test	ah,40h		; LBA mode?
	jz	CalcLBA		; No, go calculate the LBA
	mov	[LBA],edx	; Yes, save LBA value in I/O parameters
	or	byte [LBA+dwd.hw+dbt.hb],LBABITS; Set DEV and LBA device bits
	jmp	short VDSChk	; Continue
CalcLBA mov	si,SECSHD	; Save starting sector in SI
	and	si,cx
	mov	di,dx		; Save starting head in DI
	shr	cl,6		; Get cylinder number in CX
	xchg	cl,ch
	mov	ax,SECSCYL	; Convert cylinder to sectors
	mul	cx
	xchg	ax,di		; Swap low-order and head number
	mov	al,SECSHD	; Convert head to sectors
	mul	ah
	add	di,ax		; Add to cylinder sectors
	adc	dl,dh
	dec	si		; Get starting sector number -1
	add	si,di		; Add to cylinder/head sectors
	adc	dl,dh
	mov	[LBA+dwd.lw],si ; Save LBA value in I/O parameters
	mov	dh,LBABITS	; Set DEV/LBA bits and ensure bits 19-16 are 0
	mov	[LBA+dwd.hw],dx
VDSChk	push	byte BIOSSEG	; Point ES to BIOS data
	pop	es
	test	byte [es:BIOSVDS+dbt.lb],020h; Are VDS services active?
	jz	Addr20		; No, set up 20-bit DMA address
	mov	word [DMAAdr+dwd.hw],-1; Invalidate DMA address
	push	ds		; Point to VDS descriptor block
	pop	es
	mov	di,VDS
	mov	ax,8103h	; Do VDS "lock" on our I/O buffer
	mov	dx,0Ch
	int	4Bh
	jc	VDSErr		; Failed? Reload regs. & "pass" request!
	mov	ah,1		; Set VDS "lock" flag for use at exit
	cmp	word [DMAAdr+dwd.hw],-1; Did we get a valid DMA address?
	jne	DoReq		; Yes, go do this I/O request
VDSErr	pop	es		; VDS error! Reload all CPU registers
	pop	ds	; Most likely reject cause is a request with fragmented
	popa		; buffers, rare for DOS and INVOLVED to process, so we
	jmp	NotUs	; "pass" such requests back to the BIOS
Addr20	xor	eax,eax		; No VDS - set 20-bit DMA address
	push	bx
	mov	ebx,eax		; Clear high word of offset
	pop	bx
	mov	ax,[VDSSeg]	; Load segment
	shl	eax,4		; Convert from segment to physical address
	add	eax,ebx		; Add offset
	mov	[DMAAdr],eax
DoReq	mov	bp,sp		; Point BP to our stack "frame"
	and	byte [bp+26+dbt.lb],0FEh; Reset exiting CF (denotes error)
	mov	dx,CSTAT	; Point to controller primary status
	call	LoadTmr		; Set time limit
ChkRdy	cmp	cx,[es:di]	; 100 ms without becoming ready?
	je	TimedO		; Yes? Post timeout error and exit!
	in	al,dx		; Get controller status flags
	and	al,BUSY+READY+FAULT+ONCYL
	js	ChkRdy		; If controller is busy, go check again
	test	al,FAULT	; Does disk show a "fault"?
	jnz	Failed		; Yes? Post failure error and exit!
	cmp	al,READY+ONCYL	; Is our disk ready and on-cylinder?
	jne	ChkRdy		; No, loop back and check again
	mov	al,[IOCmd]	; If reading, get DMA "read" command
	add	al,6
	and	al,8
	mov	dx,[CUCMD]	; Reset DMA command register
	out	dx,al
	xchg	ax,cx		; Save command byte for below
	inc	dx
	inc	dx
	mov	al,24h		; Reset DMA control register
	out	dx,al
	cld			; Ensure we do "forward" moves!
	mov	dx,CSECCT	; Output our 6 I/O parameter bytes to HDD
	mov	si,Params	; sector count, LBA low/mid/high, device
DMAPar	outsb			; registers; the latter contains LBA 4MSb
	inc	dx
	shr	al,1		; Luckily, exactly 6 LSb in AL are used!
	jnz	DMAPar
	xchg	ax,cx		; Reload command byte from above
	mov	dx,[CUCMD]	; Set DMA "GO" command bit
	inc	ax
	out	dx,al
	inc	dx		; Point to DMA control register
	inc	dx
	call	LoadTmr		; Set time limit
ChkDMA	cmp	cx,[es:di]	; Has our DMA transfer timed out?
TimedO	mov	al,TIMOUT	; (Get error code ready)
	je	BadIO		; Yes? Post timeout error & exit!
	in	al,dx		; Read controller DMA status
	and	al,1		; Is DMA still in progress?
	jnz	ChkDMA		; Yes, loop back & check again
	mov	dx,CSTAT	; Get controller status
	in	al,dx
	and	al,FAULT+ERROR	; Any controller or disk errors?
	jnz	Failed		; Yes? Post failure error & exit!
PostEC	mov	[bp+18+dbt.hb],al;Post 0 (or error) in exiting AH
	mov	dx,[CUCMD]	; Reset DMA "GO" command bit
	xor	al,al
	out	dx,al
	xchg	ax,cx		; Was I/O buffer "locked" using VDS?
	jcxz	Exit		; No, reload registers and exit
	push	ds		; Point to VDS descriptor block
	pop	es
	mov	di,VDS
	mov	ax,8104h	; Do VDS "unlock" on I/O buffer
	xor	dx,dx
	int	4Bh
Exit	pop	es		; Reload all CPU registers and exit
	pop	ds
	popa
	popf
	iret
Failed	mov	al,HERROR	; Hard error! Get error code
BadIO	mov	byte [bp+18+dbt.lb],0; Clear sector count in exiting AL
	inc	byte [bp+26+dbt.lb]; Set exiting carry flag (error!)
	jmp	PostEC		; Go post error code and exit
LoadTmr push	byte BIOSSEG	; Point to BIOS timer
	pop	es
	mov	di,BIOSTMR
	mov	cx,[es:di]	; MSW not needed
	add	cx,RDYTO	; Set up ID command time limit
	ret
	align	16		; Round up to nearest paragraph
ResEnd	equ	$		; End of resident driver code

; "Strategy" routine. This routine saves our DOS "Init" request packet
; for handling below. At entry, ES:BX points to the packet.

Strat	mov	[cs:SaveRP+dwd.lw],bx; Save DOS request-packet address
	mov	[cs:SaveRP+dwd.hw],es
	retf			; Exit - await DOS "Device Interrupt"

; "Device-Interrupt" routine. This routine initializes the driver and
; is dismissed from memory when the "Init" packet is returned to DOS.

DevInt	pushf			; Entry - save all registers
	pusha
	push	ds
	push	es
	push	cs		; Set our DS
	pop	ds
	les	bx,[SaveRP]	; Point to DOS request packet
	cmp	byte [es:bx+RP.RPOp],0; Is this an "Init" packet?
	jne	near I_BadP	; No? Post errors and exit quick!
	mov	dx,TTLMsg	; Display our "title" message
	call	putstr
	les	bx,[es:bx+RP.RPCmdl]; Point to the command line tail
GetNext mov	al,[es:bx]	; Get a command line character
	or	al,al		; Terminate if end of line reached
	jz	FindIt
	cmp	al,CR
	je	FindIt
	cmp	al,LF
	je	FindIt
	cmp	al,'W'		; "Enable UDMA write" option?
	jne	ChkMode		; No, continue with the next character
	mov	byte [WritEn],3 ; Yes, set the "UDMA write enable" flag
ChkMode cmp	al,'2'		; Mode digit?
	jb	ChkNext		; No, continue
	cmp	al,'6'
	ja	ChkNext
	mov	[MaxMode],al	; Yes, store the maximum allowable UDMA mode
ChkNext inc	bx
	jmp	GetNext
FindIt	call	find_it		; Find the UDMA controller PCI base port
	jc	near I_Quit	; Not found? Quit!
	mov	[CUCMD],ax	; Save command register address ( = base)
	mov	dx,CCMD-1	; Issue "Identify Device" command
	mov	al,0A0h
	out	dx,al
	mov	al,0ECh
	call	I_Cmd
	jc	I_DefM		; Error - display "Default" message
	mov	dx,CDATA	; Point to controller PIO data reg
	mov	cx,53		; Skip ID bytes 0-105
I_Skp1	in	ax,dx
	loop	I_Skp1
	in	ax,dx		; Read ID bytes 106 and 107
	mov	bh,al		; Save "DMA valid" flag byte
	mov	cx,34		; Skip ID bytes 108-175
I_Skp2	in	ax,dx
	loop	I_Skp2
	in	al,dx		; Read ID bytes 176 and 177
	mov	bl,al		; Save "DMA mode" flag byte
	mov	cx,167		; Skip remaining ID data
I_Skp3	in	ax,dx
	loop	I_Skp3
	test	bh,4		; Are UltraDMA flag bits valid?
	jnz	I_Pick		; Yes, select best UltraDMA mode
I_DefM	mov	dx,DFMsg	; Set up to display "Default" message
	jmp	short I_SelM	; Go display msg. & set UDMA mode 2
I_Pick	mov	al,[CurMode]	; Get "current mode" value
	cmp	al,[MaxMode]	; Maximum allowable mode reached?
	jae	I_GotM		; Yes, use mode 2
	cmp	bl,8		; No, will disk do UDMA mode 3?
	jb	I_GotM		; No, use mode 2
	inc	ax		; Set up for UDMA mode 3
	mov	word [DspMode],'44'
	cmp	al,[MaxMode]	; Maximum allowable mode reached?
	jae	I_GotM		; Yes, use mode 3
	cmp	bl,10h		; No, will disk do UDMA mode 4?
	jb	I_GotM		; No, use mode 3
	inc	ax		; Set up for UDMA mode 4
	mov	word [DspMode],'66'
	cmp	al,[MaxMode]	; Maximum allowable mode reached?
	jae	I_GotM		; Yes, use mode 4
	cmp	bl,20h		; No, will disk do UDMA mode 5?
	jb	I_GotM		; No, use mode 4
	inc	ax		; Set up for UDMA mode 5
	mov	dword [DspMode],'100.'
	cmp	al,[MaxMode]	; Maximum allowable mode reached?
	jae	I_GotM		; Yes, use mode 5
	cmp	bl,40h		; No, will disk do UDMA mode 6?
	jb	I_GotM		; No, use mode 5
	inc	ax		; Set up for UDMA mode 6
	mov	word [DspMode+1],'33'
I_GotM	mov	[CurMode],al	; Update "current mode" value
	mov	dx,SMMsg	; Display "Setting mode" message
I_SelM	call	putstr
	mov	dx,CSUBCM	; Set mode-select subcode
	mov	al,SETM
	out	dx,al
	inc	dx
	mov	al,[CurMode]	; Set desired UltraDMA mode value
	add	al,10h
	out	dx,al
	mov	al,SETF		; Issue set-features command to disk
	call	I_Cmd
	jc	I_SErr		; Error - display message & exit!
	xor	eax,eax		; Clear EAX for below
	mov	ax,cs		; Post code segment in VDS block
	mov	[VDSSeg],ax
	shl	eax,4		; Get 20-bit code segment value
	push	byte BIOSSEG	; Point ES to BIOS
	pop	es
	test	byte [es:BIOSVDS+dbt.lb],20h; VDS services active?
	jz	I_SetD		; No, use code segment for DMA
	push	cs		; Point to VDS descriptor block
	pop	es
	mov	di,VDS
	mov	ax,8103h	; "Lock" this driver into memory
	mov	dx,0Ch
	int	4Bh
	jc	I_VErr		; Failed? Display error msg. & exit
	mov	eax,[DMAAdr]	; Get 32-bit base driver address
	cmp	eax,byte -1	; Did we REALLY get a 32-bit address?
	je	I_VErr		; No? Display error message & exit
I_SetD	add	eax,byte DMAAdr ; Set DMA command-list address
	mov	dx,[CUCMD]
	add	dl,4		; Point to DMA I/O command pointer
	out	dx,eax
	mov	byte [VDSSize+dwd.lw+dbt.lb],0; Clear LSB of VDS buffer size
	mov	ax,3513h	; Get current INT13 vector
	int	21h
	mov	[Int13V+dwd.lw],bx; Save vector for "passed" requests
	mov	[Int13V+dwd.hw],es
	mov	ax,2513h	; "Hook" this driver into INT13
	mov	dx,Entry
	int	21h
	les	bx,[SaveRP]	; Post driver size & success code
	mov	word [es:bx+RP.RPSize+dwd.lw],ResEnd
	mov	[es:bx+RP.RPSize+dwd.hw],cs
	mov	word [es:bx+RP.RPStat],RPDON
	jmp	short I_Exit	; Go reload registers and exit
I_SErr	mov	dx,SEMsg	; DMA mode error! Point to message
	jmp	short I_Err	; Go display error message & exit
I_VErr	mov	dx,VEMsg	; VDS lock error! Point to message
I_Err	call	putstr		; Display error message & suffix
I_Quit	mov	dx,Suffix
	call	putstr
	les	bx,[SaveRP]	; Post 0 size & error status
	mov	word [es:bx+RP.RPSize+dwd.lw],0
	mov	[es:bx+RP.RPSize+dwd.hw],cs
I_BadP	mov	word [es:bx+RP.RPStat],RPERR; "Unknown command"
I_Exit	pop	es		; Reload registers and exit
	pop	ds
	popa
	popf
	retf

; Subroutine to issue initialization commands to our disk

I_Cmd	mov	dx,CCMD		; Issue desired initialization command
	out	dx,al
	call	LoadTmr		; Set up ID command time limit
I_CmdW	cmp	cx,[es:di]	; Has our ID command timed out?
	je	I_CmdE		; Yes, set CPU carry flag & exit
	in	al,dx		; Get controller alternate status
	test	al,BUSY		; Is our controller still busy?
	jnz	I_CmdW		; Yes, loop back and keep checking
	test	al,ERROR	; Did ID command cause any errors?
	jz	I_CmdX		; No, leave carry flag off & exit
I_CmdE	stc			; Error - set CPU carry flag on
I_CmdX	ret			; Exit

; Initialization variables and messages:

SaveRP	dd	0		; Saved request-packet pointer
MaxMode db	'2'		; Maximum possible UDMA mode (command option)
TTLMsg	db	'UDMA Hard Disk Driver ', Version, CRLF,'$'
DFMsg	db	CRLF,'Default '
SMMsg	db	CRLF,'UDMA mode '
CurMode db	'2, ATA-'
DspMode db	'33. ',CRLF,'$'
SEMsg	db	CRLF,'Set-mode$'
VEMsg	db	CRLF,'VDS lock$'
Suffix	db	' error - driver NOT loaded',CRLF,'$'

hprint	call	_8p		; Stanislav's tightest but cryptic hex output
_8p	xchg	al,ah
_8print	call	_4p
_4p	ror	al,4
_4print	push	ax
	and	al,0Fh
	cmp	al,0Ah
	sbb	al,69h
	das
	int	29h
	pop	ax
	ret

putstr	push	ax
	mov	ah,9		; display string in DX
	int	21h
	pop	ax
	ret

; Interface byte table - busmaster, legacy mode (bit writable or not):

itable	db	80h,8Ah,0FAh
it_end	equ	$

; Find the UltraDMA controller. Return its base I/O address in AX (CF on error)

find_it mov	dx,cntrlr
	call	putstr
	xor	edi,edi
	mov	ax,0B101h
	int	1Ah		; PCI BIOS v2.0c+ installation check
	cmp	edx,'PCI '	; BIOS OK?
	je	biosok		; yes, continue
	mov	dx,notsup	; no, BIOS too old
	jmp	short finderr
biosok	mov	si,itable
findev	mov	ecx,10100h	; class 1 (storage), subclass 1 (IDE)
	lodsb			; interface byte
	mov	cl,al
	mov	ax,0B103h	; find PCI class code
	push	si
	xor	si,si		; prepare device index (0)
	int	1Ah		; BH: bus, BL: bit 7-3: device, 2-0: function
	pop	si
	jnc	found		; if found, break loop
	cmp	si,it_end	; end of table?
	jne	findev		; no, continue searching
	mov	dx,notfnd	; yes - not found, show error and exit
	jmp	short finderr
found	mov	dx,busstr
	call	putstr
	mov	ax,bx		; get bus/device/function for display
	xchg	ah,al
	call	_8print		; show bus
	mov	dx,devstr
	call	putstr
	rol	ax,5		; move bits 15:8 to 4:0,15:13
	and	al,11111b
	call	_8print		; show device
	mov	dx,funstr
	call	putstr
	rol	ax,3		; move bits 15:13 to 2:0
	and	al,111b
	call	_4print		; show function
	mov	di,4		; get command low byte
	mov	ax,0B108h	; read configuration byte
	push	bx		; bus/device/function may be distroyed
	int	1Ah
	pop	bx
	and	cl,101b		; mask Bus Master and I/O Space bits
	cmp	cl,101b		; asked bits supported?
	je	bitsup		; yes, continue
	mov	dx,busmer	; no, exit
finderr call	putstr
	stc			; error return
	ret
bitsup	mov	di,20h		; yes, get base address register 4
	mov	ax,0B109h	; read configuration word
	int	1Ah
	xchg	cx,ax		; base address now in AX
	and	ax,0FFFCh	; mask non-signinficant 2LSb
	mov	dx,adrstr	; no, continue
	call	putstr
	call	hprint		; show base address
	clc
	ret			; base in AX

notsup	db	CR,'PCI BIOS 2.0c+ required$'
cntrlr	db	'UDMA controller $'
notfnd	db	'not found$'
busstr	db	'found at bus $'
devstr	db	', device $'
funstr	db	', function $'
adrstr	db	', base $'
busmer	db	CRLF,'Bus master$'
