/*
 * TREE command for MS-DOS
 *
 * This command is virtually identical to the MS-DOS TREE command,
 * except that it expands the current directory path instead of
 * showing '.' in the display.
 *
 * Copyright 1995 Dave Dunfield
 * Copyright 2000 Kenneth J. Davis and Dosius Software Co.
 * Modified by Joe Cosentino on 7/27/00.
 * Freely distributable.
 */

#include <direct.h>
#include <stdio.h>
#include <ctype.h>
#include <dos.h>
#include <string.h>
#include <dir.h>
#include <errno.h>
#define get_drive() (getdisk())
#define getdir(x) getcurdir(0, (x))

#define DIRS    500                     /* Depth of directory stacking */
#define DEPTH   50                      /* Depth of scanner recursion */

// G L O B A L S ////////////////////////////////////////////////////////////

char
    *parg = 0,                      /* Path argument */
    path[66],                       /* Final path specification */
    full = 0,                       /* Full listing specified */
    dirstack[DIRS][13],             /* Stack of directory names */
    *actstack[DEPTH],               /* Stack of active levels */
    *Vline = "\xB3\x20\x20",        /* Vertical line */
    *Vtee  = "\xC3\xC4\xC4",        /* Vertical/Horizonal tee */
    *Corn  = "\xC0\xC4\xC4",        /* Vertical/Horizontal corner */
    *Hline = "\xC4\xC4\xC4";        /* Horisontal line */

unsigned
    dirptr = 0,                     /* Directory stacking level */
    level = 0;                      /* Function recursion level */

static char help_text[] = {"\
Graphically displays the directory structure of a drive or path.\n\
\n\
TREE [drive:][path] [/F] [/A]\n\
\n\
  /F   Displays the names of the files in each directory.\n\
  /A   Uses ASCII instead of extended characters.\n"};

// F U N C T I O N S ////////////////////////////////////////////////////////

/*
 * Handle a single directory, recurse to do others
 */
void tree_path(void)
{
    unsigned plen, dirbase, i, j, k;
    struct ffblk ffb;
    char *ptr, *name=ffb.ff_name;

    /* Get all sibdirectory names in this dir */
    dirbase = dirptr;
    plen = strlen(path);
    strcpy(path+plen, "*.*");
    if (!findfirst(path, &ffb, -1))
        do
            {
            if ((ffb.ff_attrib & FA_DIREC) && (*name != '.'))
                {
                strcpy(dirstack[dirptr++], name);
                continue;
                } // end if.

            } // end do.
        while (!findnext(&ffb));

    /* Display files in this dir if required */
    actstack[level++] = (dirbase == dirptr) ? "   " : Vline;
    if (full)
        {
        i = 0;
        if (!findfirst(path, &ffb, -1))
            do
                {
                if (ffb.ff_attrib & (FA_DIREC | FA_LABEL))
                    continue;

                for (j=0; j < level; ++j)
                    fputs(actstack[j], stdout);

                i = -1;
                printf("%s\n", name);
                } // end do.
            while (!findnext(&ffb));

        if (i)
            {
            for (j=0; j < level; ++j)
                fputs(actstack[j], stdout);

            putc('\n', stdout);
            } // end if.

        } // end if.

    /* Report of no subdirectories exist */
    if ((dirbase == dirptr) && (level == 1))
        printf("No sub-directories exist\n");

    /* Recurse into subdirectories */
    for (i=dirbase;i<dirptr;++i)
        {
        actstack[level-1] = ((i+1) != dirptr) ? Vtee : Corn;
        for (j=0;j<level;++j)
            fputs(actstack[j], stdout);

        actstack[level-1] = ((i+1) != dirptr) ? Vline : "   ";
        printf("%s\n", ptr = dirstack[i]);
        strcpy(path+plen, ptr);
        strcat(path, "\\");
        tree_path();
        } // end for.

    /* Restore entry conditions and exit */
    path[plen] = 0;
    dirptr = dirbase;
    --level;

} // end tree_path.

/////////////////////////////////////////////////////////////////////////////

/*
 * Main program - parse arguments & start recursive procedure
 */
int main(int argc, char *argv[])
{
    struct SREGS s;
    union REGS r;
    int i, drive, curdrive;
    char *ptr, c, *output;
    struct ffblk ffb;

    for (i=1; i < argc; ++i)
        {
        ptr = argv[i];
        while (*ptr) switch (c = *ptr++)
            {
            case '/' :              /* Option switch */
                switch (c = toupper(*ptr++))
                    {
                    case 'A' : /* Ascii - switch BOX characters */
                        Vline = "|  ";
                        Vtee  = "+--";
                        Corn  = "\\--";
                        Hline = "---";
                        continue;
                    case 'F' : /* Select FULL mode */
                        full = -1;
                        continue;
                    case '?' : /* Help request */
                        fputs(help_text, stdout);
                        exit(0);

                    } // end switch.

                printf("Invalid switch - /%c\n", c);
                exit(-1);
            default:   /* Pathname */
                if (parg)
                    {
                    printf("Too many parameters - %s\n", argv[i]);
                    exit(-1);
                    } // end if.

                parg = argv[i];
                ptr = "";

            } // end switch.

        } // end for.

    /* If no path specified, default to current */
    if (!parg)
        {
        *(parg = help_text) = '\\';
        getdir(help_text+1);
        } // end if.

    /* If no drive name specified, obtain current drive */
    if (parg[1] == ':')
        strcpy(path, parg);
    else
        {
        *path = get_drive() + 'A';
        path[1] = ':';
        strcpy(path+2, parg);
        } // end else.

    if (argc == 2)
        {
        strcpy(output, "vol ");
        strcat(output, argv[1]);
        system(output);
        } // end if.
    else if (argc < 2)
        {
        curdrive = _getdrive();         // Save current drive.
        chdir(path);
        system("vol");
        _chdrive(curdrive);
        } // end if.

    /* Display volume label of disk */
    parg[0] = drive;

    /* Display path and append backslash if not given */
    printf("\n%s\n", path);
    switch (path[strlen(path)-1])
        {
        default:
            strcat(path, "\\");
        case ':':;
        case '\\':;
        } // end switch.

    /* Perform recursive function */
    tree_path();
    return 0;

} // end main.
