/*
    DISK.H
    
    commons data + functions, shared between
    
    DSK.C and INITDISK.C
    
    note:
    
    INITDISK runs with different CODE, but same DATA segments !!
    
*/


#define MAX_HARD_DRIVE  8
#define NDEV            20      /* only one for demo            */
#define SEC_SIZE        512     /* size of sector in bytes      */


#define LBA_READ         0x4200
#define LBA_WRITE        0x4300
extern  UWORD   LBA_WRITE_VERIFY;


/* physical characteristics of a drive */

struct CHS {
    ULONG Cylinder;
    UWORD Head;
    UWORD Sector;
    };

struct DriveParamS
{
    UBYTE driveno;              /* = 0x8x                           */
    unsigned LBA_supported:1;        /* set, if INT13 extensions enabled */
    unsigned WriteVerifySupported:1; /* */
    ULONG total_sectors;

    struct CHS chs;             /* for normal   INT 13 */
};

struct media_info
{
  struct DriveParamS drive;     /* physical charactereistics of drive */
  ULONG mi_size;                /* physical sector count        */
  ULONG mi_offset;              /* relative partition offset    */
  ULONG mi_FileOC;              /* Count of Open files on Drv   */
  

  struct FS_info
    {
    ULONG serialno;
    BYTE  volume[11];
    BYTE  fstype[8];
    }fs;

};

/*
    data shared between DSK.C and INITDISK.C
*/    


extern struct media_info * FAR miarrayptr; /* Internal media info structs  */
    
extern UBYTE DiskTransferBuffer[1 * SEC_SIZE];

extern int FAR nUnits;

extern void ( FAR *FAR ReadAllPartitionTablesptr)(void);


/*
    some funny interface funtions for different code segments
*/

extern WORD FAR init_disk_printf(CONST BYTE * fmt, ...);
extern int  FAR init_disk_LBA_Transfer(struct DriveParamS *driveParam ,UWORD mode,  VOID FAR *buffer, 
                                ULONG LBA_address,unsigned totaltodo, UWORD *transferred);
extern void FAR init_disk_LBA_to_CHS(struct CHS *chs, ULONG LBA_address, struct DriveParamS *driveparam);

    