
mark_path:
		; Place the sfn/lfn marker at the appropriate place in the path string.
		; in
		;	di=pointer to path string
		;	ax=offset in path string of sfn/lfn separation
		add		di,ax
		cmpb	[di],0
		je		@f1
		movb	[di],'|'
	@f1:
		sub		di,ax
		ret
; end of mark_path

toupper:
		; Convert character in al to uppercase.
		; in
		;	al=character to convert
		; out
		;	al=converted character
		;	cf set=character was lowercase
		;	cf clear=no conversion
		cmp		al,'a'
		jb		?upper
		cmp		al,'z'
		ja		?upper
		sub		al,'a'-'A'
		stc
		ret
	?upper:
		clc
		ret
; end of toupper

resolve_substitution:
		push	ds
		push	si
		mov		si,di
		push	es
		pop		ds
		mov		ah,0x60
		int		0x21
		pop		si
		pop		ds
		ret
; end of resolve_substitution

get_current_directory:
		push	ds
		push	si
		push	es
		pop		ds
		mov		si,di
		mov		ah,0x47
		int		0x21
		pop		si
		pop		ds
		ret
; end of get_current_directory

expand_path:
		; in
		;	ds:si=source path buffer to be expanded
		;	es:di=destination path buffer
		; out
		;	ax=length of sfn section of returned path. Includes leading 'd:\',
		;		but not the '\' separating the sfn section from the lfn
		;		section. ie ax holds the number of characters between the 's
		;		in "'D:\sfn section'\lfn section".
		; source and destination must not be the same, however, no check is
		; made. So be-eth it.
		push	dx
		push	cx
		push	bx
		push	si
		push	di

		cld
		; extract or determine the drive letter.
		lodsb
		cmp		al,0
		je		?dont_have_drive_letter
		cmpb	[si],':'
		je		?have_drive_letter
	?dont_have_drive_letter:
		; No drive letter was supplied, so grab the current default drive from
		; dos.
		sub		si,2
		mov		ah,0x19
		int		0x21
		add		al,'A'					; convert to drive letter for below
	?have_drive_letter:
		call	toupper
		mov		dl,al
		sub		dl,'A'-1
		inc		si

		stosb
		movd	[es:di],0x00005c3a		; ':\',0
		dec		di						; back to beginning of buffer

		cmp		ch,0x80
		je		?use_subst_drive
		call	resolve_substitution
		jcl		?error
	?use_subst_drive:
		call	end_of_string			; move di to the end of the path string
		cmpb	[es:di-1],'\\'
		je		?have_trailing_slash
		cmpb	[es:di-1],'/'
		jne		?not_forward_slash
		dec		di
	?not_forward_slash:
		movb	[es:di],'\\'
		inc		di
	?have_trailing_slash:
		push	di						; save `start' of path (root for drive)
		cmpb	[si],'\\'
		je		?absolute_path
		cmpb	[si],'/'
		je		?absolute_path
		call	get_current_directory
		jcl		?error
		cmpb	[es:di],0
		je		?in_root
		call	end_of_string
		inc		di
		movb	[es:di-1],'\\'
	?in_root:
		dec		si
	?absolute_path:
		mov		dx,di					; start of lfn section
		inc		si
		; Need to now go through the supplied path adding path elements and
		; resolving ; '.','..','...' etc.
		; Is ':' allowed in path names, or is it a reserved character?
		xor		ax,ax
	?next_path:
		xor		bx,bx
		cmpb	[si],'.'
		jne		?next_char
	?next_dot:
		inc		bx
		cmpb	[si+bx],0
		je		?backup_path_0
		cmpb	[si+bx],'\\'
		je		?backup_path
		cmpb	[si+bx],'/'
		je		?backup_path
		cmpb	[si+bx],'.'
		je		?next_dot
	?next_char:
		lodsb
		; convert '/'s to '\'s
		cmp		al,'/'
		jne		?not_fslash
		mov		al,'\\'
	?not_fslash:
		cmp		al,':'
		je		?invalid_path
		cmp		al,'*'
		je		?invalid_path
		cmp		al,'?'
		je		?invalid_path
		cmp		al,'"'
		je		?invalid_path
		cmp		al,'<'
		je		?invalid_path
		cmp		al,'>'
		je		?invalid_path
		cmp		al,'|'
		je		?invalid_path

		mov		cx,di
		sub		cx,[esp+2]				; start of destination buffer
		cmp		cx,260
		ja		?invalid_path
		stosb
		cmp		al,0					; clears carry if true
		je		?done
		cmp		al,'\\'
		jne		?next_char
		jmp		?next_path
	?backup_path_0:
		dec		si
	?backup_path:
		; advance si past next '/', '\' or to 0
		lea		si,[bx+si+1]
	?prev_path:
		dec		bx
		jz		?next_path				; '.' is current directory
	?prev_char:
		cmp		[esp],di				; `root'
		jae		?invalid_path
		dec		di
		cmpb	[es:di-1],'\\'
		jne		?prev_char
		cmp		di,dx
		jae		?prev_path
		; We've backed up over some of the dos supplied sfn section of the
		; path, so update the beginning of the lfn section
		mov		dx,di
		jmp		?prev_path
	?invalid_path:
		mov		ax,0x03					; path not found (invalid path)
		add		sp,2
	?error:
		movb	[es:di],0
		stc
		jmp		?exit
	?done:
		cmpb	[di-2],'\\'
		jne		?end_ok
		movb	[di-2],0
;		sub		di,2
		dec		di
		cmp		di,dx
		jae		?end_ok
		mov		dx,di
	?end_ok:
		add		sp,2
		mov		ax,dx					; start of lfn section
		sub		ax,[esp]				; start of destination buffer
		dec		ax
	?exit:
		pop		di
		pop		si
		pop		bx
		pop		cx
		pop		dx
		ret
; end of expand_path

lfn_truename:
		push	cs
		pop		es
		mov		di,filename_buffer

		cmp		cl,0
		jne		?short_name
		call	expand_path
		jcl		?error
		push	es
		pop		ds
	; If not in W95 compatability mode (lfn_only_flag==0), convert the sfn
	; path supplied by dos to it's lfn form
		cmpb	[lfn_only_flag],0
		je		?dont_convert_sfn
		mov		cx,ax
		mov		si,di
		mov		di,path_buffer
		add		si,cx
		mov		dl,[si]
		movb	[si],0
		sub		si,cx
		mov		ax,1
		call	get_true_file_path
		jb		?error					; shouldn't happen
		add		si,cx
		mov		[si],dl
		push	di
		call	end_of_string
		call	strcpy
		pop		di
	?dont_convert_sfn:
		mov		si,di
		mov		es,[bp+sf.ES]
		mov		di,[bp+sf.DI]
		call	strcpy
		jmp		?term_drv_str
	?short_name:
		cmp		cl,1
		jne		?long_name
		call	expand_path
		jc		?error
		push	cs
		pop		ds
		call	mark_path
		mov		si,di
		mov		di,path_buffer
		xor		ax,ax
		call	get_true_file_path
		jc		?error
		jmp		?term_drv_str
	?long_name:
		cmp		cl,2
		jne		?no_func
		call	expand_path
		jc		?error
		push	cs
		pop		ds
		call	mark_path
		mov		si,di
		mov		di,path_buffer
		mov		ax,1
		call	get_true_file_path
		jc		?error
		jmp		?term_drv_str
	?no_func:
		mov		ax,1
	?error:
		orb		[bp+sf.FLAGS],1			; set carry
		mov		[bp+sf.AX],ax			; invalid function
		jmp		?exit
	?term_drv_str:
		cmpb	[es:di+2],0
		jne		?copy_string
		movw	[es:di+2],0x005c		; '\',0
	?copy_string:
		mov		si,di
		mov		di,[bp+sf.DI]
		mov		es,[bp+sf.ES]
		call	strcpy
	?exit:
		ret
; end of lfn_true_name

lfn_volume_info:
		;        AX = 71A0h
		;        DS:DX -> ASCIZ root name (e.g. "C:\")
		;        ES:DI -> buffer for file system name
		;        CX = size of ES:DI buffer
		;Return: CF clear if successful
		;            BX = file system flags (see #1437)
		;            CX = maximum length of file name [usually 255]
		;            DX = maximum length of path [usually 260]
		;            ES:DI buffer filled (ASCIZ, e.g. "FAT","NTFS","CDFS")
		;        CF set on error
		;            AX = error code
		;                7100h if function not supported
		;Notes:  for the file system name buffer, 32 bytes should be sufficient; that's
		;         what is used in some sample code by Walter Oney from Microsoft.
		;        this function accesses the disk the first time it is called
		;SeeAlso: AX=714Eh,AX=7160h/CL=00h
		;
		;Bitfields for long filename volume information flags:
		;Bit(s)  Description     (Table 1437)
		; 0      searches are case sensitive
		; 1      preserves case in directory entries
		; 2      uses Unicode characters in file and directory names
		; 3-13   reserved (0)
		; 14     supports DOS long filename functions
		; 15     volume is compressed
		movd	[es:di],0x00544146		; 'FAT',0
		movw	[bp+sf.BX],0x4003
		movw	[bp+sf.CX],255
		movw	[bp+sf.DX],260
		ret
; enf of lfn_volume_info

lfn_get_file_info:
		;--------D-2171A6-----------------------------
		;INT 21 - Windows95 - LONG FILENAME - GET FILE INFO BY HANDLE
		;        AX = 71A6h
		;        BX = file handle
		;        DS:DX -> buffer for file information (see #1438)
		;        CF set
		;Return: CF clear if successful
		;            file information record filled
		;        CF set on error
		;            AX = error code
		;                7100h if function not supported
		;SeeAlso: AX=71A7h/BL=00h
		;
		;Format of Windows95 file information:
		;Offset  Size    Description     (Table 1438)
		; 00h    DWORD   file attributes
		; 04h    QWORD   creation time (0 = unsupported)
		; 0Ch    QWORD   last access time (0 = unsupported)
		; 14h    QWORD   last write time
		; 1Ch    DWORD   volume serial number
		; 20h    DWORD   high 32 bits of file size
		; 24h    DWORD   low 32 bits of file size
		; 28h    DWORD   number of links to file
		; 2Ch    DWORD   unique file identifier (high 32 bits)
		; 30h    DWORD   unique file identifier (low 32 bits)
		;Note:   the file identifer and volume serial number together uniquely identify
		;          a file while it is open; the identifier may change when the system
		;          is restarted or the file is first opened
		ret
; enf of lfn_get_file_info

lfn_generate_short_name:
		;        AX = 71A8h
		;        DS:SI -> ASCIZ long filename (no path allowed!)
		;        ES:DI -> buffer for ASCIZ short filename
		;        DH = short name's format
		;            00h 11-char directory entry/FCB filename format
		;            01h DOS 8.3
		;        DL = character sets
		;            bits 7-4: short name's character set (see #1439)
		;            bits 3-0: long name's character set (see #1439)
		;Return: CF clear if successful
		;            ES:DI buffer filled
		;        CF set on error
		;            AX = error code
		;                7100h if function not supported
		;Note:   this function uses the same algorithm as the filesystem except that
		;          the returned name never has a numeric tail for disambiguation
		;SeeAlso: AX=7160h/CL=00h,AX=7160h/CL=02h,AX=71A7h/BL=00h
		;
		;(Table 1439)
		;Values for Windows95 filename character set:
		; 00h    Windows ANSI
		; 01h    current OEM character set
		; 02h    Unicode
		push	cs
		pop		es
		mov		di,filename_buffer
		mov		cx,260
		call	strncpy
		push	cs
		pop		ds
		movb	[filename_buffer+259],0
		mov		si,di
		mov		di,path_buffer
		call	generate_short_filename
		mov		si,di
		mov		di,[bp+sf.DI]
		mov		es,[bp+sf.ES]
		cmp		dh,0
		je		?FCB
		call	strcpy
		jmp		?exit
	?FCB:
		mov		cx,8
	@b1:
		lodsb
		cmp		al,0
		je		@f1
		cmp		al,'.'
		je		@f1
		stosb
		loop	@b1
	@f1:
		mov		ah,al
		mov		al,' '
		rep
		stosb
		mov		cx,3
		cmp		ah,0
		je		@f2
	@b2:
		lodsb
		cmp		al,0
		je		@f2
		stosb
		loop	@b2
	@f2:
		mov		al,' '
		rep
		stosb
	?exit:
		ret
; end of lfn_generate_short_name

lfn_time_convert:
		;--------D-2171A7BL00-------------------------
		;INT 21 - Windows95 - LONG FILENAME - FILE TIME TO DOS TIME
		;        AX = 71A7h
		;        BL = 00h
		;        DS:SI -> QWORD file time
		;Return: CF clear if successful
		;            CX = DOS time (see #1317)
		;            DX = DOS date (see #1318)
		;            BH = hundredths (10-millisecond units past time in CX)
		;        CF set on error
		;            AX = error code
		;                7100h if function not supported
		;Desc:   convert Win95 64-bit file time (UTC) into DOS-style date and time
		;          (local timezone)
		;Note:   the conversion fails if the file time's value is outside the range
		;          1/1/1980 and 12/31/2107
		;SeeAlso: AX=71A6h,AX=71A7h/BL=01h
		;--------D-2171A7BL01-------------------------
		;INT 21 - Windows95 - LONG FILENAME - DOS TIME TO FILE TIME
		;        AX = 71A7h
		;        BL = 01h
		;        CX = DOS time (see #1317)
		;        DX = DOS date (see #1318)
		;        BH = hundredths (10-millisecond units past time in CX)
		;        ES:DI -> buffer for QWORD file time
		;Return: CF clear if successful
		;            ES:DI buffer filled
		;        CF set on error
		;            AX = error code
		;                7100h if function not supported
		;Desc:   convert DOS-style date and time (local timezone) into Win95 64-bit
		;          file time (UTC)
		ret
; end of lfn_time_convert

lfn_reset_drive:
		;--------D-21710D-----------------------------
		;INT 21 - Windows95 - RESET DRIVE
		;        AX = 710Dh
		;        CX = action (see #1431)
		;        DX = drive number
		;Return: CF clear
		;Note:   for compatibility with DOS versions prior to v7.00, the carry flag
		;          should be set on call to ensure that it is set on exit
		;SeeAlso: AH=0Dh
		;
		;(Table 1431)
		;Values for drive reset action:
		; 0000h  flush filesystem buffers for drive, and reset drive
		; 0001h  flush filesystem buffers and cache for drive, and reset drive
		; 0002h  remount DriveSpace volume
		mov		ah,0x0d
		int		0x21
		mov		[bp+sf.AX],ax
		setc	al
		or		[bp+sf.FLAGS],al	; al will be either 0 or 1, so this is ok
		ret
; end of lfn_reset_drive
