 ; This file is part of LBAcache, the 386/XMS DOS disk cache by
 ; Eric Auer (eric@coli.uni-sb.de), 2001-2003.

 ; LBAcache is free software; you can redistribute it and/or modify
 ; it under the terms of the GNU General Public License as published
 ; by the Free Software Foundation; either version 2 of the License,
 ; or (at your option) any later version.

 ; LBAcache is distributed in the hope that it will be useful,
 ; but WITHOUT ANY WARRANTY; without even the implied warranty of
 ; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ; GNU General Public License for more details.

 ; You should have received a copy of the GNU General Public License
 ; along with LBAcache; if not, write to the Free Software Foundation,
 ; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ; (or try http://www.gnu.org/licenses/licenses.html at www.gnu.org).

; LBAcache - a hard disk cache based on XMS, 386 only,
; and aware of the 64bit LBA BIOS Int 13 Extensions.
; GPL 2 software by Eric Auer <eric@coli.uni-sb.de> 2001-2003

	; Entry point "comcache"
	; comcache prepares the command line and the EOF RAM pointer
	; when starting as .COM - then it jumps to "install" which
	; is common to .SYS and .COM version. Install is run in a seg
	; where the cache starts at offset 0, not 0x100 ! 

COMFIXUP	equ	0x100	; everything is org 0, but the .com is
	; actually org 100h, so we use a fixup to keep things simple.

SYSDATA		equ	(0x6c-0x0e)	; where the .sys data block will
	; be: only the pointers at offset 0x0e and 0x12 will be used,
	; pointing to "EOF HEAP"/"EOF TSR" and the command line respectively.
	; At offsets 0x5c and 0x6c in PSP are two default FCBs of 16 bytes
	; each, which we can overwrite without further problems.
	; We put this block in the PSP segment which is later used to find
	; the PSP (for calling int 21.31 / 21.4c).

comcache:
	mov es,[cs:0x2c]	; environment segment
	; see Ralf Browns IntList table 1379 (PSP: 1378)
	mov ah,0x49
		int 0x21	; free the environment (TODO: error handling)!

	push cs			; set segments to sane again
	pop es
	push cs
	pop ds

	; we do nothing to copy the command line, as lbacache can handle
	; the .com string EOF - we just give it a pointer.
	mov word [SYSDATA+0x12],0x81	; command line offset
	mov [SYSDATA+0x12+2],cs		; command line segment

	push ax			; for the "SP=0x(1)0000" case
	mov ax,sp
	sub ax,COMFIXUP		; EOF is in .sys, not in .com segment!
	mov [SYSDATA+0x0e],ax		; end of heap offset
	mov ax,cs
	add ax,COMFIXUP / 16	; EOF is in .sys, not in .com segment!
	mov [SYSDATA+0x0e+2],ax		; end of heap segment
	pop ax

	; install expects ES:BX to point to SYSDATA, ES is already okay.
	mov bx,SYSDATA

	; simulate the "intr" routine (only setup.asm needs this, once...)
	mov [cs:pb+COMFIXUP],bx
	mov [cs:pb+COMFIXUP+2],es

	mov ax,cs
	add ax,0x10	; install expects org 0, not org 0x100 driver!
	push ax
	mov ax,install	; offset of installer, no fixup of course!
	push ax
	retf		; jump to install code, in .sys CS.

