; LBAcache - a hard disk cache based on XMS, 386 only, 
; and aware of the 64bit LBA BIOS Int 13 Extensions.
; GPL 2 software by Eric Auer <eric@coli.uni-sb.de> 2001/2002

; Check out the CHS version as well (limited to 8 GB, wimps out
; on LBA write)... and probably other derived versions...

; %define PRETENDER 1
;	^- do NOT modify int 0x13 because we have a bug :-(
;	(flag introduced 24.11.2001)
; %define DBGsp 1	; print SP at some occasions

%ifdef DBGsp
%imacro STACKDEBUG 0	; 0 parameters (1 would be referred %1...)
	push ax
	mov ax,sp
	inc ax
	inc ax
		push word colonmsg
		call meep	; warn
	pop ax
%endmacro
%else
%define STACKDEBUG nop
%endif

; dat     segment

; WARNING: nasm treats mov ax,label and mov ax,[label] the same,
; use mov ax,[seg:label] to access memory AT label !?
; (only a problem for sources, not for destinations)

	org  0	; SYS/XMS version of an hard disk read cache

		; inspired by PC Magazine dcache.com (which was
		; COM/EMS version and only 1 drive, max 256 MBy drive)
	; LBACACHE written by Eric Auer 10/2001 <eric@coli.uni-sb.de>
        ; (based on 5/96 sys with 386 driver for 850 MB HDD also by EA)
	; (old versions of this cache in 10/2001 were called HDDCACHE)

; not implemented: floppy cache, CD-ROM cache, (even more verbosity,)
;                  ^             ^-- preferably separate programs
;                  \-- now available, see below!
;                  int 0x13 LBA extensions support, CMD LINE ARGS
;                  ^-- now available, see below!    ^-- now avail...
;
; not planned:     useability with EMS and 8086 (use DCACHE there),
;                  DOS rather than int 0x13 cache, write cache.
;                  (write cache may be offered as a separate tool)
;
; History:
; 12.-13.10.2001 first working version (fixed 1024 sec buffer).
;     14.10.2001 added more verbosity, statistics, round-robin search.
; 18.-20.11.2001 wrote a LBA (and CHS) big version (needs more DOS RAM).
;                Default are now 2024 sectors.
;     22.11.2001 Alternative "no search" dumb but fast logic for binsel.
;     23.11.2001 added ability to run CHS only to the LBA version,
;                so the CHS version is discontinued. Now sys -and- com!
;    -25.11.2001 lots of bugfixes and improvements, command line parsing.
;                <   new year: 2002   >
;     11.01.2002 added the floppy cache function: enable with FLOP ;-).
;                Also added the F (flush) option to the uncache tool.
;                Hope disk change detect and chs<->lba still work...
;     22.01.2002 multi sector read collection in read.asm, various patches
;                for testing in Bochs (define to ign. missing change line,
;                hack to avoid A20 crash in XMS / Bochs BIOS int 15.87).
;     25.01.2002 new option STAK to activate a 500 byte local stack
;                because FreeDOS has a -tiny- 192 byte kernel stack (!).
;                PLUS new options INFO SYNC STOP to access the uncache
;                functions (NO separate UNCACHE binary any more).
;     28.08.2002 small cleanup and beautifying of the INFO function,
;                removed beep when detecting floppy disk change.

; include the SYS header, SYS basics and global data
; this must be FIRST as it contains stuff that will stay in RAM
; if the driver is disabled but complete unloading does not work

%include "datahead.asm"

.386

; -------------------------------------------------------------------

; include the main NEWI13 dispatcher which calls
; hdread and hdwrite which now come in two versions,
; one for LBA and one for CHS - {hd,lba}{read,write}
; we can return from those to either enderr, endok, or oldint
; for now, several functions cause the cache to be flushed or shut
; down completely - no support for flushing only one drive yet!
; also contains callold, which calls the original int 0x13
; FLOPPY: disk change detection and similar things are done here

%include "dispatch.asm"

; -------------------------------------------------------------------

	; main R/W handling functions
	; for CHS: hdwrite and hdread
	; es:bx is buffer, cx/dh location, dl drive, al size
	; for LBA: lbawrite and lbawrite
	; dl is drive, ds:si points to a structure of:
	; B 0x10 (0x18 to allow a 64bit flat pointer)
	; B 0
	; W number of sectors (also used for a return value:
	;   number of sucessfully read/written sectors)
	; D DOS pointer to buffer (or -1 to use flat pointer)
	; Q sector number
	; Q optional flat pointer
	; (we do NOT handle the flat pointer or sector numbers
	;  longer than 32bit, the dispatcher checks this!)

	; FLOPPY: relies on flushing on disk change already
	; handled in dispatch.asm above. Only change: floppy forces CHS

%include "rwfunc.asm"

; -------------------------------------------------------------------

	; XMS helper functions
	; copytoxms copies one sector from es:bx to XMS slot AX
	; copytodos copies one sector from XMS slot AX to es:bx

%include "xmscopy.asm"

; -------------------------------------------------------------------

	; more helper functions (using int 0x10):
	; meep: makes a beep or shows the message pointed to by
	;       a word on stack (if the word is not 0...),
	;       then shows AX and returns, taking the word from
	;       the stack again. Saves all regs including flags.
	; showal: shows AL as hex. Trashes lots of registers.

%include "meepdisp.asm"

; -------------------------------------------------------------------

	; status table handling functions

	; old format was - per entry - B LLLLLLDD (lru and drive),
	; B DH W CX, location and drive passed in CX/DH and DL.
	; new format is - per entry - D sector low, B drive, B LRU,
	; W reserved (could be used to support more than 4 G of
	; sectors, which will be drives of more than 4 TB, or to
	; support any other fancy feature, for example a linked bin
	; list for chains of adjacent sectors).
	; location and drive are passed in EAX and DL.

	; Input is sector number EAX, output (xms) bin AX
	; findbin:  finds a bin for a location (stc if not found),
        ; newbin:   allocates a new bin for a given location,    
        ;           flushing old bins if needed.
        ;           (main bin selection "intelligence" !)  
	; flush:    marks all cache buffers as empty, resets table
        ; flushone: empties all slots for drive DL only 
        ; telltabsize: (returns carry on error)
        ;          tells in AX how big a table for AX sectors will be

%include "binsel.asm"

; -------------------------------------------------------------------

	; end of install code, needs to be resident (because of flush)

resinst:
inittable:

	mov ax,[cs:localsp]
	or ax,ax
	jz noinitstak
	mov di,table 		; *offset*
	mov al,0x20
initstak:
	mov [cs:di],al		; fill local stack and table with " "
	inc di
	cmp di,[cs:localsp]
	jb initstak
noinitstak:

		call flush	; mark cache as empty, initialize table
				; -> cache size must be known!

quitpop:		; this is where a failure ends...
	pop ds		; restore all regs and return
	popa
.8086

quitinst:
	mov word [cs:running],1	; mark init as done
        jmp nix

; -------------------------------------------------------------------

fish2err:
	db 'LBACACHE shutdown: INT 0x13.',7,0
fisherr	db 'LBACACHE flush: INT 0x13.',7,0
wrerr	db 'LBACACHE flush: write error.',7,0
rderr	db 'LBACACHE: read error.',7,0
xmserr	db 'LBACACHE: XMS error.',7,0
; fullerr	db 'LBACACHE: scaling ',7,0
meepseg		db ' driver segment end: 0x',0
meepsect	db ' sectors in cache: 0x',0


hello	db 'Hard disk XMS/386 read cache, '
	db   'E. Auer <eric@coli.uni-sb.de> 2001'
	db '-2002', 13,10
	db 'License: GPL 2. '

align 8,db ' '	; align with spaces :-)
table:		; THIS is where our table -starts-, or in other words,
		; THIS is where the resident code -ends- !!!
		; this + table size -> first free byte position.

	db      'For drives 0x80..0x83 (int 0x13, LBA or CHS),'
	db 13,10
	db 'and for 1.44 MB floppies (A:/B:, CHS).'
	db 13,10,0


	; the rest after <table> will be overwritten by our (aligned)
	; status table...

	; ( old format: first byte is (DL && 3) || (importance << 2) )
	; ( next byte is DH, then we have the CX word                )
	; ( newer format: dword sector, byte drive, byte lru, word   )

	; 1/2002 format:  dword sector0, byte drive, byte lru, word
	; bitmask (bitmask: allows ..16 sectors per slot, default _4_)
	; Possible write cache format: 2 byte-sized bitmasks, one for
	; "used" and one for "dirty". Max 8 sectors per slot then.

; -------------------------------------------------------------------

	; main install and setup routine follows (starts with
	; 8086 compatible code to detect 386, then does a check
	; for the existence of XMS, allocates the cache there,
	; and stores the drive geometry information for drives
	; 0x80 .. 0x83 for CHS <-> LBA conversion
	; install: is the entry point.
	; jumps to resinst: at the end.
	; FLOPPY: added detection of change lines to know which
	; drives we should dare to cache.

%include "setup.asm"

; -------------------------------------------------------------------

	; parse command line, display it...
	; input: pointer esbx to "that device structure"

        ; recognizes words:
        ; digit -> set size in units of ksectors*
        ; BUF digit -> as digit
        ; DRV letters -> enable caching only for letters    
        ;     (C..F, aliases are 0..3, unknown are ignored) 
        ; ?:\anything -> ignored (e.g. the first argument in
        ;     .sys mode will be c:\path\to\lbacache.sys)
        ; HELP or HLP or ? -> show help message
        ; anything else -> error message

        ; defaults are using the size from datahead.asm sectors
        ; and to cache all drives 0x80..0x83
	; FLOPPY: added FLOP keyword to enable floppy read cache
	; for drives enumerated by setup.asm, See also dispatch.asm .

%include "cmdline.asm"

; -------------------------------------------------------------------

	; the whole uncache binary is now a part of the lbacache
	; binary. see uncache.asm for what it does (it handles the
	; INFO, SYNC and STOP command line arguments)...
	; Accessed by a near call to "uncache", no regs changed.
	; The call reads out [cs:args]. No XMS handle may be present
	; when calling uncache!

%include "uncache.asm"

; -------------------------------------------------------------------

.8086
			; obvious: do NOT use this after it is
			; overwritten by the table - use meep instead
strtty: push ax
	push bx
strt2:	mov bx,7	; print out some text string using bios
        mov ah,0x0e
        mov al,[cs:si]
	inc si		; so we need not care for std/cld as w/ lods!
        or al,al
        jz short sttend
	        int 0x10
        jmp short strt2	; YUCK, was to strtty - stack bomb!
sttend: pop bx
	pop ax
	ret

; -------------------------------------------------------------------

xmserr2	db 'This software needs a 386 and enough free XMS memory.'
	db 13,10,0

err386	db 13,10,'This software needs at least an 80386 CPU'
	db 13,10,'Check PCmag DCACHE for an open source PC XT cache.'
	db 13,10,0

errdrv	db 'Zero hard drives installed, will only pretend caching.'
	db 13,10,0

errnolba	db 'No LBA BIOS found, trying to stick to CHS...'
	db 13,10,0

errnofdd	db 'No floppy disk drives with change line detected,'
	db 13,10,  'floppy cache requests will be discarded.',13,10,0

; dat     ENDS
; END
