; Begin of file cdrom.inc

UNKNOWN         equ             0
ISO9660         equ             1
HIGHSIERRA      equ             2

; CD ROM Dir entry flag bits
EXIST           equ             000000001h     ; hidden when 1
DIR             equ             000000002h
ASSOCFILE       equ             000000004h
RECORD          equ             000000008h
PROTECTION      equ             000000010h
MULTIEXTENT     equ             000000080h


;  ISO9660 description based upon standard

isoVolDesc      STRUCT
Type              byte               1                ; 1
ID                byte            "CD001"          ; 2-6
Version           byte            1                ; 7
                  byte            0                ; 8
SysID             byte            32 dup (?)       ; 9-40   a-char
VolID             byte            32 dup (?)       ; 41-72
                  byte            8  dup (0)       ; 73-80
VolSizeLSB        dword           ?                ; 81-84
VolSizeMSB        dword           ?                ; 85-88
                  byte            32 dup (0)       ; 89-120
SetSizeLSB        word            ?
SetSizeMSB        word            ?
SetSeqLSB         word            ?
SetSeqMSB         word            ?
BlkSizeLSB        word            ?
BlkSizeMSB        word            ?
PathTabSizeLSB    dword           ?
PathTabSizeMSB    dword           ?
PathTabLocLSB     dword           ?                ; 141-144
PathTabOptLocLSB  dword           ?                ; 145-148
PathTabLocMSB     dword           ?                ; 149-152
PathTabOptLocMSB  dword           ?                ; 152-156
DirRec            isoDirRec       ()               ; 157-190
VolSetID          byte            128 dup (' ')    ; 191-318 d-chars
PubID             byte            128 dup (' ')    ; a-chars
PrepID            byte            128 dup (' ')    ; a-chars
AppID             byte            128 dup (' ')    ; a-chars
CopyRightFileID   byte            37 dup (' ')     ; d-chars
AbstractFileID    byte            37 dup (' ')     ; d-chars
BibloFileID       byte            37 dup (' ')     ; d-chars
CreateDate        byte            17 dup (?)       ; 814-830 YYYYMMDDHHMMSSssZ
ModDate           byte            17 dup (?)       ; 831-847
ExpDate           byte            17 dup (?)
EffDate           byte            17 dup (?)
StdVer            byte            1                ; 882
                  byte            0                ; 883
isoVolDesc      ENDS

isoDirRec       STRUCT
RecLen          byte            ?
ExAttrRecLen    byte            ?
ExtLocLSB       dword           ?
ExtLocMSB       dword           ?
DataLenLSB      dword           ?
DataLenMSB      dword           ?
Date            byte            7 dup (?)     ;YMDHMSZ
Flags           byte            ?
FileUnitSize    byte            ?
InterLeave      byte            ?
VolSeqNoLSB     word            ?
VolSeqNoMSB     word            ?
FIDLen          byte            ?
FileID          byte            1 dup (?)
isoDirRec       ENDS

isoDateTime     STRUCT
Yr              byte            ?
Mon             byte            ?
Day             byte            ?
Hr              byte            ?
Min             byte            ?
Sec             byte            ?
Offset          byte            ?      ; -48 to +52  15 min increments from GMT
isoDateTime     ENDS

;  High Sierria description based upon "Inside the ISO-9660 Filesytem Format",
;    Jolitz & Jolitz, DDJ, Dec. 1992.

hsVolDesc       STRUCT
LbnLSB          dword           ?
LbnMSB          dword           ?
Type            byte            ?
ID              byte            5 dup (?)
Version         byte            ?
                byte            ?
SysID           byte            32 dup (?)
VolID           byte            32 dup (?)
                byte            8 dup (?)
VolSizeLSB      dword           ?
VolSizeMSB      dword           ?
                byte            32 dup (?)
SetSizeLSB      word            ?
SetSizeMSB      word            ?
SetSeqLSB       word            ?
SetSeqMSB       word            ?
BlkSizeLSB      word            ?
BlkSizeMSB      word            ?
PathTabSizeLSB  dword           ?
PathTabSizeMSB  dword           ?
PathTabLocLSB   dword           ?
PathTabAlt1LocLSB   dword           ?
PathTabAlt2LocLSB   dword           ?
PathTabAlt3LocLSB   dword           ?
PathTabLocMSB   dword           ?
PathTabAlt1LocMSB   dword           ?
PathTabAlt2LocMSB   dword           ?
PathTabAlt3LocMSB   dword           ?
DirRec          byte            34 dup (?)
VolSetID        byte            128 dup (?)
PubID           byte            128 dup (?)
PrepID          byte            128 dup (?)
AppID           byte            128 dup (?)
CopyRightID     byte            32 dup (?)
AbstractID      byte            32 dup (?)
CreateDate      byte            16 dup (?)
ModDate         byte            16 dup (?)
ExpDate         byte            16 dup (?)
EffDate         byte            16 dup (?)
StdVer          byte            ?
                byte            0
hsVolDesc       ENDS

hsDirRec        STRUCT
RecLen          byte            ?
ExtRecLen       byte            ?
ExtLocLSB       dword           ?
ExtLocMSB       dword           ?
DataLenLSB      dword           ?
DataLenMSB      dword           ?
Date            byte            5 dup (?)
Flags           byte            ?
Reserved1       byte            ?
InterLeave      byte            ?
SkipFactor      byte            ?
VolSeqNoLSB     word            ?
VolSeqNoMSB     word            ?
FIDLen          byte            ?
FileID          byte            1 dup (?)
hsDirRec        ENDS

hsDateTime      STRUCT
Yr              byte            ?
Mon             byte            ?
Day             byte            ?
Hr              byte            ?
Min             byte            ?
Sec             byte            ?
hsDateTime      ENDS

; End of file cdrom.inc
