unit OpenDOS; {My routines useful for utility programs, to make them user-friendly and "intuitively obvious"}
{$R-}{$S+}{$N+}{$E+}
interface
uses {$IFDEF MSWIN} WINDOS {$ELSE} DOS {$ENDIF};

const
  Version = '7.02c'; {in case it isn't specified in the main program}
  Author = 'M.Aitchison@phys.canterbury.ac.nz';  {ditto}
  ThisYear = '1997';
  LDT  : DateTime = (Year:1997;Month:8;Day:1;Hour:20);
  Copyright = 'Free & Open DOS Utility' {+'(C) '+ThisYear} ;
  FreeSoft ='Free to use & distribute (non-commercially, unmodified).';

const
  DefaultPrinter: string[4] = 'PRN';
  DefaultLogfile : ^string = @DefaultPrinter;
  DefaultSortKey : string[3]='N';
  GetFileMode    : set of (FilesNeedNotExist,RecurseMatchingDirs,RecurseAllDirs,MatchAnyWhenRecursing,HideDots,
                          ShortnamesOnly) = [];
  Explainfilelist = 'filename(s), separated by spaces, (e.g. *.BAK *abc*)';
  ExplainInDirectories='directory.. - directory name(s), separated by spaces, e.g. \MY*';
  ExplainLptOptions = '/Lpt - list to PRN (/LPT2 lists to LPT2, /L=filename lists to given file)';
  ExplainAttrOptions= '/All - allow hidden, etc files (/Attr=RS or /A=5 selects Readonly System files)';
   filelist_ = 'filelist';
   ADHRS_    = '[+|-attributelist]';
   UOGADHRS_ = '[[U|O|G]+|-attributelist]';
   Attr_     = '/A'#255;
   Brief_ 	 = '/Brief';
   Checksum_ = '/Checksum';
   Date_     = '/Date:date';
   Format_   = '/Format:"text"';
   Fullname_ = '/Fullname';
   Hidden_   = '/Hidden';
   Info_     = '/Information';
   Log_      = '/Log[:logfile]';
   L_        = '/L'#255;
   Modified_ = '/Modified files only';
   Noorder_  = '/Noorder';
   Order_    = '/O'#255;
   Prompt_   = '/Prompt';
   Quiet_    = '/Quiet';
   Readonly_ = '/Readonly';
   Replace_  = '/R:replaceoptions';
   Subdirs_  = '/S'#255;
   Totals_   = '/Totals';
   Units_    = '/Units';
   Verify_   = '/Verify';
   Verbose_  = '/V'#255;
   Wait_     = '/Wait';
   Wide_     = '/Wide[:n]';
   Pause_    = '/Pause[:pagesize]';
   Sort_CompressionRatio = 'Y';
   Sort_Size             = 'S';
   Sort_Attributes       = 'A';
   Sort_Version          = 'V';
   Sort_Date             = 'D';
   Sort_Time             = 'T';
   Sort_Extension        = 'E';
   Sort_Reverse          = '-';

type
    BytePointer = ^byte;
    String2               = string[2];
    String4               = string[4];
    String20              = string[20];
    String50              = string[50];
	String80              = string[80];
    StringPointer         = ^string;
{the following is based on Mathias Paul's CUI}
const
   YesStr        :string[127] = ' YES + 1 ON TRUE ENABLE EN HIGH ONE EIN EINS JA WAHR OUI SI '
                                 +'OKAY AYE YEP SURE GO AHEAD TAK SIM EVET KYLLO KYLL KYLL IAE ';
   NoStr         :string[81] = ' NO - 0 OFF FALSE DISABLE DIS LOW NUL AUS NULL NEIN FALSCH NICHT NON NOT NEE NIE ';
   UseLFN        : boolean = true;
   UseQword      : boolean = false; {for new date/time format}
   FileSystemFlags : word = 0;
   Info_required : boolean = false;
   Ratio_required: boolean = false;
   Perms_required: set of 'A'..'U' = [];
   StartOfSortLine: byte = 1; {increased if binary sort fields stored before line of text}
   Version_required: boolean = false;
   Checksum_required: boolean = false;

var
  FormatDefinition : array[1..22] of record
                        FieldType : char;  {'F'=Filename (LFN or SFN), normal case; 'f'=LFN, or SFN converted to smalls, etc}
                        Width     : byte;
                        Options   : word; {different use depending on field type}
                        StartAt   : byte;
                        RightJustify : boolean;
                        Delimiter : string4;
                        UnitString: string[10];
                        case boolean of false: (
                        Color : byte); true: (Colour : byte); {either spelling!}
                        end;
const
    UseShortForm    = $01; {in FormatDefinitions Options}
    UseLowerCase    = $02;
    UseBriefPath    = $04;
    UseFullPath     = $08;
    UseTruename     = $10;
    Use4DigitYear   = $04;
    UseToday        = $08;
    DayFirst        = $10; { these two fields correspond to }
    YearFirst       = $20; { first byte of CountryInfo shl 4}
    UseNumericMonth = $40;
    ConditionalYear = $80; {as in Unix: if current year give time info, not year}
    ConvertDirSize  = $80; {output '<DIR>' for size if a directory}
    Use24hourClock  = $80;
const
  Compatibility : string[12]='OpenDOS';
  Format        : string[132]='a----- SSS,SSS,SSS  dd-Ddd-dd tt:ttt fffffffff...'; {used by ListFile}
  FieldsInFormat: 0..22 = 1;
const
  File_Version  : string80 = '';
  File_Copyright: string80 = '';
  File_Checksum : string80 = '';
const
  CSI       = #27'[';   {ANSI Control Sequence Initiator: we assume 7 bits, counld by #$9B otherwise}
  Directory = DOS.Directory;
  VolumeID  = DOS.VolumeID;
  ReadOnly  = DOS.Readonly;
  Hidden    = DOS.Hidden;
  SysFile   = DOS.SysFile;
  BW40= 0;  CO40= 1;  BW80= 2;  CO80= 3;  Mono= 7;  Font8x8= 256;	{ Add-in for ROM font }
  Black= 0;	Blue= 1; 	Green= 2; 	Cyan= 3;	Red= 4;	Magenta= 5;	Brown= 6;	LightGray=7; LightGrey=LightGray;
  DarkGray= 8;	DarkGrey=DarkGray; LightBlue= 9;	LightGreen= 10;	LightCyan= 11;	LightRed= 12;	LightMagenta=13;Yellow= 14;
  White= 15;
  Blink	= $80;
  MultiTasker :(NONE,TopView,DESQview,OS2,TaskMgr,Windows,Win95) = NONE;
  Security : set of (DRDOS,S_DRDOSDIR,S_NFS,S_NETWARE,S_UNIX) = [DRDOS];
  ScreenCols = 80;	{initial guess of screen width, used for array dimensioning; see also ScreenWidth}
  ScreenRows : byte = 25;	{also for array dimensioning; could bump this up a bit, for EGA special modes}
  SwitchChar   : char = '/'; {also allows '-'}
  Sec100       : word = 0;
  PrinterType  : string[10] = '';
  WrapMode     : boolean = true;

const Present_GetParameter_state : integer = 0;
      Present_GetFile_state : integer = 0;
      NotStarted = 0;
	  LastParameter : integer = 0;
	  FirstParameter: integer = 0;
	  FirstInList	 : integer = 0;
	  AllowableAttributes : byte = byte(not DOS.Hidden);
	  RequiredAttributes : byte = $00;
	  Ext : extstr = '';
const UseColour : boolean = false;
var   ColorCode : array[black..White] of ^string;
const ColorDIRS : byte = $70+Yellow;


(*
const
  CAPSFLAG : boolean = true;
  Proto : record l: byte; m: array[1..4] of char; s: string; end = (l:0;m:('m','s','a','!');s:'');
  DTwidth=11+6;
		FastOptions      : byte=$03; {0=not /Fast (default);
										1=/NoRecursion (subdirs),2=/NoOther,4=/NoPath,8=/NoFloppies
										16=/NoARC,32=/NoZIP,64=NoZOO(etc),128=NoDoublePacking(?) (arc within ZIP etc)}
		DiskType : (UnknownDisk,Normal_MSDOS,Old_MsDos,CPM_Kaypro,CPM_other,DG_720K,CPM_Nonsystem,HPFS,EXT2FS,
					  DG_RDOS,DG_AOS_RM,DG_Diag,CPM86_DS,CPM86_SS,DG_IMOVE,DG_MSDOS,RT11disk,Gimix,
					  TRSDOS,NEWDOS,FASTBACK,FASTBACK2,BACKFAST,TAR,BAR) = Normal_MSDOS;
*)
const
	 Detect   = 0; Unknown = Detect;
	 CGA      = 1; MCGA     = 2; EGA      = 3; EGA64    = 4; EGAMono  = 5;
	 IBM8514  = 6; HercMono = 7; ATT400   = 8; VGA      = 9; PC3270   = 10;
	 DG10colour = 20; DG10mono= 21; TTY=30; D211 = 36; TVI950=34; AddsR25=39; ANSI=40; Xterm=50;
	 F1=59;     F2=60;       F3=61;      F4=62;      F5=63;      F6=64;      F7=65;      F8=66;      F9=67;      F10=68;
	 ShiftF1=84; ShiftF2=85; ShiftF3=86; ShiftF4=87; ShiftF5=88; ShiftF6=89; ShiftF7=90; ShiftF8=91; ShiftF9=92; ShiftF10=93;
	 CtrlF1=94;  CtrlF2=95;  CtrlF3=96;  CtrlF4=97;  CtrlF5=98;  CtrlF6=99;  CtrlF7=100; CtrlF8=101; CtrlF9=102; CtrlF10=103;
	 AltF1=104;  AltF2=105;  AltF3=106;  AltF4=107;  AltF5=108;  AltF6=109;  AltF7=110;  AltF8=111;  AltF9=112;  AltF10=104;
type
   Qword    = record case boolean of
                     false: (QuadWord : comp);  {number of 100ns since 1/1/1601}
                     true:  (case boolean of
                                  false: (TimeDate : longint;
                                          Unused   : word;);
                                  true:  (Time     : word;
                                          Date     : word;
                                          StillUnused : word);
                             )
                     end;
	FileInfoPacket = record Attributes : longint; {low bits 0-6 standard DOS; top word 0 or DRDOS}
                           CreationDate,
			               LastAccess,
			               LastWrite  : Qword;
                           Filesize_top32bits,
                           Filesize   : longint;
                           Reserved   : array[1..8] of char;
                           LFN   : array[0..255] of char; MoreFullname : array[256..259] of char;
                           Shortname  : array[1..14] of char;
                           UnicodeFlags : word;
			               fyle : file;
                           PermissionsValid : boolean;
			               GID,UID,Password,
                           PhysicalSize,
			               Permissions: longint;
                           Info,Version,Copyright,
                           Checksum   : ^string80;
                           Highlight  : integer;
                           Directory  : string;
			   end;
	 BigArray = array[0..32767] of char;
	 BigArrayPointer = ^BigArray;

StorageBlock = record Indicator : char; {before each program & environment; anchor before start of device table}
					  PSPsegment : word; {where to find the Program Segment Prefix}
					  Paragraphs : word; {size of memory block excludes this  header}
					  unused : array[6..8] of byte;    {usually 0}
					  OwnerName : array[1..8] of char; {in DR DOS 5, etc}
					  end;
	 PSP = record  {Program Segment Prefix at the start of each program loaded}
		INT20 : word; {contains INT 20h instruction}
		MemoryLimit : word; {segment address of memory beyond allocation}
		Reserved : byte;
		FarCall : byte; {Far call to DOS function despatcher}
		DosFunctionDespatcher, {Offset also contains how much code we can use}
		TerminateVector,
		BreakVector,
		ErrorVector : pointer;
		Parent    : word; {segment of parent}
	   UsedByDOS : array[1..20] of byte;
	   EnvironmentSegment : word;
		DosWorkArea : array[1..34] of char;
	   INT33 : word;
	   RETF  : byte;
		Reserved53 : word;
	   FCB1extension : array[1..7] of byte;
	   FCB1          : array[1..9] of byte;
	   FCB2extension : array[1..7] of byte;
	   FCB2          : array[1..20] of char;
	   Parameters    : string[127];
	   DTA           : array[1..128] of byte; {Disk Transfer Area}
	   end;
	 DevicePointer = ^DeviceHeader;
    DeviceHeader = record  {at the start of each device driver}
				  NextDevice   : DevicePointer;
	           Attributes   : word; {bit $80 =1 for char. devices (then bit 01=Stnd Input, }
	                                {                 bit 02=Stnd Output, bit 04=NUL device}
											  {                 bit 08=CLOCK, bit 10=special) }
											  {        =0 for block devices}
	                                {bit $40 =IOCTL bit         }
	                                {bit $20 =non-IBM FORMAT bit}
				  StrategyRoutine : word; {offset to strategy routine}
	           InterruptRoutine : word; {offset to interrupt routine}
	           Name     : array[1..8] of char;
				  end;
    ExtendedBiosDataAreaType =
       record NumberOfKilobytesAllocted : byte; {PS/2; see memw[0:$40E]}
              Reserved                  : array[1..$21] of byte;
	      PointingDevice : record Driver : pointer;
	                              Flags  : word; {use intr $15 to access?}
	                              Reserved : array[$28..$2F] of byte;
	                              end {of PointingDevice sub-record};
				  end {of Extended Bios Data area record; whole thing is 1K long};
    BiosParameterBlock = record {should be found in boot sector, also found in RAM}
					 BytesPerSector  : word; {should be 512}
	             SectorsPerCluster:byte; {a power of two, depends on capacity}
	             ReservedSectors : word; {1, the boot sector. Any more is suspicious}
					 NumberOfFATs    : byte; {2, some RAM drives have 1. Dos assumes 2 usually}
					 RootEntries     : word; {a power of 16, can be varied}
	             TotalSectors    : word; {e.g. 720 for a 360K disk; includes boot sector, FATs, etc}
	             IDbyte          : byte; {F0 to FF; see first byte in FAT. Some ID's doubly-assigned}
					 SectorsPerFAT   : word; {how many sectors does each FAT take up?}
	             SectorsPerTrack : word; {e.g. 8,9,15,18 for diskettes. "optional" part of BPB}
	             NumberOfSides   : word; {1 or two for diskettes}
					 SpecialReserved : longint; {should be zero; viruses may use this, so it's checked}
	             BigTotalSectors : longint; {will be zero (unused) on diskettes}
	             end {of record};
    DOS_BootSector = record FirstByte,SecondByte,ThirdByte : byte; {should be $EB, something, $90}
	                OEMname : array[1..8] of char;  {can be anything reasonable name}
	                BPB : BiosParameterBlock;              {see above}
	                PhysicalDrive : byte;                  {0 under DOS 4 for diskettes, even on B:}
	                Reserved      : byte;                  {dunno, but DOS 4 reserves it}
						 ExtendedBootRecordSignature : byte;    {seems to be 41 under DOS 4.01}
	                VolumeSerial  : record low,high : word; end; {can be anything; DOS 4 or better}
						 VolumeLabel   : array[1..11] of char;  {repeats volume label when formatted, DOS 4+}
	                FATtype       : array[1..8] of char;   {"reserved" in DOS 4, seems to contain "FAT.."}
	                BootCode      : array[$3E..$1FD] of char; {might start before/after this; version-dependent}
						 AA55          : word;                     {normally $AA, $55}
						 end;
    BootSectorPointer = ^DOS_BootSector;
    DirEntry = record Name : array[1..8] of char; ext : array[1..3] of char;
					  Attribute : word;
	              Reserved  : array[13..21] of byte;
	              Time,Date,
					  StartCluster : word;
	              Size      : longint;
	              end;
    BackupControlRecord =
       record BytesInRecord : byte; {always 34}
	      Filename   : array[1..12] of char;
	      Version    : byte; {always 3}
	      UnpackedLength : longint;
			DiskVolume : word;
	      Offset     : longint;
			CompressedSize : longint; {always = actual size}
	      Dunno      : word; {always = 32}
	      Time       : word;
			Date       : word;
			end;
    ExeHeaderRecord =
       record Signature : array[1..2] of char; {"MZ" or sometimes "ZM"}
				  BytesInLastPage, TotalPages,
              N_RelocationEntries, ParagraphsInHeader,
              MinSize,MaxSize, {in paragraphs=16bytes}
				  InitialSS, InitialSP,
              Checksum, {one's complement of all words, or zero}
              InitialIP, InitialCS,
              RelocationTableOffset, {>=40h => New Executable}
              OverlayNumber : word;
              MoreHeaderStuff : array[$1C..$3B] of char;
              NewExecutableOffset : longint;
              end;
	 NewExeHeaderRecord =
       record Signature : array[1..2] of char; {"NE" or "LE" or "LX"}
				  LinkerVersion : record major,minor : byte; end;
              EntryTableOffset,
              EntryTableSize : word;
				  CRC : longint; {or 0 for TPW, or CPUtype and OStype words for Linear executables}
				  ProgramFlags: set of (Single,Multi{DGROUP},GlobalInit,ProtMode,i8086,i286,i386,NumCoPro);
              ApplicationFlags: set of (FullScreen,CompatibleWithAPI,UsesAPI,OS2Family,Huh,ErrorsInImage,Nonconforming,DLL);
              AutoDataSegmentIndex,InitialLocalHeap,InitialLocalStack : word;
				  UtterlyBoring : array[$14..$35] of byte;
              TargetOS : byte; {1=OS/2,2=Windows...}
              OtherExeFlags : set of (SupportsLongFilenames,TwoXProtMode,TwoXPropFont);
				  MoreStuff : array[$38..$3D] of byte;
              ExpectedWindowsVersion : record minor,major : byte; end;
              end;

    FixedDiskParameterTableType = record Cylinders : word;  {see XtHardDiskParameterTable & SecondHardDiskParameterPointer,}
	                                 Heads     : byte;  {interrupts $41 & $46, and FixedDiskAtBiosTables}
	                                 StartReduceWrite : word;
	                                 StartWritePrecomp: word;
												MaximumECCburst  : byte;
	                                 ControlByte      : byte;
												StandardTimeout,
	                                 FormattingTimeout,
	                                 CheckingTimeout  : byte;
												LandingZone      : word;
												SectorsPerTrack  : byte;
	                                 ReservedF        : byte; {total of 16 bytes}
	                                 end;
	 {see DisketteParameterTablePointer, interrupt $1E, and location 0:$522}
    DisketteParameterTableType = record FirstSpecifyByte, {bits 7-4= Step Rate Time in 2ms, bits 3-0=Head Unload in 32ms}
	                                SecondSpecifyByte,{bits 7-1= Head load time in 4ms, bit 0= non-DMA (PCjr)}
											  MotorRunTime      : byte; {in 1/18th second ticks}
	                                BytesPerSector    : (Block128,Block256,Block512,Block1024); {normally Block512, i.e. 2}
	                                SectorsPerTrack   : byte; {i.e. highest number sector on a track}
	                                GapLength         : byte; {many BIOSes ignore this when reading}
	                                DataLength        : byte; {set to $FF for 512 bytes/sector}
	                                FormatGapLength   : byte; {normally $50 for 9 sectors/track}
	                                FormatFillByte    : byte; {normally $F6 for MSDOS, can be anything}
	                                HeadSettleTime    : byte; {in milliseconds, normally 15}
											  MotorStartTime    : byte; {in 125 ms increments}
	                                end;
	 StaticFunctionalityTableType = record {see PS2 Model 30 TRM p5-27}
	                           SupportedMode : longint; {bit0=1 iff Mode0 supported, etc up to mode $13}
	                           Reserved4     : array[4..5] of byte;
										LinesAvailable: byte; {scan lines possible in text modes, bit0=200}
																	 {bit1=350, bit2=400}
	                           BlocksAvailable : byte; {Character blocks available in Text modes}
	                           MaxActiveBlocks : byte; {max. number of active char blocks in Text modes}
										Miscellaneous   : word; {bit1=summing, bit2=char font loading, bit3=default palette}
	                                                   {bit5=Palette, bit6=Colour register, bit10=blink, bit11=DCC}
	                           ReservedC       : array [$C..$D] of byte;
										SavePointerFlags: byte; {bit0=512 char set, bit1=dynamic save area, bit2=Alpha font over.}
	                                                   {bit3=Graphics font override, bit4=Palette override}
	                           ReservedF       : byte;
	                           end;
    VideoParameterTableType = record     {see PS2 model 30 TRM p5-26}
	                      StaticFunctionalityTablePointer : ^StaticFunctionalityTableType;
	                      CrtMode          : byte; {0=BW40,1=CO40,2=BW80,3=CO80,7=MONO, etc. Use intr $10}
	                      CrtColumns       : byte; {usually 40 or 80; ignored by some software}
								 CrtPageLength    : word; {=$1000 for mono text, $4000 in CGA graphics, etc}
	                      CrtPageStart     : word; {offset in segment $B000 or $B800 to start of screen}
								 CursorPosition   : array [0..7] of record column,row : byte; {one for each page}
	                                                                end;  {use intr $10 functions 2 & 3}
	                      CursorMode       : word; {end & start lines within char. cell; use intr $10}
								 CursorEndLine    : byte; {eg 7 for CGA, $0C for mono}
								 CursorStartLine  : byte; {eg 6 for CGA; bit5=Cursor off}
								 CrtPage          : byte; {which video page (on CGA, EGA, etc); see intr $10 function 5}
	                      CrtControllerPort: word; {base port address of active 6845 Crt controller}
								 CrtHardwareMode  : byte; {copy of byte sent to port[CrtControllerPort+4], see port $3B8 etc}
	                      CrtPalette       : byte; {copy of byte sent to port[CrtControllerPort+5], see port $3D9}
	                      CrtRows          : byte; {rows of text on screen}
	                      CharacterHeight  : word; {scan lines per character}
	                      ActiveDisplayCombinationCode,
	                      AlternativeDisplayCombinationCode : byte;
	                      NumberOfColours  : word; {supported in present mode}
	                      NumberOfPages    : byte; {supported in present mode}
	                      ScanLines        : (C200,C350,C400,C480);
	                      Reserved2B       : array [$2B..$2C] of byte; {should be 0}
	                      StateInfo        : byte; {bit5=blink, bit3=default palette, bit2=mono, bit1=Summing}
								 Reserved2E       : array [$2E..$30] of byte;
	                      VideoMemorySize  : (C64,C128,C192,C256); {video ram available}
								 SavePointerState : byte; {bit4=Palette override, bit3=Graphics font override, }
	                                       {bit2=Alpha font override, bit1=Dynamic save area, bit0=512 character set}
	                      Reserved33       : array [$33..$3F] of byte;
								 end {of video table};
	 ScreenArrayType        = array[1..43,1..80] of record character : char;
                                                           textattr : byte; end;
    SavedScreenPointerType = ^SavedScreenType;
	 SavedScreenType = record                   {used by my SaveScreen & RestoreScreen routines}
					  PreviousPointer : SavedScreenPointerType;
	              SaveCursorXY  : word;
	              SavedSize : word;
	              SaveWindMin,SaveWindMax,
	              SaveCursorStyle,
	              SaveTextAttr    : word;
	              SavedScreenDataPointer : ^ScreenArrayType;
	              end;
    CharacterPixelMapType = array[0..1023] of byte;
    ComsPortNumber = (COM1PORT,COM2PORT,COM3PORT,COM4PORT,COM5PORT,COM6PORT,COM7PORT,COM8PORT); {so COM1's port number is 0}
	 Ptype= (Generic,PC,XT,PCjr,AT,PS2,Compatible,DG10,MBC550,Rainbow,M20,Z100,ZX81,ORAC,DeepThought);
{	 ScreenArray   = array[1..25,1..80] of word;  {some screens may be larger or smaller}
    SType = UnKnown .. Xterm;
    SystemDescriptorTable = record
							  DescriptorLength : word;
	                    Model, SubModel  : byte;
	                    BIOSRevisionLevel: byte;
	                    FutureInfo       : byte;
	                    unused           : array [7..8] of byte;
	                    end {of record};
{$IFDEF VER40}
const VideoTableAddressComponents : record offset,segment : word; end =
	                      (offset:$49;segment:$40);
var VideoTablePointer : ^VideoParameterTableType absolute VideoTableAddressComponents;
{$ELSE}
const VideoTablePointer : ^VideoParameterTableType = ptr($40,$49);
{$ENDIF}                       {this was to get around the fact you can't have vector constants in TP4!}
type
  CountryInfoType = record DateFormat : word; {0=mmddyy, 1=ddmmyy, 2=yymmdd}
						CurrencySymbol : array[1..5] of char;
						ThousandsSeparator : char; fill8 : byte; {should be 0}
						DecimalSeparator : char; fill10 : byte; {should be 0}
						DateSeparator : char; fill12 : byte;
						TimeSeparator : char; fill14 : byte;
						CurrencyFormat : set of (CurrencySymbolFollowsValue,
	                                       SpaceBetweenValueAndCurrencySymbol,
	                                       CurrencySymbolReplacesDecimalPoint);
	               NumberOfDigitsAfterDecimalInCurrency : byte;
	               TwentyFourHourClock : boolean;
	               CaseMapRoutine : pointer;
						DatalistSeparator : char; fill23 : byte;
	               unused : string[9];
	               end;
  PCDOS2CountryInfoType = record DateFormat : word; {0=mmddyy, 1=ddmmyy, 2=yymmdd}
	               CurrencySymbol : char; fill3 : byte; {should be 0}
						ThousandsSeparator : char; fill5 : byte; {should be 0}
						DecimalSeparator : char; fill7 : byte; {should be 0}
						unused : array[1..24] of byte;
						end;

const
  EMSpresent    : boolean = false;  {set by initialisation code at end of this unit}
  IRET          = $CF;              {Hardware Interrupt Return instruction (used when checking for valid interrupts)}
  LPT1 = 0; LPT2 = 1; LPT3 = 2;
  COM1 = 0; COM2 = 1; COM3 = 2; COM4 = 3;
  BufferSize : word = 4096;
  BytesRead  : word = 0;
  FileBuffer : BigArrayPointer = nil;

const
  StandardComsPortAddress : array[COM1Port..COM8Port] of word = ($3F8,$2F8,$3E8,$3E0,$2F0,$2e8,$2E0,$260);
  StandardErrorHandle = 2;
  StandardInputHandle = 0;
  StandardOutputHandle= 1;
  StandardPrinterHandle=4;
  StandardAuxHandle   = 3;
const
  PCtype        : Ptype = PC;  {determined during initialisation}
  ScreenType    : SType = HercMono;  {determined during initialisation}
  MousePresent  : (NoMouse,XTMouse,ATmouse,DangerMouse,RareSiberianHampster) = NoMouse;
  RedirectedOutput : boolean = false;
  ConCharacteristics : word =0;
  ZipDescription : string80 ='';
var
  FileInfo : FileInfoPacket;
const
  CmosPort      : word = $70; {change if not AT/PS-2}
  OldCursor     : word = $0000; {0=not sure yet}
  Model         : string[9] = ''; {PC or AT or whatever}
  ScreenWidth   : byte = 80; {set at startup, and updated by DetermineScreenAddressEtc}
  SavedScreen   : SavedScreenPointerType = nil;
  TabChar       = #9;
const
  FixedDiskDefaultTable: array[1..14] of FixedDiskParameterTableType =(
	 (Cylinders:306; Heads:4; StartReduceWrite:0; StartWritePrecomp:128; MaximumECCburst:0; ControlByte:0;
	  StandardTimeout:0; FormattingTimeout:0; CheckingTimeout:0; LandingZone:305; SectorsPerTrack:17),
	 (Cylinders:615; Heads:4; StartReduceWrite:0; StartWritePrecomp:300; MaximumECCburst:0; ControlByte:0;
	  StandardTimeout:0; FormattingTimeout:0; CheckingTimeout:0; LandingZone:615; SectorsPerTrack:17),
	 (Cylinders:615; Heads:6; StartReduceWrite:0; StartWritePrecomp:300; MaximumECCburst:0; ControlByte:0;
	  StandardTimeout:0; FormattingTimeout:0; CheckingTimeout:0; LandingZone:615; SectorsPerTrack:17),
	 (Cylinders:940; Heads:8; StartReduceWrite:0; StartWritePrecomp:512; MaximumECCburst:0; ControlByte:0;
	  StandardTimeout:0; FormattingTimeout:0; CheckingTimeout:0; LandingZone:940; SectorsPerTrack:17),
	 (Cylinders:940; Heads:6; StartReduceWrite:0; StartWritePrecomp:512; MaximumECCburst:0; ControlByte:0;
	  StandardTimeout:0; FormattingTimeout:0; CheckingTimeout:0; LandingZone:940; SectorsPerTrack:17),
	 (Cylinders:615; Heads:4; StartReduceWrite:0; StartWritePrecomp:$FFFF; MaximumECCburst:0; ControlByte:0;
	  StandardTimeout:0; FormattingTimeout:0; CheckingTimeout:0; LandingZone:615; SectorsPerTrack:17),
	 (Cylinders:462; Heads:8; StartReduceWrite:0; StartWritePrecomp:256; MaximumECCburst:0; ControlByte:0;
	  StandardTimeout:0; FormattingTimeout:0; CheckingTimeout:0; LandingZone:511; SectorsPerTrack:17),
	 (Cylinders:733; Heads:5; StartReduceWrite:0; StartWritePrecomp:$FFFF; MaximumECCburst:0; ControlByte:0;
	  StandardTimeout:0; FormattingTimeout:0; CheckingTimeout:0; LandingZone:733; SectorsPerTrack:17),
	 (Cylinders:900; Heads:15; StartReduceWrite:0; StartWritePrecomp:$FFFF; MaximumECCburst:0; ControlByte:0;
	  StandardTimeout:0; FormattingTimeout:0; CheckingTimeout:0; LandingZone:901; SectorsPerTrack:17),
	 (Cylinders:820; Heads:3; StartReduceWrite:0; StartWritePrecomp:$FFFF; MaximumECCburst:0; ControlByte:0;
	  StandardTimeout:0; FormattingTimeout:0; CheckingTimeout:0; LandingZone:820; SectorsPerTrack:17),
	 (Cylinders:855; Heads:5; StartReduceWrite:0; StartWritePrecomp:$FFFF; MaximumECCburst:0; ControlByte:0;
	  StandardTimeout:0; FormattingTimeout:0; CheckingTimeout:0; LandingZone:855; SectorsPerTrack:17),
	 (Cylinders:855; Heads:7; StartReduceWrite:0; StartWritePrecomp:$FFFF; MaximumECCburst:0; ControlByte:0;
	  StandardTimeout:0; FormattingTimeout:0; CheckingTimeout:0; LandingZone:855; SectorsPerTrack:17),
	 (Cylinders:306; Heads:8; StartReduceWrite:0; StartWritePrecomp:128; MaximumECCburst:0; ControlByte:0;
	  StandardTimeout:0; FormattingTimeout:0; CheckingTimeout:0; LandingZone:319; SectorsPerTrack:17),
	 (Cylinders:733; Heads:7; StartReduceWrite:0; StartWritePrecomp:$FFFF; MaximumECCburst:0; ControlByte:0;
	  StandardTimeout:0; FormattingTimeout:0; CheckingTimeout:0; LandingZone:733; SectorsPerTrack:17)
	  );
var
    Active6845port   : word absolute  $40:$0063;
	 ActivePage       : ^byte;
    BIOSdate         : array [1..8] of char absolute $F000:$FFF5;
    ComPort          : array[1..4] of word absolute $0040:0000;
    CurrentPage      : byte;
    CurrentTrack     : array[0..1] of byte absolute $0040:$0094;
    CurrentVideoMode : byte absolute  $40:$0049;
    Error            : integer;
    FixedDisk1Parameters : ^FixedDiskParameterTableType absolute $10:$04; {int 41h}
    FixedDisk2Parameters : ^FixedDiskParameterTableType absolute $10:$18; {int 46h}
    i, j,  f         : Integer;
    IVect            : array[8..$FF] of ^word absolute 2:0;	{interrupt vectors}
    int40segment     : word absolute $10:$02;
	 LastDiskError    : byte absolute $40:$41;
    LptPort          : array[1..4] of word absolute $0040:0008;
    OldDisketteBios  : pointer absolute $10:$00;
    OriginalTextAttr : byte;
    PhysicalHardDisks: byte absolute $40:$0075;
    PresentDiskBios  : pointer absolute 4:$C;
	 PresentTime      : longint absolute$40:$6C;
    Reg              : Registers;
	 ResultByte       : array[0..6] of byte absolute $0040:$0042;
    ScreenPointer    : ^ScreenArrayType;
    StartTime        : longint;
    st,  st2         : string80;

var
    EnvironmentPointer : pointer;
    VideoParameterTablePointer    : ^VideoParameterTableType absolute 7:$04;    {intr $1D}
    DisketteParameterTablePointer : ^DisketteParameterTableType absolute 7:$08; {intr $1E; see 0:$522}
    GraphicsCharactersPointer     : ^CharacterPixelMapType absolute 7:$0C;     {intr $1F; see GRAFTABL command}
    {intr $1F points to a table of character PEL maps for characters 128-255 when in graphics mode; see also intr $44}
	 DosProgramTerminatePointer    : pointer absolute 8:$00; {use DOS function calls $31 or $4C}
	 DosFunctionCallPointer        : pointer absolute 8:$04; {points to DOS function call processor, intr $21}
	 DosProgramTerminateUserAddress: pointer absolute 8:$08; {intr $22; clean-up routine invoked when program ends}
    DosBreakUserExitAddress       : pointer absolute 8:$0C; {intr $23; routine invoked when Ctrl-Break pressed}
    DosFatalErrorHandlerAddress   : pointer absolute 8:$10; {intr $24; routine invoked instead of "Abort,Retry,Ignore"}
    RedirectedDisketteFunctions   : pointer absolute $10:0; {intr $40; old intr $13 saved here when hard disk BIOS loaded}
    XtHardDiskParameterTable      : ^FixedDiskParameterTableType absolute $10:$04; {see XT TRM pg A-94}
	 EgaOriginalVideoVector        : pointer absolute $10:$08; {saved intr $10 vector when EGA ROM takes over}
    EgaInitialisationParameters   : pointer absolute $10:$0C;
	 PCjrGraphicsCharactersPointer : ^CharacterPixelMapType absolute $10:$10; {for characters 0-127; see also intr $1F}
    EgaGraphicsCharactersPointer  : ^CharacterPixelMapType absolute $10:$10; {for characters 0-127; see also intr $1F}
    SecondHardDiskParameterPointer: ^FixedDiskParameterTableType absolute $10:$18; {AT/PS2 only}
    PCjrNonKeyboardTranslations   : pointer absolute $10:$24; {used only on PCjr by intr $48 for scan codes $48-$69}

    ComPortAddress  : array [Com1Port..Com4Port] of word absolute$40:$00;  {for COM1 to COM4; see also COM5PortAddress, etc}
    LptPortAddress  : array [0..3] of word absolute$40:$08;  {for LPT1 to LPT4}
    ExtendedBiosDataArea : word absolute$40:$0E;  {segment of PS2's Extended Bios Data Area}

    {these flags are best obtained via intr $11; note some flags vary from model to model}
    EquipmentFlags  : word absolute$40:$10; {ppugsssr ddvvmmcb  }
	        { pp=number of printers(0-3)_/ ||\|/| \|\|\| \__b=Bootable (IPL) diskette installed           }
	        {  u=ser. printer (PCjr only)__|| | |  | | \___mm=Memory(PC,XT) or Mouse(PS2)                 }
	        {  g=games port (not PS2)_______| | |  | |_____vv=Video mode(0=none/EGA,1=CO40,2=CO80,3=MONO  }
	        {sss=number of serial ports(0-7)__| |  |                                                      }
	        {  r=reserved (PCjr DMA=0)__________|  |_______dd=diskettes-1                                 }
    {mem[0:$412] unused except for testing & PCjr keyboard transmission error count}
    MemorySize      : word absolute$40:$13;  {(*)total RAM (in Kilobytes) less video RAM; use Int $12}
	 ExpansionMemory : word absolute$40:$15;  {(*)only used in early PC's & PCjr}

	 {keyboard stuff... model-dependant flags marked with (*). See also$40:$80 etc}
    KeyboardFlags   : word absolute$40:$17;  {icnspsac icnsaclr (see also int $16) (*)  }
	        {Ins pressed__________________/||||||| |||||||\_Right shift pressed     }
	        {Caps Lock pressed_____________||||||| |||||||__Left shift pressed      }
	        {Num Lock pressed_______________|||||| ||||||___Ctrl key (left) pressed }
	        {Scroll Lock pressed_____________||||| |||||____Alt key depressed       }
	        {Pause locked (Ctrl-Num)__________|||| ||||_____Scroll lock toggled (on)}
	        {System key (*)/PCjr keyclick______||| |||______Num Lock toggled (on)   }
	        {Left Alt key (*)___________________|| ||_______Caps lock on            }
	        {Left Ctrl key (*)(AT/PS2 only)______| |________Ins mode on             }
	 AltKeypadNumber  : byte absolute$40:$19; {accumulator when using Alt & keypad for Ascii number input}
    KeyBufferHead    : word absolute$40:$1A; {(*)offset in seg $40 to head of key queue}
    KeyBufferTail    : word absolute$40:$1C; {(*)offset in seg $40 to tail of key queue}
    KeyBuffer        : array[0..15] of word absolute$40:$1E;  {Circular Queue for keystrokes}

    {disk(ette) parameters... see DiskTools unit for more explanation}
    RecalibrateStatus: byte absolute$40:$3E; {bit0=1 iff drive A needs head seek to 0, etc }
	                                     {bit7=BIOS busy  (NB for diskettes only) }
	 MotorStatus      : byte absolute$40:$3F; {bit0= A: motor on, bit1= B: motor on, etc.}
	                                     {bit7="Write occuring"   (NB for diskettes only) }
	 MotorCount       : byte absolute$40:$40; {number of ticks (1/18th sec) to keep drive motor on}
    DisketteStatus   : byte absolute$40:$41; {status of last diskette operation: 0=no error}
    DiskControllerStatus : array [0..6] of byte absolute$40:$42; {see DiskTools unit for explanation }

    {video data}
    CrtMode          : byte absolute$40:$49; {0=BW40,1=CO40,2=BW80,3=CO80,7=MONO, etc. Use intr $10}
    CrtColumns       : byte absolute$40:$4A; {usually 40 or 80; ignored by some software}
    CrtPageLength    : word absolute$40:$4C; {=$1000 for mono text, $4000 in CGA graphics, etc}
    CrtPageStart     : word absolute$40:$4E; {offset in segment $B000 or $B800 to start of screen}
    CursorPosition   : array [0..7] of record column,row : byte; {one for each page}
	                                      end absolute$40:$50;  {use intr $10 functions 2 & 3}
    CursorMode       : word absolute$40:$60; {end & start lines within char. cell; use intr $10}
    CursorEndLine    : byte absolute$40:$60; {eg 7 for CGA, $0C for mono}
    CursorStartLine  : byte absolute$40:$61; {eg 6 for CGA; bit5=Cursor off}
	 CrtPage          : byte absolute$40:$62; {which video page (on CGA, EGA, etc); see intr $10 function 5}
    CrtControllerPort: word absolute$40:$63; {base port address of active 6845 Crt controller}
    CrtHardwareMode  : byte absolute$40:$65; {copy of byte sent to port[CrtControllerPort+4], see port $3B8 etc}
    CrtPalette       : byte absolute$40:$66; {copy of byte sent to port[CrtControllerPort+5], see port $3D9}

    {cassette I-O was available only on the original IBM PC's, not XT's etc; the following
	 {bytes are reserved on other machines, e.g. for POST work areas (or rows per screen on PS2??)}
    CassetteTimeCount: word absolute$40:$67; {original PC only: time since last data transition}
    CassetteCRC      : word absolute$40:$69; {work register for 256-byte data block CRC calculation/comparison}
    CassetteLastInput: byte absolute$40:$6B; {last half-bit (250ms) input from cassette}

    {Timer count is updated 18.2 (approx) times per second by intr 8 (IRQ 0)}
    TickCount        : longint absolute$40:$6C; {updated by 8253 channel 0, normally 54.925493 millisec}
    TimerOverflow    : boolean absolute$40:$70; {non-zero if counter passed midnight & DOS hasn't done something about it}

    BiosBreakFlag    : byte absolute$40:$71;  {128 if break key has (ever?) been pressed}
    ResetFlag        : word absolute$40:$72;  {=$1234 if no need to test RAM during next POST (eg Ctrl-Alt-Del)}

    {the following bytes are used by XT's, AT's & PS2's; not used on PC, used for other things on PCjr}
    HardDiskStatus   : byte absolute$40:$74;  {status of last hard disk operation, 0=no error; see DiskTools unit}
    NumberOfHardDisks: byte absolute$40:$75;  {0,1 or 2 fixed disks for by BIOS}
    HardDiskControl  : byte absolute$40:$76;  {XT only: holds 6th parameter table entry for hard disk control sequence}
    HardDiskOffset   : byte absolute$40:$77;  {XT only: which disk port relative to $320 is being used by intr $13}

	 LptTimeout       : array [0..3] of byte absolute$40:$78; {time in seconds to wait for LPT1..4}
    ComTimeout       : array [0..3] of byte absolute$40:$7C; {time in seconds to wait for COM1..4}

    {Keyboard buffer can be shifted in many but not all PC's; you could try $52D to $6FF (but DECnet DOS uses some of this?)}
    KeyboardBufferStart : word absolute$40:$80; {offset in seg $40 to start of keyboard buffer, normally $1E}
    KeyboardBufferEnd   : word absolute$40:$82; {offset in seg $40 to end of keyboard buffer, normally $1E}

    {the following crt/disk locations are used in the PS2 (and AT clones?), unused in PC/XT, used for other purposes in PCjr}
    CrtRows          : byte absolute$40:$84; {usually 25}
    CrtBytesPerChar  : word absolute$40:$85;
    ModeOptions      : byte absolute$40:$87; {usually 0}
    {mem[0:$488] unused, except on PCjr (=Keyboard flag 2 - for Fn key & typematic)}
    CrtAdvancedFlags : word absolute$40:$89; {bit4=8x16 font (otherwise 8x8),}
	                                     {bit3=default palette loading enabled,}
	                                     {bit2=mono monitor attached,}
	                                     {bit1=video summing enabled, bits 0 & 5-7 reserved}
    DisketteByte1    : byte absolute$40:$8B; {bits 7&6: 00=500Kbps, 01=300K, 10=250K, 11=125K FM}
	                                     {bits 5&4: step rate time... 00=$0C, 01=$0D, 10=$0A, 11=reserved}
    FixedDiskStatus  : byte absolute$40:$8C; {see $474 for XT}
	 FixedDiskError   : byte absolute$40:$8D; {returned by AT/PS2 controller}
	 {mem[0:$48E] is reserved, should be zero}
    {mem[0:$48F] is reserved}

    {The following locations are used by intr $40 on the PS2 and AT, not the PC/XT/PCjr}
    MediaState       : array[0..1] of byte absolute$40:$90; {see DiskTools unit; really useful bytes!}
    {mem[0:$493] is reserved}
    PresentTrack     : array[0..1] of byte absolute$40:$94; {last track seeked on drive A: and B:}

    {The following keyboard locations are used by the PS2 and good AT's}
    KeyboardType     : byte absolute$40:$96; {bit7=ReadID in progress, bit6=Last char was start of ID}
	                                     {bit5=Force num lock if rd ID & KBX, bit4=101/102 keyboard}
	                                     {bit3=Right Alt key, bit2=Right Ctrl key}
	                                     {bit1=last code was E0 hidden, bit0=last code was E1 hidden}
    LEDflags         : byte absolute$40:$97; {what keyboard LED's to turn on}
    UserWaitPointer  : ^byte absolute$40:$98; {pointer to user's wait flag}
    UserTimeoutValue : longint absolute$40:$9C; {in microseconds}
	 RTCwait          : byte absolute$40:$A0; {bit7=RTC period time elapsed, bit0=function in use}
    {memw[0:$4A1] reserved}
    SavedFixedDiskInt: pointer absolute$40:$A4; {saved fixed disk interrupt vector, e.g. by LAN}
	 {don't confuse SavedFixedDiskInt with XT's disk bios extension saving intr $13 at DisketteFunctionsPointer}
	 CrtAlternateTable: pointer absolute$40:$A8; {pointer to alternate video parameter table}
    {memw[0:$4AC] reserved}
	 {memb[$40:$B0] reserved for 386 speed (43=33MHx)}
    DayCounter       : word absolute$40:$CE;
    {mem[0:$4CF] to mem[0:$4EF] reserved for system}
    ICA              : array[$4F0..$4FF] of byte absolute$40:$F0; {Intra-application Communications Area, reserved}
       {ICA is for any user programs (like Volkswriter, Timemark) brave enough to hope no other program is using the area}
    PrintScreenStatus: byte absolute $500:00; {0=OK, 1=PrtScr in progress, $FF=error}
    {mem[0:$501] to mem[0:$503] unused except during POST (Power On Self-Test)}
    SingleDiskRemap  : byte absolute $50:$04; {0=A:, 1=B: when DOS uses one drive for A: & B:}
    {mem[0:$505] to mem[0:$50E] unused except during POST (Power On Self-Test)}
    BasicShellFlag   : byte absolute $50:$00F; {set to 2 by BASIC SHELL command to avoid BASIC command from SHELL}
    BasicDataSegment : word absolute $50:$010; {used by (ROM) BASIC holding the default DS value}
    BasicTimerIV     : pointer absolute $50:$012; {Interrupt vector $1C save area when BASIC takes over timer}
    BasicBreakIV     : pointer absolute $50:$016; {Interrupt vector $23 save area for BASIC's break key handling}
    BasicFatalIV     : pointer absolute $50:$01A; {Interrupt vector $24 save area for BASIC catching "Abort, Retry.." errors}
    {memw[0:$51E] is used by BASIC}
    {memw[0:$520] is used by DOS}
    DisketteParameterTable : DisketteParameterTabletype absolute $50:$022; {pointed to by Int1E, see DiskTools unit}

    MonoVideoRAM    : array[1..25,1..80] of word absolute $B000:0000;
    ColourVideoRAM  : array[1..25,1..80] of word absolute $B800:0000; {Pommy spelling}
	 ColorVideoRAM   : array[1..25,1..80] of word absolute $B800:0000; {Hern spelling}
    XTdiskRom       : array[0..$7FFF] of byte absolute $C800:0000;
    XTdiskRomDate   : array[1..8] of char absolute $C800:$07B3;
    EgaBiosName     : string[$A6] absolute $C000:0004;
    EgaRom          : array[0..$7FFF] of byte absolute $C000:0000;
    FixedDiskAtBiosTables: array[1..$FF] of FixedDiskParameterTableType absolute $F000:$E401;
    RomBasic        : array[0..$7FFF] of byte absolute $F600:0000; {genuine IBM PC only}
    RomPartNumber   : array[1..8] of char absolute $FE00:0000;
    RomCopyright    : array[1..8] of char absolute $FE00:0008;
    BiosReleaseDate : array[1..8] of char absolute $F000:$FFF5;
    MachineID       : word absolute $F000:$FFFE;

const digit :array[0..15] of char = ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');

type
  cpu_info_t = record
    cpu_type : byte;
    MSW : word;
    GDT : array[1..6] of byte;
    IDT : array[1..6] of byte;
	 intflag : boolean;
    ndp_type : byte;
    ndp_cw : word;
    weitek: byte;
    test_type: char
  end;

const    {the following can be found in lo(MachineID)...}
    ID_PC   = $FF; {lo(MachineID)=$FF on real IBM PC's and early XT's}
    ID_XT   = $FE; {modern clones have $FE too; look at hi(MachineID) or BiosReleaseDate of RomCopyright to distinguish}
    ID_PcJr = $FD; {the "Edsel" of the computer business}
    ID_AT   = $FC; {almost all AT clones have $FC; hi(MachineID)=$50 for one Award Bios, $FF for another}
    ID_PS2  = $FA; {Should use intr $15 AH=$C0; Model 30 has hi(MachineID)=00)}
    ID_OldCompaq = $2D; {very old PC equivalent}
	 ID_OldCompaqXT = $9A; {old XT equivalent}
	 ID_Bison = $0036; {on old Magnum XT clones}
	 {the following machines need the full MachineID word for identification...}
	 ID_Excel = $CA00;  {early Excel XT clones}
	 ID_M20   = $FE00;  {horrible Oliv. M20}
	 ID_DG10  = $0000;  {might be a Sanyo MBC 550 or a Data General DG10, so check intr $65 and intr $FE}
const   {Cursor type numbers}
	 CursorTypeCGA_Underscore = $070A;
	 CursorTypeCGA_Block = $000A;
	 CursorTypeMono_Underscore = $0B0F;
	 CursorTypeMono_Block = $000F;
	 CursorType_Hidden = $2020; {works on most screens}

const
  CpuName : array[0..8] of string[4] = ('8088','8086','V20','V30','188','186','286','386','486');

const
  RequiredTime : longint = -999999999;
  RejectTime : longint = $7FFFFFFF;
  Today      : DateTime = (Year:0);
  ListDirContents : boolean = true;
  N_Key      : char = 'N'; {used in Pause}
  PauseResponse : char = ' ';

const CountryID : word = 64;
      CodePage  : word = 0;
      CountryInfo : CountryInfoType = (DateFormat:1;CurrencySymbol:'$'#0#0#0#0;ThousandsSeparator:',';Fill8:0;
		DecimalSeparator:'.';Fill10:0;DateSeparator:'-';fill12:0;TimeSeparator:':';fill14:0;
 		CurrencyFormat:[];NumberOfDigitsAfterDecimalInCurrency:2;TwentyFourHourClock:true;
		CaseMapRoutine:nil; DatalistSeparator:';';Fill23:0;Unused:'Aitchison');
		UseThousandsSeparator : boolean = false;
type
  String127 = string[127];
  string22  = string[22];
  arrayofchar = array[0..65530] of char;
  smallarrayofchar = array[0..127] of char;
  arrayofword = array[0..32764] of word;
  Pchar = ^smallarrayofchar;
  TitleStr = string[63]; { Window title string }
  FrameChars = array[1..8] of Char; { Window frame characters }
  LinkedFileList = ^LinkedFileListRecord;
  LinkedFileListRecord = record Next : LinkedFileList; FileName : string; end;
  WinState = record    { Window state record }
	WindMin, WindMax: Word;
	WhereX, WhereY: Byte;
	TextAttr: Byte;
	end;
type LFNbufferType = record Attributes : longint; {bits 0-6 normal DOS, bit 8=temp}
                            CreationTime,LastAccess,LastModified : Qword;
                            FileSizeHi,FileSize : longint;
                            Reserved : array[1..8] of char;
                            FullName : array[1..260] of char;
                            SFN      : array[1..14] of char;
                            end;
const LFNbuffer : LFNbufferType = (Attributes:0);
      LongName  : string =''; {ShortName : string[14]='';}



{ Define ZIP file header types based on DeZip v2.0 (C)1989 by R.P.Byrne, which carries the message:
"You may use this program, or code or tables extracted from it, as desired without restriction".}

Const
   LOCAL_FILE_HEADER_SIGNATURE = $04034B50;
   CENTRAL_FILE_HEADER_SIGNATURE = $02014B50;
   END_OF_CENTRAL_DIR_SIGNATURE = $06054B50;

Type
   OSandZipVersion = record Zip: byte; {Major*10+Minor}
						OS : (MsOrPcDos,Amiga,Vms,Unix,VMCMS,AtariST,OS2_HPFS,Macintosh,Z_System,CPM,AOSVS,RT11);
 		            end;
   Local_File_Header_Type = Record
 		          { Signature              :  LongInt; 0x04034b50}
 		            Extract_Version_Reqd   :  OSandZipVersion;
 		            Bit_Flag               :  Word; {bit 0=encrypted, bits 1&2 used iff Imploded}
 		            Compress_Method        :  Word; {0=none, 1=Shrunk,2=Reduced1..5=REduced4,6=Imploded}
 		            Last_Mod_Time          :  Word; {as per MSDOS}
 		            Last_Mod_Date          :  Word;
 		            Crc32 		  :  LongInt;
 		            Compressed_Size        :  LongInt;
 		            Uncompressed_Size      :  LongInt;
 		            Filename_Length        :  Word;
						Extra_Field_Length     :  Word;
 		            end;
   Central_File_Header_Type = Record
 		            { Signature            :  LongInt; }
			   MadeBy_Version,
			   Extract_Version_Reqd :  OSandZipVersion;
			   Bit_Flag             :  Word;
			   Compress_Method      :  Word;
			   Last_Mod_Time        :  Word;
			   Last_Mod_Date        :  Word;
			   Crc32                :  LongInt;
			   Compressed_Size      :  LongInt;
			   Uncompressed_Size    :  LongInt;
			   Filename_Length      :  Word;
			   Extra_Field_Length   :  Word;
			   File_Comment_Length  :  Word;
			   Starting_Disk_Num    :  Word;
			   Internal_Attributes  :  Word;  {bit 0 =ASCII text}
			   External_Attributes  :  LongInt; {format depends on OS}
			   Local_Header_Offset  :  LongInt;
				End;
   End_of_Central_Dir_Type =  Record
			    { Signature               :  LongInt; }
			      Disk_Number             :  Word;
			      Central_Dir_Start_Disk  :  Word;
			      Entries_This_Disk       :  Word;
			      Total_Entries           :  Word;
			      Central_Dir_Size        :  LongInt;
			      Start_Disk_Offset       :  LongInt;
			      ZipFile_Comment_Length  :  Word;
			   end;
  PKArcRecord = record
 	         Flag : byte; {should be $1A}
 	       Method : byte; {2=stored, 4=squeezed, 3=packed, etc}
 	     FileName : array[1..13] of char; {ends with NUL, may be packed with $}
 	     FileSizelo,
 	     FileSizehi : word;	{size in bytes within archive}
 	     Dateword,
 	     Timeword : word;	{packed date and time}
 		  CRC : word;	{cyclic redundancy code checksum}
		 UnpackedLength : longint;	{what size it is in the real world}
 		  end {of record};
     Char12arr	= array[1..12 ] of Char;
	  CompareFunction = function (var st1,st2 : string) : boolean;
     ErrorActionType = (Default,Ignore,Warning,NormalError,Abort,Panic);
     FileControlBlock = record
 		      ExtensionActive : byte;
 		      Res1            : byte;
 		      res4            : longint;
 		      AttrByte        : byte;
 		      DriveNumber     : byte;	{1 means A:, 2 means B: etc}
 		        Filename    : array[1..8] of char;
 		        Extension   : array[1..3] of char;
 		        CurrentBlock,
 		        RecordSize  : word;
 		        FileSize    : longint;
 		        DateTime    : longint;
 		        Reserved    : array[1..8] of byte;
 		        CurrentRecord : byte;
 		        RelativeRecord: longint;
				  end;
     LineRecord    = record Link : pointer;  LineText : string; end;
	  WhenToDelete  = (DefaultRemoveOption,Never,Always,CheckFirst,OnlyIfOld,IdenticalOnly,ExtendExistingFile);

const
  AbortEverything:boolean = false;
  AllFiles      : boolean = false;
  AnsiInstalled : boolean = false;
  Attributes    : byte = AnyFile and not (VolumeID or Hidden);
  BitInitial    : array[0..7] of string[3] = ('R-o','Hid','Sys','Vol','Dir','Mod','40','80');
  Blanks        : string80 = '                                                                             ';
  BriefOutput   : boolean = false;
  BuffLength    : integer = -1;
  Class1        : ErrorActionType = NormalError; {for "serious" errors}
  Class2        : ErrorActionType = Warning;     {for warnings}
  ClusterBytes  : longint = 1023; {bytes per cluster -1, depends on disk, O/S}
  ClusterSize   : longint = 512;
  ColumnCounter : byte = 0;
  Columns       : byte = 1;
  CurrentDrive  : byte = 0;
  DefaultOptions= '/Lpt=../Quick/Verbose../Wide..';
  DefaultParameters : string[1]='';
  Describe      : boolean = false;	{open up the file & display some of the text}
  Drive         : byte = 0;	{0=default, 1=A:, 2=B:, etc}
  ExpandDotDotDot : boolean = true;
  FilenameToMatch =#0;
  FilenameToReject='N';
  FormFeed      : string[9]=^L;
  FormFeedMode  : boolean = false;
  FullNameRequired : boolean = false;
  HeadingRequired:boolean = false;
  HeadingText   : string80 = '';
  HeadOfList    : pointer = nil;
  ItemCounter   : word = 0;	{used to determine whether a ',' is required in OutputLine}
  KeyFlagFunctionKeyPressed : boolean = false;
  KeyFlagwhichFunctionKey : char = #0;
  LastChar      : word = $0720;
  LastDiskette  : char = 'B';
  LastX         : byte = 1;
  LastY         : byte =1;
  LineCounter   : integer = 0;
  ListToPrinter : boolean = false;
  MainColour    : byte = Yellow;
const
  MonthName     : string[71] = 'APJANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDECMONTUEWEDTHUFRISATSUNYESTODTOMTIM';
  {initial of AM, then of PM, then 3char per month, then 3char per day of week, then 3char for YESterday,TODay & TOMorrow}
const
  MouseCursor   = $0F01;{circle & cross for a cursor}
  MouseX        : integer = 0;
  MouseY        : integer = 0;
  NaughtyDrives : set of 'A'..'G' = [];
  NeedToConfirm : boolean = false;
  NoOptions : string[22] = '';
  DefaultNoOption : char = 'O';
const
  PageWidth     : byte = 80;
  DoNotPause    = 32767;
  PauseInterval : integer = DoNotPause;
  PreviousDrive : byte = 255;
const
  HomeDir       : DirStr = '';
  ParameterType: string[255]='';
  RestrictionType: string[25]='';
const
  ProgName      : NameStr = '';
  RecordSize    : longint = 128;
  RecurseOption  : boolean = false;
  RejectedAttributes : byte = VolumeID or hidden; {see /A and Attributes; removed Hidden}
  RemoveOption  : WhenToDelete = Never;
  SectorSize    : longint = 512;
  SortField     : integer = 1;
  SortOptions   : string[9] = 'N';
  SortOutput    : boolean = false;
  SpecialMouseIndicator = #255;	{ReadKey returns this when the mouse was pressed}
  ThisDirName   : DirStr = '\';
  This          : integer = 0;
  TotalFiles    : word   = 0;
  TotalDirs     : word   = 0;
  TotalMsg      : string[80] = '';
  TotalRequired : boolean = false;
  TotalSize     : longint=0;
  TotalSpace    : comp =0;
  TypeOverride  : char = #0;
const
  UnitInitials  = 'WSKCMR'; {default is Bytes}
  Units         : char = ' ' ;
  UnitStuff : array[0..length(UnitInitials)] of record Divider : real; Places : byte; Name : string[9]; end
 	    = ( (Divider:1.0;     Places:0; Name:' bytes'),
 	        (Divider:2.0;     Places:0; Name:' words'),
 	        (Divider:512;     Places:0; Name:' sectors'),
 	        (Divider:1024;    Places:1; Name:' Kbytes'),
 	        (Divider:1024;    Places:0; Name:' clusters'),
 	        (Divider:1048576; Places:3; Name:' Mbytes'),
 	        (Divider:128;     Places:0; Name:' Records') );
const
  Verbosity     : byte = 3; {see also verbose}
  VerticalBar   = '';
  VerticalLine  : string[3] = VerticalBar;
  DateCompaction: set of (ShortYear,ShortTime,YearSensitive,DaySensitive)=[];
  WideOutput    : boolean = false;
  X0            : byte = 0;
  Y0            : byte =0 ;	{offsets for menus, etc on screen}

const
  ContinuationChar : char = '+';
const
  ProcessedCommand : string ='';
const
  CommandString : string[127]='';
const
  Globals       : string = '';
const
  CurrentDir    : String50='';
  ThisDir       : DirStr = '';
  MaxDir        = 2500;  {maximum number of directories after the "IN ..."}

var
    Attr        : word;
    Ch          : char;
    CommandLine : ^string127;
    DateFormat  : (USA,EUROPE,JAPAN) absolute CountryInfo;
    DirectoriesInList: integer;
    DirToUse    : array [1..MaxDir] of ^DirStr;
    DirectoryMask: string50;
    DirInfo     : searchrec;
    EgaRam      : string absolute $C000:0000;
    filename1,
    filename2   : string80;
    fn          : string;
    GotTemplate : boolean;
var
	 ExceptFlag,
    InFlag      : boolean;
    InsertMode  : boolean;
	 Keyword     : string80;
    LastInList  : integer;
var
    LogicalScreen    : ScreenArrayType; {see also SavedScreen}
var
	 MMM         : array[0..12+9] of array[1..3] of char absolute MonthName;
	 OriginalBreakFlag : boolean;
	 OriginalVideoMode: byte;
var p           : word;
    PageCounter : word;
	 PhysicalDiskettes: byte;
	 PRN         : text;
	 S           : SearchRec;
var source      : text;
var SpecialFlag : byte;
var Parameter   : array [1..255] of ^string;
    ParametersInList : byte absolute ParameterType; {was FilesInList}
	 Restriction : array [1..25] of ^string;
	 RestrictionCount : byte absolute RestrictionType;
var TempFile    : text;
var ThisGlobal  : string80;
    TimerTicks  : longint absolute $40:$6C;
	 TotalOptions: byte absolute TotalRequired;
    UnpackFlag  : boolean;	{look inside packed (PKARC-type) dump files}
    Verbose     : boolean;
var DisplayState: (NothingDisplayed,BoxDisplayed,IntrinsicsDisplayed,MacrosDisplayed,
 		   CurrentDirectoryDisplayed,PathDisplayed,DisplayUpToDate,NoDisplay);
    StartOfIntrinsics,
    StartOfMacros,
    StartOfPath,
	 StartOfCurrentDirectory : StringPointer;
    EndOfList,
    PlaceInList,
    EndOfText   : word;

type array_of_task_ids = array[byte] of byte;
     array_of_task_names = array[byte] of array[1..8] of char;

const TASK_IDS : ^array_of_task_ids = nil;
      TASK_NAMES : ^array_of_task_names = nil;

function GetTasks(var MaximumTask,MyTaskOffset,CurrentlyActiveTasks : word) : word;
function AttrName(n : longint) : string;
function CpuType : byte; inline($54/$58/$2B/$C4/$FE/$C0/$B1/$21/$D2/$E0); {2 for 286 or better}
function Dos_ReadSector(Drive : word; StartSector : longint; HowMany : word; var Where) : boolean ;
function GetAnsiVersion : longint; inline($B8/$1A00/$CD/$2F); {more later!!!}
                        {mov ax,1a00; mov bx,'AV'; mov cx,'AT'; mov dx,'AR'; int 2F; sub dl,16h; mov ah,dl; mov ...}
function EGAsize : integer; inline($B4/$12/$B3/$10/$CD/$21/$FE/$C3/$B8/>$0040/$F6/$E3);
function LastDrive : byte; inline($B4/$19/$CD/$21/$B4/$0E/$CD/$21);
function TaskMaxVersion: word; inline($2B/$D2/$B8/$2701/6/$CD/$2F/7/$8B/$C2);
function TopViewVersion : word; inline($B8/$1022/$2B/$DB/$CD/$10/$8B/$C3); {mov ax,$1022; sub bx,bx; int $10; mov ax,bx}
function DrdosVersionNumber : longint; inline($B8/$4452/$CD/$21); {mov ax,'DR'; int 21h}
function Canonical(fn : string80) : string80;
function LoCase (ch : char) : char;
function Capitals(st : string) : string;
function LowerCase(st : string) : string;
function Confirm(prompt : string) : char;
function ContainsWildCards(st : string80) : boolean;
function DateString(Day,Month,Year : word) : string20;
function TimeString(Time : longint) : string;
function DateTimeString(Year,Month,Day,Hour,Minute,Second : word) : string;
function LookupMonth(st : string20) : byte;
function TimeNumber(var param) : longint;
function StringToTime(st : string) : longint;
function StringToDate(st : string) : longint;
function Decimal(x : real) : string20;
function StringToInteger(st : string) : longint;
function CmosRam(adr : byte ): byte;
function DosErrorMessage(n : integer) : string50;
function nnnn(n : longint) : string4;
function GetGlobalSpec(target : string) : string;
function Trim0(var stuff) : string;
(*
function FindMatching(filespec : string; Attributes_needed,Attributes_ok: word) : LinkedFileList;
*)
function FileExists(fn : string80) : boolean;
function ColourToInteger(ColSpec : string) : integer;
function hex(w : word) : string4; {returns 2 or 4 characters}
function hex2(b : byte) : string;  {returns 2 hex characters (nibbles; BCD), for a byte}
function hex4(n : longint) : string;   {returns 8 hex characters for given 4-byte number}
function HexToNumber(st : string) : longint;
function KeyPressed: Boolean;
function sign(number : integer) : integer;
function Match(st1,st2 : string) : boolean;
function Max(x,y : longint) : longint;
function min(x,y : longint) : longint;
function MouseButton : word;
function pad(st : string; WhatSize : integer) : string;
function LastSlash(st : string) : byte;
function ReadKey: Char;
function StringToReal(st : string) : real;
function Truncate(st : string) : string;
function ExpandIndirect(st,target : string) : string;
function ExpandCommand(st : string) : string;
function DiskFree(Drive : byte) : comp;
function GetEnv(st : string) : string;
function GetProgName(segment : word) : NameStr;
function ParentName : NameStr;
function TryToString(st : string) : string80;
function ANSIColorStr(color, back_color: Byte): String22;
function YesNo(b : boolean) : string;
function SimpleSort(st1,st2 : string) : boolean;
function ChooseColour(fn : string): byte;
function BiosError(AH : byte) : string;
function TextPos(var TF) : longint;
function Translate(st : string): string;
function DrwxAttrName(fn : string;attr : longint) : string;
function OpenFile(var FileInfo : FileInfoPacket) : boolean;
function OpenAndRead(filename : string) : boolean;
function GetParameter(var st : string) : boolean;
function DosEmu_Version : string;
function GetFile(var FileInfo : fileInfoPacket) : boolean;
function Parse(version,copyright,author,ValidOptions,Syntax,Purpose : string) : boolean;

procedure AddToSort(st : string);
procedure Trim(var st : string);
procedure ChooseFormat(Format : string);
procedure ConvertToCapitals(var s);
procedure UpdateAllFiles(WhichPSP : word);
procedure TextColor(c : byte);
procedure FinishOff;
procedure ProcessAttributes(st : string);
procedure GetDir(drive : integer; var dir : string);
procedure NoSound;
procedure OutputLine(st : string);
procedure OutputSortedList(ThisBlockNumber : integer);
procedure RestoreScreen;
procedure SaveScreen;
procedure TestForNewPage; {for OutputLine}
procedure OutputString(st : string);
procedure CancelProgram;
procedure ExecUnix(command : string);
procedure Pause;
procedure doscall(var reg : registers);
procedure Sound(freq : real);
procedure TurnOnMouseCursor;
procedure TurnOffMouseCursor;
procedure AppendParameter(st : string);
procedure WarnErr(var st : string; Class : ErrorActionType);
procedure WarningMessage(st : string);
procedure ErrorMessage(st : string);
procedure ExpandSpecial(var command : string);
procedure ProcessFormat(Format : string);
procedure GotoXY(X,Y : byte);
procedure WriteToStandardFile(Handle : word; st : string);
procedure CursorOff;
function List_Size(Width,Options : byte; Delimiter : string4; Filesize : comp) : string;
procedure CursorOn;
procedure StringDateToQword(datestr : string; var result : Qword);
procedure UpdateFile(var fyle);
procedure WriteMsg(var Msg : string; XY : word; attr : word);
procedure GetCountryInfo(var Dest; Country : word);
procedure CheckForMouse;
procedure ListFile(FileInfo : FileInfoPacket);

procedure DisableInterrupts; inline($FA);
procedure EnableInterrupts; inline($FB);
procedure Idle;inline($CD/$28/$B8/$1000/$CD/$15);
function AccurateTime : word; inline(
	 $FA/    	{ CLI 	        }
	 $33/$C0/	{ XOR     AX,AX 	}
	 $E6/$43/    	{ OUT     43h,AL }
	 $E4/$40/    	{ IN      AL,40h }
	 $8A/$E0/    	{ MOV     AH,AL 	}
	 $E4/$40/    	{ IN      AL,40h }
	 $33/$D2/   	{ xor     dx,dx 	}
	 $8C/$D9/	{ mov     cx,ds 	}
	 $8E/$DA/	{ mov     ds,dx 	}
	 $8B/$16/$46C/	{ mov     dx,DS:[46Ch]}
	 $8E/$D9/	{ mov     ds,cx 	}
	 $FB/    	{ sti 	        }
	 $86/$C4/	{ xchg    al,ah 	}
	 $F7/$D8);		{ neg     ax 	}

function BiosKeyPressed : boolean; inline($B4/$01/$CD/$16/$B8/$FFFF/$75/$02/$2B/$C0);
function BlockDeviceAttr(Drive : byte) : word; inline($B8/$4409/$5B/$CD/$21/$8B/$C2);
function dd(n : word) : string2;
function DesqViewInfo(subcall : integer) : longint; inline($58/$B4/$2B/$2B/$DB/$B9/$4445/$Ba/$5351/$CD/$21/$8B/$C3);
function DeviceCharacteristics(handle : word) : word; inline($5B/$B8/$4400/$Cd/$21/$8B/$D0/$73/$03/$B8/$FFFF);
function DosVersion : word;
function DriveIsntRemovable(Drive : byte) : word; inline($B8/$4408/$5B/$CD/$21);
function GetBaudDivisor(Port : word) : word; inline(
	 $5a/$85/$c2/3/$fa/$ec/$8a/$c8/$0C/$80/$EE/$4a/$4a/$ec/$8a/$e0/$4a/$ec/$83/$C2/3/$50/$8A/$c1/$ee/$5b/$58);
function GetCursorType : word;       inline($B4/$0F/$CD/$10/$B4/$03/$33/$DB/$CD/$10/$8B/$C1); {present cursor style}
function GetCursorXY : word;         inline($B4/$0F/$CD/$10/$B4/$03/$CD/$10/$8B/$C2); {low byte is column, high is row}
function GetLptStatus(PrinterNumber : word) : word; inline($5A/$B4/$02/$CD/$17/$86/$C4);
	                             {pop dx/mov ah,2/ int 17h/xchg ah,al}
function GetSwitchCharacter : char;  inline($B8/$3700/$CD/$21/$8A/$C2); {normally "/"}
function GetVideoMode : byte;        inline($B8/$0F00/$CD/$10);
function HandleAttr(Handle : word) : word; inline($B8/$440A/$5B/$CD/$21/$8B/$C2);
function InputReady(Handle : word) : boolean; inline($5B/$B8/$4406/$CD/$21);
	                             {pop bx/mov ax,4406/int 21h}
function Int1588 : word; inline($B8/$8888/$CD/$15); {return Extended memory size, or $8888 on PC/XT}
function OutChar2Lpt(ch : char) : word; inline($BA/>$0000/$58/$B4/$00/$Cd/$17/$86/$C4);
function TextSize(var TF ) : longint; inline(
	 $5F/        {pop di}
	 $07/        {pop es}
	 $B8/$4202/  {mov ax,4202}
	 $33/$C9/    {xor cx,cx}
	 $8B/$D1/    {mov dx,cx}
	 $26/$8B/$1D/{mov bx,es:[di]}
	 $CD/$21/    {int 21}
	 $50/        {push ax}
	 $52/        {push dx}
	 $B8/$4200/  {mov ax,4200}
	 $33/$C9/    {xor cx,cx}
	 $8B/$D1/    {mov dx,cx}
	 $26/$8B/$1D/{mov bx,es:[di]}
	 $CD/$21/    {int 21}
	 $5A/        {pop dx}
	 $58);       {pop ax}
function WhereXY : word;       inline($B4/$03/$B7/$00/$CD/$10/$8B/$C2);

procedure ClrScr;
procedure BIOS_ClrScr(attr : byte); inline($58/$8A/$F8/$B8/$0600/$2B/$C9/$BA/$1950/$CD/$10);
	             {pop ax; mov bh,al; mov ax,0600h; sub cx,cx; mov dx,1950h; int 10h}
procedure SetBorderColour(colour : byte); inline($5B/$8A/$FB/$B8/$1001/$CD/$10);
procedure SetCursorType(Number : word); inline($59/$B4/$01/$CD/$10); {see definition of CursorType...}
												{pop cx; mov ah,1; int 10h}
procedure SetCursorXY(XY : word); inline($B4/$0F/$CD/$10/$5A/$B4/$02/$CD/$10); {X in low byte, Y in high byte}
												{mov ah,0Fh; int 10h; pop dx; mov ah,2; int 10h}
procedure SetVideoMode(Mode : word); inline($58/$CD/$10);   {7=mono, etc. I assume you'll use modes <=255}
												{pop AX; int 10h}
procedure WriteCharacter(ch : char; attr : word); inline($5B/$58/$B4/$0E/$B9/>0001/$CD/$10);
												{pop bx; pop ax; mov ah,09h; mov cx,1; int 10h}

implementation

{$IFDEF VER40}
{$I CLIOTP4}
{$ENDIF}

function DosVersion : word;
begin
DosVersion:=DOS.DosVersion;
end;

procedure Trim(var st : string);
begin
st:=copy(st,1,byte(pos(#0,st)-1));
while (st<>'') and (st[length(st)] in [^I..' ',',']) do dec(st[0]);
while (st<>'') and (st[1] in [' ',^I]) do delete(st,1,1);
end;

function Canonical(fn : string80) : string80;
var st : string80;
begin
fn:=FExpand(fn)+#0;
with reg do
     begin
     AH:=$60;
     DS:=seg(fn[1]); SI:=ofs(fn[1]);
     ES:=seg(st[1]); DI:=ofs(st[1]);
     MsDos(reg);
     if odd(Flags) then st:=fn else st[0]:=#80;
     Canonical:=Trim0(st[1]);
     end;
end;

function LoCase (ch : char) : char;
begin
if ch in ['A'..'Z'] then inc(ch,32);
LoCase:=ch;
end;

function dd(n : word) : string2;
begin
dd:=char((n div 10)+48)+chr((n mod 10)+48);
end;

function Capitals(st : string) : string;
var i : byte;
begin
ConvertToCapitals(st);
Capitals:=st;
end;

procedure ConvertToCapitals(var s);
const UseDos : boolean = true;
var c : byte;  {???}
   reg: registers;
   st : string[255] absolute s;
begin          {must re-write in machine code some time!}
if UseDos
   then with reg do
        begin
        AX:=$6521; CX:=length(st); Flags:=0;
        DS:=seg(st[1]); DX:=ofs(st[1]);
        if CX<>0 then msdos(reg);
        if odd(Flags) then UseDos:=false
                      else exit;
        end;
for c:=1 to length(st) do st[c]:=UpCase(st[c]);
end;

function LowerCase(st : string) : string;
var c : byte;
begin
for c:=1 to length(st) do if st[c] in ['A'..'Z'] then inc(st[c],32);
LowerCase:=st;
end;

function Confirm(prompt : string) : char;
var ch : char;
begin
write(prompt,'? ('+YesStr[2]+' or '+NoStr[2]+') ');
ch:=upcase(ReadKey);
Confirm:=ch;
end;

function ContainsWildCards(st : string80) : boolean;
begin
ContainsWildCards:=boolean(pos('*',st)) or boolean(pos('?',st));
end;

function DateString(Day,Month,Year : word) : string20;
var YYYY : string[4];
begin
str(1900+(Year mod 1900),YYYY);
if ShortYear in DateCompaction then delete(YYYY,1,2);
if Month>12 then Month:=13;
with CountryInfo do
	  DateString:=dd(day)+DateSeparator+MMM[Month]+DateSeparator+YYYY;
end;

function TimeString(Time : longint) : string;
begin
if Time<>-1 then UnpackTime(Time,LDT);
with LDT do TimeString:=DateTimeString(Year,Month,Day,Hour,Min,Sec);
end;

function DateTimeString(Year,Month,Day,Hour,Minute,Second : word) : string;
var st  : string[24]; HH,SS : string[4]; Time  : string[9]; x : word;
begin
with CountryInfo do
	begin
	str(100+Minute,st); st[1]:=TimeSeparator;
	if not (ShortTime in DateCompaction)
		then begin str(100+Second,SS); st:=st+TimeSeparator+SS[1]+SS[2]; end;
	if TwentyFourHourClock
		then begin
			  str(Hour:3,HH);
			  Time:=HH+st;
			  end
		else begin
			  if Hour=0 then HH:=' 12' else str(succ(pred(Hour) mod 12):3,HH);
			  Time:=HH+st+locase(MonthName[succ(Hour div 12)]);
			  end;
	end;
if Month>12 then Month:=0;
st:=DateString(Day,Month,Year);
if Month=0 then fillchar(st[1],length(st),' ');
if (YearSensitive in DateCompaction) or (DaySensitive in DateCompaction)
	then begin
	if Today.year=0 then with Today do begin GetTime(Hour,Minute,Sec,x); GetDate(Year,Month,Day,x); end;
	x:=7+length(Time);
	if (YearSensitive in DateCompaction) and (Year=Today.Year)
		then begin
				repeat dec(st[0]) until (st[length(st)] in [#0..'/']);
				st:=copy(copy(st,1,length(st)-1)+Time,1,x);
				end;
	if (DaySensitive in DateCompaction)
		then begin
			  if (Year=Today.Year) and (Month=Today.Month) and (Day=Today.Day)
				then if x<12 then st:=Time else st:='Today '+time;
			  end;
	 st:=copy(st+'              ',1,x);
	Time:='';
	end;
DateTimeString:=st+Time;
end;

function LookupMonth(st : string20) : byte;
var month : integer;
begin
val(st,month,error);
if error=0 then begin LookupMonth:=Month; exit; end;
st:=upcase(st[1])+upcase(st[2])+upcase(st[3]);
for month:=1 to 12 do
	 if st[1]=MonthName[month*3] then if (st[2]=MonthName[month*3+1]) and (st[3]=MonthName[month*3+2])
		 then begin LookUpMonth:=Month; exit; end;
LookupMonth:=0;
end;

function TimeNumber(var param) : longint;
var i,w    : word;
	 x      : record b : byte; l : longint end absolute param;
	 st     : string[22] absolute param;
	 j,k,n  : integer;
	 Date   : string[22];
	 T      : longint;
	 State  : (JustStarting,MightBeMonth,GotYear,GotMonth,GotDay,GotHour,GotMin,GotTime);

 procedure DoDigit; {within TimeNumber}
 begin
 with LDT do if state=JustStarting
  then begin
		 repeat Month:=Month*10+ord(st[i])-ord('0');
		   inc(i);
		   if i>length(st) then begin i:=255; exit; end;
		   until not (st[i] in ['0'..'9']);
		 state:=MightBeMonth;
		 if st[i]=':'
	  then begin state:=GotHour; Hour:=Month; Month:=0; end
	  else if (Month>31) or (DateFormat=JAPAN)
				 then begin Year:=Month; Month:=0; state:=GotYear; end
	   else if (Month>12) or (DateFormat>USA)
				  then begin Day:=Month; Month:=0; state:=GotDay; end;
		  end
   else begin
		  k:=0;
		  repeat k:=k*10 + ord(st[i])-ord('0');
		  inc(i);
		  until (i>length(st)) or not (st[i] in ['0'..'9']);
		  case state of
	   GotHour : begin Min:=k; state:=GotMin; end;
	   GotMin  : begin Sec:=k; state:=GotTime;end;
	   GotMonth: begin Year:=k; state:=GotYear; end;
	   else if st[i]=':'
				  then begin state:=GotHour; Hour:=k; end
				  else if (k>31) or (DateFormat=JAPAN) then begin Year:=k; state:=GotYear; end
				  else if (Hour=0) and (Day>0) and (Year>0)
							 then begin Hour:=k; State:=GotHour; end
							 else if (k>12) or ((DateFormat>USA) and (Day=0))
									 then begin Day:=byte(k);state:=GotDay; end
									 else begin Month:=byte(k); state:=GotMonth; end;
	   end { of case};
	 end;
 end {DoDigit};

 procedure GetPresentTime;
 begin
 with LDT do
      begin
      getDate(Year,Month,Day,w);
      getTime(Hour,Min,Sec,Sec100);
      end;
 PackTime(LDT,T);
 end;

 procedure DoLetter; {within TimeNumber}
 var key : string[3];
 begin
 with LDT do if (Month<>0) and (state in [GotMin,GotTime])
	   then begin
   	        case pos(upcase(st[i]),Monthname) of
		       2 : if hour<12 then inc(Hour,12); {Pm}
		       1 : if hour=12 then Hour:=0;      {Am}
		      end;
	        inc(i);
            exit;
	        end;
 key:=upcase(st[i])+upcase(st[i+1])+upcase(st[i+2]);
 if key='NOW' then
    begin GetPresentTime; inc(i,3); exit; end; {no language translation on "NOW" because program might set it}
 j:=pos(key,MonthName) div 3;
 with LDT do case j of
		 1..12 : if state=MightBeMonth
			  then begin Day:=Month; Month:=j; State:=GotMonth; end
			  else begin Month:=j; state:=GotMonth; end;
		  13..23: begin
			  GetDate(Year,Month,Day,w);
			  if j=23 then GetTime(Hour,Min,Sec,word(T));
			  PackTime(LDT,T);
			  { NOTE: THE FOLLOWING ASSUMES DAY IS IN THE SAME MONTH!}
			  if j<=19 {SUN..SAT}
			   then inc(T,(j-12-w)*65536)
			   else inc(T,65536*(j-21));
			  State:=GotYear;
			  UnpackTime(T,LDT);
			  end;
		  else begin
		  j:=pos(upcase(st[i]),copy(MonthName,1,2));
		  if j>0 then case state of
							  MightBeMonth: begin Hour:=Month; Month:=0; end;
							  end;
		  case j of
			  1 : if Hour=12 then Hour:=0;
			  2 : if Hour<12 then inc(Hour,12);
			 else DosError:=-j;
			  end;
		  state:=GotTime;
		  end;
		  end {of case of j};
 repeat inc(i) until (i>length(st)) or (st[i]<'A');
 end {DoLetter};

begin
DosError:=0;
if (x.l and $0FFFF)=0 then begin TimeNumber:=x.l; exit; end;
fillchar(LDT,sizeof(LDT),0);
i:=1; while (st[i]<='"') and (i<length(st)) do inc(i);
state:=JustStarting;
while (i<=length(st)) do with LDT do case st[i] of
	  '0'..'9' : DoDigit;
	  'A'..'Z','a'..'z' : DoLetter;
	  '+','-' : if state=JustStarting
	               then begin
                        GetPresentTime;
			            val(st,n,error);
			            repeat inc(i) until (i>length(st)) or not (st[i] in ['0'..'9','-','+']);
			            case upcase(st[i]) of
                             'M' : begin UnpackTime(T,LDT); inc(Min,n); end;
                             'S' : begin UnpackTime(T,LDT); inc(Sec,n); end;
                             'H' : begin UnpackTime(T,LDT); inc(Hour,n); end;
                             else begin inc(T,n*65536); UnpackTime(T,LDT); end;
                             end;
			            end
	               else inc(i);
	  else inc(i);
	  end;
with LDT do
 begin
 if Year=0
	 then if Month=0
		 then if Day=0 then GetDate(Year,Month,Day,w)
					 else GetDate(Year,Month,w,w)
		 else GetDate(Year,w,w,w);
 if Day=0 then Day:=1;
 if Month=0 then Month:=1;
 if Year<1900 then Year:=Year+1900;
 end;
PackTime(LDT,T);
TimeNumber:=T;
end;

function StringToTime(st : string) : longint;
begin
StringToTime:=TimeNumber(st);
end;

function StringToDate(st : string) : longint;
begin
StringToDate:=TimeNumber(st);
end;

function Decimal(x : real) : string20;
var l : longint; st : string20;
begin
if (abs(x)>2147e6) or (abs(x)<0.00001)
		then str(x,st)
		else str(x:20:7,st);
if x=0 then st:='0';
while (st[length(st)]='0') and (st<>'0') do dec(st[0]);
if st[length(st)]='.' then dec(st[0]);
while st[1]=' ' do delete(st,1,1);
if UseThousandsSeparator
	then with CountryInfo do
		  begin
		  if length(st)>3 then insert(ThousandsSeparator,st,length(st)-2);
		  if length(st)>7 then insert(ThousandsSeparator,st,length(st)-6);
		  end;
Decimal:=st;
end;

function StringToInteger(st : string) : longint;
label loop;
var n : longint; j : byte;
begin
n:=0;j:=0;
loop:
inc(j);
if j>length(st) then begin StringToInteger:=n; exit; end;
case upcase(st[j]) of
	 '0'..'9' : begin n:=n*10 + (ord(st[j]) and $0F); goto loop; end;
	 'A'..'F' : n:=StringToInteger('$'+st);
	 'H' : begin n:=StringToInteger('$'+copy(st,1,j-1)); exit; end;
	 '-' : if n>0 then n:=-n else n:=-StringToInteger(copy(st,j+1,99));
	  'X','x' : val('$'+copy(st,j+1,8),n,error);
	 '$' : val(copy(st,j,8),n,error);
	 '.' : {ignore fraction};
	  #9..' ' : if n=0 then goto loop;
		 end;
StringToInteger:=n;
end;

function DosErrorMessage(n : integer) : string50;
begin
case n of
	  0 : DosErrorMessage:='';
	  1 : DosErrorMessage:='Invalid DOS call';
	  2 : DosErrorMessage:='File not found';
	  3 : DosErrorMessage:='Invalid directory';
	  4 : DosErrorMessage:='Too many open files';
	  5 : DosErrorMessage:='File access denied';
	  6 : DosErrorMessage:='Invalid handle';
	  7 : DosErrorMessage:='Destroyed MCB';
	  8 : DosErrorMessage:='Not enough RAM';
	  9 : DosErrorMessage:='Invalid memory block';
	 10 : DosErrorMessage:='Invalid environment';
	 11 : DosErrorMessage:='Invalid format';
	 12 : DosErrorMessage:='Invalid access code';
	 13 : DosErrorMessage:='Invalid Data';
	 15 : DosErrorMessage:='Invalid drive';
	 16 : DosErrorMessage:='Directory in use';
	 17 : DosErrorMessage:='Not same device';
	 18 : DosErrorMessage:='No more files';
	 19,
	$96 : DosErrorMessage:='Write-protect';
	$14 : DosErrorMessage:='Bad unit ID';
	$15 : DosErrorMessage:='Not ready';
	$16 : DosErrorMessage:='Unknown command';
	$17 : DosErrorMessage:='Data error (CRC)';
	$18 : DosErrorMessage:='Bad structure';
	$19 : DosErrorMessage:='Disk seek error';
	$1A : DosErrorMessage:='non-DOS disk??';
	$1B,
	$9E : DosErrorMessage:='Sector not found';
$9F, $1C : DosErrorMessage:='Printer out of paper';
	$1D,112,
	$65 : DosErrorMessage:='Write fault (eg disk full)';
	$1E,
	$64 : DosErrorMessage:='Read error';
	$1F : DosErrorMessage:='General Failure';
	$20 : DosErrorMessage:='Sharing violation';
	$21 : DosErrorMessage:='Locked by another';
	$22 : DosErrorMessage:='Wrong diskette';
	$23 : DosErrorMessage:='No more FCB''s';
     36 : DosErrorMessage:='Sharing buffer exceeded';
     37 : DosErrorMessage:='Codepage mismatch';
	$32 : DosErrorMessage:='Not supported'; {network request not supported}
	$33 : DosErrorMessage:='Remote computer not listening';
	$34 : DosErrorMessage:='Duplicate name';
    $35..$3C,
	$40..$47,
	$58 : DosErrorMessage:='Network error 0x'+hex(n);
	$3D : DosErrorMessage:='Print queue full';
$49,$4A : DosErrorMessage:='SBCS error 0x'+hex(n);
	$4E : DosErrorMessage:='Redirected drive';
	$50 : DosErrorMessage:='File already exists';
    $51 : DosErrorMessage:='Dup FCB';
	$52 : DosErrorMessage:='Cannot make dir entry';
	$53 : DosErrorMessage:='Critical error';       {fail I24}
	$56 : DosErrorMessage:='Password protection';
	$57 : DosErrorMessage:='Invalid parameter';
64..$6A : DosErrorMessage:='Semaphore error 0x'+hex(n);
    270,
    $6B : DosErrorMessage:='Disk changed';
    $6C : DosErrorMessage:='Drive locked';
    $6D : DosErrorMessage:='Pipe collapsed';
    $6E : DosErrorMessage:='Open failed';
    $6F : DosErrorMessage:='Buffer overflow';
    113 : DosErrorMessage:='No more search handles';
    120 : DosErrorMessage:='Not implemented';
    125 : DosErrorMessage:='No volume label';
    {ERROR_NO_MORE_SEARCH_HANDLES   : constant := 113;
     ERROR_INVALID_TARGET_HANDLE    : constant := 114;
     ERROR_PROTECTION_VIOLATION     : constant := 115;
     ERROR_VIOKBD_REQUEST           : constant := 116;
     ERROR_INVALID_CATEGORY         : constant := 117;
     ERROR_INVALID_VERIFY_SWITCH    : constant := 118;
     ERROR_BAD_DRIVER_LEVEL         : constant := 119;
     ERROR_CALL_NOT_IMPLEMENTED     : constant := 120;
     ERROR_SEM_TIMEOUT              : constant := 121;
     ERROR_INSUFFICIENT_BUFFER      : constant := 122;
     ERROR_INVALID_NAME             : constant := 123;
     ERROR_INVALID_LEVEL            : constant := 124;
     ERROR_NO_VOLUME_LABEL          : constant := 125;
     ERROR_MOD_NOT_FOUND            : constant := 126;
     ERROR_PROC_NOT_FOUND           : constant := 127;
     ERROR_WAIT_NO_CHILDREN         : constant := 16#0080#;
     ERROR_CHILD_NOT_COMPLETE       : constant := 129;
     ERROR_DIRECT_ACCESS_HANDLE     : constant := 130;
    }
 $98,$A1:DosErrorMessage:='Device not ready';
	$9A : DosErrorMessage:='Read/verify CRC error';
	$A0 : DosErrorMessage:='Write fault';
	$A2 : DosErrorMessage:='Share or format problem';
    242 : DosErrorMessage:='Line too l-o-n-g !';
    243 : DosErrorMessage:='I''m as confused as you are!';
    244 : DosErrorMessage:='Nothing happens.';
    245 : DosErrorMessage:='*you can''t do that!*';
    246 : DosErrorMessage:='Oh yes I can!';
    247 : DosErrorMessage:='Oh no you can''t!';
    248 : DosErrorMessage:='Phase variance in the warp drive relay';
    249 : DosErrorMessage:='Ying tong iddley poo';
	else  DosErrorMessage:='DOS error: 0x'+hex(n);
	end {of case};
end;

type SortEntryPointer = ^SortEntryType;
     SortEntryType    = record EntrySize : byte; {*MUST* be first byte}
                               NextLevel : byte;
                               Line      : string;
                               end;
     SortBlockPointer = ^SortBlockType;
     SortBlockType = record LastEntryOffset : integer;
                            DataBytes : array[1..16383-sizeof(integer)] of byte;
                            end;
     SortBlockPointerArray = array[byte] of SortBlockPointer;

const SortBlockArray : ^SortBlockPointerArray = nil;
      LastSortBlockAllocated : integer = -1;

function GetSortBlock(n : integer)  : SortBlockPointer;
begin
if SortBlockArray=nil
   then begin
        new(SortBlockArray);
        fillchar(SortBlockArray,sizeof(SortBlockArray),0);
        end;
if SortBlockArray^[n]=nil
   then begin
        new(SortBlockArray^[n]);
        SortBlockArray^[n]^.LastEntryOffset:=0; {could be just filled with 2 bytes, but my debugger likes this}
        end;
GetSortBlock:=SortBlockArray^[n];
end;

{$F+}
function SimpleSort(st1,st2 : string) : boolean;
begin
SimpleSort:=st1>st2;
end;

type ComparisonFunction = function(st1,st2 : string) : boolean;

const Better : ^ComparisonFunction = @SimpleSort;
{$F-}

procedure AddToSort(st : string);
var ThisBlock,
    NewBlock  : SortBlockPointer;
    NewEntry  : SortEntryType;
    se : SortEntryPointer;
    ThisEntry,i,j,k : integer;

  procedure SplitBlock(where : integer);
  var i,j      : integer;
  begin
  inc(LastSortBlockAllocated);
  if LastSortBlockAllocated>255
     then begin ErrorMessage('Not enough RAM for sort!'); halt(99); end;
  NewBlock:=GetSortBlock(LastSortBlockAllocated);
  if NewBlock=nil
     then begin ErrorMessage('Not enough memory for sort'); OutputSortedList(0); SortOutput:=false; exit; end;
  move(ThisBlock^.Databytes,NewBlock^.Databytes,ThisEntry-1);
  i:=1;
  while (i<ThisEntry) do begin j:=i; inc(i,ThisBlock^.Databytes[i]); end;
  Newblock^.LastEntryOffset:=j;
  with ThisBlock^ do
       begin
       move(Databytes[ThisEntry],Databytes[1],(LastEntryOffset+Databytes[LastEntryOffset])+1-ThisEntry);
       LastEntryOffset:=1;
       ThisEntry:=1;
       SortEntryPointer(@Databytes[ThisEntry])^.NextLevel:=LastSortBlockAllocated;
       end;
  end;

  procedure TryToAddAtLevel(n : byte);
  begin
  ThisBlock:=GetSortBlock(n);
  with ThisBlock^ do
       begin
       ThisEntry:=1;
       while (ThisEntry<=LastEntryOffset) do with SortEntryPointer(@Databytes[ThisEntry])^
             do begin
                if not SimpleSort(st,Line)
                   then begin
                        if NextLevel>0
                           then TryToAddAtLevel(NextLevel)
                           else begin {add within the block, if there is space}
                                if NewEntry.EntrySize+LastEntryOffset+Databytes[LastEntryOffset]>sizeof(Databytes)
                                   then begin {nope, wasn't enough space}
                                        SplitBlock(ThisEntry); move(NewEntry,NewBlock^.Databytes,NewEntry.EntrySize);
                                        end
                                   else begin
                                        move(Databytes[ThisEntry],DataBytes[ThisEntry+NewEntry.EntrySize],
                                             LastEntryOffset+Databytes[LastEntryOffset]-ThisEntry);
                                        move(NewEntry,Databytes[ThisEntry],NewEntry.EntrySize);
                                        inc(LastEntryOffset,NewEntry.EntrySize);
                                        end;
                                end;
                        exit;
                        end;
                inc(ThisEntry,EntrySize);
                end;
       {add at end of the block, if there is space}
       if NewEntry.EntrySize+LastEntryOffset+Databytes[LastEntryOffset]>sizeof(Databytes)
          then begin {nope, wasn't enough space}
               i:=1;  (* NEEDS WORK HERE - What if they are all linked off to other levels?? *)
               repeat inc(i,Databytes[i]) until i>(sizeof(Databytes) div 2);
               j:=ThisEntry;
               SplitBlock(ThisEntry); move(NewEntry,NewBlock^.Databytes,NewEntry.EntrySize);
               end
          else begin
               LastEntryOffset:=ThisEntry;
               move(NewEntry,Databytes[ThisEntry],NewEntry.EntrySize);
               end;
       end;
end;

begin
with NewEntry do
     begin
     EntrySize:=sizeof(EntrySize)+sizeof(NextLevel)+1+length(st);
     NextLevel:=0;
     Line:=st;
     end;
TryToAddAtLevel(0);
end;

procedure OutputSortedList(ThisBlockNumber : integer);
var i,j,k : integer; st : string;
    ThisEntry     : integer;
    ThisBlock     : SortBlockPointer;
begin
ThisBlock:=GetSortBlock(ThisBlockNumber);
with ThisBlock^ do
     begin
     ThisEntry:=1;
     while ThisEntry<=LastEntryOffset
        do with SortEntryPointer(@Databytes[ThisEntry])^ do
           begin
           if NextLevel<>0
              then begin
                   i:=NextLevel;
                   OutputSortedList(NextLevel);
                   if NextLevel<>i
                      then begin ThisBlock:=GetSortBlock(ThisBlockNumber); end;
                   end;
           OutputLine(copy(Line,StartOfSortLine,255));
           inc(ThisEntry,EntrySize);
           end;
     end;
end;

procedure FinishOff;
var st2 : string[40];
begin
if SortOutput then begin
                   OutputSortedList(0);
                   SortOutput:=false;
                   end;
if (Columns>1) and (ColumnCounter>1)
	then begin Columns:=1; OutputLine(''); end;
if TotalMsg<>'' then OutputLine(TotalMsg);
if ListToPrinter
	then begin
	if FormFeedMode then writeln(PRN,FormFeed);
	if TextRec(PRN).handle>StandardPrinterHandle then close(PRN);
	end
{$IFOPT G-}
	else if (ParentName='KERNEL') or (ParentName='VIEWMAX') then pause
{$ENDIF};
SetCBreak(OriginalBreakFlag);
end;

function GetGlobalSpec(target : string) : string;
var
	 i,j  : byte;
begin
i:=pos(target,globals);
GetGlobalSpec:='';
if i=0 then exit;
ThisGlobal:=copy(Globals,i+1,254);
i:=0;
repeat inc(i);
		 if (ThisGlobal[i]='"')
	  then repeat inc(i) until (i>=length(ThisGlobal)) or (ThisGlobal[i]='"');
		 until (i>length(ThisGlobal)) or (ThisGlobal[i]=SwitchChar);
ThisGlobal[0]:=char(i-1);
if Target[2]<>'"'
	then begin
	j:=1;
	repeat inc(j);
			 if j>length(ThisGlobal) then exit;
			 until (ThisGlobal[j] in ['=',':']);
	ThisGlobal:=copy(ThisGlobal,j+1,254);
	end;
if (ThisGlobal[length(ThisGlobal)]='"') and (ThisGlobal[1]='"') and (length(ThisGlobal)>1)
	then GetGlobalSpec:=copy(ThisGlobal,2,length(ThisGlobal)-2)
	else GetGlobalSpec:=ThisGlobal;
end;

function ColourToInteger(ColSpec : string) : integer;
const ColourName : array[black..7] of string[7] =
      ('BLACK','BLUE','GREEN','CYAN','RED','MAGENTA','BROWN','WHITE');
var ThisColour,c : integer;
begin
ThisColour:=StringToInteger(ColSpec);
if (ThisColour>0) or (pos(ColSpec,'$00x00')>0)
   then begin ColourToInteger:=ThisColour; exit; end
   else ConvertToCapitals(ColSpec);
ThisColour:=-99;
for c:=black to 7 do if pos(copy(ColourName[c],1,3),ColSpec)>0 then ThisColour:=c;
if ThisColour<0 then for c:=black to 7
   do if pos(copy(Translate(ColourName[c]),1,3),ColSpec)>0 then ThisColour:=c;
if (pos('LIG',ColSpec)>0) or (pos('BRI',ColSpec)>0) or (pos(copy(Translate('BRIGHT'),1,4),ColSpec)>0)
   then inc(ThisColour,8);
if ThisColour>=0
   then begin
        if ThisColour=7 then ThisColour:=White;
        end
   else begin
        if (pos('YEL',ColSpec)>0) or (pos(copy(Translate('YELLOW'),1,4),ColSpec)>0)
           then ThisColour:=Yellow
           else if (pos('GRA',ColSpec)>0) or (pos('GREY',ColSpec)>0) or (pos(copy(Translate('GRAY'),1,3),ColSpec)>0)
                   then begin
                        if (pos('DARK',ColSpec)>0) or (pos(copy(Translate('DARKGRAY'),1,4),ColSpec)>0)
                           then ThisColour:=DarkGray
                           else ThisColour:=LightGray;
                        end
                   else ThisColour:=White;
        end;
ColourToInteger:=ThisColour and $FF;
end;

Function ANSIColorStr(color, back_color: Byte): String22;
   { Returns a ANSI color sequence (currently maximal length is 11 chars). }
   Type
    String4 = String[4];
   Const
    ANSINorm     = '0';
    ANSIHigh     = '1;';
    ANSIBlack    = '30';
    ANSIRed      = '31';
    ANSIGreen    = '32';
    ANSIBrown    = '33';
    ANSIBlue     = '34';
    ANSIMagenta  = '35';
    ANSICyan     = '36';
    ANSIWhite    = '37';
    ANSIBlackH   = '40';
    ANSIRedH     = '41';
    ANSIGreenH   = '42';
    ANSIBrownH   = '43';
    ANSIBlueH    = '44';
    ANSIMagentaH = '45';
    ANSICyanH    = '46';
    ANSIWhiteH   = '47';
    ANSICols     : Array [0..15] Of String4 =
                   (ANSIBlack, ANSIBlue, ANSIGreen, ANSICyan,
                    ANSIRed, ANSIMagenta, ANSIBrown, ANSIWhite,
                    ANSIHigh+ANSIBlack, ANSIHigh+ANSIBlue,
                    ANSIHigh+ANSIGreen, ANSIHigh+ANSICyan,
                    ANSIHigh+ANSIRed, ANSIHigh+ANSIMagenta,
                    ANSIHigh+ANSIBrown, ANSIHigh+ANSIWhite);
    ANSIColsH    : Array [0..15] Of String4 =
                   (ANSIBlackH, ANSIBlueH, ANSIGreenH, ANSICyanH,
                    ANSIRedH, ANSIMagentaH, ANSIBrownH, ANSIWhiteH,
                    ANSIHigh+ANSIBlackH, ANSIHigh+ANSIBlueH,
                    ANSIHigh+ANSIGreenH, ANSIHigh+ANSICyanH,
                    ANSIHigh+ANSIRedH, ANSIHigh+ANSIMagentaH,
                    ANSIHigh+ANSIBrownH, ANSIHigh+ANSIWhiteH);
   Begin
    If (color In [0..15]) Then
     ANSIColorStr:=Concat(ANSINorm,';',ANSICols[color],';',ANSIColsH[back_color])
    Else        { length: 1         2  3456             7  8901 = 11 }
     ANSIColorStr:=ANSINorm;
   End; {ANSIColorStr}

procedure TextColor(c : byte);
begin
if ANSIinstalled
   then begin
        write(#27'[',AnsiColorStr(c and 15,c shr 4),'m');
        end;
end;

procedure GetDir(drive : integer; var dir : string);
var buffer : record First256 : array[0..255] of char; Last5 : array[256..260] of char; end;
begin
with reg do begin
				AX:=$7147; DX:=drive; DS:=seg(buffer); SI:=ofs(buffer);
				fillchar(buffer,sizeof(buffer),0);
				msdos(reg);
				if not odd(Flags)
					then begin
                    dir:=chr(64+drive)+':\'+trim0(buffer);
                    end;
				end;
system.GetDir(drive,dir);
end;

function Trim0(var stuff) : string;
var st : array[1..255] of char absolute stuff;
begin
trim0:=copy(st,1,byte(pos(#0,st)-1));
end;

function FileExists(fn : string80) : boolean;
var attr : word; reg : registers; S : searchrec;
begin
if (length(fn)=0)
   then begin FileExists:=false; exit; end;
FindFirst(fn,AnyFile,S);
FileExists:=(DOSERROR=0);
{fn:=fn+#0;
with reg do
     begin
     AX:=$4300; DS:=seg(fn[1]); DX:=ofs(fn[1]); MsDos(reg);
     FileExists:=not odd(Flags);
     end;
}
end;

function hex(w : word) : string4; {returns 2 or 4 characters}
begin
if w<256 then hex:=hex2(w) else hex:=copy(hex4(w),5,4);
end;

function hex2(b : byte) : string;  {returns 2 hex characters (nibbles; BCD), for a byte}
begin
hex2:=digit[b shr 4]+digit[b and $0F];
end;

function hex4(n : longint) : string;   {returns 8 hex characters for given 4-byte number}
var   i     : byte;
      st    : string[8];
begin
st:='00000000';
for i:=1 to length(st) do st[i]:=digit[(n shr ((length(st)*4)-4*i)) and $0F];
hex4:=st;
end;

function HexToNumber(st : string) : longint;
var i : byte;
    n : longint;
begin
n:=0;
for i:=1 to length(st) do
    case st[i] of
       '0'..'9' : n:=n*16 + (ord(st[i]) and $0F);
       'A'..'f' : n:=n*16 + (ord(st[i]) and $0F) +9;
    ' ','$','X' : {skip over blanks};
 	  else    begin HexToNumber:=n; exit; end;
 	  end;
HexToNumber:=n;
end;

function KeyPressed: Boolean;
var reg : registers;
begin
with reg do
     begin
     AX:=$0B00; MsDos(reg);  KeyPressed:=AL<>0;
     end;
end;

function sign(number : integer) : integer;
begin
if number<0
   then sign:=-1
   else if number=0 then sign:=0 else sign:=+1;
end;


function Match(st1,st2 : string) : boolean;
var i,j,k : byte;
begin
i:=0;
Match:=false;
for j:=1 to length(st2) do
    begin
    inc(i);
    if st2[j]='*'
       then begin
 	    repeat inc(j);
  		   if (j>length(st2)) or ((st2[j]='.') and (j+1=length(st2)) and (st2[j+1]='*') and (pos('.',st1)>i))
  		      then begin Match:=true; exit; end;
  		   until st2[j]<>'*';
 	    if i>length(st1)
 	       then begin
 	            if (st2[j]='.') and (pos('.',st1)=0)
  		       then st1:=st1+'.' {treat dirname. like dirname}
  		       else exit;
 	            end;
 	    repeat if (st1[i]=st2[j]) or (st2[j] in ['*','?','['])
  		      then if Match(copy(st1,i,255),copy(st2,j,255))
  		              then begin Match:=true; exit; end;
  		   inc(i);
  		   until i>length(st1);
 	    exit;	{no match}
 	    end;
    if i>length(st1)
       then if (st2[j]='.') and (pos('.',st1)=0)
 	       then st1:=st1+'.' {treat dirname. like dirname}
 	       else exit;
    if st1[i]<>st2[j]
       then if st2[j]<>'?'
 	       then begin
 	            if st2[j]='['
 	               then begin
 	                    k:=j;
 	                    repeat inc(k);
 	                           if k>length(st2) then exit;
 	                           until (st2[k]=']');
 	                    for j:=j+1 to k-1 do
 	                        if (st2[j]=st1[i]) or ((st2[j]='-') and (st2[j-1]<st1[i]) and (st2[j+1]>st1[i]))
 	                           then Match:=match(copy(st1,i+1,255),copy(st2,k+1,255))
 	                    end;
 	            exit;
 	            end;
    end;
Match:=(i>=length(st1));
end;

function Max(x,y : longint) : longint;
begin
if y>x then Max:=y else Max:=x
end;

function min(x,y : longint) : longint;
begin
if y<x then min:=y else min:=x
end;

function MouseButton : word;
var reg : registers;
begin
case MousePresent of
   XTmouse : with reg do begin
	          AX:=3; BX:=0;CX:=0;DX:=0;
	          intr($33,reg);
	          MouseButton:=BX;
	          MouseX:=CX; MouseY:=DX;
	          end;
   ATmouse : with reg do begin
	          AX:=$C206; BX:=0;
	          intr($15,reg);
	          MouseButton:=BL and $0F;
	          end;
     else MouseButton:=0;
     end {of case};
end;

procedure NoSound;
begin
if lo(MachineID)<$FA then begin write(^G); exit; end;
inline($B0/$B6/	{mov al,B6 }
       $FA/    	{cli       }
       $E6/$43/	{out 43,al }
       $E4/$61/	{in  al,61 }
       $24/$FE/	{and al,FE }
       $E6/$61/	{out 61,al }
       $FB     	{sti       }
		 );
end;

procedure UpdateAllFiles(WhichPSP : word);
const Stuff : array[0..10] of word = (0,0,0,0,0,0,0,0,0,0,0);
var   reg   : registers;
begin
with reg do begin
            if WhichPSP=0 then WhichPSP:=PrefixSeg;
            AX:=$5D01; Stuff[9]:=0 {this computer}; Stuff[10]:=WhichPSP;
            DS:=seg(stuff); DX:=ofs(stuff);
            msdos(reg);
            AX:=$5D09; msdos(reg);
            AX:=$6800; BX:=TextRec(PRN).handle; msdos(reg);
            end;
end;

const AccumulatedStrings : string =''; {used by OutputString & OutputLine}

procedure TestForNewPage; {for OutputLine}
begin
inc(LineCounter);  {$I-}{$B-}
Idle;   {intr $28 to give TSR's a shot}
if ListToPrinter then writeln(PRN) else WriteToStandardFile(StandardOutputHandle,^M^J);
if boolean(PauseInterval) and (LineCounter>=PauseInterval)
  then begin
   if ListToPrinter
 	  then if FormFeedMode
              then write(PRN,^M^J+FormFeed)
	          else if copy(TextRec(PRN).name,1,3)='LPT'
                      then write(PRN,^M^J^J^J^J^J);
   if IORESULT<>0 then;
   LineCounter:=1; {$I+}
   Pause;
   end;
ColumnCounter:=0;
end;

procedure OutputLine(st : string);
var   i,j,t : integer;
    Line  : ^LineRecord;

begin
{$I+}
if IORESULT<>0 then (* fix later *);
if Columns>1 then
   begin
   t:=length(st); {$R+}{$S+}
   if (pos(#27'[',st)>0)
         then begin
              if not AnsiInstalled then;
              for i:=1 to length(st)-3 do if (st[i]=#27) and (st[i+1]='[')
                  then begin
                       j:=i+1;
                       repeat inc(j) until (st[j] in ['A'..'z']) or (j>=length(st));
                       dec(t,1+j-i);
                       end;
              end;
   i:=pred(PageWidth) div Columns;
   if t<i
      then repeat st:=st+' '; inc(t); until t>=i
      else if not WrapMode
         	   then begin st[0]:=char(i); st[i]:=' '; end
 	           else while (st[length(st)]=' ') and (t>i) do dec(st[0]);
               {if (st[length(st)]<>' ') and (length(st)<>i) then st:=st+' '}
   if ListToPrinter
      then write(PRN,st)
      else WriteToStandardFile(StandardOutputHandle,st);
   inc(ColumnCounter,t);
   if ColumnCounter>PageWidth-i
      then TestForNewPage;
   exit;
   end;
OutputString(st);
TestForNewPage;
end;

procedure OutputString(st : string);
var i,n,p : byte;
begin
if (Columns>1)
   then begin AccumulatedStrings:=AccumulatedStrings+st; inc(ColumnCounter,length(st)); exit; end;
i:=1;
while i<length(st) do
      begin
      while st[i]=^I
 	    do begin st[i]:=' '; while (i mod 8)<>0 do begin insert(' ',st,i); inc(i); end; end;
      if st[i]=^M then ColumnCounter:=1
  		  else if st[i]<>^J
                  then inc(ColumnCounter)
                  else inc(LineCounter);
      if (ColumnCounter>PageWidth) and WrapMode
 	 then begin
 	      while (i>0) and (st[i]>' ') do dec(i);
 	      if i<ColumnCounter div 2
 	         then begin i:=PageWidth-1; insert('-'^M^J,st,i); end
 	         else insert(^M^J,st,i);
 	      ColumnCounter:=1;
 	      end;
      inc(i);
      end;
if ListToPrinter
   then begin
	{$I-} write(PRN,st); {$I+}
	ExitCode:=IORESULT;
	if ExitCode=152 then begin Pause; write(PRN,st); LineCounter:=1; end;
	end
   else WriteToStandardFile(StandardOutputHandle,st);
end;

function pad(st : string; WhatSize : integer) : string;
begin
if length(st)<WhatSize
   then begin fillchar(st[length(st)+1],WhatSize-length(st),' ');st[0]:=char(WhatSize);end;
pad:=st;
end;

procedure CancelProgram;
begin
writeln(' ^CANCEL '^I^I'  ');
halt(9);
end;

procedure Pause;
var st : string[9];
begin
if IORESULT<>0 then (* fix later *);
if ListToPrinter
      then Flush(PRN)
      else flush(output);
write(' --Ready? ['+YesStr[2]+']--');
UpdateAllFiles(0);
repeat idle until keypressed;
write(^M,' ':40,^M);
PauseResponse:=readkey;
{Hmmm, must use Dos call for this}
case upcase(PauseResponse) of
  ^C,#27,'Q' : CancelProgram;
       #0 : case readkey of
 	     #83,#79,#68 : CancelProgram;
 	             #80 :LineCounter:=PauseInterval;
 	             end;
      else if upcase(PauseResponse)=N_key then CancelProgram;
      end;
end;

function LastSlash(st : string) : byte;
var p : byte;
begin
p:=pos('{',st);
if p=0 then p:=length(St);
while p>0 do
      begin
      dec(p);
      if st[p] in ['\','/'] then begin LastSlash:=p; exit; end;
      end;
p:=pos(':',st);
while (p<length(st)) and (st[p]=' ') do dec(p);
LastSlash:=p;
end;

function ReadKey: Char;
begin
Idle;
reg.AX:=$0800;
MsDos(reg); {Read a key, wait for input, allow ^C}
ReadKey:=char(reg.AL);
end;

procedure Sound(freq : real);
var period : word;

begin
if lo(MachineID)<$FA
   then begin write(^G); exit; end;
if freq=0.0 then freq:=440.0      	{default frequency is 440 Hz (A above middle C)}
   else if freq<18.2 then freq:=18.2	{lowest freq is divisor of 65535, i.e. 18.2Hz}
   else if freq>455000.0 then freq:=15000; {don't want to generate RF interference, do we?}
{$R-}
period:=round(1193180.0 / freq);
{$R-}
inline(	$B0/$B6/	{  mov al,B6 }
 	$FA/    	{  cli       }
 	$E6/$43/	{  out 43,al }
 	$8B/$86/period/	{  mov ax,freq[BP]}
 	$E6/$42/	{  out 42,al }
 	$8A/$C4/	{  mov al,ah }
 	$E6/$42/	{  out 42,al }
 	$E4/$61/	{  in  al,61 }
 	$0C/$03/	{  or  al,3  }
 	$E6/$61/	{  out 61,al }
 	$FB     	{  sti       }
       );
end;

{$V-}
function StringToReal(st : string) : real;
var x : real; i : longint;
begin
StringToReal:=-1;
while (st<>'') and (st[1]<'!') do delete(st,1,1);
while (st[length(st)] in [#9..' ',',']) do dec(st[0]);
if st='' then exit;
if st[1]='$' then begin val(st,i,error); StringToReal:=i; end
   else if pos('.',st)>0 then begin val(st,x,error); StringToReal:=x; end
   else begin
 	for i:=1 to length(st) do st[i]:=upcase(st[i]);
 	error:=0;
 	case st[1] of
	    '0': if (st[2]='X') then begin st[1]:='$'; st[2]:='0'; val(st,i,error); StringToReal:=i; end;
 	    '': StringToReal:=pi;
 	    '': begin val(copy(st,2,99),x,error); StringToReal:=sqrt(x); end;
 	    '': StringToReal:=9.999e37;
 	   else begin val(st,x,error); StringToReal:=x; end;
	   end;
 	end;
end;
{$V-}

function Truncate(st : string) : string;
begin
Truncate:=copy(st,1,pred(pos(#0,st)));
end;

procedure TurnOnMouseCursor;
const idiot : boolean = true;
var reg : registers;
begin
if (MousePresent=NoMouse) and idiot then
	begin Idiot:=false; CheckForMouse; end;
with reg do case MousePresent of
	  XTMouse: begin AX:=1;BX:=0;CX:=0;DX:=0; intr($33,reg); end;
	  ATmouse: begin AH:=$C2; AL:=01; intr($15,reg); end; {reset it}
	  end;
end;

procedure TurnOffMouseCursor;
var reg : registers;
begin
with reg do case MousePresent of
	  XTMouse: begin AX:=2;BX:=0;CX:=0;DX:=0; intr($33,reg); end;
	  ATmouse: begin AH:=$C2; AL:=00; intr($15,reg); end; (* ok?*)
	  end;
end;

function GetEnv(st : string) : string;
begin
GetEnv:=DOS.GetEnv(st);
end;

procedure WarnErr(var st : string; Class : ErrorActionType);
begin
if (Class=Ignore) or (pos('W',NoOptions)>0) then exit;
if Class<=Warning
   then begin
 	    WriteToStandardFile(StandardErrorHandle,^I' --> WARNING: '+st+^M^J);
 	    if ListToPrinter and (ExitCode=0)
	       then writeln(PRN,' --> WARNING: '+st);
 	    end
   else if Class<>Abort then
           begin
 	       WriteToStandardFile(StandardErrorHandle,^I' ==> ERROR: '^G+st+^M^J);
 	       if ListToPrinter and (ExitCode=0) then writeln(PRN,' --> ERROR: '+st);
 	       end;
{put logging to SYSLOGD in here some day!!!}
if ExitCode=0 then ExitCode:=max(1,DosError);
if Class=Panic
   then begin writeln('PRESS RESET!'); inline($EB/$FE); end;
if Class>=NormalError then halt(ExitCode);
end;

procedure WarningMessage(st : string);
begin
WarnErr(st,Class2);
end;

procedure ErrorMessage(st : string);
begin
WarnErr(st,Class1);
end;

function ExpandIndirect(st,target : string) : string;
var fyle : text;
begin
assign(fyle,st);{$I-}
reset(fyle);
repeat readln(fyle,st); until (target='') or match(st,'*'+target+'*') or eof(fyle);
close(fyle);
{$I+}
ExpandIndirect:=st;
if IORESULT<>0 then;
end;

function ExpandCommand(st : string) : string;
var o,p: byte; Dir,Name,fn : string; Ext : ExtStr;
begin
fn:=copy(st,pos(' ',st),255);
while (fn<>'') and (fn[1]=' ') do delete(fn,1,1);
o:=pos(' ',fn);
case upcase(st[1]) of
     'F' : begin
	   Fsplit(fn,Dir,Name,Ext); fillchar(S,36,0);
	   FindFirst(fn,AnyFile-VolumeID,S); st[0]:=#0;
	   case st[5] of
{FILESIZE}      'S': st:=Decimal(S.Size);
{FULL/FILENAME} 'N': if st[2]='U' then st:=Fexpand(fn) else st:=Name;
{FILETIME}      'T': st:=TimeString(S.Time);
{FILEEXT}       'E': st:=Ext;
{FULLPATH}      'P': st:=Fexpand(dir);
{FILEATTR}      'A': str(S.Attr:2,st);
{FINDALL}      else while DOSERROR=0 do begin st:=st+dir+S.Name+' '; FindNext(S); end;
	       end;
	   end;
     'A' : st:=decimal(ord(fn[1])); {ASC}
     'E' : begin st:=''; for o:=1 to length(fn) do st:=st+fn[o]+' '; end;{EXPLODE}
     'V' : begin {Volumeid}
	   S.Name:=''; FindFirst('\*.*',VolumeID,S); st:=S.Name;
           p:=pos('.',st); if p>0 then delete(st,p,1);
	   end;
     'C' : GetDir(0,st);  {CWD}
     'G' : st:=ExpandIndirect(copy(fn,o+1,99),copy(fn,1,o-1)); {GREP}
     'R' : begin randomize; if fn<'0' then fn:='1000'; str(random(StringToInteger(fn)):4,st); end;
     'I' : begin
	   st:=copy(st,pos(' ',st),255);
	   for o:=length(st) downto 1 do if st[o]=' ' then delete(st,o,1); {IMPLODE}
	   end;
     'T' : begin st:=TimeString(StringToTime(fn)); p:=pos(' 0:00:00',st); if p>0 then st[0]:=chr(p-1); end;
	  'W' : st:=FExpand(FSearch(fn,'.;'+GetEnv('PATH')+';\;C:\')); {WHEREIS}
 '0'..'9': for o:=StringtoInteger(st) downto 1 do
			 begin st:=copy(fn,1,byte(pos(' ',fn)-1)); delete(fn,1,1+length(st)); end;
	  end;
ExpandCommand:=st;
end;

procedure ExpandSpecial(var command : string);
var i,j : integer; st : string;
begin
for i:=length(command)-1 downto 1 do if (command[i]='[')
    then begin
	 st:=capitals(copy(command,i+2,255));
	 j:=lo(pos(']',st)-1);
	 st:=copy(st,1,j); j:=length(st)+3;
	 while st[length(st)]=' ' do dec(st[0]);
	 case command[i+1] of
	      '!' : st:=ExpandCommand(st);
	      '$' : st:=GetEnv(st);
	      '@' : st:=ExpandIndirect(st,'');
			'?' : begin write(st+'?'); readln(st); end;
	      end;
	 delete(command,i,j);
	 insert(st,command,i);
	 end;
end;

function GetProgName(segment : word) : NameStr;
var st : string; p  : ^char;
	 pofs : word absolute p;
	 SB : ^StorageBlock;
begin
SB:=ptr(segment-1,0);
st:=SB^.OwnerName;
if (length(st) in [1..8]) and (st[1] in ['!'..'z'])
	then begin
	     while (st[length(st)]=#0) and (st<>'') do dec(st[0]);
	     end
   else begin
        p:=ptr(PSP(ptr(segment,0)^).EnvironmentSegment,0);
        if seg(p^)>8
           then begin GetProgName:=''; exit; end;
        repeat while p^<>#0 do inc(pofs);
		         inc(pofs);
		         until p^=#0;
        inc(pofs,2);
        repeat inc(pofs); inc(st[0]); st[length(st)]:=p^; until (p^=#0) or (length(st)>88);
        end;
trim(st);
GetProgName:=st;
end;

procedure GotoXY(X,Y : byte);
begin
if ANSIinstalled
   then if (X or Y)=1 then write(CSI,'H') else write(CSI,Y,';',X,'H')
   else SetCursorXY(X+256*Y-$0101);
end;

procedure ClrScr;
begin
if ANSIinstalled
   then write(#27'[H'#27'[J')
   else BIOS_ClrScr(OriginalTextAttr);
end;

function ParentName : NameStr;
begin
ParentName:=getProgName(PSP(ptr(PrefixSeg,0)^).Parent);
end;

function TryToString(st : string) : string80;
var i : byte;
begin
for i:=length(st) downto 1 do
    case st[i] of
	 #0 : if i>3 then st[0]:=char(i) else st[i]:=' ';
     #1..' ',#127..#255: if st[i-1]<=' ' then delete(st,i,1) else st[i]:=' ';
	 end;
while (st<>'') and (st[length(st)] in [#0..' ']) do dec(st[0]);
while (st<>'') and (st[1] in [#0..' ',#127,#255]) do delete(st,1,1);
TryToString:=st;
end;

function YesNo(b : boolean) : string;
var st : string22;
begin
if (b) then st:=copy(YesStr,2,22)
       else st:=copy(NoStr,2,22);
YesNo:=copy(st,1,byte(pos(' ',st)-1));
end;

function BiosError(AH : byte) : string;
var st : string[33];
begin
case AH of
  $31,$80 : st:='Time-out (no disk in drive)';
	 $53 : st:='Virus detected by ScanBoot';
	 $40 : st:='Seek failure';
	 $20 : st:='General controller failure';
	 $10 : st:='Checksum error';
	 $0C : st:='Unsupported disk format';
	 $09 : st:='DMA boundary Error';
	 $08 : st:='DMA overrun Error';
	 $06 : st:='Disk changed';
	 $04 : st:='Sector not found';
	 $03 : st:='WRITE-PROTECTED DISK!';
	 $02 : st:='Bad Address Mark';
	 $01 : st:='Invalid controller command';
	  else st:='BIOS error: '+hex(AH) ;
	 end {of case};
BiosError:=st;
end;

procedure WriteToStandardFile(Handle : word; st : string);
begin
with reg do begin
		 AH:=$40; BX:=handle; CX:=length(st);
		 DS:=seg(st); DX:=ofs(st[1]);
		 MsDos(reg);
		 if odd(Flags) then DosError:=AX else DosError:=0;
		 end;
end;

procedure CursorOff;
begin
if OldCursor=0
	then OldCursor:=GetCursorType;
SetCursorType($2020);
end;

procedure CursorOn;
begin
if (OldCursor and $0F0F)=0 then case CurrentVideoMode of
	0..6 : OldCursor:=$0608;
	 $11..$12 : OldCursor:=$890F;
	 else OldCursor:=$010F;
	 end;
SetCursorType(OldCursor);
end;

function CmosRam(adr : byte ): byte;
begin
if CmosPort=$70
	then begin {AT or PS/2 CMOS}
		  inline($FA);        { cli        ;DisableInterrupts }
		  Port[CmosPort]:=adr;{ out 70h,adr                   }
		  inline($EB/$00);    { jmp $+0                       }
		  CmosRam:=Port[$71]; { in  CmosRam,71h               }
		  inline($FB);        { sti        ;EnableInterrupts  }
		  end
	else begin
		  if odd(CmosPort)
		then CmosRam:=Port[CmosPort+1024*adr]
		else CmosRam:=Port[CmosPort+adr];
		  end;
end;

procedure SetCmosRam(adr,NewContents : byte );
var i : byte; C: word;
begin
if CmosPort=$70
	then begin {AT or PS/2 CMOS}
		  inline($FA);            { cli        ;DisableInterrupts }
		  Port[$70]:=adr;         { out 70h,adr                   }
		  Port[$71]:=NewContents; { out 71h,NewContents           }
		  inline($FB);            { sti        ;EnableInterrupts  }
		  if (adr in [$10..$2D])
		then begin
			  C:=0;
			  for i:=$10 to $2D do inc(C,CmosRam(i));
			  SetCmosRam($2E,hi(C)); SetCmosRam($2F,lo(C));
			  end;
		  end
	else begin
		  if odd(CmosPort) then C:=CmosPort+1024*adr else C:=CmosPort+adr;
		  Port[C]:=NewContents;
		  if NewContents<>Port[C] then {worry};
		  end;
end;

function ChooseColour(fn : string): byte;
var c : byte; ext : string[5];
begin
ext:=Capitals(copy(fn,pos('.',fn),4));
ext:=' '+copy(ext,2,3)+' ';
for c:=black to white do
    if pos(ext,ColorCode[c]^)>0
       then begin ChooseColour:=c; exit; end;
ChooseColour:=OriginalTextAttr;
end;

function TextPos(var TF) : longint;
begin
with TextRec(TF) do TextPos:=BufPos{+FilePos(file(TF))};
end;

procedure UpdateFile(var fyle);
var handle : word absolute fyle;
begin
reg.AH:=$68; reg.BX:=handle; msdos(reg);
end;

procedure WriteMsg(var Msg : string; XY : word; attr : word);
var i : byte;
begin
SetCursorXY(XY);
for i:=1 to length(Msg) do WriteCharacter(Msg[i],attr);
end;

procedure GetCountryInfo(var Dest; Country : word);
var CI : CountryInfoType absolute Dest;
    ExtendedCI : record InfoID        : byte;
                        ECIsize,ID,CP : word;
                        ThisCI        : CountryInfoType;
                        end;
begin
country:=64;
with reg do
   begin
   AX:=$6501; BX:=$FFFF; DX:=Country; ES:=seg(ExtendedCI); DI:=ofs(ExtendedCI); CX:=sizeof(ExtendedCI);
   if Country=0 then DX:=BX;
   msdos(reg);
   if not odd(Flags) then with ExtendedCI do
      begin
      move(ThisCI,CI,sizeof(CI));
      CodePage:=CP;
      CountryID:=ID;
      exit;
      end;
   end;
inline( $B8/$3800/       { MOV   AX,3800h    }
		  $8B/$5E/<Country/{ MOV   BX,Country[BP]}
		  $0B/$DB/         { OR    BX,BX       }
		  $74/02/          { JZ    $+2         }
		  $B0/$FF/         { MOV   AL,0FFh     }
		  $C5/$56/<Dest/   { LDS   DX,Dest[BP] }
		  $CD/$21);        { INT   21h         }
end;

procedure RestoreScreen;
var p : SavedScreenPointerType;
begin
p:=SavedScreen;
if SavedScreen<>nil then with p^ do
     begin
     move(SavedScreenDataPointer^,ScreenPointer^,SavedSize);
     SetCursorXY(SaveCursorXY);
     SavedScreen:=PreviousPointer;
     if p<>NIL then FreeMem(p,sizeof(SavedScreen^)+SavedSize);
     p:=NIL;
     end;
end;

procedure SaveScreen;
var
    OldScreenSavePointer    : SavedScreenPointerType;
    ScreenSize              : word;
begin
if ofs(ScreenPointer^)<>0
   then case GetVideoMode of
	               7 : ScreenPointer:=ptr($B000,0000);
	  18,13,14,15,16 : ScreenPointer:=ptr($A000,0000);
	             else  ScreenPointer:=ptr($B800,0000);
                     end;
ScreenSize:=ScreenWidth*ScreenRows*2;
OldScreenSavePointer:=SavedScreen;
GetMem(SavedScreen,sizeof(SavedScreen^)+ScreenSize);
with SavedScreen^ do
     begin
     SavedSize:=ScreenSize; PreviousPointer:=OldScreenSavePointer;
     SavedScreenDataPointer:=addr(SavedScreen^); inc(word(SavedScreenDataPointer),sizeof(SavedScreen^));
     move(ScreenPointer^,SavedScreenDataPointer^,SavedSize);
     SaveCursorXY:=GetCursorXY;
     end;
end;

procedure CheckForMouse;
begin
if (IVect[$33]=nil) or (byte(IVect[33]^)=IRET)
	then MousePresent:=Nomouse
	else with reg do begin {initialise XT mouse via interrupt $33}
					AX:=0;BX:=0;CX:=0;DX:=0; intr($33,reg);
					if AX<>0 then MousePresent:=XTmouse;
					end;
with reg do begin
			AH:=$C2; {AT/PS2 pointing device subcommand of int 15}
			AL:=$00; BH:=1; {enable pointing device}
			intr($15,reg);
			if AH=0 then MousePresent:=ATmouse;
			end;
end;

function Translate(st : string): string;
begin
{???}
Translate:=st;
end;

function DrwxAttrName(fn : string;attr : longint) : string;
var b : byte;
	st : string[30];
   executable : char;
begin
if pos(copy(fn,pos('.',fn),4),'.BAT.EXE.COM')>0
   then executable:='x'
   else executable:='-';
if boolean(attr and ReadOnly) then st:='r-'+executable else st:='rw'+executable;
if boolean(attr and $80) then st[3]:='n';
if boolean(attr and SysFile) then st[3]:='s' else if boolean(attr and Hidden) then st[3]:='h';
if (DRDOS in Security) and ((attr shr 8)=0)
	then with reg do begin
	                 DS:=seg(fn[1]); DX:=ofs(fn[1]); fn:=fn+#0;
                     AX:=$4302; CX:=0; MsDos(reg);
					 if odd(Flags) then Security:=Security-[DRDOS];
                     end
    else reg.CX:=(attr shr 8);
with reg do if CX<>0 then
     begin
     st:=st+'drwxdrwxd';
     {st:=st+'drw'+executable+'drw'+executable+'d';}
	 if odd(CX) then st[4]:='-';
	 if boolean(CX and 4) then st[2]:='-';
	 if boolean(CX and 8) then st[1]:='-';
	 if (st[1]='-') and not boolean(CX and 2)
        then st[3]:='e'
		else if (st[3]='-') and ((CX and 2)=0) then st[3]:=executable;
	 for b:=4 to 11 do
		if odd(CX shr b)
           then st[(b and 12)+4-(b and 3)]:='-';
	 end;
if boolean(attr and Directory) then DrwxAttrName:='d'+st
	else if boolean(attr and Archive) then DrwxAttrName:='_'+st
	else DrwxAttrName:='-'+st;
end;

function Dos_ReadSector(Drive : word; StartSector : longint; HowMany : word; var Where) : boolean ;
const NumberOfFloppyDiskDrives : byte = 2;
var Result : byte;
    BootSector : DOS_Bootsector absolute where;
    Packet : record SectorNumber : longint;
                    NumberToRead : word;
                    TransferAddr : pointer;
                    end;
    PackPointer : pointer;
begin
Dos_ReadSector:=true;
intr($11,reg);
with reg do if odd(AX) then NumberOfFloppyDiskDrives:=succ((AX shr 6) and 3)
                       else NumberOfFloppyDiskDrives:=0;
{A:=0, B:=1, etc}
if drive<max(2,NumberOfFloppyDiskDrives)
   then with reg do begin
                    AH:=2; AL:=HowMany;
                    CH:=0;
                    CL:=1+StartSector;
                    DX:=Drive; {DH=head=0}
                    ES:=seg(where); BX:=ofs(where);
                    if true then intr($40,reg)
                            else intr($13,reg);
                    if odd(flags) and (ah=6)
                       then begin AH:=2; AL:=HowMany; intr($13,reg); end;
                    result:=flags and 1;
                    end
   else begin
        inline(
  $55/$16/$1E/         { PUSH BP,SS,DS  }
  $8B/$8E/HowMany/     { MOV CX,HowMany[BP]}
  $8B/$86/Drive/       { MOV AX,Drive[BP] }
  $8B/$96/StartSector/ { MOV DX,StartSector[BP]}
  $C5/$9E/Where/       { LDS BX,Where[BP] }
  $CD/$25/             { INT 25h ; read DOS absolute sectors}
  $1F/                 { POP DS  ; because flags pushed}
  $1F/$17/$5D/         { POP DS,SS,BP}
  $73/$02/             { JNC .+2}
  $0C/$01/             { OR AL,1}
  $88/$86/Result);     { MOV Result[BP],AL}
        if (Result>1) or (BootSector.BPB.BytesPerSector<128) or (StartSector>=$FFFF) then
           begin
           with Packet do
             begin
             SectorNumber:=StartSector;
             NumberToRead:=HowMany;
             TransferAddr:=@where;
             end;
           HowMany:=$FFFF;
           PackPointer:=@Packet;
           inline(
             $55/$16/$1E/         { PUSH BP,SS,DS  }
             $8B/$8E/HowMany/     { MOV CX,HowMany[BP]}
             $8B/$86/Drive/       { MOV AX,Drive[BP] }
             $8B/$96/StartSector/ { MOV DX,StartSector[BP]}
             $C5/$9E/PackPointer/ { LDS BX,Where[BP] }
             $CD/$25/             { INT 25h ; read DOS absolute sectors}
             $1F/                 { POP DS  ; because flags pushed}
             $1F/$17/$5D/         { POP DS,SS,BP}
             $88/$86/Result);     { MOV Dos_WriteSector[BP],AL}
           DosError:=Result;
           Dos_ReadSector:=(DosError=0);
           end;
        end;
end;

function AttrName(n : longint) : string;
const Wot : array[1..3] of string[9]=('World','Group','Owner');
var i,j : byte; st : string;
begin
st:='';
if boolean(n and SysFile) then st:=st+'S';
if boolean(n and Directory) then st:=st+'<DIR>';
if boolean(n and VolumeID) then st:=st+'<VOL>';
if boolean(n and Hidden) then st:=st+'H';
if boolean(n and ReadOnly) then st:=st+'R';
if boolean(n and Archive) then st:=st+'A';
if boolean(n and $40) then st:=st+'4';
if n<$100
   then begin AttrName:=st; exit; end;
for i:=1 to 3 do
    begin
    st:=st+','+Wot[i]+':';
    if (n and $800)>0 then st:=st+'-' else st:=st+'r';
    if (n and $200)>0 then st:=st+'-' else st:=st+'x';
    if (n and $400)>0 then st:=st+'-' else st:=st+'w';
    if (n and $100)>0 then st:=st+'-' else st:=st+'d';
    n:=n shr 4;
    end;
st[1]:='[';
AttrName:=st+']';
end;

function OpenAndRead(filename : string) : boolean;
var tempfile : file;
	 DiskError,i,k : integer; EndPart : array[0..1024] of char;
begin
ZipDescription:='';
if FileBuffer=nil then
   begin
	BufferSize:=min(MaxAvail-222,30*1024);
   GetMem(FileBuffer,BufferSize);
   end;
fillchar(FileBuffer^,BufferSize,0);
OpenAndRead:=false;
assign(tempfile,filename);
filemode:=$40; {ReadOnly, non-exclusive}
{$I-} reset(TempFile,1);
DosError:=IOresult;
if (DosError=5)
   then with reg,FileRec(TempFile) do
        begin
        Filename[length(FileName)+1]:=#0;
        DS:=seg(filename[1]); DX:=ofs(FileName[1]);
        AH:=$3D; AL:=0; MsDos(reg);
        mode:=fmInput; RecSize:=1;
		  OpenAndRead:=not odd(Flags);
        if odd(Flags) then exit;
        Handle:=AX;
        DosError:=0;
		  BX:=AX;
        AH:=$3F;
        DS:=seg(FileBuffer^); DX:=ofs(FileBuffer^); CX:=BufferSize;
        MsDos(reg);
        AH:=$3E; BX:=Handle; MsDos(reg);
        exit;
        end;
if DosError=0
	 then begin
			{$I-} blockread(tempfile,FileBuffer^,BufferSize,BytesRead);
         DosError:=IORESULT;
         OpenAndRead:=true;
         if pos('.ZIP',filename)>0
            then begin
					  seek(tempfile,FileSize(TempFile)-sizeof(EndPart));
                 blockread(tempfile,EndPart,sizeof(EndPart),k);
                 i:=k-1;
                 while (i>0) and (EndPart[i]<>#0) do dec(i);
                 ZipDescription[0]:=chr(min(80,k-i-1));
                 if i>=0 then
						  move(EndPart[i],ZipDescription[1],length(ZipDescription));
                 end;
         end;
close(TempFile);
if IOresult<>0 then ;
{$I+}
end;

function OpenFile(var FileInfo : FileInfoPacket) : boolean;
begin
with reg,FileInfo do
     begin
     assign(fyle,directory+trim0(LFN));
     {$I-}
     reset(fyle,1);
     if IORESULT<>0
        then begin OpenFile:=false; exit; end;
     end;
OpenFile:=true;
end;

procedure ProcessFormat(Format : string);
var i,j,k,f,x : word;
begin
if Today.year=0 then with Today do
   begin GetTime(Hour,Min,Sec,x); GetDate(Year,Month,Day,x); end;
f:=0;
i:=1;
while i<length(Format) do
      if Format[i]=' '
         then inc(i)
         else begin
              inc(f);
              fillchar(FormatDefinition[f],sizeof(FormatDefinition[f]),0);
              with FormatDefinition[f] do
                   begin
                   startAt:=i;
                   FieldType:=upcase(Format[i]);
                   if (Format[i] in ['a'..'z']) or (Format[i+1]=chr(ord(Format[i])+32))
                      then Options:=UseLowercase
                      else Options:=0;
                   j:=i;
                   repeat inc(j);
                          if (Format[j] in ['!'..'/',':'..'?']) and (pos(Format[j],Delimiter)=0)
                             then Delimiter:=Delimiter+Format[j];
                          until (j>length(Format)) or not (Format[j] in ['!'..'/',':'..'?',FieldType,LoCase(FieldType)]);
                   width:=j-i;
                   st:=Capitals(copy(Format,i,width));
                   Colour:=OriginalTextAttr;
                   case FieldType of
                        'F','N',
                        'E','P' : begin
                                  if not UseLFN then Options:=Options or UseShortForm;
                                  if delimiter[1]=':' then Options:=Options or UseBriefPath;
                                  end;
                        'I'     : Info_Required:=true;
                        'S'     : RightJustify:=true;
                        'Y'     : begin RightJustify:=true; Ratio_Required:=true; end;
                        'C'     : begin RightJustify:=true; Checksum_Required:=true; end;
                        'O','G',
                        'U'     : begin Perms_Required:=Perms_Required+[FieldType]; RightJustify:=false; end;
                        'M'     : begin
                                  Options:=(Options or Use4DigitYear+ConditionalYear) and not DayFirst;
                                  Delimiter:=' :';
                                  FieldType:='D';
                                  end;
                        'D','L' : begin
                                  case DateFormat of
                                       USA : {USA; default};
                                       EUROPE : Options:=Options+DayFirst;
                                       JAPAN : Options:=Options+YearFirst;
                                       end;
                                  if Delimiter='' then Delimiter:=CountryInfo.DateSeparator;
                                  case width of
                                       1..4 : Options:=(Options and UseLowercase) + DayFirst;
                                        5,8 : Options:=Options or (UseNumericMonth);
                                        6,7 : Options:=Options or (UseToday);
                                          9 : ;
                                         10 : Options:=Options or (UseNumericMonth+Use4digitYear);
                                         11 : Options:=Options or (Use4digitYear);
                                        else  begin
                                              if pos('T',Capitals(Format))=0
                                                 then begin
                                                      Options:=Options or (Use4DigitYear+ConditionalYear);
                                                      width:=width-7;
                                                      inc(f);
                                                      fillchar(FormatDefinition[f],sizeof(FormatDefinition[f]),0);
                                                      with CountryInfo,FormatDefinition[f] do
                                                           begin
                                                           FieldType:='T'; Width:=6;
                                                           StartAt:=i+FormatDefinition[f-1].width+1;
                                                           if TwentyFourHourClock then Options:=Use24hourClock else Options:=0;
                                                           Delimiter:=TimeSeparator;
                                                           end;
                                                      end;
                                              end;
                                        end { of case width};
                                  end { of 'D','L'};
                        'T' : with CountryInfo do
                                   begin
                                   if Delimiter='' then Delimiter:=TimeSeparator;
                                   if (width in [5,8]) or TwentyFourHourClock
                                      then Options:=Options+Use24hourClock;
                                   end;
                        end {of case fieldtype};
                   i:=j;
                   end { with format...};
              end { else begin};
FieldsInFormat:=f;
end;

function List_Size(Width,Options : byte; Delimiter : string4; Filesize : comp) : string;
var st : string;
begin
str(FileSize:3:0,st);
if Delimiter>#0 then begin
                     i:=length(st)-2;
                     while (i>1) and (length(st)<width)
                      do begin insert(Delimiter,st,i); dec(i,3); end;
                     end;
List_Size:=st;
end;

function DiskFree(Drive : byte) : comp;
begin
DiskFree:=DOS.DiskFree(Drive);
end;

procedure ListFile(FileInfo : FileInfoPacket);
var DT       : DateTime;
  i,j,k,
  width2,
  width      : integer;
  Line       : string;
  st         : string;
  YYYY       : string4;
  Key,
  DateString,
  SizeString : string[80];  {actually size and date sometimes}
  LFN : array[0..261] of char;
  LFNstring : string absolute LFN;

  function List_Filename(width,options : byte; SFN,LFN : string) : string;
  begin
  if boolean(Options and UseShortForm)
     then begin
          if SFN<>''
             then if boolean(Options and UseLowerCase)
                     then LFN:=LowerCase(SFN)
                     else LFN:=SFN;
          end
     else if SFN='' then if boolean(Options and UseLowerCase)
                    then LFN:=LowerCase(LFN);
  if boolean(Options and UseLowercase)
     then if LFN=SFN then LFN:=LowerCase(LFN); {??}
  if boolean(Options and UseBriefPath)
     then if (FileInfo.Directory[2]=':') and (LFN[2]<>':')
             then LFN:=copy(FileInfo.Directory,1,2)+LFN
             else LFN:=chr(96+CurrentDrive)+':'+LFN
     else if RecurseOption
             then LFN:=FileInfo.Directory+LFN;
  List_Filename:=LFN;
  end;

  function NamePart(st : string) : string;
  var i,j : integer;
  begin
  i:=length(st); j:=i+1;
  while (i>0) and not (st[i] in ['/','\',':']) do
        begin
        if st[i]='.' then j:=i;
        dec(i);
        end;
  NamePart:=copy(st,i+1,j-i-1);
  end;

  function ExtPart(st : string) : string;
  var i,j : integer;
  begin
  i:=length(st); j:=i+1;
  while (i>0) and not (st[i] in ['/','\',':']) do
        begin
        if st[i]='.' then j:=i;
        dec(i);
        end;
  ExtPart:=copy(st,j,99);
  end;

  function List_Date(Width,Options : byte; Delimiter : string4; ThisDate : longint) : string;
  var YYYY,st : string80;
  begin
  with DT do
       begin
       UnpackTime(ThisDate,DT);
       if Month>13 then Month:=0;
       if (Options and UseNumericMonth)=0
                      then begin
                           st:=MMM[Month];
                           if boolean(Options and UseLowerCase)
                              then st:=st[1]+LowerCase(copy(st,2,99));
                           Translate(st);
                           end
                      else st:=dd(Month);
       if boolean(Options and DayFirst)
                    then st:=dd(day)+Delimiter[1]+st
                    else st:=st+Delimiter[1]+dd(day);
       if boolean(Options and UseToday) and (Day=Today.Day) and (Month=Today.Month) and (Year=Today.Year)
                    then begin
                         st:='Today';
                         Translate(st);
                         if (Options and UseLowerCase)=0 then ConvertToCapitals(st);
                         end
                    else if boolean(Options and ConditionalYear) and (Year=Today.Year)
                            then st:=st+' '+dd(Hour)+Delimiter[2]+dd(Min) {insert time instead of year}
                            else begin
                                 str(1900+(Year mod 1900):4,YYYY);
                                 if (Options and Use4DigitYear)=0 then delete(YYYY,1,2);
                                 if boolean(Options and YearFirst)
                                    then st:=YYYY+Delimiter[1]+st
                                    else if boolean(Options and ConditionalYear)
                                            then st:=st+'  '+YYYY
                                            else st:=st+Delimiter[1]+YYYY;
                                 end;
       if Month=0 then fillchar(st[1],length(st),' ');
       List_Date:=copy(st+'   ',1,width);
       end;
  end;

  function List_UnixPermissions(Width,Options : byte; Delimiter : string4; Attributes,Permissions : word) :string80;
  var st : string;
  begin
  with FileInfo do st:=DrwxAttrName(directory+Shortname,Attributes);
  if (width>=10) and (length(st)<10)
      then st:=st+copy(st,2,3)+copy(st,2,3);
  List_Unixpermissions:=st;
  end;

  function List_Attributes(Width,Options : byte; Delimiter : string4; Attributes,Permissions : word) :string80;
  var i : integer; st : string;
  begin
  Delimiter:=Delimiter+' ';
  fillchar(st[1],width,Delimiter[1]); st[0]:=chr(min(6,width));
  (*
  for i:=0 to 7 do if odd(Attributes shr i)
      then st[i+1]:=BitInitial[i][1];
  *)
  if boolean(Attributes and Readonly) then st[1]:='r';
  if boolean(Attributes and SysFile ) then st[2]:='s';
  if boolean(Attributes and Archive ) then st[3]:='a';
  if boolean(Attributes and Hidden  ) then st[5]:='h';
  if boolean(Attributes and DOS.Directory)
     then if Compatibility[1] in ['D','N','O']
             then st:='DIRECTORY'
             else st[4]:='d';
  List_Attributes:=st;
  end;

  function List_Time(Width,Options : byte; Delimiter : string4; Time : word) :string80;
  var st : string; DT : DateTime;
  begin
  with DT do
       begin
       UnpackTime(Time,DT);
       if boolean(Options and Use24hourClock)
          then begin
               if Hour>12 then st:=dd(Hour-12)
                          else st:=dd(Hour);
               st:=st+delimiter[1]+dd(min);
               if Hour>=12 then st:=st+Monthname[2]
                           else st:=st+Monthname[1];
               if boolean(Options and UseLowerCase)
                  then st:=LowerCase(st);
               end
          else st:=dd(Hour)+Delimiter[1]+dd(Min);
       if length(st)+3<=width then insert(Delimiter[1]+dd(Sec),st,6);
       end;
  if st[1]='0' then st[1]:=' ';
  List_Time:=copy(st,1,width);
  end;

begin {procedure ListFile}
fillchar(Line,sizeof(Line),' '); Line:='';
with FileInfo do
   begin
   for f:=1 to FieldsInFormat do with FormatDefinition[f] do
      begin
      case FieldType of
           'F' : st:=List_Filename(width,options,trim0(ShortName),trim0(LFN));
           'S' : if boolean(Attributes and DOS.Directory)
                    then if ((Options and ConvertDirSize)<>0)
                            then begin st:='<dir>'; if (Options and UseLowercase)=0 then ConvertToCapitals(st); end
                            else st:=''
                    else st:=List_Size(Width,Options,Delimiter,FileSize);
           'D' : st:=List_Date(Width,Options,Delimiter,LastWrite.TimeDate);
           'P' : st:=Directory;
           'I' : st:=Info^;
           'V' : st:=Version^;
           'C' : st:=Checksum^;
           'Y' : if PhysicalSize=0 then st:=''
                                   else st:=decimal(round(FileSize*100/PhysicalSize))+'%';
           'L' : st:=List_Date(Width,Options,Delimiter,LastAccess.TimeDate);
           'O' : if UID=0 then st:='root ' else st:=decimal(UID); {Owner}
           'G' : if GID=0 then st:='  ' else st:=decimal(GID);
           'U' : st:=List_Unixpermissions(Width,Options,Delimiter,Attributes,Permissions);
           'A' : st:=List_Attributes(Width,Options,Delimiter,Attributes,Permissions);
           'T' : st:=List_Time(Width,Options,Delimiter,LastWrite.Timedate);
           'M' : st:=List_Time(Width,Options,Delimiter,LastWrite.Timedate);
           'N' : st:=NamePart(List_Filename(Width,Options,trim0(Shortname),trim0(LFN)));
           'E' : st:=ExtPart(List_Filename(Width,Options,trim0(Shortname),trim0(LFN)));
           else st:=FieldType;
      	   end;
      if length(Line)+1<StartAt
         then Line[0]:=char(StartAt-1);
      if length(st)>=width
         then begin
              if (length(st)>width) and (st[length(st)] in ['0'..'9','A'..'z']) then st:=st+' ';
              end
         else if RightJustify then repeat insert(' ',st,1) until length(st)>=width;
      if length(Line)>StartAt
         then while (st[1]=' ') and (length(st)>=max(0,width+StartAt-length(Line)))
              do delete(st,1,1);
      Line:=Line+st+' ';
      end;
   if UseColour
      then Line:=#27'['+AnsiColorStr(Highlight and 15,Highlight shr 4)+'m'+Line+#27'[m';
   if SortOutput
      then begin
           fillchar(key,16,0);
           for i:=1 to length(SortOptions) do
               begin
               case SortOptions[i] of
                'F' : begin st:=Directory+Trim0(LFN); st[1]:=upcase(st[1]); end; {just first letter}
                'N' : begin move(ShortName,st[1],14); st[1]:=upcase(st[1]); end; {just first letter}
                'E','X' : st:=capitals(copy(ShortName,pos('.',ShortName),4))+#0;
                'D','T' : st:=nnnn(LastWrite.TimeDate);
                'S'     : st:=nnnn(longint(FileSize));
                end;
               key:=key+st;
               end;
           key[0]:=chr(StartOfSortLine-1);
           AddToSort(key+Line);
           end
      else OutputLine(Line);
   if boolean(Attributes and DOS.directory)
      then inc(TotalDirs)
      else inc(TotalFiles);
   inc(TotalSize,FileSize);
   TotalSpace:=TotalSpace+PhysicalSize;
   end;
end;

function nnnn(n : longint) : string4;
var bbbb : array[1..4] of char absolute n;
begin
nnnn:=bbbb[4]+bbbb[3]+bbbb[2]+bbbb[1];
end;

function GetParameter(var st : string) : boolean;
begin
inc(Present_GetParameter_state);
if Present_GetParameter_state>LastParameter
	then begin GetParameter:=false; exit; end
	else GetParameter:=true;
st:=Parameter[Present_GetParameter_state]^;

end;

function CMatch(st1,st2 : string) : boolean;
begin
ConvertToCapitals(st1);
ConvertToCapitals(st2);
CMatch:=match(st1,st2);
end;

type RecursionListPointer = ^RecursionListRecord;
     RecursionListRecord = record Next : RecursionListPointer;
                                  Dir  : string;
                                  end;
const MaxIndirect = 5;
      Nesting   : 0..MaxIndirect = 0;
var
     IndirectRecord : array[1..MaxIndirect] of
                    record IndirectSize, IndirectOffset : word;
                           IndirectList   : pchar;
                           end;

const RecursionList : RecursionListPointer = nil;

function GetFile(var FileInfo : fileInfoPacket) : boolean;
const ThisParam : integer = 0;
      ThisMatch : string80 = '*';
      LFNhandle : word = 0;
label Sneaky;
const S         : SearchRec = ();
var st,ThisWildSpec: string;
    Old            : RecursionListPointer;
    WildMatch     : boolean;
begin
fillchar(FileInfo,sizeof(FileInfo),0);
if Present_GetFile_state=NotStarted
   then begin
        Nesting:=0; ThisParam:=FirstInList;
        Present_GetFile_State:=1;
        end;
GetFile:=true;
with reg,FileInfo do case Present_GetFile_State of
     1 : begin {need to get a parameter string}
         if ThisParam<=ParametersInList
            then st:=Parameter[ThisParam]^
            else begin GetFile:=false; exit; end;
         inc(ThisParam);
         if (copy(st,1,1)='@') and not FileExists(st) and OpenAndRead(copy(st,2,255))
                    then begin
                         Present_GetFile_State:=4;
                         if Nesting<5 then inc(Nesting)
                                      else ErrorMessage('indirect nesting level loop? '+st);
                         with IndirectRecord[nesting] do
                              begin
                              IndirectOffset:=0;
                              IndirectSize:=BytesRead;
                              getmem(IndirectList,BytesRead);
                              move(FileBuffer^,IndirectList^,BytesRead);
                              freemem(FileBuffer,BufferSize);
                              end;
                         GetFile:=GetFile(FileInfo);
                         exit;
                         end;
         Directory:=st;
         while (Directory<>'') and not (Directory[length(Directory)] in ['\','/',':']) do dec(Directory[0]);
     Sneaky:
         ThisDir:=Directory;
         if copy(ThisDir,2,1)=':' then CurrentDrive:=ord(upcase(ThisDir[1]))-64
                                  else CurrentDrive:=ord(upcase(CurrentDir[1]))-64;
         move(st[1],LFN,length(st)); LFN[length(st)]:=#0;
         st:=copy(st,length(Directory)+1,255);
         ThisMatch:=st;
         WildMatch:=ContainsWildCards(st);
         AX:=$714E;
			CL:=AllowableAttributes;
			CH:=RequiredAttributes;
         SI:=1; {old MSDOS-style date/time format}
         DS:=seg(LFN); DX:=ofs(LFN);
         ES:=seg(FileInfo); DI:=ofs(FileInfo);
         msdos(reg);
         if (AH<>$71) and not odd(Flags)
            then begin
                 if WildMatch
                    then Present_GetFile_State:=2
                    else if boolean(Attributes and DOS.Directory) and ListDirContents
                            then begin
                                 Present_GetFile_State:=7;
                                 LongName:=LongName;
                                 end;
                 LFNhandle:=AX;
                 UnicodeFlags:=CX;
                 if Shortname[1]=#0 then move(LFN,Shortname,sizeof(ShortName));
                 exit;
                 end
            else begin
                 if RequiredAttributes<>0
                    then Attributes:=RequiredAttributes
                    else Attributes:=(AllowableAttributes and AnyFile);
                 if WildMatch then if pos('.',st)=0 then st:=st+'.*';
			     FindFirst(Directory+st,byte(Attributes),S);
                 while DOSERROR=0
                    do begin
                         Attributes:=S.Attr;
                         if WildMatch
                            then Present_GetFile_state:=3
                            else if boolean(Attributes and DOS.Directory) and ListDirContents
                                    then begin
                                         Present_GetFile_state:=7;
                                         end;
                         FileSize:=S.Size;
                         move(S.Name[1],Shortname[1],14);
                         Shortname[length(s.name)+1]:=#0;
                         move(Shortname,LFN,14);
                         CreationDate.TimeDate:=S.Time;
                         LastWrite.TimeDate:=S.Time;
                         if CMatch(S.Name,ThisMatch)
                            then exit;
                         FindNext(S);
                         end;
                 if WildMatch
                    then begin
                         if boolean(Verbosity and 8) then WarningMessage('No files match: '+st);
                         end
                    else if (FilesNeedNotExist in GetFileMode) or FileExists(Directory+st)
                            then begin {could be win95's bug with devices}
                                 p:=pos('.',st);
                                 if p>9 then st:=copy(st,1,8)+'.'+copy(st,p+1,3)+#0;
                                 st:=Capitals(st)+#0'       ';
                                 move(st[1],ShortName,14);
                                 Attributes:=0; Reserved:='NOTFOUND';
                                 exit;
                                 end;
                 if nesting>0
                    then Present_GetFile_state:=4
                    else Present_GetFile_state:=1;
                 GetFile:=GetFile(FileInfo);
                 exit;
                 end;
            end {case of 1};
     2 : begin {in LFN findfirst/next}
         AX:=$714F; BX:=LFNhandle; SI:=1;
			CL:=AllowableAttributes;
			CH:=RequiredAttributes;
         ES:=seg(FileInfo); DI:=ofs(FileInfo);
         Directory:=ThisDir;
         msdos(reg);
         if (AH=$71) or odd(Flags)
            then begin
                 if nesting>0
                    then Present_GetFile_state:=4
                    else Present_GetFile_state:=1;
                 AX:=$71A1; msdos(reg);
                 if RecursionList<>nil
                    then Present_GetFile_State:=5;
                 GetFile:=GetFile(FileInfo);
                 end
            else begin
                 st:=ThisDir+Trim0(LFN);
                 if Shortname[1]=#0 then move(LFN,Shortname,sizeof(ShortName));
                 if boolean(Attributes and DOS.Directory) and RecurseOption and (Shortname[1]<>'.')
                    then begin
                         Old:=RecursionList;
                         getmem(RecursionList,6+length(st));
                         with RecursionList^ do begin Next:=Old; Dir:=st; end;
                         end;
                 end;
         end;
     3 : begin {in SFN findfirst/next}
         FindNext(S);
         Directory:=ThisDir;
         while DOSERROR=0
               do begin
                  st:=ThisDir+S.Name+#0;
                  move(S.Name[1],Shortname[1],14);
                  Shortname[length(s.name)+1]:=#0;
                  move(Shortname,LFN,14);
                  CreationDate.TimeDate:=S.Time;
                  LastWrite.TimeDate:=S.Time;
                  Filesize:=S.size;
                  Attributes:=S.Attr;
                 if boolean(S.Attr and DOS.Directory) and RecurseOption and (Shortname[1]<>'.')
                    then begin
                         Old:=RecursionList;
                         getmem(RecursionList,6+length(st));
                         with RecursionList^ do begin Next:=Old; Dir:=trim0(st[1]); end;
                         end;
                  if (S.Attr=15) and (S.Name[1]<' ')
                     then {do something with long name??}
                     else if Cmatch(S.Name,ThisMatch)
                             then exit;
                  FindNext(S);
                  end;
         if nesting>0
            then Present_GetFile_state:=4
            else Present_GetFile_state:=1;
         if RecursionList<>nil
            then Present_GetFile_State:=6;
         GetFile:=GetFile(FileInfo);
         end;
     4 : begin {in indirect file lookup}
         with IndirectRecord[nesting],FileInfo do
              begin
              st:='';
              while (IndirectOffset<IndirectSize) and (IndirectList^[IndirectOffset] in [#0..' ',',',';'])
                    do inc(IndirectOffset);
              while (IndirectOffset<IndirectSize) and not (IndirectList^[IndirectOffset] in [#0..' ',',',';'])
                    do begin st:=st+IndirectList^[IndirectOffset]; inc(IndirectOffset); end;
              if st=''
                 then begin
                      dec(nesting);
                      if nesting=0 then Present_GetFile_State:=1;
                      GetFile:=GetFile(FileInfo);
                      exit;
                      end;
              Directory:=st;
              repeat dec(Directory[0]) until Directory[length(Directory)] in [#0,'\','/',':'];
              goto Sneaky
              end;
         end;
    5,6: begin {subdir search}
         Directory:=RecursionList^.Dir+'\';
         st:=Directory+'*';
         RecursionList:=RecursionList^.Next;
         goto Sneaky;
         end;
    else begin
         Directory:=ThisDir+ThisMatch+'\';
         st:=Directory+'*';
         goto Sneaky;
         end;
     end;
end;

type
    LinkedListPointer = ^LinkedList;
    LinkedList = record Next : LinkedListPointer;
                        Parameter : string;
                        end;
(*
const MaxSeq = 23;
var
    sequence : array[1..MaxSeq] of record SyntacticName : string80;
                                      FirstParam    : integer;
                                      Given         : LinkedListPointer;
                                      StartBrackets,
                                      EndBrackets   : byte;
                                      PossibleSuccessors : set of 0..MaxSeq;
                                      end;
*)

function LookupAttribute(c : char) : integer;
begin
LookupAttribute:=1 shl pred(pos(c,'RHSVDA'));
end;

procedure ProcessAttributes(st : string);
  var i,j,k : integer; c,mode: char;
  begin
  mode:=':';
  for i:=1 to length(st) do
      begin
      c:=upcase(st[i]);
      case c of
           '+','-','=' : mode:=st[i];
           'A','D','H','R','S',
           'V' : case mode of
                     '-' : AllowableAttributes:=AllowableAttributes-LookupAttribute(st[i]);
                     '+' : RequiredAttributes:=RequiredAttributes+LookupAttribute(st[i]);
                     else  begin
                           Attributes:=Attributes+LookupAttribute(st[i]);
                           RequiredAttributes:=Attributes; AllowableAttributes:=Attributes;
                           end;
                     end;
           end;
      end;
  end;

procedure AppendParameter(st : string);
var i,j : byte;
begin
inc(ParametersInList);
getmem(Parameter[ParametersInList],1+length(st));
Parameter[ParametersInList]^:=st;
end;

function Parse(version,copyright,author,ValidOptions,Syntax,Purpose : string) : boolean;
const NeedToExplain : set of (n_attr,n_sort) = [];
var i,j,k,seq : integer;
    LongCmd   : array[0..1024] of char;
    CheckForMinus : boolean;

  procedure fixup(var st : string);
  begin
  st:=copy(st,pos('=',st)+1,99);
  trim(st);
  end;

  procedure ShowEnv(e,value : string);
  begin
  OutputString(' '+e+'='+value+',');
  end;

  function Pretty(st : string) : string;
  begin
  Translate(st);
  if AnsiInstalled then Pretty:=#27'[1;34m'+st+#27'[m'
                   else Pretty:=st;
  end;

  procedure SetTextAttr(row,col,ta : byte);
  begin
  ScreenPointer^[row,col].textattr:=ta;
  end;

  procedure ExplainWhatItDoes;
  const ErrorActionName : array[Default..Panic] of string[6] =
        ('Default','Ignore','Warn','Error','Abort','Reboot');
  var st,examples : string; blanks : string80; i,j,k,b : integer;
      opt : string[6];
  begin
  fixup(version);
  fixup(copyright);
  fixup(author);
  fillchar(blanks,80,' ');
  case Compatibility[1] of
       'D':st:=' R';
       else st:=' v';
       end;
  st:=' '+ProgName+st+Version;
  i:=pos('{',purpose);
  if i=0 then Examples:=''
         else begin
              Examples:=copy(Purpose,i+1,255);
              delete(Purpose,i,255);
              end;
  st:=st+copy(blanks,1,+77-length(st)-length(Purpose))+Purpose+' ';
  Copyright:=Copyright+' by '+author;
  insert(copy(blanks,1,(79-length(Copyright))shr 1),Copyright,1);
  if RedirectedOutput
     then begin
          WriteToStandardFile(StandardOutputHandle,st+^M^J^M^J
                         +Copyright+^M^J^M^J);
          end
     else if AnsiInstalled {$IFOPT G+} or true {$ENDIF}
             then begin
                  WriteToStandardFile(StandardOutputHandle,#27'[0m'#27'[H'#27'[2J'#27'[7m'^M+st+^M^J+
                     ^J#27'[0;36m'^M+Copyright+^M^J^J#27'[0m'^M);
                  end
             else begin
                  BIOS_ClrScr(LightGray); gotoXY(1,1);
                  writeln(st+#220);
                  k:=length(st)+1;
                  fillchar(st[1],k,#223); st[1]:=' ';st[0]:=chr(k);
                  writeln(st);
                  writeln(Copyright,^M^J);
                  if ScreenPointer^[1,k].character=#220 then
                     begin
                     for i:=1 to k do
                         begin
                         SetTextAttr(1,i,$70);
                         SetTextAttr(2,i,8);
                         SetTextAttr(3,i,cyan);
                         end;
                     SetTextAttr(1,k,8);
                     end;
                  end;
  st:=Syntax;
  while pos('{',st)>0 do
        begin
        i:=pos('{',st); j:=i;
        repeat inc(j) until (j>length(st)) or (st[j]='}');
        delete(st,i,j+1-i);
        end;
  if ValidOptions<>'' then st:=st+' [options]';
  OutputLine(Pretty('USAGE:')+' '+ProgName+' '+st);
  if pos(ADHRS_,syntax)>0
	then begin
		  OutputLine('  '+ADHRS_+': select only files (+)with or (-)without given attributes');
        end;
  st:=Syntax;
  while pos('{',st)>0 do
        begin
        i:=pos('{',st); j:=i; k:=i;
        repeat inc(j) until (j>length(st)) or (st[j]='}');
        repeat dec(k) until (k<1) or (st[k]=' ');
        OutputLine('  '+copy(st,k+1,i-k-1)+': '+copy(st,i+1,j-i-1));
        delete(st,i,j+1-i);
        end;
  if pos(filelist_,syntax)>0
	then begin
		  OutputLine('  '+filelist_+': '+Explainfilelist);
{
		  if pos('['+filelist_+']',syntax)>0
			then OutputLine('   (if the '+filelist_+' is empty *.* will be listed)');
}
		  end;
  OutputLine(^J+Pretty('OPTiONS:'));
  i:=1;
  Columns:=2;
  while i<length(ValidOptions) do
        begin
        j:=i+1;
        repeat inc(j) until (j>length(ValidOptions)) or (ValidOptions[j]='/');
        st:=copy(ValidOptions,i,j-i)+' ';
        if st[3]=#255
           then begin {standard option}
                case st[2] of
                     'A' : st:='A:attr Attributes required';
                     'L' : st:='L[:fn] List to printer (or filename)';
                     'O' : st:='O[:..] Order (sort by Name, etc)';
                     'S' : st:='Subdir Recurse into subdirectories';
                     'V' : st:='V[:n] Verbose output (e.g. /V=7)';
                     end;
                end
           else begin
                if (copy(st,1,3)='/No') and (st[4]<>' ') then insert(' ',st,4);
                k:=pos('{',st);
                case k of
                    1,2  : st:=copy(st,k+1,length(st)-k-1);
                    3..99: st:=copy(st,2,k-2)+' '+copy(st,k+1,length(st)-k-2)
                   else begin
                        delete(st,1,1);
                        k:=pos(':',st); b:=pos(' ',st);
                        if k=0 then opt:=''
                               else if st[k-1]='[' then opt:=copy(st,k-1,b-k)
                                                   else opt:=copy(st,k,b-k);
                        k:=1; while(st[k] in ['A'..'Z','0'..'9']) do inc(k);
                        b:=pos(' ',st);
                        if opt='' then st:=copy(st,1,k-1)+' '+st
                                  else if k+length(opt)>6
                                          then st:=copy(st,1,k-1)+':.. '+st
                                          else begin
                                               st:=copy(st,1,k-1)+opt+' '+st;
                                               if opt=copy(st,length(st)+1-length(opt),9)
                                                  then dec(st[0],length(opt));
                                               end;
                        end;
                   end {of case};
                k:=pos(' ',st);
                while k<7 do begin insert(' ',st,k); inc(k); end;
                end;
        if AnsiInstalled
           then OutputLine(#27'[1m '+SwitchChar+st[1]+#27'[m'+copy(st,2,80))
           else OutputLine(' '+SwitchChar+copy(st,1,80));
        i:=j;
        end;
  Columns:=1;
  if ColumnCounter>1 then OutputLine('');
  Outputline(^J+Pretty('ENViRONMENT VARiABLES:'));
  if pos(Order_,ValidOptions)>0 then st:='/O:n' else st:='';
  OutputLine(' '+ProgName+^I' Specify default options, e.g. SET '+ProgName+'='+st+'/Verbosity=16');
  ShowEnv('CLASS1',ErrorActionName[Class1]);
  ShowEnv('CLASS2',ErrorActionName[Class2]);
  ShowEnv('_ANSI',YesNo(AnsiInstalled));
  ShowEnv('COMPATIBILITY',Compatibility);
  OutputLine(' LFN='+YesNo(UseLFN));
  if Examples<>''
     then begin
          if Examples[length(Examples)]='}' then dec(Examples[0]);
          st:='EXAMPLE';
          if pos(^J,Examples)>0 then st:=st+'S';
          for i:=length(Examples) downto 1 do if Examples[i]=^M then insert(^J,Examples,i+1);
          OutputLine(^J+Pretty(st)+':'^M^J+Examples);
          end;
  end;

  procedure CheckForCommonGlobals;
  var i,j : integer;
  begin
  if pos(Attr_,ValidOptions)>0 then if pos('/A',Globals)>0
     then begin
          st:=GetGlobalSpec('/A');
          if st='' then AllowableAttributes:=$3F
                   else {???};
          end;
  if RequiredAttributes=0
     then Attributes:=AllowableAttributes
     else Attributes:=RequiredAttributes;
  FileMode:=$42;
  if pos('/^L',globals)>0
     then begin   (* *)
          FormFeedMode:=true;
          if ListToPrinter then if PauseInterval=0 then PauseInterval:=60;
          st:=GetGlobalSpec('/^L');
          if st<>'' then FormFeed:=st;
          end;
  if (pos('/L',globals)>0) and (pos(L_,ValidOptions)>0)
     then begin
          st:=GetGlobalSpec('/L');
          if (st='') and match(ThisGlobal,'LPT?') then st:=ThisGlobal;
          if boolean(Verbosity and 4) then HeadingRequired:=true;
          if st='' then st:=DefaultLogfile^;
          assign(PRN,st);
          {$I-}
          FileMode:=$42;
          append(PRN);
          if IORESULT>0
             then rewrite(PRN);
          {$I+}
          if st=DefaultPrinter
             then with TextRec(PRN) do
                  begin
                  Handle:=StandardPrinterHandle;
                  end;
          if IORESULT=0 then ListToPrinter:=true
                        else begin ErrorMessage('Cannot /list to: '+st); exit; end;
          PrinterType:=Capitals(GetEnv(st+'.TYPE'));
          end
     else begin
          ListToPrinter:=false;
          move(output,PRN,sizeof(TextRec));
          end;
  if pos('/S',Globals)>0 then if pos(Subdirs_,ValidOptions)>0
     then RecurseOption:=true;
  if pos('/"',globals)>0
     then HeadingText:=GetGlobalSpec('/"');
  if (pos(Replace_,ValidOptions)>0) and (pos('/R',globals)>0)
     then begin
          st:=GetGlobalSpec('/R');
          if st='' then RemoveOption:=DefaultRemoveOption
                   else begin
                        if st[1]='R' then st[1]:='O';
                        p:=pos(st[1],'NACOIE');
                        if p=0 then ErrorMessage('Unknown replace option: '+st)
                               else RemoveOption:=WhenToDelete(p);
                        end;
          end;
  if (pos('/T',globals)>0) and (pos(Totals_,ValidOptions)>0) {Title & totals}
     then begin
          st:=GetGlobalSpec('/T');
          if st=''
             then begin
                  HeadingRequired:=(pos('/TI',globals)>0) or (pos('/TO',globals)=0);
                  TotalRequired:=true;
                  end
             else begin HeadingText:=st; HeadingRequired:=true; end;
          end;
  st:=GetGlobalSpec('/U');
  if (st<>'') and (pos(Units_,ValidOptions)>0)
     then begin Units:=upcase(st[1]);
          if st[length(st)-1]=':' then UnitStuff[3].Places:=ord(st[length(st)]) and 15;
          end;
  if (pos(Pause_,ValidOptions)>0) and (pos('/P',Globals)>0)
     then begin
          st:=GetGlobalSpec('/P');
          if st<>''
             then PauseInterval:=StringToInteger(st)
             else if ScreenType>TTY
                         then PauseInterval:=23
                         else if (lo(MachineID) in [ID_AT,ID_PS2]) or (ScreenType=EGA)
                                     then begin
                                          PauseInterval:=mem[$40:$84];  {max. row location on modern machines}
                                          if PauseInterval<8 then PauseInterval:=24;
                                          end
                                     else PauseInterval:=24;
              if ListToPrinter then PauseInterval:=60;
          if PauseInterval<0 then begin FormFeedMode:=true; PauseInterval:=abs(PauseInterval); end;
          end
     {else PauseInterval:=DoNotPause};
  if (pos(Wide_,ValidOptions)>0) and (pos('/W',globals)>0)
     then begin
              st:=GetGlobalSpec('/W');
              if st<>''
                 then PageWidth:=StringToInteger(st)
                 else PageWidth:=132;
              if PrinterType<>''
                 then writeln(PRN,#27'*0'#27'[');
              end
     else if (not ListToPrinter) and (CrtColumns in [40,80..132])
                 then PageWidth:=CRTcolumns;
  WideOutput:=PageWidth>80;
  if pos('/V',Globals)>0
     then begin
              st:=GetGlobalSpec('/V');
              if st<>'' then Verbosity:=StringToInteger(st)
                    else if pos(Verbose_,ValidOptions)>0 then Verbosity:=$1F
              end;
  Verbose:=Verbosity>3;
  BriefOutput:=(Verbosity=0) or (pos('/!',Globals)>0);
  {look for /1 /2 /3 etc (setting columns)}
  p:=pos('/',Globals);
  while p>0 do
        begin
        inc(p);
        if Globals[p] in ['0'..'9']
           then begin
                Columns:=0;
                repeat Columns:=ord(Globals[p])-ord('0');
                       inc(p);
                       until (p>length(Globals)) or not (Globals[p] in ['0'..'9']);
                p:=0;
                end
           else begin
                while (p<length(Globals)) and (Globals[p]<>'/') do inc(p);
                if p>=length(Globals) then p:=0;
                end;
        end;
  if HeadingRequired or (Columns>1) then
     begin {first construct heading text if none already...}
     if HeadingText=''
        then st:=ProgName+' '+ProcessedCommand
        else st:=HeadingText;
     if ListToPrinter
        then begin
             {$I-} writeln(PRN,st); {$I+}
             ExitCode:=IORESULT;
             if ExitCode>=152
                then begin if PauseInterval>0 then Pause; write(PRN,^M); writeln(PRN,st);end
                else if ExitCode<>0 then ErrorMessage(DosErrorMessage(ExitCode));
             end
        else writeln(st);
  (* *)
     end;
  if (pos('/O',globals)>0) and (pos(Order_,ValidOptions)>0)
     then begin
          SortOutput:=true;
          st:=GetGlobalSpec('/O');
          if st<>'' then SortOptions:=capitals(st);
          end;
  if SortOutput
     then begin
          if SortOptions='' then SortOptions:=DefaultSortKey;
          StartOfSortLine:=1;
          for i:=1 to length(SortOptions) do
              case SortOptions[i] of
                   'N' : inc(StartOfSortLine,14);
                   'F' : inc(StartOfSortLine,64);
                   'E','X' : inc(StartOfSortLine,3);
                   'D','S' : inc(StartOfSortLine,4);
                   'T' : inc(StartOfSortLine,2);
                   else inc(StartOfSortLine,1);
                   end;
          LastSortBlockAllocated:=-1;
          new(SortBlockArray); {first use of this, via GetSortBlock, will zero block0}
          fillchar(SortBlockArray^,sizeof(SortBlockArray^),0);
          end
  end;

  procedure ProcessGlobal(st : string);
  var p : byte;
  begin
  Globals:=Globals+'/'+upcase(st[2])+copy(st,3,255);
  if upcase(st[2])='N' then
     begin
     if length(st)<=3 then p:=length(st)
                      else if st[3] in [':','='] then p:=4
                                                 else p:=3;
     if length(st)=2 then NoOptions:=NoOptions+DefaultNoOption
                     else begin
                          st[3]:=upcase(st[p]);
                          if pos('/'+st[3],Globals)=0
                             then NoOptions:=NoOptions+st[3];
                          end;
     end;
  end;

  function GetRest : string;
  var j : integer;
  begin
  j:=i;
  repeat inc(i) until LongCmd[i] in [#0,',',#9,' '];
  if i<>j then st[0]:=chr(min(255,i-j));
  move(LongCmd[j+1],st[2],length(st)-1);
  GetRest:=st;
  end;

begin {Parse}
FirstInList:=1; Attributes:=0;
i:=pos('/No',ValidOptions);
if i>0 then DefaultNoOption:=upcase(ValidOptions[i+3]);
i:=1; seq:=0;
CheckForMinus:=pos('+|-',Syntax) in [1..4];
k:=1;
move(CommandLine^[1],LongCmd[1],length(CommandLine^));
if CommandLine^[1]='@' then st:=''
                       else st:=GetEnv('CMDLINE');
st:=''; {???}
if st<>'' then move(st[1],LongCmd[length(CommandLine^)+1],length(st));
LongCmd[length(CommandLine^)+length(st)+1]:=#0;
LongCmd[length(CommandLine^)+length(st)+2]:=#0;

i:=1;
while LongCmd[i]<>#0 do
      begin
      st:=LongCmd[i];
      case st[1] of
           #9,' ' : inc(i);
           ','  : begin AppendParameter(''); inc(i); end;
           '/' : if SwitchChar='/'
                    then begin
                         repeat inc(i);
                                if LongCmd[i]='"'
                                   then begin
                                        repeat inc(i);
                                               st:=st+LongCmd[i];
                                               until (LongCmd[i] in ['"',#0]) or (length(st)=255);
                                        dec(st[0]);
                                        end
                                   else st:=st+LongCmd[i];
                                until (LongCmd[i] in [#0,'/',' ']) or (i>=sizeof(LongCmd));
                         dec(st[0]);
                         ProcessGlobal(st);
                         end
                    else AppendParameter(GetRest);
           '-' : if CheckForMinus
                    then AppendParameter(GetRest)
                    else ProcessGlobal(GetRest);
           else begin
                AppendParameter(GetRest);
                end;
           end;
    end;
(*
if (ParametersInList=0) and (not CanBeAFilter) and (pos('['+filelist_+']',Syntax)>0)
   then AppendParameter('*');
*)
CheckForCommonGlobals;
if pos(Attr_,ValidOptions)>0 then if pos('/A',Globals)>0
   then begin
        st:=GetGlobalSpec('/A');
        if st='' then AllowableAttributes:=$3F
                 else {???};
        end;
if RequiredAttributes=0
   then Attributes:=AllowableAttributes
   else Attributes:=RequiredAttributes;
if pos('/?',Globals)>0
	then begin
		  ExplainWhatItDoes;
		  Parse:=false;
		  end
	else Parse:=true;
LastParameter:=ParametersInList;
end;

procedure doscall(var reg : registers);
begin
msdos(reg);
end;

procedure ChooseFormat(Format : string);
const Default='O';
var st : string;
begin
if Format='' then Format:=Default;
if (length(Format)=1) or ((length(Format)<=8) and (Format[1]<>Format[2]))
   then case Format[1] of
     'M': Format:='NNNNNNNN EEE S,SSS,SSS,SSS  DD-DD-DD tt:ttt';
     'W': Format:='NNNNNNNN EEE S,SSS,SSS,SSS  DD-DD-DD tt:ttt FFFFFFFFFFFF...';
     'F': Format:='ffffffffffffffff a----- SSS,SSS,SSS DD-Ddd-dddd tt:ttt';
     'O': Format:='a-----/uuuu SS,SSS,SSS,SSS dd-Ddd-dd tt:ttt f:ffffff..';
     'U': Format:='pppppppppp ggggg uuuuu sssssssss d.......... fffffff..';
     else Format:='a----- SSS,SSS,SSS  dd-Dd-dd tt:ttt f:ffffff..'; {used by ListFile}
     end;
if (SortOptions<>'') and (Format=Default)
   then begin
        st:=Capitals(Format);
        if pos(Sort_CompressionRatio,SortOptions)>0 then if pos('Y',st)=0
           then Format:=Format+' YYY%';
        if pos(Sort_Version,SortOptions)>0 then if pos('V',st)=0
           then Format:=Format+' V........................';
        if pos(Sort_Size,SortOptions)>0 then if pos('S',st)=0
           then Format:=Format+' SSS,SSS,SSS,SSS';
        if pos(Sort_Date,SortOptions)>0 then if pos('D',st)=0
           then Format:=Format+' dd/ddd/dddd tt:ttt';
        end;
OpenDOS.Format:=Format;
end;

const DosEmuDate = '02/25/93';

function DosEmu_Version : string;
const v          : word= 0;
      Patchlevel : word= 0;
var st  : string;
    i   : integer;
begin
DosEmu_Version:='';
if BiosDate<>DosEmuDate
   then exit;
v := 0;
asm mov ax,0
    mov cs:[v],ax {set version to zero}
    int $E6
    cmp AX,$aa55
    jne @nogo
    mov [v],bx
    mov [patchlevel],cx
  @nogo:
    end;
if v=0 then exit; {strange}
DosEmu_Version:=decimal(hi(V))+'.'+decimal(lo(V))+'.'+decimal(Patchlevel);
end;

procedure ExecUnix(command : string);
begin
if BiosDate<>DosEmuDate
   then begin DOSERROR:=99; exit; end;
command:=copy(command,1,254)+#0;
with reg do begin
            AX:=$50;
            ES:=seg(command[1]); DS:=ES; DX:=ofs(command[1]);
            intr($e6,reg);
            DOSERROR:=reg.ax;
            end;
end;

procedure StringDateToQword(datestr : string; var result : Qword);
var reg : registers;
begin
with Result do
     begin
     TimeDate:=TimeNumber(datestr);
     Unused:=0;
     if UseQword then with reg do
        begin
        AX:=$71A7; BL:=1;
        ES:=seg(result); DI:=ofs(result);
        CX:=result.time; DX:=result.date; BH:=sec100;
        msdos(reg);
        end;
     end;
end;

function GetTasks(var MaximumTask,MyTaskOffset,CurrentlyActiveTasks : word) : word;
begin
with reg do begin
            AX:=$2701; BX:=0; CX:=0; DX:=0;
            intr($2F,reg);
            MyTaskOffset:=BX; CurrentlyActiveTasks:=CX;
            if (AX<>$27) and (DX>0)
               then begin GetTasks:=DX; MaximumTask:=AX; end
               else begin GetTasks:=0; MaximumTask:=0; exit; end;
            TASK_IDS:=ptr(ES,SI);
            TASK_NAMES:=ptr(ES,DI);
            end;
end;

{   Initialisation code for unit: OpenDOS }

begin
{initialisation code does environment pointers, etc.}
ConCharacteristics:=DeviceCharacteristics(StandardOutputHandle);
RedirectedOutput:=( (ConCharacteristics and $9093)<>$8093) or ((ConCharacteristics and $F0)=$C0);
st:=GetENV('_CODEPAGE');
i:=StringToInteger(st);
GetCountryInfo(CountryInfo,i);
st:=Paramstr(0);
Fsplit(st,st,Progname,st);
{$IFOPT G-}
EMSpresent:=(IVect[$67]<>IVect[$66]) and (byte(IVect[$67]^)<>IRET);
ProgName:=GetProgName(PrefixSeg);
{$ENDIF}
EnvironmentPointer:=ptr(memw[PrefixSeg:$2C],0);
OriginalVideoMode:=GetVideoMode;
if OriginalVideoMode=MONO
   then ScreenPointer:=ptr($B000,0)
   else ScreenPointer:=ptr($B800,0);
StartTime:=TimerTicks;
CommandLine:=ptr(PrefixSeg,$80);
SwitchChar:=GetSwitchCharacter;
st:=GetEnv('SWITCHAR');
if st<>'' then SwitchChar:=st[1];
if TaskMaxVersion>0 then MultiTasker:=TaskMgr
	else if word(DesqViewInfo(1))>0 then MultiTasker:=DesqView
	else if TopViewVersion>0 then MultiTasker:=TopView;
st:=GetEnv('COMPATIBILITY');
if st<>'' then Compatibility:=st;
st:=GetEnv('NOCHAR');
if st<>'' then NoStr:=' '+capitals(st);
st:=GetEnv('YESCHAR');
if st<>'' then YesStr:=' '+capitals(st)+' '+YesStr;
st:=GetEnv('CLASS2');
if st<>'' then Class2:=ErrorActionType(pos(upcase(st[1]),'IWEAR'));
st:=GetEnv('CLASS1');
if st<>'' then Class1:=ErrorActionType(pos(upcase(st[1]),'IWEAR'));
if RedirectedOutput
   then {AnsiInstalled:=false but could use CUP to check}
   else AnsiInstalled:=(byte(GetAnsiVersion)>0) {check for ANSI.SYS, but not AVATAR?}
       or (word(ivect[$16])=$296) and ((mem[seg(ivect[$16]^):$15C]=170)); {check for PCMAG ANSI.COM}
{if RedirectedOutput then AnsiInstalled:=false;}
st:=GetEnv('_ANSI');
if st<>'' then AnsiInstalled:=pos(' '+capitals(st),NoStr)=0;
st:=GetEnv('LFN');
if st<>'' then UseLFN:=pos(' '+capitals(st),NoStr)=0;
if UseLFN then with reg do
   begin
   st:='\'#0#0#0#0#0#0#0#0#0#0#0#0#0;
   AX:=$71A0; DS:=seg(st[1]); DX:=ofs(st[1]); SI:=DX;
   ES:=seg(st[1]); DI:=ofs(st[1]); CX:=length(st);
   MsDos(reg);
   if AH=$71 then UseLFN:=false else FileSystemFlags:=BX;
   end;
OriginalTextAttr:=7;
GetCBreak(OriginalBreakFlag);
for i:=1 to EnvCount do
	 if pos('windir',EnvStr(i))=1 then MultiTasker:=Windows;
RequiredAttributes:=0;
AllowableAttributes:=AnyFile and not (Hidden or VolumeID);
GetDir(0,CurrentDir);
end.
