; ### This file is part of FDAPM, a tool for APM power management and
; ### energy saving. (c) by Eric Auer <eric #@# coli.uni-sb.de> 2003.
; FDAPM is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License as published
; by the Free Software Foundation; either version 2 of the License,
; or (at your option) any later version.
; ### FDAPM is distributed in the hope that it will be useful, but
; ### WITHOUT ANY WARRANTY; without even the implied warranty of
; ### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; ### GNU General Public License for more details.
; You should have received a copy of the GNU General Public License
; along with FDAPM; if not, write to the Free Software Foundation,
; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
; (or try http://www.gnu.org/licenses/ at http://www.gnu.org).

; This file: All interrupt handlers and related things that
; belong to the TSR part of the tool.
; If UNIDLECHECK is %define-d, more handlers are enabled.
; Main configuration variables are in main file:
; dw apmversion, db savingstrat, dw MainStatus,
; db IdleStrategy, dw IdleHardness, dw APMPollFreq.

i16:	cmp ah,1	; 0: 84 key "check"  /  1: 84 key "get"
	jbe ii16
	cmp ah,10h	; 102 key style "get"
	jz ii16
	cmp ah,11h	; 102 key style "check"
	jz ii16
	cmp ah,20h	; 122 key style "get"
	jz ii16
	cmp ah,21h	; 122 key style "check"
	jnz ix16
ii16:	test ah,1	; GET key or CHECK for key?
	jz ii16i	; 0, 10h... are "get key". Those are "idling"
			; 1, 11h... are only "check for key". Work!
ii16w:	
	call working	; sign of WORK state: checking for key
	jmp short ix16
	;
ii16L:	mov word [cs:whichIdling],idle16Calls	; which counter update
	call idling	; sign of IDLE state: waiting for key
ii16i:	push ax		; only "go idling" if no key in queue!
	or ah,1		; 0->1, 10h->11h, 20h->21h: check for key
	pushf			; simulate interrupt
	call far [cs:oldi16]	; original handler
	pop ax
	jz ii16L	; if no key available yet, KEEP IDLING.
	;
ix16:	jmp far [cs:oldi16]

i2a:	cmp ah,84h
	jnz ix2a
	mov word [cs:whichIdling],idle2aCalls	; which counter update
	call idling
ix2a:	jmp far [cs:oldi2a]

i28:	mov word [cs:whichIdling],idle28Calls	; which counter update
	call idling
ix28:	jmp far [cs:oldi28]

; ---------------

i2f:	cmp ah,54h	; a call for POWER ?
	jz ini2f
	jmp ii2f	; skip POWER API
ini2f:
	; *** the POWER API ***
	cmp al,0
	jnz i2fa
	mov ax,0100h	; "version 1.0"
	mov bx,504dh	; detection magic "PM"
	iret
i2fa:	cmp al,1
	jnz i2fb
	or bh,bh
	jnz setstat
	mov bl,[cs:MainStatus]
i2fret:	xor ax,ax
	iret
setstat:			; ***
	mov [cs:MainStatus],bl	; 2LSB: 0 off 2 std 3 adv
	call useMainStatus
	jmp short i2fret
i2fb:	cmp al,2
	jnz i2fc
	or bh,bh
	jnz setstrat
	mov bl,[cs:IdleStrategy]	; dummy for now
	jmp short i2fret
setstrat:			; ***
	mov [cs:IdleStrategy],bh	; bit field??? dummy for now
	jmp short i2fret
i2fc:	cmp al,3
	jnz i2fd
	or bx,bx
	jnz sethard
	mov bx,[cs:IdleHardness]	; 1..5 min, 6 reg, 7..8 max
	jmp short i2fret
sethard:			; ***
	mov [cs:IdleHardness],bx	; dummy for now
i2fd:	cmp al,81h
	jnz i2fe
	or bx,bx
	jnz getAPMstat
getIDLEstat:
	cmp cx,28
	jb i2ferr
	mov ax,IdleStatBuf
	call getStatBuf
	jmp short i2fret
getAPMstat:
	cmp cx,4
	jb i2ferr
	mov ax,APMStatBuf
	call getStatBuf
	jmp short i2fret
i2ferr:	mov ax,87h
	iret
i2fe:	cmp al,82h
	jnz ii2f
	or bx,bx
	jnz setPollFreq
	mov bx,[cs:APMPollFreq]	; dummy for now
	jmp short i2fret
setPollFreq:			; ***
	mov [cs:APMPollFreq],bx	; dummy for now
	jmp short i2fret
ii2f:	cmp ah,0aeh
	jnz ix2f
	call working
ix2f:	jmp far [cs:oldi2f]

getStatBuf:	; copy from cs:ax to ds:si length cx. Do not change regs.
	pushf
	push ax
	push bx
	push cx
	push si
	mov bx,ax
gSBlp:	mov al,[cs:bx]
	mov [ds:si],al
	inc si
	inc bx
	loop gSBlp
	pop si
	pop cx
	pop bx
	pop ax
	popf
	ret

useMainStatus:	; update settings to reach OFF, REG or ADV mode
	push ax
	mov ah,[cs:MainStatus]	; 0 off 2 std 3 adv
	and ah,3
	mov al,[cs:savingstrat]
	and al,0fch	; no HLT nor APM IDLE
			; or al,ah is probably too simplistic, so...
	cmp ah,3	; only in ADV mode use int hooks!?
	jnz noMainADV
	or al,3		; enable both HLT and APM IDLE
		; (idling will ignore APM IDLE if no APM available)
noMainADV:
	mov [cs:savingstrat],al
	; *** is this all that we have to do??? ***
	pop ax
	ret

; ---------------

idling:		; called whenever the system is idle!
	pushf
	;
	push ax
	xor ax,ax
	inc word [cs:idleCalls]	; maintain the statistics
	adc [cs:idleCalls+2],ax	; ... which are 32 bit
	call getTime		; get timer tick time of now
	cmp ax,[cs:lastIdleTick]
	jz sameIdle		; still the same, do not count
	mov [cs:lastIdleTick],ax
	xor ax,ax
	inc word [cs:idleTicks]		; the global counter
	adc word [cs:idleTicks+2],ax	; 16bit code ;-)
	push bx
	mov bx,[cs:whichIdling]	; increment which special counter?
	cmp bx,idle2fCalls	; sane?
	jb spuriousIdle
	inc word [cs:bx]		; "idle for reason x counter"
	adc word [cs:bx+2],ax		; 16bit code ;-)
spuriousIdle:
	pop bx
sameIdle:
	pop ax
	;
	test byte [cs:savingstrat],2
	jz nAPMidling
	push ax
	mov ax,[cs:apmversion]
	cmp ax,0100h
	jb nAPMid
	mov ax,5305h	; tell "CPU idle"
	int 15h
nAPMid:	pop ax
nAPMidling:
	test byte [cs:savingstrat],1
	jz nHLTing
	sti
	hlt	; HLT alone can save energy already!
nHLTing:
	popf
	ret


working:			; for now, we only update the uptime!
	pushf
	push ax
	call getTime		; current time?
	push ax
	sub ax,[cs:lastOnTick]	; after the "last checked on..." tick?
	jc wrapWorkTime		; to be safe, ignore if wrapping
	jz wrapWorkTime		; we would add 0 - skip that
	add [cs:onTicks],ax		; add to accumulated uptime
	adc word [cs:onTicks+2],0	; ... which is a 32bit value
wrapWorkTime:
	pop ax
	mov [cs:lastOnTick],ax	; update in any case
	pop ax

%ifdef UNIDLECHECK
	; *** we would increment a busy counter here...    ***
	; *** a timer tick handler might decrement it and  ***
	; *** trigger "idling" when the counter reaches 0  ***
	; ***  (the increment must be with "saturation")   ***
	; *** increment STATISTICS based on CALLER IP, too ***

	test byte [cs:savingstrat],2	; APM in use?
	jz nwAPM
	push ax
	mov ax,[cs:apmversion]
	cmp ax,100h
	jb nwAPM2
	mov ax,5306h	; tell "CPU busy"
	int 15h
nwAPM2:	pop ax
nwAPM:
%endif	; UNIDLECHECK
	popf
	ret


getTime:	; get low word of timer tick count in AX
	push ds
	mov ax,40h
	mov ds,ax
	mov ax,[ds:6ch]	; current time
	pop ds
	ret

; ---------------

%ifdef UNIDLECHECK
i08:	pushf
	; *** ***
	; *** count down "working" count and call "idling" if 0
	; *** ***
	popf
ix08:	jmp far [cs:oldi08]

i10:	cmp ah,3
	jbe ix10
	call working
ix10:	jmp far [cs:oldi10]

i13:	call working
	jmp far [cs:oldi13]

i14:	cmp ah,3
	jz ix14
	call working
ix14:	jmp far [cs:oldi14]

i17:	cmp ah,2
	jz ix17
	call working
ix17:	jmp far [cs:oldi17]

i21:	cmp ah,4bh
	jnz ix21
	call working
ix21:	jmp far [cs:oldi21]

oldi08	dd -1
oldi10:	dd -1
oldi13:	dd -1
oldi14:	dd -1
oldi17:	dd -1
oldi21:	dd -1
%endif	; UNIDLECHECK

; not handling int 6c ...
; IRQ already handled by BIOS, by the way ...

; ---------------

	align 4
	db "int>"
oldi16:	dd -1
oldi28:	dd -1
oldi2a:	dd -1
oldi2f:	dd -1
	db "<int"

lastIdleTick	dw 0	; avoid counting one idle moment twice
lastOnTick	dw 0	; helps to count busy time
whichIdling	dw 0	; pointer to "what called idling?"

		db ">>"
IdleStatBuf:
onTicks		dd 1	; timer ticks with CPU on (not 0: avoid div by 0)
idleTicks	dd 0	; timer ticks with CPU idle
idleCalls	dd 0	; calls to "idling" in total
idle2fCalls	dd 0	; calls to "idling" by int 2f handler
idle28Calls	dd 0	; calls to "idling" by int 28 handler
idle16Calls	dd 0	; calls to "idling" by int 16 handler
idle2aCalls	dd 0	; calls to "idling" by int 2a handler
		db "<<"

APMStatBuf:
resumeCount	dd 0	; count of resumes (found by APM polling?)

