/* pause.c */

/* Waits for the user to press a key.  Always exits successfully */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>			/* strncmp */

#include <conio.h>			/* getch() */

#include "catgets.h"			/* catopen/getcats */


/* Functions */

void usage (nl_catd cat);


/* The program starts here */

int
main (int argc, char **argv)
{
  char *s;
  int i;
  nl_catd cat;

  /* Open the message catalog */

  cat = catopen ("pause", 0);

  /* Check command line */

  for (i = 1; i < argc; i++)
    {
      if (strncmp (argv[i], "/?", 2) == 0)
	{
	  usage (cat);
	  catclose (cat);
	  exit (0);
	} /* if /? */

      else
	{
	  printf ("%s ", argv[i]);
	} /* else */
    } /* for */

  if (argc == 1)
    {
      s = catgets (cat, 1, 0, "Press any key to continue");
      printf (s);
    } /* argc==1 */

  /* Grab a key */

  getch();
  printf ("\n");

  /* Done */

  catclose (cat);
  exit (0);
}

/* usage - display the program usage.  do not exit from here */

void
usage (nl_catd cat)
{
  char *s;

  /* Display usage */

  s = catgets (cat, 0, 0, "Waits for the user to press a key");
  fprintf (stderr, "PAUSE: %s\n", s);

  s = catgets (cat, 0, 1, "Usage");
  fprintf (stderr, "%s:\n", s);

  s = catgets (cat, 0, 2, "message");
  fprintf (stderr, "  PAUSE [ %s ]\n", s);
}
