/* TYPE (MORE)
 * Displays the contents of a file (one screen at time.)
 * Copyright (C) 1996, James Hall.
 */

#include <stdio.h>
#include "utils.h"
#include "gop.h"

main (int argc, char **argv)
{
	int i, ch;
	FILE *stream;

	/* Set global variables for MORE */

#ifdef PROG_MORE
	xx_pause = 1;
	xx_numrows = x_height ();
#else
	xx_pause = 0;
#endif

	/* Check options on command line */

	while ((ch = gop(argc, argv, "pPlLuUtTcCeEaA")) != EOF) {
		switch (ch) {
#if defined (PROG_TYPE)
		case 'p':
		case 'P':
			xx_pause = 1;
			break;
#endif
		case 'l':
		case 'L':
			xx_tolower = 1;
			break;
		case 'u':
		case 'U':
			xx_toupper = 1;
			break;
		case 't':
		case 'T':
			xx_tabs = 1;
			break;
		case 'c':
		case 'C':
			xx_controls = 1;
			break;
		case 'e':
		case 'E':
			xx_ends = 1;
			break;
		case 'a':
		case 'A':
			xx_tabs = 1;
			xx_controls = 1;
			xx_ends = 1;
			break;
		default:
#if defined(PROG_MORE)
			fprintf (stderr, "Usage: MORE [/L][/U][/T][/C][/E][/A] files..\n");
#else
			fprintf (stderr, "Usage: TYPE [/P][/L][/U][/T][/C][/E][/A] files..\n");
#endif
			exit (1);
		}
	}

	/* Check command line.  Open all files on command line. */

	if (gop_ind < argc) {
		for (i = gop_ind; i < argc; i++) {
			if ((stream = fopen (argv[i], "r"))) {
				while ((ch = x_getc (stream)) != EOF) {
					x_putc (ch, stdout);
				}
				fclose (stream);
			}
			else {
				fprintf (stderr, "Cannot open file %s\n", argv[i]);
			}
		}
	}
	else {
		while ((ch = x_getc (stdin)) != EOF) {
			x_putc (ch, stdout);
		}
	}

	exit (0);
}
