/* TEE
 * Splits the standard input, saving a copy to a file, and printing a copy
 * to the standard output.
 *
 * Copyright (C) 1996, James Hall.
 */

#include <stdio.h>

main (int argc, char **argv)
{
	FILE *stream;
	char ch;

	/* Check command line.  There should be only 1 arg (argc=2). */

	if (argc != 2) {
		fprintf (stderr, "Bad number of arguments on command line.\n");
		exit (1);
	}

	/* Open the TEE file.  Copy input to output and a file. */

	if ((stream = fopen (argv[1], "w"))) {
		while ((ch = getchar()) != EOF) {
			putc (ch, stream);
			putchar (ch);
		}

		fclose (stream);
		exit (0);
	}
	else {
		fprintf (stderr, "Cannot open file %s\n", argv[1]);
		exit(2);
	}
}
