/* FGC, BGC
 * Set the foreground color and background color.
 * Requires ANSI.SYS be resident.
 *
 * Copyright (C) 1996, James Hall.
 */

#include <stdio.h>
#include <string.h>

#define ESC '\033'


#if defined(PROG_FGC)
 #define OFFSET 30
 #define DEFAULT 37                          /* white */
#elif defined(PROG_BGC)
 #define OFFSET 40
 #define DEFAULT 40                          /* black */
#endif


#define NUM_COLORS 8

char *color[NUM_COLORS] = {"black", "red", "green", "yellow", "blue", "magenta",
	"cyan", "white"};


main (int argc, char **argv)
{
	int i;

	/* Check for one argument. */

	if (argc == 1) {
		/* No arguments on command line. */
		printf ("%c[%dm", ESC, DEFAULT);
		exit (0);
	}

	/* Check for two arguments. */

	if (argc == 2) {
		/* Exactly one arg on command line */
		for (i = 0; i < NUM_COLORS; i++) {
			if (strcmp (argv[1], color[i]) == 0) {
				printf ("%c[%dm", ESC, OFFSET + i);
				exit (0);
			}
		}

		/* Not found. */

		fprintf (stderr, "Unknown color.\n");
		exit (2);
	}

	/* Wrong command line. */

	fprintf (stderr, "Bad number of arguments.\n");
	exit (1);
}
