/* TYPE (MORE)
 * Displays the contents of a file (one screen at time.)
 * Copyright (C) 1996, James Hall.
 */

#include <stdio.h>
#include "utils.h"

main (int argc, char **argv)
{
	int i, ch;
	FILE *stream;

	/* Set global variables for MORE */

#if 0
	x_init ();
#endif /* 0 */


#ifdef PROG_MORE
	xx_pause = 1;
	xx_numrows = x_height ();
#else
	xx_pause = 0;
#endif

	xx_lines = 0;

	/* Check command line.  Open all files on command line. */

	for (i = 1; i < argc; i++) {
		if ((stream = fopen (argv[i], "r"))) {
			while ((ch = x_getc (stream)) != EOF) {
				x_putc (ch, stdout);
			}
			fclose (stream);
		}
		else {
			fprintf (stderr, "Cannot open file %s\n", argv[i]);
		}
	}

	exit (0);
}
