/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

/*************************************************************************
 * This program converts a text file from the UNIX newline format to the
 * DOS newline format.  UNIX uses a bare '\n' character, while DOS uses a
 * carriage return & newline pair.
 *
 * Author: James Hall
 */

#include <stdio.h>
#include "getopt.h"
#include "freedos.h"


void usage (void);


main (int argc, char **argv)
{
  int i;
  char ch;
  FILE *pFile;

  /* Scan the command line */

  while ((i = getopt (argc, argv, "?")) != EOF)
    {
      switch (i)
	{
	default:
	  usage ();
	  break;
	}
    }

  /* Convert the files */

  if ((argc - optind) < 1)
    {
      trch (stdin, UNIX_NL, DOS_NL);
      exit (0);
    }

  for (i = optind; i < argc; i++)
    {
      if ((pFile = fopen (argv[i], "r")) != NULL)
	{
	  trch (pFile, UNIX_NL, DOS_NL);
	  fclose (pFile);
	}

      else
	fprintf (stderr, "Cannot open file %s\n", argv[i]);
    }

  exit (0);
}

void 
usage (void)
{
  printp ("UNIX2DOS", "Converts a file from the UNIX newline format to DOS.");
  printu ("UNIX2DOS", "[file..]");
  exit (1);
}
