/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

/***********************************************************************
 * This program displays the help pages for Free-DOS.  It assumes the
 * env. variables HELPATH and PAGER have been set.  HELPPATH should not
 * have a trailing backslash.
 *
 * Author: James Hall
 */

#include <stdio.h>		/* For printf, puts */
#include <stdlib.h>		/* For getenv, system */
#include <errno.h>		/* For system */
#include <process.h>		/* For system */
#include "getopt.h"		/* For getopt */
#include "freedos.h"		/* Free-DOS stuff */


void usage (void);


main (int argc, char **argv)
{
  /* NOTE: As of 12/26/94, Free-DOS does not divide the Help pages by
     section.  However, it seems a good idea to do so in future, so I
     am using a "section" to make the change-over easier. */

  int i, iSec = 1;
  char *psz, szPager[MAX_STR], szPath[MAX_STR], szProg[MAX_STR], szShell[MAX_STR];
  FILE *pFile;

  /* Scan the command line */

  while ((i = getopt (argc, argv, "?")) != EOF)
    {
      switch (i)
	{
	default:
	  usage ();
	  break;
	}
    }

  /* NOTE: I am no longer supporting the big help file.  It is silly and
     really a waste of disk space.  Just print the usage if no commands
     are provided. */

  if ((argc - optind) < 1)
    usage ();


  /* Get the environment variables */

  if (psz = getenv ("HELPPATH"))
    strcpy (szPath, psz);
  else
    strcpy (szPath, "C:\\DOS\\HELP");

  if (psz = getenv ("PAGER"))
    strcpy (szPager, psz);
  else
    strcpy (szPager, "MORE");

  /* Display the Help pages */

  for (i = optind; i < argc; i++)
    {
      fBasename (szProg, argv[i]);
      sprintf (szShell, "%s %s\\%d\\%s", szPager, szPath, iSec, szProg);

      puts (szShell);
      system (szShell);
    }

  exit (0);
}


void 
usage (void)
{
  printp ("HELP", "Displays the Help pages for Free-DOS commands");
  printu ("HELP", "command..");
  exit (1);
}
