./" Set up page header
./" PH args are @left@middle@right@
.PH "@NANSI.SYS 3.1 user's guide@- % -@April 1991@"
.nr LL 70n
.LG
.ce
NANSI.SYS
.ce
An Enhanced MS-DOS Console Driver
.ce
Version 3.1   April 1991
.sp 3
.NH 1
Introduction - Who should use NANSI.SYS
.LP
NANSI.SYS is a console device driver for MS-DOS computers.  It executes
the same ANSI cursor control sequences as does the standard console driver
ANSI.SYS, but significantly faster.  It also offers several extra 
features.  Best of all, it is cheap, and its source code is available from 
the author.
.LP
You can benefit from using NANSI.SYS if:
.br
1. you use programs (such as DIR, MORE, or NETHACK) which display text on 
the screen via DOS, or
.br
2. you have an EGA or VGA, and want to use the 43- or 50-line mode of your 
display, or
.br
3. you run out of space when redefining keys with ANSI.SYS, or
.br
4. you are a programmer who uses ANSI escape sequences, and are 
frustrated with slow display updates, or
.br
5. you are porting display-intensive Unix programs to run under MS-DOS.
.LP
You will not benefit from using NANSI.SYS if:
.br
1. you never wish commands like TYPE or DIR were faster, and
.br
2. you only use programs like Microsoft Word or Word Perfect, which bypass
DOS when displaying text, and
.br
3. you aren't interested in displaying 43 lines of text on your EGA or VGA, and
.br
4. you have never heard of ANSI.SYS anyway.
.LP
Installing NANSI.SYS will bring no improvement in display speed for
programs that bypass DOS (e.g. Microsoft Word), a 30% improvement in display
speed with most programs that don't bypass DOS, a 50% improvement with 
"optimized" programs (see chapter below), and a 95% improvement with
"optimized" programs that avoid scrolling.  (Yup, that's right, 20 times
faster!)
.LP
One "optimized" program, COPY /b foo.txt CON:, comes with DOS.
To test the speed improvement yourself, create a long text file
named foo.txt, and display it with COPY /b foo.txt con:
with NANSI.SYS installed- it will go by very quickly.  This speed increase 
occurs even when running in a window in Microsoft Windows 3.0.
.NH 1
Compatibility
.LP
NANSI.SYS has been tested on IBM PC/XT, /AT, and PS/2 systems, as well as
on the Leading Edge model D.  It should run on any CGA, MDA, EGA, or VGA 
compatible video card.  It is compatible with Microsoft Windows 3.0.
.bp
.NH 1
Copyright status
.LP
This program and documentation is Copyright 1986, 1991 Daniel Kegel.
The executable program and its documentation may be freely distributed.
.LP
If you use this program for education or at home, you are 
encouraged to send a US$10 donation to the author.
If you use it for business purposes, you are required to purchase
a right-to-use license by sending US$10 to the author.
.LP
Copies of the driver on 360 KB floppy, together with printed documentation,
may be obtained from the author for US$35.
Copies of the driver's source code are also available.
.LP
License fees, donations, and correspondence (in English or German) should be 
directed to the author at the following address:
.DS
Daniel Kegel
2750 N. Lincoln Ave.
Altadena, CA. 91001 USA
.DE
.br
or at the Internet E-mail addresses
.DS
dank@blacks.jpl.nasa.gov  or  dank@jomby.caltech.edu
.DE
.br
.NH 1
Version
.LP
The version number can be found with the DOS command TYPE NANSI.SYS.
.br
This documentation is for version 3.1, created April 1991.  
.NH 1
Installation and System Requirements
.LP
NANSI.SYS version 3.1 is distributed as the archive NANSI31.ARC or NANSI31.ZIP,
with the following contents:
.DS
NANSI.SYS - the device driver
NANSI.DOC - this documentation file
RAW.C     - how to set and clear RAW mode for faster screen output
RAW.H     - definitions for users of RAW.C
GC.ON     - text file which, when TYPEd, turns on the graphics cursor
.DE
.LP
NANSI.SYS requires MS-DOS version 2.0 or higher, and
uses about 3 kilobytes of system RAM.
.LP
To install NANSI.SYS on your computer, copy the file NANSI.SYS to your
boot disk (usually C:), and include one of the following statements in the
configuration file CONFIG.SYS on your boot disk:
.br
For IBM VGA and Vega VGA cards, or if you don't know what kind of card you have:
.DS
DEVICE=NANSI.SYS
.DE
.br
For Paradise VGA Plus cards:
.DS
DEVICE=NANSI.SYS /t54 /t55 /t56 /t57
.DE
.br
For VGA cards using the Oak Technology OTI-067:
.DS
DEVICE=NANSI.SYS /t4F /t50 /t51
.DE
.br
For VGA cards using the Trident Microsystems TVGA 8900:
.DS
DEVICE=NANSI.SYS /t50 /t51 /t52 /t53 /t54 /t55 /t56 /t57 /t58 /t59 /t5A
.DE
.NH 1
COMMAND-LINE OPTIONS
.LP
.NH 2
/s   : tell Nansi to be secure, and disable keyboard redefinition
.LP
Although it is nice to be able to redefine the keyboard with escape
sequences, it is a gaping security risk.  To prevent trojan horse attacks
from messages in text files, archives, and programs downloaded from
the outside world, disable this feature by invoking Nansi with the /s option
in config.sys.  For example,
.DS
DEVICE=NANSI.SYS /s /t54 /t55 /t56 /t57
.DE
.NH 2
/tnn : tell Nansi that video mode nn is a text mode
.LP
No two VGA cards seem to have the same set of video mode codes.  The same
mode number can indicate a graphics mode on one card, and a text mode
on another card.  Worse yet, BIOS can't tell you what kind of mode it's in.
This is a problem because Nansi gets its speed by bypassing BIOS, which it
can only do in text modes.
.LP
Nansi solves this dilemma by maintaining a 256-entry table, one entry per
possible video mode.  By default, the table says that only modes 0, 1, 2, 3,
and 7 are text modes.  You can add new text modes with the /t option.  For
instance, if modes D hex and 50 hex are text modes, you would invoke Nansi
as follows:
.DS
DEVICE=NANSI.SYS /t0D /t50
.DE
.LP
If your board is in a non-IBM text video mode (for instance, mode 50 hex),
and you haven't added /t50 after NANSI.SYS in CONFIG.SYS, the cursor will
disappear after a CLS command, and the text output will be sluggish; 
furthermore, if you turn on the graphics cursor (by TYPEing the file GC.ON
which came with NANSI), the beginning and end of every text line will be
garbled.
.LP
If you mistakenly specify a graphics mode with the /t option, the display
will be garbled while in that mode.  Get back to normal by typing MODE CO80
or rebooting, and remove the offending /t option from config.sys.
.bp
.NH 1
ANSI Control Sequences
.LP
While putting text up on the screen, NANSI.SYS keeps a lookout for
the escape character (chr(27), known as ESC); this character signals
the start of a terminal control sequence.
Terminal control sequences follow the format
.br
    ESC [ param; param; ...; param cmd
.br
where
.br
    ESC is the escape character chr$(27).
.br
    [ is the left bracket character.
.br
    param is an ASCII decimal number, or a string in quotes.
.br
    cmd is a case-specific letter identifying the command.
.br
Usually, zero, one, or two parameters are given.  If parameters
are omitted, they usually default to 1; however, some commands
(KKR) treat the no-parameter case specially.
Spaces are not allowed between parameters.
.LP
For example, both ESC[1;1H and ESC[H send the cursor to the home
position (1,1), which is the upper left.
.LP
In general, if you ask the cursor to go beyond the edge of the screen, it 
goes to the appropriate edge.  (ANSI.SYS was not always so nice.)
.LP
The following C macro illustrates how one could print a string
at a given location on the screen:
.br
    #define printXY(x,y,s)  printf("%c[%d;%dH%s", 27, y, x, s);
.br
.LP
Either single or double quotes may be used to quote a string.
Each character inside a quoted string is equivalent to one numeric
parameter.  Quoted strings are normally used only for the Keyboard
Key Reassignment command.
.LP
Each ANSI control sequence supported by NANSI.SYS is described below.
The descriptions follow the format
.NH 3
ABBREVIATED_NAME: what_to_send  LONG NAME
.LP
where ABBREVIATED_NAME is a short name for the sequence, what_to_send
tells you what characters make up the sequence, and LONG NAME is a long
name for the sequence.
.bp
.NH 2
Sequences dealing with Cursor Positioning
.NH 3
CUP: ESC[#;#H  Cursor Position
.LP
Moves the cursor to the position specified by the parameters.  The first
parameter, y, specifies the row number; the second parameter, x, specifies
the column number.  If no parameters are given, the cursor is moved to (1,1),
the upper left corner of the screen.  
.LP
.NH 3
HVP: ESC[#;#f  Horizontal and Vertical Position
.LP
This is identical to Cursor Position.  Don't ask me why it exists.
.LP
.NH 3
CUU: ESC[#A    Cursor Up
.LP
Moves the cursor up the given number of rows without changing its horizontal 
position.
.LP
.NH 3
CUD: ESC[#B    Cursor Down
.LP
Moves the cursor down the given number of rows without changing its horizontal 
position.
.LP
.NH 3
CUF: ESC[#C    Cursor Forward
.LP
Moves the cursor right the given number of columns without changing its 
vertical position.
.LP
.NH 3
CUB: ESC[#D    Cursor Backward
.LP
Moves the cursor left the given number of columns without changing its 
vertical position.
.LP
.NH 3
DSR: ESC[#n    Device Status, Report!
.LP
# must be 6.  The sequence ESC[6n causes the console driver to output a CPR
(Cursor Position Report) sequence.
.LP
Note: This sequence is not supported by the ANSI.SYS emulator built into
Microsoft Windows 1.x or 2.x.
.bp
.NH 3
CPR: ESC[#;#R  Cursor Position Report
.LP
The console driver outputs this sequence upon reciept of a DSR sequence.
The first parameter is the cursor's vertical position; the second parameter
is the cursor's horizontal position.
.LP
Note: Contrary to the MS-DOS manual, ANSI.SYS outputs a carriage 
return after this sequence.  NANSI.SYS faithfully reproduces this quirk.
.LP
The resulting string can have up to eleven characters.
For example, if you have a 100-line display (wow), and the cursor is at 
(x=132,y=100), the string will be ESC[132;100R followed by a carriage return.
.LP
This should never be sent to the console driver.
.LP
Also note: This sequence is not supported by the ANSI.SYS emulator built into
Microsoft Windows 1.x or 2.x.
.LP
Here is an example of how to use DSR/CPR to find the current cursor position
with the C language:
.DS
/* Code fragment to get current cursor X and Y from console */
/* Be sure to disable line-buffering on stdin before calling */
./" Note: \e is how to display a backslash in nroff
int x, y, c;
printf("\e033[6n");
fflush(stdout);
if (getchar() != '\e033' || getchar() != '[')
    abort("Console not responding to DSR?");
for (y=0; isdigit(c=getchar()); y=y*10+(c-'0'));
if (c != ';')
    abort("Console CPR faulty?");
for (x=0; isdigit(c=getchar()); x=x*10+(c-'0'));
if (c != 'R')
    abort("Console CPR faulty?");
#ifndef VT100
    getchar();  /* ignore trailing CR */
#endif
.DE
.LP
This can also be useful for sensing screen size.
.LP
.NH 3
SCP: ESC[s      Save Cursor Position
.LP
Saves the cursor's X and Y locations in an internal variable.  See RCP.
.LP
.NH 3
RCP: ESC[u    Restore Cursor Position
.LP
Moves cursor to the position it held when the last SCP sequence was received.
.bp
.NH 2
Sequences that Edit the Display
.NH 3
ED: ESC[#J    Erase in Display
.LP
# must be 2.  Clears the entire screen.
.LP
Note: Contrary to the MS-DOS manual, ANSI.SYS also moves the cursor to the 
upper left corner of the screen.  Contrary to the ANSI standard,
ANSI.SYS does not insist on # being 2.
NANSI.SYS faithfully reproduces these quirks.
(Version 2.2 of NANSI.SYS insisted on # being 2, and it caused compatibility
problems with programs that ignored the MS-DOS manual.)
.LP
.NH 3
EL: ESC[K    Erase in Line
.LP
Deletes from the cursor to the end of the line.
.LP
.NH 3
IL: ESC[#L    Insert Lines
.LP
The cursor line and all lines below it move down # lines, leaving blank
space.  The cursor position is unchanged.
The bottommost # lines are lost.
.LP
Note: This is not supported in ANSI.SYS.
.LP
.NH 3
DL: ESC[#M    Delete Lines
.LP
The block of # lines at and below the cursor are deleted; all lines below
them move up # lines to fill in the gap, leaving # blank lines at the bottom 
of the screen.  The cursor position is unchanged.  
.LP
Note: This is not supported in ANSI.SYS.
.LP
.NH 3
ICH: ESC[#@    Insert Characters
.LP
The cursor character and all characters to the right of it move right #
columns, leaving behind blank space.  The cursor position is unchanged.
The rightmost # characters on the line are lost.
.LP
Note: This is not supported in ANSI.SYS.
.LP
.NH 3
DCH: ESC[#P    Delete Characters
.LP
The block of # characters at and to the right of the cursor are deleted;
all characters to the right of it move left # columns, leaving behind blank 
space.  The cursor position is unchanged.
.LP
Note: This is not supported in ANSI.SYS.
.bp
.NH 2
Sequences that Set Modes
.NH 3
KKR: ESC["string"m   Keyboard Key Reassignment
.LP
The first char (or, for function keys, two chars) of the string gives the 
key to redefine; the rest of the string is the key's new value.
To specify unprintable chars, give the ASCII value of the char
outside of quotes, as a normal parameter.
IBM function keys are two byte strings starting with zero.
For instance, ESC[0;59;"dir a:";13p redefines function key 1 to
have the value "dir a:" followed by the ENTER key.
.LP
There are about 500 bytes available to hold redefinition strings.  Once this
space fills up, new strings are ignored.
.LP
To clear all definitions, send the string ESC[m.
(There was no way to do this in ANSI.SYS.)
.LP
This feature is a security risk, and can be disabled with the /s option
when loading Nansi in config.sys.  See Command-line Options above.
.LP
Here's a table of the ASCII values of the common function keys; for 
others, see the IBM Basic manual or the "IBM PS/2 and PC BIOS Interface 
Technical Reference".
.DS
F1  0;59
F2  0;60
F3  0;61
F4  0;62
F5  0;63
F6  0;64
F7  0;65
F8  0;66
F9  0;67
F10 0;68
.DE
Note: You can't currently access F11 and F12.  IBM made this unpleasant to 
do; you must use a different BIOS call to fetch keys, and that call also 
changes the meaning of several existing keys.
.LP
.NH 3
SGR: ESC[#;#;...#m  Set Graphics Rendition
.LP
The Set Graphics Rendition command is used to select foreground
and background colors or attributes.
When you use multiple parameters, they are executed in sequence, and
the effects are cumulative.
.DS
Attrib     Value
    0      All attributes off (normal white on black)
    1      Bold
    4      Underline
    5      Blink
    7      Reverse Video
    30-37  foreground black/red/green/yellow/blue/magenta/cyan/white
    40-47  background black/red/green/yellow/blue/magenta/cyan/white
.DE
.bp
.LP
.NH 3
SM: ESC[=nh  Set Video Mode
.LP
This sequence selects one of the available video modes. 
The IBM BIOS supports several video modes; the codes given in the
BIOS documentation are used as parameters to the Set Mode command.
(In bitmap modes, the cursor is simulated with a small blob (^V).)
.DS
    Mode Code           Value
        0               text 40x25 Black & White
        1               text 40x25 Color
        2               text 80x25 Black & White
        3               text 80x25 Color
        4               bitmap 320x200 4 bits/pixel
        5               bitmap 320x200 1 bit/pixel
        6               bitmap 640x200 1 bit/pixel
        13              bitmap 320x200 4 bits/pixel
        14              bitmap 640x200 4 bits/pixel
        15              bitmap 640x350 1 bit/pixel
        16              bitmap 640x350 4 bits/pixel
        17              bitmap 640x480 1 bit/pixel
        18              bitmap 640x480 4 bits/pixel
        19              bitmap 320x200 8 bits/pixel

.DE
Modes 0, 1, and 4-19 require a CGA, EGA or VGA.
.br
Modes 13-16 require an EGA or VGA.
.br
Modes 17-19 require a VGA.
.br
Other graphics cards may support other video modes.
.LP
The EGA and VGA let you use a shorter character cell in text modes
in order to squeeze more lines of text out of the 25-line text modes.
To enter short line mode, set the desired 25-line text mode (0 to 3),
then Set Mode 43.  For instance: ESC[=3h ESC[=43h.
To exit short line mode, set the desired 25-line text mode again.
On IBM VGA cards, this sequence gives you a 50 line screen.
NANSI.SYS ignores mode 43 unless there is an EGA or VGA on your computer.
.bp
.NH 3
SM: ESC[?nh  Set Nonvideo Mode
.LP
This sequence is used to set non-video modes.  The only value supported is
.DS
    Mode Code           Value when set
        7               Cursor wraps at end of line

.DE
Setting mode 7 tells the cursor to wrap around to the next line when it 
passes the end of a line.
.NH 3
RM: ESC[?nl  Reset Nonvideo Mode
.LP
This sequence is used to reset non-video modes.  The only value
supported is
.DS
    Mode Code           Value when reset
        7               Cursor stops at end of line

.DE
Resetting mode 7 tells the cursor to 'stick' at the end of the line instead
of wrapping to the next line.
.bp
.NH 1
Background - What does a console driver do, and how?
.LP
A console driver consists of subroutines which are called by MS-DOS.
MS-DOS itself is mostly just subroutines which can be called by application 
programs.
.LP
Programs that want to display text on the screen can call the "Write"
subroutine provided by MS-DOS.  This subroutine in turn calls the "Write"
subroutine of the console driver.
.LP
When you, for example, type
.br
    C> type foo.txt
.br
COMMAND.COM uses the "Read" subroutine of MS-DOS to read the file "foo.txt"
from the disk; it then uses the "Write" subroutine of MS-DOS with the
file's contents.  MS-DOS then calls the console driver's "Write" subroutine, 
which finally puts the data up on the screen.
.LP
Both ANSI.SYS and NANSI.SYS use IBM Video BIOS to control the screen.
However, NANSI.SYS writes directly to the screen in text modes; this
allows much faster operation.
.LP
.NH 1
How to Display Text Quickly
.LP
Output to the screen via DOS is usually slow because characters are sent
one-at-a-time through several layers of software.  Application programs often
call a DOS function for each character or line.
.LP
To avoid this overhead, application programs should write as many characters 
per DOS call as possible (in C programs, this means using setbuf(), fflush(), 
and buffered output).
.LP
Another problem is that application programs sometimes send line after line of 
text, letting the cursor stay at the bottom of the screen.  
This forces the console driver to scroll the entire screen up once for 
each line displayed, which is rather expensive.
.LP
This can be fixed by having the application program clear the screen and home
the cursor after each page of output.
.LP
Finally, the biggest problem is that DOS calls the device driver once or twice 
for each character written.
.LP
Fortunately, DOS can be told to pass the entire write request directly to 
the device driver; this is called "raw" mode.
The files RAW.C and RAW.H, included in this package, provide an easy way
to set and clear "raw" mode, to turn break checking on and off, and to
check for keystrokes when in raw mode.
.LP
Even if you follow all these rules, output with ANSI.SYS will still be
very slow, simply because ANSI.SYS was written to be portable, with total 
disregard for performance.  NANSI.SYS, on the other hand, was written by
a performance fanatic.
.NH 1
NANSI and Microsoft Windows
.LP
Microsoft Windows 1.x and 2.x allowed you to run command.com in a window,
but did not give you access to NANSI.SYS.  Windows 3.0 gives you
full access to NANSI.SYS, even when running command.com in a window (wow!).
However, you can only do this if you have a 386-based computer (boo, hiss);
on other computers, Windows runs command.com only in full screen mode.
.LP
Under Microsoft Windows 3.0, if you write text to stdout in RAW mode,
the display is not refreshed until the end of the write; no intermediate
scrolling is shown.  I suspect this is because Windows doesn't refresh the
display until display memory hasn't been touched for a few milliseconds.
.NH 1
.LP
Enhancements since version 3.0 of NANSI.SYS
.LP
A new escape sequence has been added to enable and disable the
simulated cursor in graphics mode (see SET MODE 99).  The graphics cursor
is disabled by default.
.LP
Nansi can now sense options given on the DEVICE=NANSI.SYS line in config.sys.
.LP
A command-line option has been added to disable the keyboard redefinition
escape sequence.  This closes up a big security loophole.
.LP
A command-line option has been added to allow the user to tell Nansi
about nonstandard text video modes (see COMMAND-LINE OPTIONS).  This
is important if you want to use non-IBM text modes properly, as Nansi
treats nonstandard modes as graphics by default, which results in slower
display.
.NH 1
Enhancements since version 2.2 of NANSI.SYS
.LP
Now obeys BIOS's idea of number of screen lines, when supported.
.LP
Works properly when on video pages greater than zero, too.
.LP
Supports 132-column displays.
.LP
Deleted Output Character Translation feature.  It took up 260 bytes,
and nobody ever used it.
.LP
Fixed bug related to setting background color while in graphics mode.
.LP
No longer assumes AH is zero upon entry to driver.  
.LP
.bp
.NH 1
Limitations in the current version of NANSI.SYS
.LP
Video modes are specified in hexadecimal on the command line, and
in decimal in escape sequences.  This is a needless inconsistancy, but since
users' manuals usually specify the mode numbers in hex, it shouldn't be
too big a bother.
You can convert a hexadecimal number to decimal in BASIC with the print
command.  For example, from the DOS prompt, typing
.DS
C:>basic
print &h7f
system
.DE
displays "127".
.LP
All parameter values must be between 0 and 255.
.LP
The maximum number of characters available for keyboard redefinition is 500.
Any single keyboard redefinition escape sequence must be shorter than (500 - 
(total keyboard redefinition space already used)) bytes.
.LP
The user should be able to turn off keyboard redefinition, due to the
possibility that this feature can be used for a Trojan Horse attack
via E-Mail or public domain program documentation.
.LP
Insert and delete character do not work in graphics modes.
.LP
Graphics mode writing is slow.
.LP
Does not support erase-to-end-of-screen and other useful functions.
.LP
Nansi determines whether the BIOS number-of-screen-lines variable is supported
by checking for an EGA card.  There might be a better way.
.LP
Nansi only checks for an EGA or VGA card at startup time.  If you have
two video cards installed, and one shows more text lines per screen than the
other, AND you switch between the cards without rebooting, Nansi could 
conceivably become confused about the number of text lines on the screen.
.LP
Nansi currently assumes that function keys start with a zero byte.  
The new keys (e.g. F11 and F12) don't, so Nansi will have to change a little
to support them.
