; Mouse Protocol Analyzer for serial mice
; Copyright (c) 1997-2000 Nagy Daniel <nagyd@almos.vein.hu>
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU Library General Public
; License along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
;

;
; History:
;
; 1.3 - made by Arkady V.Belousov <ark@mos.ru>
;	Added parsing and showing PNP data
; 1.2 - made by Arkady V.Belousov <ark@mos.ru>
;	Source synchronized with CTMOUSE source
;	Added command line option for COM LCR value
;	Added dumping of reset sequence, generated by mouse
; 1.1 - Added command line option for COM port selection
; 1.0 - First public release
;

WARN

j		equ	jmp short

movSeg		macro	dest,src
		push	src
		pop	dest
	endm

saveFAR		macro	addr,segm,offs
		mov	word ptr addr[0],offs
		mov	word ptr addr[2],segm
	endm

PrintS		macro	addr
	IFNB <addr>
	 IFDIFI <addr>,<dx>
		mov	dx,offset addr
	 ENDIF
	ENDIF
		mov	ah,9
		int	21h
	endm

.model tiny
.code
		org	100h
start:		jmp	real_start

oldIRQaddr	dd	?		; old IRQ handler address

IO_address	dw	?		; IO port number
IRQintnum	db	?,25h		; INT number of selected IRQ
PICstate	db	?		; indicates which bit to clear in PIC
IOdone		db	0		; indicates processed mouse bytes
limit		db	?
COMLCR		db	?

CRLF2		db	0Dh,0Ah
CRLF		db	0Dh,0Ah,'$'
S_syntax	db	'Syntax: protocol <COM (1-4)> <bytes per event (3-5)> <COM LCR value (2-3)>',0Dh,0Ah,'$'
S_notCOM	db	'COM port doesn',39,'t found!',0Dh,0Ah,'$'

S_1200		db	'1200 bps, $'
S_2400		db	'2400 bps, $'
S_LCRvalue	label	byte
databits	db	'5 data bits, '
stopbits	db	'1 stop bit.',0Dh,0Ah,'Reset:$'
S_spaces	db	0Dh,0Ah,'      $'
S_bitbyte	db	' 00000'
S_byte		db	' 00$'

S_CRCerr	db	0Dh,0Ah,0Dh,0Ah,'PNP CRC error...$'
S_manufact	db	0Dh,0Ah,0Dh,0Ah,'Manufacturer: $'
S_product	db	0Dh,0Ah,'  Product ID: $'
S_serial	db	0Dh,0Ah,'    Serial #: $'
S_class		db	0Dh,0Ah,'       Class: $'
S_driverid	db	0Dh,0Ah,'   Driver ID: $'
S_username	db	0Dh,0Ah,'   User name: $'

dummy		db	?,?

;
;				IRQ handler
;

IRQhandler	proc	far
		cld
		push	ds ax bx cx dx si di bp es
		movSeg	ds,cs
		mov	al,20h
		out	20h,al			; {20h} end of interrupt

		mov	dx,[IO_address]
		add	dx,5
		in	al,dx			; {3FDh} check for overrun
		mov	ah,al
		sub	dx,5
		in	al,dx			; {3F8h} flush receive buffer
		xchg	ah,al

		test	al,2
		jnz	@@restart		; jump if overrun occured
		test	al,1
		jz	@@exitIRQ		; jump if data not ready
;----------
		movSeg	es,cs
		mov	di,offset S_bitbyte+1
		mov	cx,8			; 8 bits
@@nextbit:	mov	al,'0' SHR 1
		rol	ax,1
		stosb
		loop	@@nextbit
		PrintS	S_bitbyte
;----------
		inc	[IOdone]
		mov	al,[IOdone]
		cmp	al,[limit]
		jb	@@exitIRQ

		PrintS	CRLF
@@restart:	mov	[IOdone],0		; zero counter

@@exitIRQ:	pop	es bp di si dx cx bx ax ds
		iret
IRQhandler	endp

;

resetmouse	proc
		mov	dx,si
		add	dx,3
		mov	al,80h
		out	dx,al			; {3FBh} set DLAB on

		mov	dx,si
		in	ax,dx			; {3F8h},{3F9h} get speed
		mov	cx,ax

;---------- show communications parameters
		mov	dx,offset S_1200
		cmp	cx,96
		je	@@printspeed
		mov	dx,offset S_2400
@@printspeed:	PrintS

		mov	al,[COMLCR]
		mov	ah,al
		and	al,3
		add	[databits],al
		shr	ah,3
		adc	[stopbits],0
		PrintS	S_LCRvalue
;----------
		mov	dx,si
		add	dx,3
		mov	al,[COMLCR]
		out	dx,al			; {3FBh} set comm params

;---------- pulse (drop and raise) RTS signal
		xor	ax,ax
		mov	es,ax
		inc	dx
		mov	di,es:[46Ch]
@@wait1:	cmp	di,es:[46Ch]
		je	@@wait1			; wait timer tick start
		out	dx,al			; {3FCh} DTR/RTS/OUT2 off

		mov	al,3
		mov	di,es:[46Ch]
@@wait2:	cmp	di,es:[46Ch]
		je	@@wait2			; wait timer tick end
		out	dx,al			; {3FCh} DTR/RTS on, OUT2 off

;---------- read and show reset sequence, generated by mouse
		mov	bx,20			; output counter
		mov	di,offset PNPdata
@@inloop:	mov	cx,2			; length of silence in ticks
		mov	dx,si
		add	dx,5
		push	di
@@timeloop:	mov	di,es:[46Ch]
@@waitloop:	in	al,dx			; {3FDh} line status reg
		test	al,1
		jnz	@@showbyte		; jump if data ready
		cmp	di,es:[46Ch]
		je	@@waitloop		; jump if same tick
		loop	@@timeloop		; wait next tick of silence
		pop	di
		j	@@parsePNP

;---------- save and show next byte
@@showbyte:	pop	di
		mov	dx,si
		in	al,dx			; {3F8h} receive byte
		mov	[di],al
		inc	di
		mov	ah,48
		mov	cl,4
		push	ax
		shr	al,cl
		or	ax,ax			;!!! clear AC flag
		aaa
		db	0D5h,17			; aad 17
		mov	S_byte[1],al
		pop	ax
		or	ax,ax			;!!! clear AC flag
		aaa
		db	0D5h,17			; aad 17
		mov	S_byte[2],al
		PrintS	S_byte
		dec	bx
		jnz	@@inloop
		PrintS	S_spaces
		mov	bl,20
		j	@@inloop

;---------- parse and show PNP data
@@parsePNP:	mov	cx,di
		mov	di,offset PNPdata
		sub	cx,di
		jcxz	@@resetret
@@findstart:	mov	al,[di]
		cmp	al,'('-20h
		je	@@startcrc
		inc	di
		loop	@@findstart
		j	@@resetret

@@startcrc:	mov	bx,di
		mov	al,0
@@crcloop:	add	al,[di]
		cmp	byte ptr [di],')'-20h
		je	@@checkcrc
		add	byte ptr [di],20h
		inc	di
		loop	@@crcloop
		j	@@resetret

@@checkcrc:	dec	di
		sub	al,[di]
		dec	di
		sub	al,[di]
		add	al,20h+20h
		mov	ah,48
		mov	cl,4
		push	ax
		shr	al,cl
		or	ax,ax			;!!! clear AC flag
		aaa
		db	0D5h,17			; aad 17
		mov	cl,al
		pop	ax
		or	ax,ax			;!!! clear AC flag
		aaa
		db	0D5h,17			; aad 17
		mov	ch,al
		cmp	cx,[di]
		je	@@showPNP
		PrintS	S_CRCerr
		j	@@resetret

@@showPNP:	mov	cx,3
		add	bx,cx
		mov	dx,offset S_manufact
		call	print1PNPfield
		mov	cx,4
		mov	dx,offset S_product
		call	print1PNPfield
		cmp	byte ptr [bx],'\'
		jne	@@resetret
		mov	dx,offset S_serial
		call	print2PNPfield
		mov	dx,offset S_class
		call	print2PNPfield
		mov	dx,offset S_driverid
		call	print2PNPfield
		mov	dx,offset S_username
		call	print2PNPfield

@@resetret:	PrintS	CRLF2
		ret
resetmouse	endp

;

print1PNPfield	proc
		PrintS
		mov	ah,2
@@print1loop:	mov	dl,[bx]
		inc	bx
		int	21h
		loop	@@print1loop
@ret:		ret
print1PNPfield	endp

print2PNPfield	proc
		PrintS
		mov	ah,2
@@print2loop:	inc	bx
		cmp	bx,di
		jae	@ret
		mov	dl,[bx]
		cmp	dl,'\'
		je	@ret
		int	21h
		j	@@print2loop
print2PNPfield	endp

;

disableCOM	proc
		in	al,21h			; {21h} get PIC mask
		or	al,[PICstate]		; disable serial interrupts
		out	21h,al
;----------
		mov	dx,si
		add	dx,3
		mov	al,0
		out	dx,al			; {3FBh} set DLAB off
		inc	dx
		in	al,dx			; {3FCh} modem ctrl
		and	al,0F3h
		out	dx,al			; {3FCh} OUT2 off
		sub	dx,3
		mov	al,0
		out	dx,al			; {3F9h} all interrupts off
		ret
disableCOM	endp

;

enableCOM	proc
		mov	dx,si
		add	dx,3
		mov	al,[COMLCR]
		out	dx,al			; {3FBh} set comm params
		inc	dx
		mov	al,0Bh
		out	dx,al			; {3FCh} DTR/RTS/OUT2 on
		sub	dx,3
		mov	al,1
		out	dx,al			; {3F9h} DR int enable
;----------
		in	al,21h			; {21h} get PIC mask
		mov	ah,[PICstate]
		not	ah
		and	al,ah			; enable serial interrupts
		out	21h,al
		ret
enableCOM	endp

;

setCOMport	proc
		xor	bx,bx
		mov	es,bx
		mov	bl,al
		shl	bx,1
		mov	cx,es:400h[bx]
		stc
		jcxz	@@setCOMret
		mov	[IO_address],cx

		shr	al,1
		mov	al,4			; IRQ4 for COM1/3
		jnc	@@setIRQ
		dec	ax			; OPTIMIZE: AX instead AL
						; IRQ3 for COM2/4
@@setIRQ:	mov	cl,al
		add	al,8
		mov	[IRQintnum],al
		mov	al,1
		shl	al,cl
		mov	[PICstate],al		; PIC interrupt enabler
		;clc
@@setCOMret:	ret
setCOMport	endp

;

skipwhite	proc
@@skiploop:	cmp	si,di
		jae	SYNTAX
		lodsb
		cmp	al,' '
		jbe	@@skiploop
@@skipret:	ret
skipwhite	endp


; Real Start 

SYNTAX:		lea	dx,S_syntax
EXITERRMSG:	PrintS
		int	20h

real_start:	cld
		mov	si,80h
		lodsb
		mov	ah,0
		mov	di,ax
		add	di,si

		call	skipwhite
		sub	al,'1'
		jb	SYNTAX
		mov	dx,offset S_notCOM
		cmp	al,3
		ja	EXITERRMSG
		call	setCOMport
		;mov	dx,offset S_notCOM
		jc	EXITERRMSG

		call	skipwhite
		sub	al,'0'
		jbe	SYNTAX
		mov	[limit],al

		call	skipwhite
		sub	al,'0'
		jb	SYNTAX
		mov	[COMLCR],al
;----------
		mov	si,[IO_address]
		call	disableCOM
		mov	al,[IRQintnum]
		mov	ah,35h
		int	21h
		saveFAR [oldIRQaddr],es,bx
		mov	ax,word ptr [IRQintnum]
		mov	dx,offset IRQhandler
		int	21h

		call	resetmouse
		call	enableCOM
		xor	ah,ah
		int	16h

		call	disableCOM
		mov	ax,word ptr [IRQintnum]
		lds	dx,[oldIRQaddr]
		int	21h

		mov	ax,3533h
		int	21h
		mov	ax,es
		or	ax,bx
		jz	@@exit
		xor	ax,ax
		int	33h
@@exit:		int	20h

;
PNPdata		label	byte
		end	start
