LOCAL void	FAST_	say		(CStr);
LOCAL void	FAST_	sayv		(CStr format, count);
LOCAL void	FAST_	say_error	(CStr, CStr);
LOCAL void	FAST_	pause_		(count fill, count reserve, CStr);
LOCAL void	FAST_	new_line	(void);

LOCAL count	STACK_	mul_div2	(ulong, count m, count shift);
LOCAL void	STACK_	scale_sz_	(ulong, count shift, char [5]);
LOCAL PStr	STACK_	scale_sz	(ulong, count shift, char [6]);

/*----------------------------------------------------------------------*/

LOCAL void FAST_ say (CStr s) { printf ("%s", s); }

LOCAL void FAST_ sayv (CStr format, count v) { printf (format, v); }

LOCAL void FAST_ say_error (CStr s1, CStr s2) {
	printf ("\nMEM: error: %s%s\n", s1, s2);
}

LOCAL void FAST_ pause_ (count fill, count reserve, CStr s) {
	if (SYS.screen.pause) {
		fill++;
		count filled = SYS.screen.filled + fill;

		SYS.screen.filled = filled;
		if (filled  < SYS.screen.last_row &&
		    reserve < SYS.screen.last_row - filled) {
			say ("\n"); say (s); return;
		}

		SYS.screen.filled = fill;
		say ("\nPress <Enter> to continue or <Esc> to exit...");
		if ((byte) inkey () == 27) exit (EXIT_ESC);
		say ("\r\t\t\t\t\t\t\r");
	} else	say ("\n");
	say (s);
}

LOCAL void FAST_ new_line (void) { pause (0, 0); }

/*----------------------------------------------------------------------*/

/* return v * m / 2**shift;						*/
/* assume ([log2 (v*m)] < 16 + shift < 16 + 48);			*/

#define I asm

LOCAL count STACK_ mul_div2 (ulong v, count m, count shift) {
	/* w = 65536, v * m = (vh*w + vl) * m = vh*m*w + vl*m		*/
	_CX = m; I mov ax,word ptr [v+2]; I mul cx;	/* dx:ax=vh*m	*/
	_BX = _DX; I xchg cx,ax; I mul word ptr [v];	/* dx:ax=vl*m	*/
	I add dx,cx; I adc bx,0;			/* bx:dx:ax=v*m	*/

	for (_CL = shift; _CL >= 8; _CL -= 8) {
		_AL = _AH, _AH = _DL,
		_DL = _DH, _DH = _BL,
		_BL = _BH, _BH = 0;
	}
	_DH = _DL, _DL = _AH; I shr dx,cl; I shr ax,cl; _AH = _DL;
	return _AX;
}

LOCAL void STACK_ scale_sz_ (ulong v, count shift, char buf [5]) {
	static const char suffix [] = { ' ', 'k', 'M', 'G', 'T', 'P' };

	char *p = buf + 3; *p = '0';
	count vpart = (count)(v >> (sizeof (count) * CHAR_BIT));
	count v_len = sizeof (count) * CHAR_BIT - 1u;
	if (vpart == 0) {
		vpart = (count)v;
		if (vpart == 0) return;
		v_len = -1u;
	}
	do v_len++, vpart >>= 1; while (vpart);
	/* 0 < 2**v_len <= v < 2**(v_len+1)				*/

	/* assert (v_len + shift < 60);					*/
	count thousands = (v_len + shift) / 10u;
	*++p = suffix [thousands];

	count frac_len = thousands * 10u;	/* total fraction bits	*/
	/* 2**frac_len <= v*2**shift < 2**(frac_len + 10)		*/

	if (frac_len < shift) {
		/* 1 < v*2**(shift-frac_len) < 1024 && v < 512		*/
		shift -= frac_len;
		v = (count)v << shift;
		shift = frac_len;
	}
	shift = frac_len - shift;		/* real fraction bits	*/
	count mant = (count)(v >> shift);

	if (mant < 100 && frac_len) {
		mant = mul_div2 (v, 100, shift);
		if (mant < 1000) *--p = mant % 10u + '0'; mant /= 10u;
				 *--p = mant % 10u + '0'; mant /= 10u;
		*--p = '.';
	}

	/* assume (mant < 1024); */
	do {	*--p = mant % 10u + '0';
		mant /= 10u;
	} while (mant);
}

LOCAL PStr STACK_ scale_sz (ulong v, count shift, char buf [6]) {
	memfill (buf, 5); buf [5] = '\0';
	scale_sz_ (v, shift, buf);
	return buf;
}
