 ; This file is part of LBAcache, the 386/XMS DOS disk cache by
 ; Eric Auer (eric@coli.uni-sb.de), 2001-2003.

 ; LBAcache is free software; you can redistribute it and/or modify
 ; it under the terms of the GNU General Public License as published
 ; by the Free Software Foundation; either version 2 of the License,
 ; or (at your option) any later version.

 ; LBAcache is distributed in the hope that it will be useful,
 ; but WITHOUT ANY WARRANTY; without even the implied warranty of
 ; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ; GNU General Public License for more details.

 ; You should have received a copy of the GNU General Public License
 ; along with LBAcache; if not, write to the Free Software Foundation,
 ; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ; (or try http://www.gnu.org/licenses/licenses.html at www.gnu.org).

; LBAcache - a hard disk cache based on XMS, 386 only,
; and aware of the 64bit LBA BIOS Int 13 Extensions.
; GPL 2 software by Eric Auer <eric@coli.uni-sb.de> 2001-2003

; Check out the CHS version as well (limited to 8 GB,
; uses less DOS memory, and wimps out on LBA write)...


; this is a silly com-loader to make a com-tsr out of
; what was created to be a sys-driver... as small as
; possible, of course.

bits 16
segment .text

	org 0x100	; it is a .com file!


	; save some memory by storing some data by overwriting
	; the beginning of our code!
%define stratfar 0x100
%define intrfar 0x104


entry:		; guess: the entry point
	jmp pastcom	; jmp near
commagic:
	; db "COMCACHE"	; magic, will be written later!
pastcom:			; (ES will be reset to CS later)

	mov es,[cs:0x2c]	; environment segment
	; see Ralf Browns IntList table 1379 (PSP: 1378)
	mov ah,0x49
		int 0x21	; free the environment!
				; (jc "could not free... bla")

	push cs			; set segments to sane again
	pop es
	push cs
	pop ds

	; we do nothing to copy the command line,
	; as lbacache can handle the .com string EOF
	mov [ds:clseg],ds	; obvious

	mov [ds:syseofs],sp	; *** NEW 11/2002: used! could be
				; *** 0x(1)0000 for the moment

	mov bx,systhing		; *offset* of our structure

	mov cl,4
	mov ax,syspoint		; *offset* of sys header
	shr ax,cl
	mov bp,cs
	add ax,bp		; now we have the sys segment

	mov [ds:stratfar+2],ax	; sysseg
	mov [ds:intrfar+2],ax	; sysseg

	sub word [ds:syseofs],syspoint+200	; *** NEW 11/2002
	mov [ds:syseseg],ax	; *** NEW 11/2002: init to sysseg

			; far link pointer and attrib are skipped
	mov ax,[ds:syspoint+6]	; read strategy pointer
	mov [ds:stratfar],ax
	mov ax,[ds:syspoint+8]	; read "interrupt" pointer
	mov [ds:intrfar],ax

	call far [cs:stratfar]	; give ES BX to sys part
	jmp instthatsys

; -------------

align 4
leStack:	; dd 0	; past the last dword of our bonus stack!

; -------------

instthatsys:
	mov sp,leStack-4	; make stack as big as possible!
				; if SP will be < 0x80, big trouble...
				; if ... in cmdline, small trouble :-)
	call far [cs:intrfar]	; start the main action!

	; The sys part will have returned a far pointer
	; telling us how much of it is going to stay TSR.
	; For now, lbacache NEVER returns any other useful
	; information through the SYS interface than this
	; pointer!

	mov bp,cs	; bp -> cs
	mov ax,[ds:syseofs]	; where first free byte is
	cmp ax,0xfff0
	jbe rndok
	mov ax,0x1000	; 0x10000 shr 4 needs special treating
	jmp short rndbig
rndok:
	add ax,15	; round up
	mov cl,4
	shr ax,cl	; paragraphs
rndbig:
	add ax,[ds:syseseg]
	sub ax,bp	; ,cs	; size of TSR in paragraphs
	mov bx,syspoint
	mov cl,4
	shr bx,cl	; size of loader in paragraphs
	cmp ax,bx
	jz comexit	; zero bytes of TSR
	jb comwimp	; < zero bytes of TSR ???

	mov bp,ax	; size again

	mov word [cs:syspoint],0x100	; bonus magic to be written:
	mov word [cs:syspoint+2],cs	; point to com part
				; (useful to find the MCB later!)

; -------------

comtsr:				; go TSR
	mov al,'Y'		; TSR status is "YES"
		call endall	; show message etc.
	mov dx,bp		; SIZE IN PARAGRAPHS
	mov ax,0x3100		; modern DOS TSR API
	int 0x21		; terminate and stay resident

; -------------

comexit:
	mov al,'N'		; TSR status is "NO"
		call endall	; show messages etc.
	jmp short comexit2

; -------------

comwimp:
	mov al,'?'		; TSR status is "STRANGE"
		call endall	; show message etc.
	mov ah,0
		int 0x16	; wait for a key
comexit2:

	; if the exit would be due to an error, we could
	; restore int 13 from some backup here - but we
	; may NOT restore it if the "no tsr" state is deliberate!

	mov ax,0x4c01
		int 0x21	; exit with an errorlevel of 1

; -------------

endall:	pop si			; return pointer!
	push cs
	pop ds			; restore...
	push cs
	pop es			; ...segments
	mov sp,0xfc		; move stack into cmdline
	mov [tsrxmsg],al	; insert status :-)
	push si	; save
	mov di,commagic		; *offset*
	mov si,commagbak	; *offset
	cld
	movsw			; write the magic value "COMCACHE"
	movsw			; (was inside potential stack...)
	movsw
	movsw
	pop si	; restore
	mov dx,tsrmsg	; *offset*
	push ax	; save
	mov ah,9
		int 0x21	; show our status
	pop ax	; restore
	jmp si			; return pointer!

; -------------

; stratfar	dd 0	; far pointer (moved up...)
; intrfar	dd 0	; far pointer (moved up...)

int13combak	dd 0	; remember, in case of error

systhing:	; the data structure expected by the sys
		; as we are only targetting lbacache, most
		; elements are not used!
	db 0x18	; 00: length (fixed to 0x18 for command 0)
	db 0	; 01: ?			subunit
	db 0	; 02: command: 0 means init
	dw 00	; 03: flags, only written by lbacache but not read
	dd 0,0	; 05: ... 8 reserved bytes
	db 0	; 0D: ?			number of drives
		;     the rest is specific to the command
		;     ( in our case the command is INIT )
syseofs	dw 0	; 0E: offset where sys tsr ends
syseseg	dw 0	; 10: segment where sys tsr ends
clofs	dw 0x81	; 12: offset of command line
clseg	dw 0	; 14: segment of command line
	db 0	; 16: ?
	db 0	; 17: a returned status code
	db 0	; 18: flags: msb set to mark [17] as valid
		; I hope the structure ends here!
	
; -------------

tsrmsg
commagbak	db "COMCACHE"	; the magic string, do not change!
		db " TSR: "
tsrxmsg:
crlfmsg		db "X",13,10,"$"	; X -> Y/N/? for tsr status

align 16	; start at a new segment/paragraph

; -------------

syspoint:	; sys starts with: a field for a far pointer to the
		; next driver, a word for attributes, 2 near pointers
		; to strat (saves esbx) and int (handles the request)
		; functions (use call far!), and a padded 8 char name.

; *** Combine the DOS way: copy /b comcache + lbacache.sys lbacache.com
; *** Unix way: cat comcache lbacache.sys > lbacache.com
