/*  Label

    Version 1.4

    Modified by Joe Cosentino 2000,2003.
    Modified by Brian E. Reifsnyder, August 2000.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include <io.h>
#include <dos.h>
#include <stdlib.h>
#include <string.h>

// D E F I N E S ////////////////////////////////////////////////////////////

#define VERSION          "1.4"          // Added the VERSION definition...BER
#define BAD_CHARS        21
#define MAX_LABEL_LENGTH 11
#define DRIVE            7
#define NAME             8
#define ENDNAME          19
#define SPACEBAR         ' '
#define DBQ              '"'
#define REMOTE           0x9
#define IOCTL            0x44
#define PATHLEN          64

// G L O B A L S ////////////////////////////////////////////////////////////

char bad_chars[BAD_CHARS] = "*?/\\|.,;:+=<>[]()&^\"",Drive[3]="?:",TempDrive[3] = "?:",Label[13]="",OldLabel[13]="",newline[2]={0xd, 0xa},curdir[PATHLEN]={0},rootdir[4]="?:\\",getsbuf[MAX_LABEL_LENGTH+3],input_redir=-1;
int NoLabel=1,firsttime=1,DriveNotFirst=0;
char fcb[128]={0xff, 0, 0, 0, 0, 0, 0x8, 0, '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?'};
char con_fcb[44]={0xff, 0, 0, 0, 0, 0, 0, 0, 'C', 'O', 'N',' ',' ',' ',' ',' ',' ',' ',' '};
char creat_fcb[44]={0xff, 0, 0, 0, 0, 0, 0x8, 0, ' ', ' ', ' ',' ',' ',' ',' ',' ',' ',' ',' '};

// P R O T O T Y P E S //////////////////////////////////////////////////////

int classify_args(int, char *[], char *[], char *[]);
void myprintf(char [], int);
void mygets(char *, unsigned int);
void hexprint(char);
void far _interrupt ctrlc_hndlr();
int valid_drive(char *);
void GetDrive();
void get_label();
void disp_label();
int make_label();
void del_label();
void save_label(char *);
int check_label(char *);
int valid_label(char *);
void do_cmdline(int, char *[]);
int check_quotes();
void on_exit();

// F U N C T I O N S ////////////////////////////////////////////////////////

int classify_args(int narg, char *rawargs[], char *fileargs[], char *optargs[])
{
    int index, jndex, kndex;
    char *argptr;

    for (index=0,jndex=0,kndex=0;index<narg;index++)
        {
        argptr = rawargs[index];
        if (*argptr == '/')
            {
            argptr++;
            optargs[kndex++] = argptr;
            } // end if.
        else
            {
            fileargs[jndex++] = argptr;
            } // end else.
            
        } // end for.

   return kndex;

} // end classify_args.

/////////////////////////////////////////////////////////////////////////////

void GetCurDir(union REGS regs, char *dir)
{
    regs.x.ax=0x4700;
    regs.h.dl=0;
    regs.x.si=(unsigned)dir;
    intdos(&regs, &regs);

} // end GetCurDir.

/////////////////////////////////////////////////////////////////////////////

void SetCurDir(union REGS regs, char *dir)
{
    regs.x.ax=0x3B00;
    regs.x.dx=(unsigned)dir;
    intdos(&regs,&regs);

} // end SetCurDir.

/////////////////////////////////////////////////////////////////////////////

void myprintf(char string[], int len)
{
    union REGS regs;

    if (!len)
        len=strlen(string);

    regs.h.ah=0x40;
    regs.x.bx=1;
    regs.x.cx=len;
    regs.x.dx=(unsigned)string;
    intdos(&regs,&regs);

} // end myprintf.

/////////////////////////////////////////////////////////////////////////////

void mygets(char *buff, unsigned int length)
{
    char *sptr;
    int i;
    union REGS regs;

    if (input_redir==-1)
        {
        regs.h.ah=0x44;
        regs.h.al=0x0;
        regs.x.bx=0x0;
        intdos(&regs, &regs);
        if (regs.x.dx & 0x80)
            input_redir = 0;
        else
            input_redir = 1;

        } // end if.

    if (input_redir)
        {
        regs.h.ah=0xb;
        intdos(&regs,&regs);
        if (regs.h.al==0)
            {
            puts("");
            exit(10);
            } // end if.

        } // end if.

    getsbuf[0]=(char) length;
    getsbuf[2]=0;
    regs.x.dx=(unsigned) getsbuf;
    regs.h.ah=0xa;
    intdos(&regs,&regs);
    puts("\r");
    sptr = &getsbuf[2];
    if (*sptr==0x1a)
        {
        puts("");
        exit(10);
        } // end if.

    for (i=0;i<getsbuf[1];i++)
        *buff++=*sptr++;

    *buff='\0';

} // end mygets.

/////////////////////////////////////////////////////////////////////////////

void hexprint(char c)
{
    unsigned char temp;

    temp=c;                             // Print hi.
    temp=temp>>4;
    if (temp<10)
        temp+='0';
    else
        temp+=('A'-10);

    printf(&temp);
    temp=c & 0xf;                       // Print lo.
    if (temp<10)
        temp+='0';
    else
        temp+=('A'-10);

    printf(&temp);

} // end hexprint.

/////////////////////////////////////////////////////////////////////////////

void far _interrupt ctrlc_hndlr()
{
    exit(0);

} // end ctrlc_hndlr.

/////////////////////////////////////////////////////////////////////////////

int valid_drive(char *s)
{
    char buf1[128],buf2[128];
    struct SREGS sregs;
    union REGS regs;

    if (s[1] != ':')
        return(0);

    *TempDrive=*s;

    // Make sure this is a valid drive.
    con_fcb[DRIVE]=*TempDrive-'A'+1;
    regs.x.ax=0x0f00;
    regs.x.dx=(unsigned)con_fcb;
    intdos(&regs, &regs);
    if (regs.h.al)
        {
        printf("Not a valid drive\n");
        exit(1);
        } // end if.

    regs.x.ax=0x1000;
    regs.x.dx=(unsigned)con_fcb;
    intdos(&regs, &regs);                 // Now close the file.

    // Make sure user is not trying to label a network drive.
    regs.h.ah=IOCTL;
    regs.h.al=REMOTE;
    regs.h.bl=(char)(*TempDrive-'A'+1);
    intdos(&regs, &regs);
    if (regs.x.dx & 0x1000)
        {
        printf("You cannot label a network drive\n");
        exit(5);
        } // end if.

    // Make sure the user is not trying to label a drive which has
    // been ASSIGNed, JOINed, or SUBSTed.
    strcpy(buf1, TempDrive);
    strcat(buf1, "\\");
    segread(&sregs);
    regs.x.si=(unsigned)buf1;
    regs.x.di=(unsigned)buf2;
    regs.x.ax=0x6000;
    intdosx(&regs, &regs, &sregs);
    if (*buf1 != *buf2)
        {
        printf("You cannot label a drive which has\n"
               "been ASSIGNed, JOINed, or SUBSTed.\n");
        exit(5);
        } // end if.

    return(1);

} // end valid_drive.

/////////////////////////////////////////////////////////////////////////////

void GetDrive()
{
    unsigned driveno;

    _dos_getdrive(&driveno);
    Drive[0]=(char) driveno+'A'-1;
    valid_drive(Drive);

} // end GetDrive.

/////////////////////////////////////////////////////////////////////////////

void get_label()
{ 
    char temp[MAX_LABEL_LENGTH+1]; 

    do
        {
        printf("Volume label (11 characters, ENTER for none)? ");
        mygets(temp,MAX_LABEL_LENGTH+1);
        } // end do.
    while (check_label(temp));
    strcpy(Label, temp);

} // end get_label.

/////////////////////////////////////////////////////////////////////////////

void disp_label()
{
    unsigned char serialbuf[26];
    union REGS regs;
    struct SREGS sregs;

    // First set the dta to be fcb so information returned is put there.
    regs.x.ax=0x1a00;
    regs.x.dx=(unsigned)fcb;
    intdos(&regs, &regs);

    // Now try to find the volume label.
    fcb[DRIVE]=*Drive-'A'+1;
    regs.x.ax=0x1100;
    regs.x.dx=(unsigned)fcb;
    intdos(&regs, &regs);
    if (regs.h.al)
        {
        printf("Volume in drive ");
        myprintf(Drive,1);
        printf(" has no label\n");
        } // end if.
    else
        {
        NoLabel=0;
        fcb[ENDNAME]='\0';
        printf("Volume in drive ");
        myprintf(Drive,1);
        printf(" is %s\n",&fcb[NAME]);
        } // end else.

    // Now print out the volume serial number, if it exists.
    segread(&sregs);
    regs.x.ax=0x6900;
    regs.h.bl=*Drive-'A'+1;
    regs.x.dx=(unsigned)serialbuf;
    intdosx(&regs, &regs, &sregs);
    if (!regs.x.cflag)
        {
        printf("Volume serial number is ");
        hexprint(serialbuf[5]);
        hexprint(serialbuf[4]);
        printf("-");
        hexprint(serialbuf[3]);
        hexprint(serialbuf[2]);
        printf("\n");
        } // end if.

} // end disp_label.

/////////////////////////////////////////////////////////////////////////////

int make_label()
{
    union REGS regs;
    int i,length;

    creat_fcb[DRIVE]=*Drive-'A'+1;
    length=strlen(Label);
    for (i=0;i<length;i++)
        creat_fcb[NAME+i]=Label[i];

    regs.x.ax=0x1600;                    // Create the file.
    regs.x.dx=(unsigned)creat_fcb;
    intdos(&regs, &regs);
    if (!regs.h.al)
        {
        regs.x.ax=0x1000;                // Close the file.
        regs.x.dx=(unsigned)creat_fcb;
        intdos(&regs, &regs);
        return(1);
        } // end if.
    else
        return(3);

} // end make_label.

/////////////////////////////////////////////////////////////////////////////

void save_label(char *string)
{
    if (firsttime)
        firsttime=0;
    else
        {
        if (DriveNotFirst)
            {
            printf("Invalid drive\n");
            exit(4);
            } // end if.
        else
            strcat(Label, " ");

        } // end else.

    strcat(Label,string);

} // end save_label.

/////////////////////////////////////////////////////////////////////////////

void del_label()
{
    char findstring[7];
    struct find_t findstr;
    union REGS regs;

    strcpy(findstring, "?:\\*.*");
    *findstring=*Drive;
    if (!_dos_findfirst(findstring, _A_VOLID, &findstr))
        {
        strcpy(OldLabel, findstr.name);
        fcb[DRIVE]=*Drive-'A'+1;
        regs.x.ax=0x1300;
        regs.x.dx=(unsigned)fcb;
        intdos(&regs, &regs);
        } // end if.

} // end del_label.

/////////////////////////////////////////////////////////////////////////////

int check_label(char *s)
{
    int length,LabelLen;
    int i,j;

    s=strupr(s);

    // Make sure label is not too long.
    length=strlen(s);
    LabelLen=strlen(Label);
    if ((length > MAX_LABEL_LENGTH) || ((LabelLen > 0) && ((length + LabelLen + 1) > MAX_LABEL_LENGTH)))
        {
        strcpy(Label,"");
        printf("The label is too long.  The label must\n"
               "be 11 characters or less.\n");
        return (2);
        } // end if.

    // Make sure all characters are legitimate.
    for (i=0;i<length;i++)
        {
        for (j=0;j<BAD_CHARS;j++)
            {
            if (s[i]==bad_chars[j])
                {
                strcpy(Label,"");
                printf("Invalid volume label\n");
                return(4);
                } // end if.

            } // end for.

        if ((unsigned char)s[i]<(unsigned char)SPACEBAR)
            {
            strcpy(Label,"");
            printf("Invalid volume label\n");
            return(4);
            } // end if.

        } // end for.

    return(0);

} // end check_label.

/////////////////////////////////////////////////////////////////////////////

int valid_label(char *s)
{
    if (s[2] != '\0')
        {
        if (check_label(&s[2]))
            return(1);

        save_label(&s[2]);
        return(0);
        } // end if.

} // end valid_label.

/////////////////////////////////////////////////////////////////////////////

void do_cmdline(int ac, char *av[])
{
    int i;

    for (i=1;i<ac;i++)
        {
        if (valid_drive((av[i])=strupr(av[i])))
            {
            if (*Drive == '?')
                {
                *Drive=*av[i];          // Save the drive letter.
                } // end if.
            else
                {
                printf("There were multiple drives mentioned.\n"
                       "Please select one drive to label at a time.\n");
                exit(26);
                } // end if.
      
            // See if the drive letter is the first parameter.
            if (i != 1)
                DriveNotFirst=1;

            // See if the label is tacked right onto the drive letter.
            // Verify label if it is.
            if (valid_label(av[i]))
                return;

            } // end if.
        else
            {
            if (check_label(av[i])) 
                return;
            else
                save_label(av[i]);

            } // end else.

        } // end for.

    if (check_quotes())
        {
        strcpy(Label,"");
        printf("Invalid label\n");
        return;
        } // end if.

} // end process_cmdline.

/////////////////////////////////////////////////////////////////////////////

int check_quotes()
{
    union REGS regs;
    static unsigned char far *psp;

    // Get the segment address of PSP.
    regs.x.ax=0x6200;
    intdos(&regs, &regs);

    // Get address of original command line.
    FP_OFF(psp)=0x81;
    FP_SEG(psp)=regs.x.bx;

    // Check for double quotes.
    for (;*psp != '\r';psp++)
        {
        if (*psp==DBQ)
            return(1);

        } // end for.

    return(0);

} // end check_quotes.

/////////////////////////////////////////////////////////////////////////////

void on_exit()
{
    union REGS regs;
  
    if (curdir[0] != 0)                 // Originally at root?
        SetCurDir(regs, curdir);         // Change to original dir.

} // end on_exit.

/////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
    char ans[2],*fileargs[64],*optargs[64];
    int n_options,index,help_flag=0;
    union REGS regs;

    _dos_setvect(0x23, ctrlc_hndlr);
    atexit(on_exit);
    n_options = classify_args(argc, argv, fileargs, optargs);
    for (index=0;index<n_options;index++)
        {
        if (optargs[index][0] == '?') help_flag=1;
        else
            {
            printf("Invalid parameter - /%s\n", strupr(optargs[index]));
            exit(1);
            } // end else.

        } // end for.

    if (help_flag)
        {
        printf("\nLABEL Version %s\n",VERSION);
        printf("Creates, changes or deletes the volume label of a disk.\n\n"
               "Syntax: LABEL [drive:][label] [/?]\n"
               "  [drive:]  Specifies which drive you want to label\n"
               "  [label]   Specifies the new label you want to label the drive\n"
               "  /?        Displays this help message\n");
        return 0;
        } // end if.

    do_cmdline(argc, argv);
    if (*Drive == '?')                  // If no drive specified, use current.
        GetDrive();

    // Save current directory and move to root.
    GetCurDir(regs, curdir);
    if (curdir[0] != 0)
        {
        *rootdir=*Drive;
        SetCurDir(regs, rootdir);
        } // end if.
   
    // If no label was specified, show current one first and then get new one.
    if (*Label == '\0')
        {
        disp_label();
        get_label();
        } // end if.
    
    // If they entered an empty label, then ask them if they want to
    // delete the existing volume label.
    if ((*Label == '\0') && (!NoLabel))
        {
        do
            {
	    printf("\nDelete current volume label (Y/N)? ");
            mygets(ans,2);
            } // end do.
        while (((*ans=(char)toupper(*ans)) != 'Y') && (*ans != 'N'));
    
        if (toupper(*ans) == 'N')
            exit(1);

        } // end if.

    // Delete the old volume label.
    del_label();
  
    // Create the new one, if there is one to create.
    if (*Label != '\0')
        {
        if (make_label())
            {
            exit(1);
            } // end if.

        } // end if.

    exit(0);

} // end main.
