{$A-,B-,D+,E-,F-,I-,L+,N-,O-,R-,S-,V-}
{ ===================================================================
  Turbo Pascal Unit    INTER2          4. September 1991

  Version 2.0   Object oriented.  Replaces Version 1.2.

  For the simple handling of interrupts, especially the simple
  creating of interrupt handlers as well as the creating of own
  DOS commands by CED.

  Functionality as of version 1.2.
  CallInt enriched with registers.
  ===================================================================
  possible errors in this unit:

               1: Interrupt-Dequeueing not possible.
               2: CED-Enqueueing failed.
               3: CED-Dequeueing failed.
               4: Heap-Overflow while reading parameters.
  ===================================================================}


Unit Inter2;
{$F+}

Interface

Uses Global; 

Const  Modul       = 1;        { Inter2 is module 1 }
       PeriodicInt = $1C;      { timer interrupt }
       SerialInt   = $0C;      { hardware interupt called from uart }
       ParallelInt = $0F;      { hardware interrupt called on ACK }
       PrinterBIOS = $17;      { bios interrupt for printer }
       DosInt      = $21;      { ms-dos interrupt }
       KeyInt      = $09;      { hardware interrupt called when a key is pressed }
       VideoBIOS   = $10;      { bios interrupt for screen }
       TestInt     = $4B;      { unused interrupt }

Type   Registers   = Record    { replaces registers of the dos-unit }
                       Bp,Es,Ds,Si,Di : Word;
                       Case Boolean Of
                         False : (Dx,Cx,Bx,Ax,Ip,Cs,Flags : Word);
                         True  : (Dl,Dh,Cl,Ch,Bl,Bh,Al,Ah : Byte);
                       End;
       ProcTyp     = Procedure(Var Regs : Registers);
       StringPtr   = ^String;
       BaseObj     = Object
                         PushRegs : Array[1..13] of Byte;
                         MovAx    : Byte;
                         DataSeg  : Word;
                         MovDsAx  : Word;
                         Call     : Byte;
                         IntHand  : Pointer;
                         PopRegs  : Array[1..9] of Byte;
                         Jump     : Byte;
                         NextInt  : Pointer;
                         Error    : Byte;
                      End;


{ The object IntHandObj makes it possible to attach an own interrupt
  handler into an interrupt. Therefore it bilds a chain.
  So, if an interrupt occurs, first the own interrupt handler will be
  processed, then we jump to the precedent interrupt handler.
  The destructor Dequeue realizes the detaching of the interrupt handler
  from the chain. This only works if it's the last handler of the chain.
  The procedure ExitChain offers the interrupt handler the possibility to
  abort the processing of the chain.}

       IntHandObj  = Object(BaseObj)
                        IntNum   : Byte;
                        Constructor Enqueue(Num     : Byte;
                                            Proc    : ProcTyp;
                                            DS      : Word);
                        Destructor Dequeue;
                     End;

{ The object CedHandObj serves to install own DOS commands by help of CED,
  see also CED manual.}
       CedHandObj  = Object(BaseObj)
                        Name      : String;
                        Constructor Enqueue(ComName     : String;
                                            Proc        : ProcTyp;
                                            DS          : Word;
                                            Mode        : Byte);
                        Destructor Dequeue;
                     End;




Procedure CallInt(Adr : Pointer; Var Regs : Registers);
{ callint calls an interrupt routine standing at addresse adr.}


Procedure Intr(IntNum : Byte; Var Regis : Registers);
{ equals intr in the dos-unit.}


Procedure MsDos(Var Regs : Registers);


Procedure SetIntVec(IntNum : Byte; Adress : Pointer);
{ equals setintvec of the dos-unit.}


Procedure GetIntVec(IntNum : Byte; Var Adress : Pointer);


Procedure Jump(P : Pointer); InLine($CB);      { RETF }
{ this procedure jumps to the given addresse.}


Procedure MovEs(W : Word); InLine(7);  { POP ES }


Procedure MovDs(W : Word); InLine($1F); { POP DS }


Procedure DisableInts; Inline($Fa);   { Disable Interrupts }
{ disables hardware interrupts.}


Procedure EnableInts; Inline($Fb);   { Enable    Interrupts }
{ enables hardware interrupts.}


Procedure Nop; Inline($90);


Procedure EoI; Inline($B0/$20/$E6/$20);
{ MOV AL,20                         report End of Interrupt to interrupt
  OUT 20,AL                         controller.}


Procedure Keep(B : Byte);


Procedure NullOut(Regis : Registers);
{ for ced-commands.
  Sets length of command line to zero to disable execution of the command
  by DOS.}


Function CedAllParam(Var R : Registers) : StringPtr;


Function CedParam(n : Byte; Var R : Registers) : StringPtr;
{ Returns n-th parameter of a Ced commando }


Procedure InitStack(Sp,Ss : Word);
Inline($Fa/$58/$5B/$8E/$D0/$89/$DC/$Fb);
{ initializes the stack.}

Procedure ExitChain;
Inline($8B/$E5/$5D/$83/$C4/8/$5d/$07/$1f/$5e/$5f/$5a/$59/$5b/$58/$CF);
{ Mov  Sp,Bp
  Pop  Bp
  Add  Sp,8
  Pop  Registers
  IRet
 by this procedure we can abort the processing of a chain.}


{ ******************************************************************* }

  Implementation

{ ******************************************************************* }


Const  Base        : BaseObj = (PushRegs:($50,$53,$51,$52,$57,$56,$1e,$06,$55,$8B,$C4,$16,$50);
                                MovAx:$B8;
                                DataSeg:0;
                                MovDsAx:$d88e;
                                Call:$9a;
                                IntHand:Nil;
                                PopRegs:($5d,$07,$1f,$5e,$5f,$5a,$59,$5b,$58);
                                Jump:$ea);

Constructor IntHandObj.Enqueue;
Begin
    PushRegs:=Base.PushRegs;
    MovAx:=$B8;
    DataSeg:=DS;
    MovDsAx:=$D88E;
    Call:=$9A;
    IntHand:=@Proc;
    PopRegs:=Base.PopRegs;
    Jump:=$EA;
    IntNum:=Num;
    GetIntVec(IntNum,NextInt);
    SetIntVec(IntNum,@PushRegs);
    Error:=0;
End;

Destructor IntHandObj.Dequeue;
Var    P           : ^IntHandObj;
Begin
   GetIntVec(IntNum,Pointer(P));
   If P=@PushRegs Then
      SetIntVec(IntNum,NextInt)
   Else
      Global.SetError(Modul,1,0);  { Error 1: Dequeueing not possible.}
End;


Procedure SetIntVec;
Begin
   DisableInts;
   Pointer(Ptr(0,IntNum shl 2)^):=Adress;
   EnableInts;
End;

Procedure GetIntVec;
Begin
   Adress:=Pointer(Ptr(0,IntNum shl 2)^);
End;

Procedure CallInt; External;

Procedure Intr; External;

Procedure MsDos;
Begin
   Intr($21,Regs);
End;

Procedure Keep;
Var    EndSeg      : Word;
       Regs        : Registers;
Type   PSPTyp      = Array[1..2] of Word;
Begin
   EndSeg:=PSPTyp( PTR(PrefixSeg,0)^ )[2];
   With Regs Do
   Begin
      AH:=49;
      AL:=B;
      DX:=EndSeg-PrefixSeg;
      Intr($21,Regs);
   End;
End;


{ ###################################################################
                      procedures for Ced
  ################################################################### }

Type   BufTyp      = Array[Byte] of Char;

Constructor CedHandObj.Enqueue;
Var    Regs        : Registers;
Begin
   PushRegs:=Base.PushRegs;
   MovAx:=$B8;
   DataSeg:=DS;
   MovDsAx:=$D88E;
   Call:=$9A;
   IntHand:=@Proc;
   PopRegs:=Base.PopRegs;
   Jump:=$CB;
   With Regs Do
   Begin
      Ah:=$FF;       {Ced Service}
      Al:=0;         {Function 0: Enqueueing}
      Bl:=Mode;
      Name:=ComName+#13;
      Ds:=Seg(Name);
      Si:=Succ(Ofs(Name));
      Es:=Seg(PushRegs);
      Di:=Ofs(PushRegs);
      MsDos(Regs);
      If Odd(Flags) Then
         Global.SetError(Modul,2,0);           { Error 2: CED-Enqueueing failed.}
   End;
End;

Destructor CedHandObj.Dequeue;
Var    Regs        : Registers;
Begin
   With Regs Do
   Begin
      AH:=$FF;
      AL:=1;                 { Function 1:Dequeueing.}
      DS:=Seg(Name);
      SI:=Ofs(Name)+1;
      MsDos(Regs);
      If Odd(Flags) Then
         Global.SetError(Modul,3,0);  { Error 3: CED-Dequeueing failed.}
   End;
End;


Procedure NullOut;
Begin
   With Regis Do
      Mem[Ds:Si]:=13;
End;

Function CedAllParam(Var R : Registers) : StringPtr;
Var    S           : StringPtr;
       Buffer      : ^BufTyp;
       BP          : Byte;
Begin
   If MaxAvail<256 Then
   Begin
      Global.SetError(Modul,4,0);       { Error 4: No Heap memory while reading parameters.}
      CedAllParam:=Nil;
      Exit;
   End;
   New(S);
   S^:='';
   Buffer:=Ptr(R.DS,R.Dx);
   BP:=0;
   While Buffer^[BP]<>#13 Do
   Begin
      S^:=S^+Buffer^[BP];
      Inc(BP);
   End;
   CedAllParam:=S;
   Dispose(S);
End;

Function CedParam(n : Byte; Var R : Registers) : StringPtr;
Var    Buffer      : ^BufTyp;
       BP          : Byte;
       S           : StringPtr;
Begin
   Buffer:=Ptr(R.Ds,R.Dx);
   BP:=0;
   If MaxAvail<256 Then
   Begin
      Global.SetError(Modul,4,0);             { Error 4: No Heap memory while reading parameters.}
      CedParam:=Nil;
      Exit;
   End;
   New(S);
   S^:='';
   While (n>0) and (Buffer^[BP]<>#13) Do
   Begin
      Inc(BP);
      If (Buffer^[Pred(BP)]=' ') and (Buffer^[BP]<>' ') Then
         Dec(n);
   End;
   If n=0 Then
      While (Buffer^[BP]<>' ') and (Buffer^[BP]<>#13) Do
      Begin
         S^:=S^+Buffer^[BP];
         Inc(BP);
      End;
   CedParam:=S;
   Dispose(S);
End;

{$L CallInt2}
{$L Intr}

End.
