/* keydefru.h */
/* country=7, code page=866, language=441, keyboard=ru */

/*
 * history
 * 24 apr 02: tom ehlert - creation
 * 2002.05.10: fixed by Arkady Belousov <ark@mos.ru>
 */

#define LANGUAGE "russia"
#define STATUS   "by Arkady"

#define NAME(x) x##_RU

#include <dos.h>
#include "mkeyb.h"


/********************************************************
 * RUSSIAN keyboard mappings				*
 ********************************************************/

/* keyboard image (contributed by Arkady Belousov <ark@mos.ru>)

Standard layout characters+scancodes:
ͻ
~29!02@03#04$05%06^07&08*09(0A)0B-0C=0DBacksp 0E
Ķ
Tab 0Fq10w11e12r13t14y15u16i17o18p19[1A]1B      
 < 
 Caps 3Aa1Es1Fd20f21g22h23j24k25l26;27'28Enter 1C
Ķ
 Shift 2A z2Cx2Dc2Ev2Fb30n31m32,33.34/35 Shift 36 
Ķ
 Ctrl 1D Alt 38\56    Spacebar 39    \2BAlt E38Ctrl E1D
ͼ

normal:
ͻ
   1  2  3  4  5  6  7  8  9  0  -  =   Backsp 
Ķ
 Tab                                
 < 
  Caps                          Enter 
Ķ
  Shift                      /    Shift  
Ķ
 Ctrl  Alt  \           Spacebar          \  Alt  Ctrl 
ͼ

Shift:
ͻ
   !  "    ;  :  ,  .  *  (  )  _  +   Backsp 
Ķ
 Tab                                
 < 
  Caps                          Enter 
Ķ
  Shift                      ?    Shift  
Ķ
 Ctrl  Alt  |           Spacebar          %  Alt  Ctrl 
ͼ

Caps Lock:
ͻ
   1  2  3  4  5  6  7  8  9  0  -  =   Backsp 
Ķ
 Tab                                
 < 
  Caps                          Enter 
Ķ
  Shift                      /    Shift  
Ķ
 Ctrl  Alt  \           Spacebar          \  Alt  Ctrl 
ͼ

Caps Lock+Shift:
ͻ
   !  "    ;  :  ,  .  *  (  )  _  +   Bacskp 
Ķ
 Tab                                
 < 
  Caps                          Enter 
Ķ
  Shift                      ?    Shift  
Ķ
 Ctrl  Alt  |           Spacebar          %  Alt  Ctrl 
ͼ
*/

uchar NAME(scancodetable)[] = {

//* 1 */ PUNCT(0x02, '1', '!')
 /* 2 */ PUNCT(0x03, '2', '"')
 /* 3 */ PUNCT(0x04, '3', '')
 /* 4 */ PUNCT(0x05, '4', ';')
 /* 5 */ PUNCT(0x06, '5', ':')
 /* 6 */ PUNCT(0x07, '6', ',')
 /* 7 */ PUNCT(0x08, '7', '.')
//* 8 */ PUNCT(0x09, '8', '*')
//* 9 */ PUNCT(0x0A, '9', '(')
//* 0 */ PUNCT(0x0B, '0', ')')
//* - */ PUNCT(0x0C, '-', '_')
//* = */ PUNCT(0x0D, '=', '+')

 /* q */ ALPHA(0x10, '', '')
 /* w */ ALPHA(0x11, '', '')
 /* e */ ALPHA(0x12, '', '')
 /* r */ ALPHA(0x13, '', '')
 /* t */ ALPHA(0x14, '', '')
 /* y */ ALPHA(0x15, '', '')
 /* u */ ALPHA(0x16, '', '')
 /* i */ ALPHA(0x17, '', '')
 /* o */ ALPHA(0x18, '', '')
 /* p */ ALPHA(0x19, '', '')
 /* [ */ ALPHA(0x1A, '', '')
 /* ] */ ALPHA(0x1B, '', '')

 /* a */ ALPHA(0x1E, '', '')
 /* s */ ALPHA(0x1F, '', '')
 /* d */ ALPHA(0x20, '', '')
 /* f */ ALPHA(0x21, '', '')
 /* g */ ALPHA(0x22, '', '')
 /* h */ ALPHA(0x23, '', '')
 /* j */ ALPHA(0x24, '', '')
 /* k */ ALPHA(0x25, '', '')
 /* l */ ALPHA(0x26, '', '')
 /* ; */ ALPHA(0x27, '', '')
 /* ' */ ALPHA(0x28, '', '')

 /* ~ */ ALPHA(0x29, '', '')
 /* \ */ PUNCT(0x2B, '\\','%')

 /* z */ ALPHA(0x2C, '', '')
 /* x */ ALPHA(0x2D, '', '')
 /* c */ ALPHA(0x2E, '', '')
 /* v */ ALPHA(0x2F, '', '')
 /* b */ ALPHA(0x30, '', '')
 /* n */ ALPHA(0x31, '', '')
 /* m */ ALPHA(0x32, '', '')
 /* , */ ALPHA(0x33, '', '')
 /* . */ ALPHA(0x34, '', '')
//* / */ PUNCT(0x35, '/', '?')
	 0
};

// define this, if after starting the default layout is still international

struct KeyboardDefinition NAME(Keyboard) = {
	"RU",                             //char LanguageShort[4];			// "GR",                    
	"RUSSIA - russian Keyboard (by arkady)",  //char *Description;				// created by, "with combis"
	DRIVER_FUNCTION_REDUCED,          //char DriverFunctionRequired;                                  
	NAME(scancodetable),              //char *ScancodeTable;                                          
#ifdef COMBI
	{	NAME(combi1table),NAME(combi2table),NAME(combi3table),
		NAME(combi4table),NAME(combi5table),NAME(combi6table) },
#else
	{ 0 },
#endif			
	0,                                //char DezimalDingsbums;                                          
	1,                                //char DefaultLayoutUS;			// TRUE for russian               
	} ;                               
                                      
                                      
                                      