/* keydefSP.H */

/* status: experimental */

#define LANGUAGE "spanish"
#define STATUS   "mostly OK"


// I don't know if spanish DOS keyboard driver needs combies


#define EURO 0x00	/* unknown so far */

/********************************************************
* SPANISH keyboard mappings                             *
********************************************************/

/* table layout:

key on US keyboard,
       scancode,
            flags, what is defined
                                3 keys for NORMAL, 1 for ALTGREY

*/


unsigned char scancodetable[] =
	{

/* 1 */  0x02, NORMAL|ALTGREY, 	'1','!',0xff,'|',
/* 2 */  0x03, NORMAL|ALTGREY, 	'2','"',0xff,'@',
/* 3 */  0x04, NORMAL|ALTGREY,  '3',0xfa,0xff,0x23,
/* 4 */  0x05, NORMAL,      	'4','$',0xff,
/* 5 */  0x06, NORMAL|ALTGREY,	'5','%',0xff,EURO,
/* 6 */  0x07, NORMAL|ALTGREY,  '6','&',0xff,0xaa,		/*  */
/* 7 */  0x08, NORMAL        ,  '7','/',0xff,
/* 8 */  0x09, NORMAL        ,  '8','(',0xff,
/* 9 */  0x0a, NORMAL        ,  '9',')',0xff,
/* 0 */  0x0b, NORMAL        ,  '0','=',0xff,

/* - */  0x0c, NORMAL        ,  '\'','?',0x1f,

/* = */  0x0d, NORMAL,			0xad,0xa8,0,	 /* 13   #0 #0 #0 */
/* Q */  0x10, ALTGREY, 		 '@',

#ifdef COMBI
/* [ */  0x1a, NORMAL|ALTGREY,  COMBI2,COMBI3,0x1b,'[',
#else
/* [ */  0x1a, NORMAL|ALTGREY,  '`','^',0x1b,'[',
#endif


/* ] */  0x1b, NORMAL|ALTGREY,   '+','*',0x1d,']',

/* ; */  0x27, NORMAL|CAPS|ALTGREY, 0xa4,0xa5,0xff,	'~', /* 39C   #0 #0 ~ */
#ifdef COMBI
/* ' */  0x28, NORMAL|ALTGREY,  COMBI1,COMBI4,0x00,'{',	 /* 40  '  #0 #0 { */
#else
/* ' */  0x28, NORMAL|ALTGREY,  '\'',0xf9,0xff,'{',
#endif

/* ` */  0x29, NORMAL|ALTGREY,   0xba,0xaa,0x1c,'\\',	/* 41   #28 #0 \ */
/* \ */  0x2b, NORMAL|ALTGREY,   0x87,0x80,IGNORE,'}', /* */

/* M */  0x32, ALTGREY,  		 0xe6,					/* greek mue */
/* , */  0x33, NORMAL,		     ',',';', 0xff,
/* . */  0x34, NORMAL,		     '.',':', 0x1f,
/* / */  0x35, NORMAL,		     '-','_', 0x1f,

/*   */  0x56, NORMAL|ALTGREY,	 '<','>', IGNORE, '|',

	0
	};


/*
	these keys are generated on a COMBI+character base,
	don't know if that is correct.
	I also don't know what keys to generate, as the
	standard character set (DOS/BIOS) doesn't have
	norwegian/swedish/spanish characters

*/
#ifdef COMBI
unsigned char combi1table[] = 		/* ' a e i o u E #32' */
	{/*scancode lower upper */
/* A */  0x1e, 0xa0,0xb5,
/* E */  0x12, 0x82,0x90,
/* I */  0x17, 0xa1,0xd6,
/* O */  0x18, 0xa2,0xe0,
/* U */  0x16, 0xa3,0xe9,
/*blank*/0x39, '\'','\'',		/* and additional generated character */
	0};

unsigned char combi2table[] = 		/* ` a e i o u #32` */
	{/*scancode lower upper */
/* A */  0x1e, 0x85,0xb7,
/* E */  0x12, 0x8a,0xd4,
/* I */  0x17, 0x8d,0xde,
/* O */  0x18, 0x95,0xe3,
/* U */  0x16, 0x97,0xeb,
/*blank*/0x39, '`','`',		/* and additional generated character */
	0};

unsigned char combi3table[] = 		/* ^ a e i o u #32^ */
	{/*scancode lower upper */
/* A */  0x1e, 0x83,0xb6,
/* E */  0x12, 0x88,0xd2,
/* I */  0x17, 0x8c,0xd7,
/* O */  0x18, 0x93,0xe2,
/* U */  0x16, 0x96,0xea,
/*blank*/0x39, '^','^',		/* and additional generated character */
	0};
unsigned char combi4table[] =
	{/*scancode lower upper */
							/* a e i o u A O U y #32*/
/* A */  0x1e,0x84, 0x8e,
/* E */  0x12,0x89, 0xd3,
/* I */  0x17,0x8b, 0xd8,
/* O */  0x18,0x94, 0x99,
/* U */  0x16,0x81, 0x9a,
/* y */  0x15,0x98, 0x00,   /* no Y character ?? */

/*blank*/0x39, 0xf9,0xf9,		/* and additional generated character */
	0};
unsigned char combi5table[] = 		/*  C c ??? */
	{/*scancode lower upper */
/*blank*/0x39, ' ',' ',		/* and additional generated character */
	0};

#endif

