/* keydefLA.H */

//
// history 
// 26 apr 02: tom ehlert - creation
//


// latin america     needs combi's
#define COMBI

#define LANGUAGE "altin american"
#define STATUS   "first try"



#define EURO 0x00   /* unknown so far */

/********************************************************
* latin american    keyboard mappings                   *
********************************************************/

/* keyboard layout (origin arkady)

US characters+Scancodes:
ͻ
29  02 03 04 0506  07 08 09 0a 0b 0c 0d 2b  BS 
Ķ
 0f   q10w11e12r13t14y15u16i17o18p19[1a]1b      
 < 
 Caps 1da1es1fd20f21g22h23j24k25l26;27'28Enter 1c
Ķ
  Shift 2az2cx2dc2ev2fb30n31m32,33.34/35 Shift  36
ͼ
*/

/* copied mostly from italy,
   changed 

  4 3 #35 #0 #0 #0
 12 ' ? #31 #0 \
 13   #0 #0 #0
 16C q Q #17 #0 @
 26 '  #27 #0 #0
 27 + * #29 #0 ~
 39C   #0 #0 #0
 40 { [ #0 #0 ^
 41 |  #0 #0 
 43 } ] #28 #0 `

[Combi]
' a e i o u E #32'
` a e i o u #32`
^ a e i o u #32^
 a e i o u A O U y #32
~ n N #32~
 C c

*/


unsigned char scancodetable[] = 
    {
/* 2 */  0x03,      NORMAL        , '2' ,'"' ,0   ,      /*   3 2 #34 #0 #0 #0 */
/* 3 */  0x04,      NORMAL        , '3' ,'#' ,0   ,      /*   4 3 #35 #0 #0 #0 */
/* 4 */  0x05,      NORMAL        , '4' ,'$' ,0   ,      /*   5 4 $ #0 #0 #0 */
/* 5 */  0x06,      NORMAL        , '5' ,'%' ,0   ,      /*   6 5 % #0 #0 #0  */
/* 6 */  0x07,      NORMAL        , '6' ,'&' ,0x1e,      /*   7 6 & #30 #0 #0 */
/* 7 */  0x08,      NORMAL        , '7' ,'/' ,0   ,      /*   8 7 / #0 #0 #0  */
/* 8 */  0x09,      NORMAL        , '8' ,'(' ,0x1b,      /*   9 8 ( #0 #0 #0  */
/* 9 */  0x0a,      NORMAL        , '9' ,')' ,0x1d,      /*  10 9 ) #0 #0 #0  */
/* 0 */  0x0b,      NORMAL        , '0' ,'=' ,0   ,      /*  11 0 = #0 #0 #0   */

#ifdef COMBI
/* - */  0x0c,      NORMAL|ALTGREY, COMBI1,'?' ,0x1f,'\\', /*  12 ' ? #31 #0 \ */
#else
/* - */  0x0c,      NORMAL|ALTGREY, '\'','?' ,0x1f,'\\', /*  12 ' ? #31 #0 \ */
#endif
/* = */  0x0d,      NORMAL        , 0xa8,0xad,0   ,      /*  13   #0 #0 #0 */
/*   */  0x10,             ALTGREY,                '@',  /*  16C q Q #17 #0 @ */

#ifdef COMBI
/* [ */  0x1a,      NORMAL        , '\'',COMBI4,0x1b,      /*  26 '  #27 #0 #0 */
#else
/* [ */  0x1a,      NORMAL        , '\'',0xf9,0x1b,      /*  26 '  #27 #0 #0 */
#endif
#ifdef COMBI
/* ] */  0x1b,      NORMAL|ALTGREY, '+' ,'*' ,0x1d,COMBI5 , /*  27 + * #29 #0 ~ */
#else
/* ] */  0x1b,      NORMAL|ALTGREY, '+' ,'*' ,0x1d,'~' , /*  27 + * #29 #0 ~ */
#endif
/* ; */  0x27,CAPS| NORMAL        , 0xa4,0xa5,0   ,      /*  39C   #0 #0 #0*/
#ifdef COMBI
/* ' */  0x28,      NORMAL|ALTGREY, '{' ,'[' ,0   ,COMBI3, /*  40 { [ #0 #0 ^ */
#else
/* ' */  0x28,      NORMAL|ALTGREY, '{' ,'[' ,0   ,'^' , /*  40 { [ #0 #0 ^ */
#endif
/*   */  0x29,      NORMAL|ALTGREY, '|' ,0xf8,0   ,0xaa, /*  41 |  #0 #0 */
#ifdef COMBI
/*   */  0x2b,      NORMAL|ALTGREY, '}' ,']' ,0x1c,COMBI2, /*  43 } ] #28 #0 ` */
#else
/*   */  0x2b,      NORMAL|ALTGREY, '}' ,']' ,0x1c,'`' , /*  43 } ] #28 #0 ` */
#endif
/* , */  0x33,      NORMAL        , ',' ,';' ,0   ,      /*  51 , ; #0 #0 #0  */
/* . */  0x34,      NORMAL        , '.' ,':' ,0   ,      /*  52 . : #0 #0 #0  */
/* / */  0x35,      NORMAL        , '-' ,'_' ,0   ,      /*  53 - _ #0 #0 #0 */ 

/*   */  0x56,      NORMAL        , '<' ,'>' ,0x1c,      /*  86 < > #0 #0 #0  */

    0
    };

/*
	these keys are generated on a COMBI+character base,

	the upper case accented characters '`^+AEIOU need an enhanced
	codepage (850), as they can't be displayed in standard BIOS
	codepage (437)
*/

/*
[Combi]
' a e i o u E #32'
` a e i o u #32`
^ a e i o u #32^
 a e i o u A O U y #32
~ n N #32~
 C c
*/

#ifdef COMBI
unsigned char combi1table[] = 		/* ' a e i o u E #32' */
	{/*scancode lower upper */
/* A */  0x1e, 0xa0,0xb5,
/* E */  0x12, 0x82,0x90,
/* I */  0x17, 0xa1,0xd6,
/* O */  0x18, 0xa2,0xe0,
/* U */  0x16, 0xa3,0xe9,
/*blank*/0x39, '\'','\'',		/* and additional generated character */
	0};

unsigned char combi2table[] = 		/* ` a e i o u #32` */
	{/*scancode lower upper */
/* A */  0x1e, 0x85,0xb7,
/* E */  0x12, 0x8a,0xd4,
/* I */  0x17, 0x8d,0xde,
/* O */  0x18, 0x95,0xe3,
/* U */  0x16, 0x97,0xeb,
/*blank*/0x39, '`','`',		/* and additional generated character */
	0};

unsigned char combi3table[] = 		/* ^ a e i o u #32^ */
	{/*scancode lower upper */
/* A */  0x1e, 0x83,0xb6,
/* E */  0x12, 0x88,0xd2,
/* I */  0x17, 0x8c,0xd7,
/* O */  0x18, 0x93,0xe2,
/* U */  0x16, 0x96,0xea,
/*blank*/0x39, '^','^',		/* and additional generated character */
	0};
unsigned char combi4table[] = 		/*  a e i o u A O U y #32 */
	{/*scancode lower upper */
/* A */  0x1e, 0x84,0x8e,
/* E */  0x12, 0x89,0   ,
/* I */  0x17, 0x8b,0   ,
/* O */  0x18, 0x94,0x99,
/* U */  0x16, 0x81,0x9a,
/* Y */  0x15, 0x98,0   ,
/*blank*/0x39, '','',		/* and additional generated character */
	0};
unsigned char combi5table[] = 		/* ~ n N #32~ */
	{/*scancode lower upper */
/* N */  0x16, 0xa4,0xa5,
/*blank*/0x39, '~','~',		/* and additional generated character */
	0};

#endif




//#define DECIMALDINGSBUMS ','
