/* keydefGR.H */

//
// history
// 20 apr 02: tom ehlert - creation
//


// I don't think german DOS keyboard driver needs combies
// #define COMBI

#define LANGUAGE "deutsch"
#define STATUS   "mostly OK"



#define EURO 0x00	/* unknown so far */

/********************************************************
* GERMAN keyboard mappings                             *
********************************************************/


unsigned char scancodetable[] =
	{
/* Z */  0x2c, REPLACESCAN , 0x15,
/* Y */  0x15, REPLACESCAN , 0x2c,


/* 1 */  0x02, NORMAL,       	'1','!',0xff,
/* 2 */  0x03, NORMAL,       	'2','"',0xff,
/* 3 */  0x04, NORMAL,       	'3',0x15,0xff,
///4 */  0x05, NORMAL,      	'4','$',0xff,
/* 5 */  0x06,        ALTGREY,	             EURO,
/* 6 */  0x07, NORMAL,          '6','&',0xff,
/* 7 */  0x08, NORMAL|ALTGREY,  '7','/',0xff,'{',
/* 8 */  0x09, NORMAL|ALTGREY,  '8','(',0xff,'[',
/* 9 */  0x0a, NORMAL|ALTGREY,  '9',')',0xff,']',
/* 0 */  0x0b, NORMAL|ALTGREY,  '0','=',0xff,'}',

/* - */  0x0c, NORMAL|ALTGREY,  0xe1,'?',0x1c,'\\',	/* szet */
#ifdef COMBI
/* = */  0x0d, NORMAL,			COMBI1,COMBI2,0xff,		/* COMBI ' and ` + aeiou*/
#else
/* = */  0x0d, NORMAL,			'\'','`',0xff,				/* normal '+` */
#endif
/* Q */  0x10, ALTGREY, 		 '@',
/* [ */  0x1a, NORMAL|CAPS,  0x81,0x9a,0x1b,	/* ue */
/* ] */  0x1b, NORMAL|ALTGREY,   '+','*',0x1d,'~',
/* ; */  0x27, NORMAL|CAPS,  0x94,0x99,0xff,	/* german umlauts oe */
/* ' */  0x28, NORMAL|CAPS,  0x84,0x8e,0xff,	/* ae */
#ifdef COMBI
/* ` */  0x29, NORMAL,		     COMBI3,0xf8,0xff,			/* COMBI ^ + aeiou */
#else
/* ` */  0x29, NORMAL,		     '^',0xf8,0xff,				/* ^  */
#endif
/* \ */  0x2b, NORMAL,		     '#','\'',IGNORE,
/* M */  0x32, ALTGREY,  		 0xe6,	/* greek mue */
/* , */  0x33, NORMAL,		     ',',';', 0xff,
/* . */  0x34, NORMAL,		     '.',':', 0x1f,
/* / */  0x35, NORMAL,		     '-','_', 0x1f,

/*   */  0x56, NORMAL|ALTGREY,	 '<','>', IGNORE, '|',
	0
	};

// character to be send, if NUMLOCK + '.' on numeric keypad
#define DECIMALDINGSBUMS ','

/*
	these keys are generated on a COMBI+character base,

	the upper case accented characters '`^+AEIOU need an enhanced
	codepage (850), as they can't be displayed in standard BIOS
	codepage (437)
*/
#ifdef COMBI
unsigned char combi1table[] = 		/* ' a e i o u E #32' */
	{/*scancode lower upper */
/* A */  0x1e, 0xa0,0xb5,
/* E */  0x12, 0x82,0x90,
/* I */  0x17, 0xa1,0xd6,
/* O */  0x18, 0xa2,0xe0,
/* U */  0x16, 0xa3,0xe9,
/*blank*/0x39, '\'','\'',		/* and additional generated character */
	0};

unsigned char combi2table[] = 		/* ` a e i o u #32` */
	{/*scancode lower upper */
/* A */  0x1e, 0x85,0xb7,
/* E */  0x12, 0x8a,0xd4,
/* I */  0x17, 0x8d,0xde,
/* O */  0x18, 0x95,0xe3,
/* U */  0x16, 0x97,0xeb,
/*blank*/0x39, '`','`',		/* and additional generated character */
	0};

unsigned char combi3table[] = 		/* ^ a e i o u #32^ */
	{/*scancode lower upper */
/* A */  0x1e, 0x83,0xb6,
/* E */  0x12, 0x88,0xd2,
/* I */  0x17, 0x8c,0xd7,
/* O */  0x18, 0x93,0xe2,
/* U */  0x16, 0x96,0xea,
/*blank*/0x39, '^','^',		/* and additional generated character */
	0};
unsigned char combi4table[] = 		/* something missing yet ?? */
	{/*scancode lower upper */
	0};
unsigned char combi5table[] = 		/* something missing yet ?? */
	{/*scancode lower upper */
	0};

#endif

