#
# makefile for device.lib
#
# $Header: /home/cvsroot/kernel/ipl/src/drivers/device.mak,v 1.3 1999/02/09 04:41:40 jprice Exp $
#
# $Log: device.mak,v $
# Revision 1.3  1999/02/09 04:41:40  jprice
# Make makefile use common config.mak file
#
# Revision 1.2  1999/01/22 04:16:39  jprice
# Formating
#
# Revision 1.1.1.1  1999/01/20 05:51:00  jprice
# Imported sources
#
#
#   Rev 1.2   29 Aug 1996 13:07:12   patv
#Bug fixes for v0.91b
#
#   Rev 1.1   19 Feb 1996  3:19:26   patv
#Added NLS, int2f and config.sys processing
#
#   Rev 1.0   02 Jul 1995  7:54:52   patv
#Initial revision.
#

!include "..\..\..\config.mak"


# MICROSOFT C
# -----------
#MODEL  = s
#CFLAGS = /c /Gs /A$(MODEL)
#AFLAGS = /Mx /Dmem$(MODEL)=1
#TERM   = ;

# BORLAND C
# -----------
MODEL  = s
CFLAGS = -c -m$(MODEL)
AFLAGS = /Mx /Dmem$(MODEL)=1
LIBFLAGS = /c
TERM   =

OBJS   = console.obj devend.obj eoi.obj floppy.obj fmemcmp.obj fmemcpy.obj \
fmemset.obj inb.obj int86.obj intr.obj inw.obj keyboard.obj outb.obj \
outw.obj setvec.obj getvec.obj spl.obj timer.obj rdpcclk.obj rdatclk.obj \
wrpcclk.obj wratclk.obj

#LIBOBJS1= +console +devend +eoi +floppy +fmemcmp +fmemcpy
#LIBOBJS2= +fmemset +inb +int86 +intr +inw +keyboard +outb
#LIBOBJS3= +outw +setvec +getvec +spl +timer +rdpcclk +rdatclk
#LIBOBJS4= +wrpcclk +wratclk


LIBOBJS1= +console +devend +eoi +floppy +fmemcmp +fmemcpy
LIBOBJS2= +fmemset +inb +int86 +inw +keyboard +outb
LIBOBJS3= +outw +setvec +getvec +spl +timer +rdpcclk +rdatclk
LIBOBJS4= +wrpcclk +wratclk



# Build the LIBRARY
# -----------------
all:            production

production:     device.lib
                copy device.lib ..\..\lib

clean:
                del device.lib
                del *.obj
                del *.bak
                del *.crf
                del *.xrf
                del *.map
                del *.lst

device.lib : $(OBJS)
        DEL device.lib
        $(LIB) $(LIBFLAGS) device $(LIBOBJS1) $(TERM)
        $(LIB) $(LIBFLAGS) device $(LIBOBJS2) $(TERM)
        $(LIB) $(LIBFLAGS) device $(LIBOBJS3) $(TERM)
        $(LIB) $(LIBFLAGS) device $(LIBOBJS4) $(TERM)



# RULES (DEPENDENCIES)
# ----------------
.c.obj :
        $(CC) $(CFLAGS) $<

.asm.obj :
        $(ASM) $(AFLAGS) $< ;


