;
; File:
;                          entry.asm
; Description:
;                      System call entry code
;
;                       Copyright (c) 1998
;                       Pasquale J. Villani
;                       All Rights Reserved
;
; This file is part of DOS-C.
;
; DOS-C is free software; you can redistribute it and/or
; modify it under the terms of the GNU General public License
; as published by the Free Software Foundation; either version
; 2, or (at your option) any later version.
;
; DOS-C is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
; the GNU General public License for more details.
;
; You should have received a copy of the GNU General public
; License along with DOS-C; see the file COPYING.  If not,
; write to the Free Software Foundation, 675 Mass Ave,
; Cambridge, MA 02139, USA.
;
; $Id: entry.asm,v 1.3 1999/02/01 01:48:41 jprice Exp $
;
; $Log: entry.asm,v $
; Revision 1.3  1999/02/01 01:48:41  jprice
; Clean up; Now you can use hex numbers in config.sys. added config.sys screen function to change screen mode (28 or 43/50 lines)
;
; Revision 1.2  1999/01/22 04:13:25  jprice
; Formating
;
; Revision 1.1.1.1  1999/01/20 05:51:01  jprice
; Imported sources
;
;
;     Rev 1.0   07 Feb 1998 20:42:08   patv
;  Modified stack fram to match DOS standard
; $EndLog$

                page    60,132
                title   System call entry code

IFDEF ??version
_TEXT           segment byte public 'CODE'
DGROUP          group   _FIXED_DATA,_DATA,_BSS,_BSSEND  ; small model
                assume  cs:_TEXT,ds:DGROUP,ss:DGROUP
_TEXT           ends

_FIXED_DATA     segment para public 'DATA'
_FIXED_DATA     ends

_DATA           segment word public 'DATA'
_DATA           ends

_BSS            segment word public 'BSS'
_BSS            ends

_BSSEND         segment byte public 'STACK'
_BSSEND         ends

ELSE
_TEXT           segment byte public 'CODE'
_TEXT           ends

_FIXED_DATA     segment para public 'DATA'
_FIXED_DATA     ends

_DATA           segment word public 'DATA'
_DATA           ends

CONST           segment word public 'CONST'
CONST           ends

_BSS            segment word public 'BSS'
_BSS            ends

_BSSEND         segment byte public 'STACK'
_BSSEND         ends

DGROUP          group   CONST,_DATA,_BSS,_BSSEND        ; small/tiny model
                assume  ds:DGROUP, ss:DGROUP
ENDIF

                include stacks.inc

_TEXT           segment byte public 'CODE'
                extrn   _int21_syscall:near
                extrn   _int25_handler:NEAR, _int26_handler:NEAR
                extrn   _set_stack:FAR
                extrn   _restore_stack:FAR
                extrn   _api_sp:WORD
                extrn   _api_ss:WORD
                extrn   _disk_api_tos:WORD
                public  _cpm_entry
                public  _int20_handler
                public  _int21_handler
                public  _low_int25_handler
                public  _low_int26_handler
                public  _int27_handler


;
; MS-DOS CP/M style entry point
;
;       VOID FAR
;       cpm_entry(iregs UserRegs)
;
; This one is a strange one.  The call is to psp:0005h but it returns to the
; function after the call.  What we do is convert it to a normal call and
; fudge the stack to look like an int 21h call.
;
                assume  cs:_TEXT
_cpm_entry      proc    far
                ; Stack is:
                ;       return offset
                ;       psp seg
                ;       000ah
                ;
                push    bp              ; trash old return address
                mov     bp,sp
                xchg    bp,2[bp]
                pop     bp
                pushf                   ; start setting up int 21h stack
                ;
                ; now stack is
                ;       return offset
                ;       psp seg
                ;       flags
                ;
                push    bp
                mov     bp,sp           ; set up reference frame
                ;
                ; reference frame stack is
                ;       return offset           bp + 6
                ;       psp seg                 bp + 4
                ;       flags                   bp + 2
                ;       bp              <---    bp
                ;
                push    ax
                mov     ax,2[bp]        ; get the flags
                xchg    ax,6[bp]        ; swap with return address
                mov     2[bp],ax
                pop     ax              ; restore working registers
                pop     bp
                ;
                ; Done. Stack is
                ;       flags
                ;       psp seg (alias .COM cs)
                ;       return offset
                ;
                cmp     cl,024h
                jbe     cpm_error
                mov     ah,cl           ; get the call # from cl to ah
                jmp     short _int21_handler    ; do the system call
cpm_error:      mov     al,0
                iret
_cpm_entry      endp


;
; Terminate the current process
;
;       VOID INRPT far
;       int20_handler(iregs UserRegs)
;
                assume  cs:_TEXT
_int20_handler  proc    far
                mov     ah,0            ; terminate through int 21h
_int20_handler  endp


;
; MS-DOS system call entry point
;
;       VOID INRPT far
;       int21_handler(iregs UserRegs)
;
                assume  cs:_TEXT
_int21_handler  proc    far
                ;
                ; Create the stack frame for C call.  This is done to
                ; preserve machine state and provide a C structure for
                ; access to registers.
                ;
                ; Since this is an interrupt routine, CS, IP and flags were
                ; pushed onto the stack by the processor, completing the
                ; stack frame.
                ;
                ; NB: stack frame is MS-DOS dependent and not compatible
                ; with compiler interrupt stack frames.
                ;
                PUSH$ALL

                ;
                ; Create kernel refernce frame.
                ;
                ; NB: At this point, SS != DS and won't be set that way
                ; until later when which stack to run on is determined.
                ;
                mov     bp,DGROUP
                mov     ds,bp
                mov     bp,sp
                ;
                ; Push the far pointer to the register frame for
                ; int21_syscall and remainder of kernel.
                ;
                push    ss
                lea     ax,word ptr [bp]
                push    ax
                call    near ptr _int21_syscall
                ;
                ; Clean up stack.  It's int2_syscall responsibility to
                ; restore user stack.
                ;
                pop     cx
                pop     cx
                ;
                ; Recover registers from system call.  Registers and flags
                ; were modified by the system call.
                ;
                POP$ALL

                ;
                ; ... and return.
                ;
                iret
_int21_handler  endp



;
; Terminate the current process
;
;       VOID INRPT far
;       int27_handler(iregs UserRegs)
;
                assume  cs:_TEXT
_int27_handler  proc    far
                ;
                ; First convert the memory to paragraphs
                ;
                add     dx,0fh          ; round up
                rcr     dx,1
                shr     dx,1
                shr     dx,1
                shr     dx,1
                ;
                ; ... then use the standard system call
                ;
                mov     ax,3100h
                jmp     short _int21_handler    ; terminate through int 21h
_int27_handler  endp

;
; I really do need to get rid of this because it's the only thing stopping
; us from being ROMABLE.
;
stkframe        dd      ?

_low_int25_handler  proc far
                sti
                pushf
                push    ax
                push    cx
                push    dx
                push    bx
                push    sp
                push    bp
                push    si
                push    di
                push    ds
                push    es

                mov     word ptr cs:stkframe, sp     ; save stack frame
                mov     word ptr cs:stkframe+2, ss

                cld
                mov     ax, seg DGROUP
                mov     ds, ax

                mov     word ptr DGROUP:_api_sp, offset DGROUP:_disk_api_tos
                mov     word ptr DGROUP:_api_ss, ds

                call    far ptr _set_stack

                push    word ptr cs:stkframe+2
                push    word ptr cs:stkframe
                call    _int25_handler
                add     sp, 4

                call    far ptr _restore_stack

                pop     es
                pop     ds
                pop     di
                pop     si
                pop     bp
                pop     bx      ; pop off sp value
                pop     bx
                pop     dx
                pop     cx
                pop     ax
                popf
                retf            ; Bug-compatiblity with MS-DOS.
                                ; This function is supposed to leave the original
                                ; flag image on the stack.
_low_int25_handler  endp


_low_int26_handler  proc far
                sti
                pushf
                push    ax
                push    cx
                push    dx
                push    bx
                push    sp
                push    bp
                push    si
                push    di
                push    ds
                push    es

                mov     word ptr cs:stkframe, sp     ; save stack frame
                mov     word ptr cs:stkframe+2, ss

                cld
                mov     ax, seg DGROUP
                mov     ds, ax

                mov     word ptr DGROUP:_api_sp, offset DGROUP:_disk_api_tos
                mov     word ptr DGROUP:_api_ss, ds

                call    far ptr _set_stack

                push    word ptr cs:stkframe+2
                push    word ptr cs:stkframe
                call    _int26_handler
                add     sp, 4

                call    far ptr _restore_stack

                pop     es
                pop     ds
                pop     di
                pop     si
                pop     bp
                pop     bx      ; pop off sp value
                pop     bx
                pop     dx
                pop     cx
                pop     ax
                popf
                retf
_low_int26_handler  endp

_TEXT           ends
                end
