
/****************************************************************/
/*                                                              */
/*                          ioctl.c                             */
/*                                                              */
/*                    DOS/NT ioctl system call                  */
/*                                                              */
/*                      Copyright (c) 1995                      */
/*                      Pasquale J. Villani                     */
/*                      All Rights Reserved                     */
/*                                                              */
/* This file is part of DOS-C.                                  */
/*                                                              */
/* DOS-C is free software; you can redistribute it and/or       */
/* modify it under the terms of the GNU General Public License  */
/* as published by the Free Software Foundation; either version */
/* 2, or (at your option) any later version.                    */
/*                                                              */
/* DOS-C is distributed in the hope that it will be useful, but */
/* WITHOUT ANY WARRANTY; without even the implied warranty of   */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See    */
/* the GNU General Public License for more details.             */
/*                                                              */
/* You should have received a copy of the GNU General Public    */
/* License along with DOS-C; see the file COPYING.  If not,     */
/* write to the Free Software Foundation, 675 Mass Ave,         */
/* Cambridge, MA 02139, USA.                                    */
/****************************************************************/

#include "../../hdr/portab.h"
#include "globals.h"

/* $Logfile:   C:/dos-c/src/kernel/ioctl.c_v  $ */
#ifdef VERSION_STRINGS
static BYTE *RcsId = "$Header:   C:/dos-c/src/kernel/ioctl.c_v   1.4   16 Jan 1997 12:46:54   patv  $";
#endif

/*
 * $Log:   C:/dos-c/src/kernel/ioctl.c_v  $
 * 
 *    Rev 1.4   16 Jan 1997 12:46:54   patv
 * pre-Release 0.92 feature additions
 * 
 *    Rev 1.3   29 May 1996 21:03:30   patv
 * bug fixes for v0.91a
 * 
 *    Rev 1.2   19 Feb 1996  3:21:34   patv
 * Added NLS, int2f and config.sys processing
 * 
 *    Rev 1.1   01 Sep 1995 17:54:16   patv
 * First GPL release.
 * 
 *    Rev 1.0   02 Jul 1995  8:32:04   patv
 * Initial revision.
 */

#ifdef PROTO
sft FAR *get_sft(COUNT);
#else
sft FAR *get_sft();
#endif

COUNT 
DosDevIOctl (iregs FAR *r, COUNT FAR *err)
{
	sft FAR *s;
	struct dpb FAR *dpbp;
	COUNT hndl = r -> BX;

	/* Test that the handle is valid                */
	if(r->AL < 3 || r->AL == 6 || r->AL == 7 || r->AL == 0x0a || r->AL == 0x0c)
	{
		
	    /* Get the SFT block that contains the SFT      */
	    if((s = get_sft(hndl)) == (sft FAR *)-1)
	    {
		*err = DE_INVLDHNDL;
		return 0;
	    }
	} else if (r->AL != 0xb && r->AL < 0x10) {
	    if (r->BL > nblkdev)
	    {    
		*err = DE_INVLDDRV;
		return 0;
	    } else dpbp = &blk_devices[r -> BL];
	}


	switch(r -> AL)
	{
	case 0:
		r -> DX = s -> sft_flags;
		break;

	case 1:
		s -> sft_flags =
		  (s -> sft_dev -> dh_attr & ~SFT_MASK) |  0x80 | (r -> DX & SFT_MASK);
		break;

	case 2:
	case 3:
	case 4:
	case 5:
		*err = DE_INVLDFUNC;
		return 0;
	case 6:
		if (s -> sft_flags & SFT_FDEVICE)
		{
		    r -> AL = s -> sft_flags & SFT_FEOF? 0 : 0xFF;
		}
		else 
		    r -> AL = s -> sft_posit >= s -> sft_size? 0xFF : 0;
		break;

	case 7:
		if (s -> sft_flags & SFT_FDEVICE)
		{    
		}
		r -> AL = 0;
		break;
	case 8:
		if (dpbp -> dpb_device -> dh_attr & 0x800)
		{
		}
		*err = DE_INVLDFUNC;
		return 0;
	case 9:
		r -> DX = dpbp -> dpb_device -> dh_attr;
		break;
	case 0x0a:
		r -> DX = s -> sft_dcb_or_dev._sft_dcb -> dpb_device -> dh_attr;
		break;
	case 0x0c:
		if (s -> sft_flags & SFT_FDEVICE)
		{
		    if (s -> sft_dcb_or_dev._sft_dev -> dh_attr & 0x4000)
		    {
		    }
		}
		*err = DE_INVLDFUNC;
		return 0;
	case 0x0d:
		if (dpbp -> dpb_device -> dh_attr & 0x4000)
		{
		}
		*err = DE_INVLDFUNC;
		return 0;
	case 0x0e:
		r -> AL = 0;
		break;
	case 0x0f:
		*err = DE_INVLDFUNC;
		return 0;
	default:
		*err = DE_INVLDFUNC;
		return 0;
	}
	*err = SUCCESS;
	return 0;
}



