/* Copyright (C) 2002 Aitor Santamaria_Merino <aitor.sm@wanadoo.es> */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdlib.h>
#include <DOS.h>
#include "GDSKFREE.H"

//////////// PART 1b:  HD INFO ///////////////////////////////////////////

#include <stdio.h>
#include <conio.h>
/* indicates how many bytes are free, and if total_space is not NULL then
   also indicates total bytes.  Note: this may return incorrect information
   if the actual values exceed 2GB
*/
void getDiskFree(BYTE dl, unsigned long *free_space, unsigned long *total_space)
{
#if 1
   	union REGS regs;

	regs.x.ax = 0x3600;    // get free disk space (max 4GB)
	regs.h.dl = dl;
	intdos (&regs, &regs);
	if (regs.x.ax == 0xFFFF) // invalid drive
	{
		*free_space = 0UL;
		if (total_space != NULL) *total_space = 0UL;
	}
	else
	{
		*free_space = (unsigned long)regs.x.ax    // sectors/cluster
				  * (unsigned long)regs.x.bx  // # free clusters
				  * (unsigned long)regs.x.cx; // bytes/sector
				                              // dx=total clusters
		if (total_space != NULL)
			*total_space =  (unsigned long)regs.x.ax  // sectors/cluster
					                              // bx=# free clusters
					  * (unsigned long)regs.x.cx // bytes/sector
					  * (unsigned long)regs.x.dx;  // total clusters
	}
#else
	struct dfree free;

      getdfree(dl, &free);
      *free_space = (free.df_sclus == 0xFFFF) ?
		0UL
		:
		(unsigned long) free.df_avail
		* (unsigned long) free.df_bsec
		* (unsigned long) free.df_sclus;

	if (total_space != NULL)
	      *total_space = (free.df_sclus == 0xFFFF) ?
			0UL
			:
			(unsigned long) free.df_total
			* (unsigned long) free.df_bsec
			* (unsigned long) free.df_sclus;
#endif
}
