/* $Id: getkey.c,v 1.4 1998/08/17 03:14:58 jhall Exp $ */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdio.h>
#include <string.h>				/* for index() */
#include <ctype.h>				/* for toupper, tolower */

#if !defined (unix)
#  include <conio.h>				/* for building on DOS */
#endif

#include "getkey.h"


/* Retrieves the next key pressed (from the keyboard) */

int
getkey (void)
{
#if defined (unix)
  int ch;

#if !defined (linux)
  fpurge (stdin);				/* clears the input stream */
#endif

  ch = getchar();
  while (getchar() != '\n');			/* like flushing the input */

  return (ch);

#else
  return (getche());				/* graceful fix for DOS */
#endif
}

/* Retrieves the next key.  Returns the key only when the key is found
   in a list. */

int
getkeyl (const char *list)
{
  int key;

  do {
    key = getkey ();
  } while (!cindex (list, key));

  return (key);
}

/* Retrieves the next key.  Returns the key only when the key is found
   in a list, without regard to case. */

int
getkeyli (const char *list)
{
  int key;

  do {
    key = getkey ();
  } while (!cindex (list, toupper(key)) && !cindex (list, tolower(key)));

  return (key);
}

/* NEED TO REPLACE THIS WITH BSD 'index()' */

/* Locate the character in the string.  Return the index of the
   string, starting at zero, or <0 if not found. */

int
cindex (const char *s, int ch)
{
  int i;

  for (i = 0; s[i] != '\0'; i++) {
    if (ch == s[i]) {
      return (i);
    }
  }

  return (-1);
}
