#ifdef unix
#include <curses.h>
#else
#include "thecurse.h"
#endif

#include "cur.h"				/* the curlib functions */

/* this is a test program, which does very little except run through
   some basic curses routines.  use this as a portability experiment
   between curses/UNIX and dcurses/DOS. */

int
main ()
{
  char name[80] = "";				/* the user name */

  /* start curses */

  initscr();

#ifdef unix
  cbreak();
  noecho();
#endif

  /* Most programs would additionally use the sequence: */

#ifdef unix
  nonl();
  intrflush(stdscr, FALSE);
  keypad(stdscr, TRUE);
#endif

  /* erase the screen, and print a message */

  erase();
  standout();
  mvaddstr (1, 33, "Enter your name");
  cur_mvaddnch (2, 33, 15, ACS_HLINE);
  standend();

  beep();
  refresh();

  /* read the name */

  cur_mvgetnstr (5, 10, 80, name);

  /* exit curses */

  erase();
  refresh();

  endwin();

  /* end the program */

  printf ("your name is: <%s>\n", name);
  exit (0);
}
