/* $Id: mvgetnst.c,v 1.1.1.1 1998/06/10 03:36:47 jhall Exp $ */

/* Copyright (C) 1998 Jim Hall, jhall1@isd.net */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* mvgetnstr - reads at most n characters into a string pointed to by
   s, starting at y,x, and wrapping at the end of the screen.
   Succeeding lines start at y+1,x, ... */

/* returns a pointer to s */

#ifdef unix
#include <curses.h>
#else
#include "thecurse.h"
#endif

#include <ctype.h>				/* for isprint() */
#include "cur.h"


#define ENTER_KEY '\r'


char *
cur_mvgetnstrc (int y, int x, int n, char *s, int space)
{
  int len;                    			/* the length of s */
  int pos;                    			/* our position in s */
  int key;

  int k, j;                   			/* current y, x position */
  int k0, j0;                 			/* old y, x position */


  /* draw the spaces */

  cur_mvaddnch (y, x, n, space);

  /* paint my string */

  cur_mvaddnstr (y, x, n, s);

  /* determine the length of s */

  for (pos = 0; s[pos] != '\0'; pos++);

  if (pos > n) {
    len = n;
  }
  else {
    len = pos;
  }

  /* move to beginning of s */

  move (y, x);
  pos = 0;
  k = y;
  j = x;

  /* Now read the string from the user, allowing backspace to backup
     and kill last char, left/right for navigation, Enter to save the
     string. */

  /* let the width of the screen tell you when to skip to the next
     line, and let n tell you when to stop moving pos,len forward in
     s. */

  while ((key = getch()) != ENTER_KEY) {
    switch (key) {

    default:
      /* may be a valid character, or may not be */

      if (isprint(key)) {
	s[pos] = key;
	addch(s[pos]);

	/* will also go on to KEY_RIGHT condition */
      }

      else {
	beep();
	refresh();

	/* stop here */
	break;
      }
	
    case KEY_RIGHT:
      /* right arrow key - move cursor one position right.  also used
         when adding new characters to the string.  may need to push
         the len out by one. */

      /* need to store the k,j position for later use */

      k0 = k;
      j0 = j;

      if (++pos > n) {
	/* can't move past end of string */

	pos = n;
	beep();
	refresh();
      }
      else if (++j >= COLS) {
	/* move to next line - we know we are not on the last line,
            because we were able to move pos up by one */

	j = x;
	k++;
      }

      /* do we need to move pos? */

      if (pos > len) {
	/* move the Null character as well */

	if (key == KEY_RIGHT) {
	  s[len] = ' ';
	  mvaddch (k0, j0, ' ');
	}

	len = pos;
	s[len] = '\0';
      }

      move (k, j);
      refresh();
      break;

    case KEY_LEFT:
    case KEY_BACKSPACE:                     /* the Backsp key */
    case KEY_DC:                            /* the Delete key */
      /* left arrow key - move cursor one position left */

      if (--pos < 0) {
	/* can't move past start of string */

	pos = 0;
	beep();
	refresh();
      }
      else if (--j < x) {
	/* move to line above - we know we are on the second line,
           because we were able to move the j position left beyond the
           start of x */

	j = COLS - 1;
	k--;
      }

      /* erase the current character */

      if ((key == KEY_BACKSPACE) || (key == KEY_DC)) {
	/* do we need to move the Null? */

	if (pos == (len - 1)) {
	  /* move the Null left one */
	  len--;
	  s[pos] = '\0';
	  mvaddch (k, j, space);
	}

	else {
	  /* erase the character */

	  s[pos] = ' ';
	  mvaddch (k, j, ' ');
	}
      } /* if */

      /* reposition the cursor */

      move (k, j);
      refresh();
      break;

    } /* switch */
  } /* while */

  /* done */

  return (s);
}

char *
cur_mvgetnstr (int y, int x, int n, char *s)
{
  /* the "c" version of the function allows you specify the space
     character */

  return (cur_mvgetnstrc (y, x, n, s, '.'));
}
